/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanCombinationType implements DescribedItem
{
    A1_ONLY("Array 1 Only"),
    A2_ONLY("Array 2 Only"),
    COMPARE("Compare"),
    A1_MINUS_A2("Array 1 - Array 2"),
    A2_MINUS_A1("Array 2 - Array 1"),
    A1_PLUS_A2("Array 1 + Array 2"),
    A1_TIMES_A2("Array 1 \u00d7 Array 2"),
    A1_OVER_A2("Array 1 / Array 2"),
    A2_OVER_A1("Array 2 / Array 1"),
    A1_MINUS_A2_PCT("(Array 1 - Array 2) / Array 2"),
    A2_MINUS_A1_PCT("(Array 2 - Array 1) / Array 1"),
    AVERAGE("Average"),
    MERGE("Merge"),
    VECTOR("Vector Magnitude");

    private final String description_;

    private PanCombinationType(String description) {
        this.description_ = description;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PanCombinationType matching(String str) {
        for (PanCombinationType item : PanCombinationType.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }
}

