/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.about.PanAboutFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class PanWindowAdapter
extends WindowAdapter
implements ComponentListener {
    private final PanFrame parent_;

    public PanWindowAdapter(PanFrame parent) {
        this.parent_ = parent;
    }

    @Override
    public void windowActivated(WindowEvent e) {
        GuiUtils.refreshFrontFrameMenuBar();
        this.parent_.repaint();
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.parent_.repaint();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        if (this.parent_ instanceof PanAboutFrame) {
            this.parent_.setVisible(false);
        } else {
            this.parent_.repaint();
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (this.parent_ instanceof PanAboutFrame) {
            this.parent_.setVisible(false);
        } else {
            this.parent_.repaint();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.parent_.close();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.parent_.needsResizeToFitDisplay()) {
            this.parent_.resizeToFitDisplay();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

