/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.text.DoubleDocument;
import gov.nasa.giss.text.IntegerDocument;
import gov.nasa.giss.text.PrintfFormat;
import javax.swing.JTextField;
import javax.swing.text.Document;

public final class PanTextField
extends JTextField {
    private PanTextField(PanGuiSize size, String name, String text) {
        this(size, name, null, text, 0);
    }

    private PanTextField(PanGuiSize size, String name, Document doc, String text, int cols) {
        if (name != null) {
            this.setName(name);
        }
        if (doc != null) {
            this.setDocument(doc);
        }
        if (text != null) {
            this.setText(text);
        }
        if (cols > 0) {
            this.setColumns(cols);
        }
        if (size == PanGuiSize.SMALL) {
            PanGuiUtils.setSizeSmall(this);
        }
    }

    public static PanTextField create(String name, String text, int cols) {
        PanTextField jtf = new PanTextField(PanGuiSize.REGULAR, name, null, text, cols);
        jtf.setHorizontalAlignment(2);
        return jtf;
    }

    public static PanTextField small(String name, String text, int cols) {
        PanTextField jtf = new PanTextField(PanGuiSize.SMALL, name, null, text, cols);
        jtf.setHorizontalAlignment(2);
        return jtf;
    }

    public static PanTextField createIntegerField(String name, int value) {
        PanTextField jtf = new PanTextField(PanGuiSize.REGULAR, name, new IntegerDocument(), Integer.toString(value), 8);
        jtf.setHorizontalAlignment(4);
        return jtf;
    }

    public static PanTextField createDoubleField() {
        PanTextField jtf = new PanTextField(PanGuiSize.REGULAR, null, new DoubleDocument(), PrintfFormat.PFORMAT_9G.sprintfx(0.0), 8);
        jtf.setHorizontalAlignment(4);
        return jtf;
    }

    public static PanTextField createDoubleField(String name, double value) {
        PanTextField jtf = new PanTextField(PanGuiSize.REGULAR, name, new DoubleDocument(), PrintfFormat.PFORMAT_9G.sprintfx(value), 8);
        jtf.setHorizontalAlignment(4);
        return jtf;
    }

    public static PanTextField createDoubleField(String name, double value, int width) {
        PanTextField jtf = new PanTextField(PanGuiSize.REGULAR, name, new DoubleDocument(), PrintfFormat.PFORMAT_9G.sprintfx(value), width);
        jtf.setHorizontalAlignment(4);
        return jtf;
    }

    public static PanTextField smallDoubleField(String name, double value) {
        PanTextField jtf = new PanTextField(PanGuiSize.SMALL, name, new DoubleDocument(), PrintfFormat.PFORMAT_9G.sprintfx(value), 8);
        jtf.setHorizontalAlignment(4);
        return jtf;
    }

    public static PanTextField createSearchField(String name) {
        PanTextField jtf = new PanTextField(PanGuiSize.REGULAR, name, null, "", 0);
        jtf.putClientProperty("JTextField.variant", "search");
        jtf.setPreferredSize(null);
        jtf.setMaximumSize(null);
        return jtf;
    }
}

