/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanConstants;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class PanStringComboBox
extends JComboBox<String> {
    public PanStringComboBox(PanGuiSize size, String name) {
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    public PanStringComboBox(PanGuiSize size, String name, String ... strs) {
        super(strs);
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    public PanStringComboBox(PanGuiSize size, String name, ComboBoxModel<String> model) {
        super(model);
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    public String getSelectedString() {
        return this.getSelectedItem().toString();
    }

    public static PanStringComboBox create() {
        return new PanStringComboBox(PanGuiSize.REGULAR, null);
    }

    public static PanStringComboBox small() {
        return new PanStringComboBox(PanGuiSize.SMALL, null);
    }

    public static PanStringComboBox small(String name) {
        return new PanStringComboBox(PanGuiSize.SMALL, name);
    }

    public static PanStringComboBox small(ComboBoxModel<String> model) {
        return new PanStringComboBox(PanGuiSize.SMALL, null, model);
    }

    public static PanStringComboBox small(String name, String ... strs) {
        return new PanStringComboBox(PanGuiSize.SMALL, name, strs);
    }

    public static PanStringComboBox createNumberFormatCombo(String name) {
        return new PanStringComboBox(PanGuiSize.REGULAR, name, PanConstants.NUMBER_PFORMATS);
    }

    public static PanStringComboBox smallNumberFormatCombo(String name) {
        return new PanStringComboBox(PanGuiSize.SMALL, name, PanConstants.NUMBER_PFORMATS);
    }

    public static PanStringComboBox createTimeFormatCombo(String name) {
        PanStringComboBox combo = new PanStringComboBox(PanGuiSize.REGULAR, name, PanConstants.TIME_FORMAT_PATTERNS);
        PanStringComboBox.append(combo, PanConstants.NUMBER_PFORMATS);
        return combo;
    }

    public static PanStringComboBox smallTimeFormatCombo(String name) {
        PanStringComboBox combo = new PanStringComboBox(PanGuiSize.SMALL, name, PanConstants.TIME_FORMAT_PATTERNS);
        PanStringComboBox.append(combo, PanConstants.NUMBER_PFORMATS);
        return combo;
    }

    public static void append(PanStringComboBox combo, String ... strs) {
        for (String str : strs) {
            combo.addItem(str);
        }
    }
}

