/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import javax.swing.JComboBox;

public final class PanOverlayComboBox
extends JComboBox<String>
implements ResourceListDataListener {
    private static OverlayResourceList overlayList_ = PanUtils.getOverlayResourceList();
    private boolean firstIsNone_ = true;
    private boolean refreshing_;

    private PanOverlayComboBox(boolean includeNone) {
        this(PanGuiSize.REGULAR, includeNone);
    }

    private PanOverlayComboBox(PanGuiSize size, boolean includeNone) {
        Object[] olays;
        for (Object o : olays = overlayList_.toArray()) {
            this.addItem(o.toString());
        }
        this.firstIsNone_ = includeNone;
        if (this.firstIsNone_) {
            this.insertItemAt("None", 0);
            this.setSelectedIndex(0);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
        overlayList_.addListDataListener(this);
    }

    public boolean isRefreshing() {
        return this.refreshing_;
    }

    public void refresh() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.refreshing_ = false;
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            this.setSelectedIndex(0);
        } else if (item instanceof String) {
            super.setSelectedItem(item);
        } else if (item instanceof MapOverlay) {
            super.setSelectedItem(item.toString());
        }
    }

    public MapOverlay getSelectedOverlay() {
        String name = (String)this.getSelectedItem();
        if (name == null) {
            return null;
        }
        return PanUtils.getOverlay(name);
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        int offset = this.firstIsNone_ ? 1 : 0;
        OverlayResourceList oList = PanUtils.getOverlayResourceList();
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        for (int i = index0; i <= index1; ++i) {
            Object olay = oList.getBackingObject(i);
            this.insertItemAt(olay.toString(), i + offset);
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
        int index1;
        int offset = this.firstIsNone_ ? 1 : 0;
        int index = this.getSelectedIndex();
        int index0 = e.getIndex0();
        for (int i = index1 = e.getIndex1(); i >= index0; --i) {
            this.removeItemAt(i + offset);
        }
        if (index >= index0 + offset && index <= index1 + offset) {
            if (index0 > 0) {
                this.setSelectedIndex(index0 - 1 + offset);
            } else {
                this.setSelectedIndex(index0 + offset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanOverlayComboBox panOverlayComboBox = this;
        synchronized (panOverlayComboBox) {
            overlayList_.removeListDataListener(this);
            this.removeAll();
        }
    }

    public static PanOverlayComboBox create(boolean includeNone) {
        return new PanOverlayComboBox(PanGuiSize.REGULAR, includeNone);
    }

    public static PanOverlayComboBox create(String name, boolean includeNone) {
        PanOverlayComboBox result = PanOverlayComboBox.create(includeNone);
        if (name != null) {
            result.setName(name);
        }
        return result;
    }

    public static PanOverlayComboBox small(boolean includeNone) {
        return new PanOverlayComboBox(PanGuiSize.SMALL, includeNone);
    }

    public static PanOverlayComboBox small(String name, boolean includeNone) {
        PanOverlayComboBox result = PanOverlayComboBox.small(includeNone);
        if (name != null) {
            result.setName(name);
        }
        return result;
    }
}

