/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.action.PanCloseAllWindowsAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.ui.PanWindowAdapter;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.StatusBar;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.util.task.Task;
import gov.nasa.giss.util.task.TaskQueue;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.lang.invoke.MethodHandles;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanFrame
extends JFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Color GRAY_232 = new Color(232, 232, 232);
    private static TaskQueue taskQueue_ = new TaskQueue();
    private static PanFrame dummyFrame_;
    private StatusBar statusBar_;

    public PanFrame() {
        this((String)null);
    }

    public PanFrame(String title) {
        super(title);
        PanFrame.getTaskQueue();
        PanWindowAdapter windowAdapter = new PanWindowAdapter(this);
        this.addWindowListener(windowAdapter);
        this.addWindowFocusListener(windowAdapter);
        this.addComponentListener(windowAdapter);
        this.attachAltActions();
        this.getContentPane().setBackground(GRAY_232);
    }

    private void attachAltActions() {
        int shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        boolean metaIsShortcut = shortcutMask == 4;
        InputMap im = this.getRootPane().getInputMap(1);
        ActionMap am = this.getRootPane().getActionMap();
        PanCloseAllWindowsAction a = new PanCloseAllWindowsAction();
        KeyStroke ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta alt W") : KeyStroke.getKeyStroke("ctrl alt W");
        im.put(ks, a.getValue("Name"));
        am.put(a.getValue("Name"), a);
    }

    protected void placeOnScreen() {
        Rectangle rr = GuiUtils.getActiveScreenBounds();
        if (rr == null) {
            this.setLocation(25, 25);
        } else {
            Dimension psize = this.getContentPane().getPreferredSize();
            int x = (rr.width - psize.width) / 2;
            int y = (rr.height - psize.height) * 4 / 10;
            this.setLocation(rr.x + x, rr.y + y);
        }
    }

    public PanMenuBar getPanMenuBar() {
        return (PanMenuBar)this.getJMenuBar();
    }

    public void setPanMenuBar(PanMenuBar mbar) {
        super.setJMenuBar(mbar);
    }

    @Override
    public void setJMenuBar(JMenuBar mbar) {
        throw new UnsupportedOperationException("Use setPanMenuBar(PanMenuBar) instead");
    }

    public void reveal() {
        this.setState(0);
        this.toFront();
        this.setVisible(true);
    }

    protected boolean needsResizeToFitDisplay() {
        Rectangle rr = this.isVisible() ? GuiUtils.getFrameScreenBounds(this) : GuiUtils.getMainScreenBounds();
        Insets ins = this.isVisible() ? GuiUtils.getFrameScreenInsets(this) : GuiUtils.getMainScreenInsets();
        Dimension dd = this.getSize();
        int insW = Math.max(24, ins.left + ins.right);
        int insH = Math.max(24, ins.top + ins.bottom);
        int availW = rr.width - insW;
        int availH = rr.height - insH;
        int excessW = Math.max(0, dd.width - availW);
        int excessH = Math.max(0, dd.height - availH);
        return excessW > 0 || excessH > 0;
    }

    public void resizeToFitDisplay() {
    }

    public void refresh() {
    }

    public void refreshMenu(String menuName) {
        EventQueue.invokeLater(() -> {
            PanMenuBar mbar = this.getPanMenuBar();
            if (mbar != null) {
                GissMenu menu = mbar.getMenuByName(menuName);
                if (menu == null) {
                    LOGGER.warn("No menu named {}", (Object)menuName);
                } else {
                    menu.refresh();
                }
            }
        });
    }

    public void close() {
    }

    public boolean isBusy() {
        return PanFrame.getTaskQueue().size() > 0;
    }

    public void addTask(Task task) {
        PanFrame.getTaskQueue().add(task);
    }

    public StatusBar getStatusBar() {
        if (this.statusBar_ == null) {
            this.statusBar_ = new StatusBar(PanFrame.getTaskQueue());
        }
        return this.statusBar_;
    }

    public static TaskQueue getTaskQueue() {
        return taskQueue_;
    }

    public static PanFrame getActiveFrame() {
        JFrame jf = GuiUtils.getActiveFrame();
        if (jf instanceof PanFrame) {
            return (PanFrame)jf;
        }
        return PanFrame.getDummyFrame();
    }

    private static PanFrame getDummyFrame() {
        if (dummyFrame_ == null) {
            dummyFrame_ = new PanFrame();
        }
        return dummyFrame_;
    }
}

