/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.color.ColorTableComboBoxRenderer;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanColorTableComboBox
extends JComboBox<AbstractColorTable>
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean refreshing_;

    private PanColorTableComboBox(boolean showSample) {
        this(PanGuiSize.REGULAR, null, showSample);
    }

    private PanColorTableComboBox(PanGuiSize size, String name, boolean showSample) {
        String ctname;
        AbstractColorTable act;
        if (name != null) {
            this.setName(name);
        }
        ArrayList<Integer> badItems = new ArrayList<Integer>(5);
        ColorTableResourceList reslist = PanUtils.getColorTableResourceList();
        Object[] items = reslist.toArray();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) {
                badItems.add(i);
            }
            this.addItem((AbstractColorTable)items[i]);
        }
        int bsize = badItems.size();
        if (!badItems.isEmpty()) {
            String msg = null;
            msg = bsize == 1 ? "Encountered bad color table " + reslist.getName((Integer)badItems.get(0)) + ";  removing it from resource list." : (bsize == 2 ? "Encountered bad color tables " + reslist.getName((Integer)badItems.get(0)) + " and " + reslist.getName((Integer)badItems.get(1)) + "removing them from resource list." : "Encountered " + bsize + " bad color tables; removing them from resource list.");
            GuiUtils.showSlowMessage(null, "Resource Error", msg);
            Collections.reverse(badItems);
            for (Integer ii : badItems) {
                LOGGER.warn("Removing bad color table {} resource.", (Object)reslist.getName(ii));
                reslist.remove(ii);
            }
        }
        if (showSample) {
            this.setRenderer(new ColorTableComboBoxRenderer());
        }
        if ((act = PanUtils.getColorTable(ctname = PanPreferences.getSharedInstance().getString("plot:colorbar.name"))) == null) {
            try {
                this.setSelectedItem(PanUtils.getDefaultColorTable());
            }
            catch (Exception exc) {
                LOGGER.debug("Exception setting CT combo to default: {}", (Object)exc.toString());
            }
        } else {
            this.setSelectedItem(act);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
        PanUtils.getColorTableResourceList().addListDataListener(this);
    }

    public boolean isRefreshing() {
        return this.refreshing_;
    }

    public void refresh() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.refreshing_ = false;
    }

    public void setSelectedItemByName(String name) {
        if (name == null) {
            return;
        }
        int isize = this.getItemCount();
        for (int i = 0; i < isize; ++i) {
            if (!name.equalsIgnoreCase(((AbstractColorTable)this.getItemAt(i)).toString())) continue;
            this.setSelectedIndex(i);
            return;
        }
        LOGGER.warn("Could not find matching item for name {}", (Object)name);
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        ColorTableResourceList reslist = PanUtils.getColorTableResourceList();
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        for (int i = index0; i <= index1; ++i) {
            Object ct = reslist.getBackingObject(i);
            this.insertItemAt((AbstractColorTable)ct, i);
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
        int index1;
        int index = this.getSelectedIndex();
        int index0 = e.getIndex0();
        for (int i = index1 = e.getIndex1(); i >= index0; --i) {
            this.removeItemAt(i);
        }
        if (index >= index0 && index <= index1) {
            if (index0 > 0) {
                this.setSelectedIndex(index0 - 1);
            } else {
                this.setSelectedIndex(index0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanColorTableComboBox panColorTableComboBox = this;
        synchronized (panColorTableComboBox) {
            PanUtils.getColorTableResourceList().removeListDataListener(this);
            this.removeAll();
        }
    }

    public static PanColorTableComboBox create(String name, boolean showSample) {
        return new PanColorTableComboBox(PanGuiSize.REGULAR, name, showSample);
    }

    public static PanColorTableComboBox create(boolean showSample) {
        return new PanColorTableComboBox(PanGuiSize.REGULAR, null, showSample);
    }

    public static PanColorTableComboBox small(String name, boolean showSample) {
        return new PanColorTableComboBox(PanGuiSize.SMALL, name, showSample);
    }

    public static PanColorTableComboBox small(boolean showSample) {
        return new PanColorTableComboBox(PanGuiSize.SMALL, null, showSample);
    }
}

