/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.ui.PanTextField;
import java.lang.invoke.MethodHandles;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCaptionListener
implements DocumentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanTextField tf_;
    private final PanPlotMeta pmeta_;
    private final String captionKey_;

    public PanCaptionListener(PanTextField tf, PanPlotMeta pmeta, String captionKey) {
        this.tf_ = tf;
        this.pmeta_ = pmeta;
        this.captionKey_ = captionKey;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        LOGGER.trace("{}", (Object)this.tf_.getText());
        this.updateCaption();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        LOGGER.trace("{}", (Object)this.tf_.getText());
        this.updateCaption();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        LOGGER.trace("{}", (Object)this.tf_.getText());
        this.updateCaption();
    }

    private void updateCaption() {
        String oldval;
        String text = this.tf_.getText();
        if (text.equals(oldval = this.pmeta_.getString(this.captionKey_))) {
            return;
        }
        this.pmeta_.setString(this.captionKey_, text);
    }
}

