/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.action.PanCombinePlotAction;
import gov.nasa.giss.panoply.action.PanCreatePlotAction;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanPlotSizeFactor;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.Toolbar;
import gov.nasa.giss.ui.ToolbarButton;
import gov.nasa.giss.util.PropertyList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class PanSourcesToolBar
extends Toolbar {
    private static final PropertyList POPUP_PROPS = PanProperties.POPUP_PROPS;
    private static final PropertyList SOURCES_PROPS = PanProperties.SOURCES_PROPS;
    private final PanSourcesFrame parent_;
    private final ImageIcon hideInfoIcon_;
    private final ImageIcon showInfoIcon_;
    private final ToolbarButton createPlotBtn_;
    private final ToolbarButton combinePlotBtn_;
    private final ToolbarButton openDatasetBtn_;
    private final ToolbarButton removeOneBtn_;
    private final ToolbarButton removeAllBtn_;
    private final ToolbarButton toggleInfoBtn_;
    private final int lprefIconWidth_;
    private final int rprefIconWidth_;

    public PanSourcesToolBar(PanSourcesFrame parent) {
        this.parent_ = parent;
        this.setShowBottomEdge(false);
        PanActionHash actionHash = this.parent_.getActionHash();
        ImageIcon createPlotIcon = new ImageIcon(this.getClass().getResource("resources/createplot.png"));
        ImageIcon combinePlotIcon = new ImageIcon(this.getClass().getResource("resources/combineplot.png"));
        ImageIcon openDatasetIcon = new ImageIcon(this.getClass().getResource("resources/opendataset.png"));
        this.hideInfoIcon_ = new ImageIcon(this.getClass().getResource("resources/hideinfo.png"));
        this.showInfoIcon_ = new ImageIcon(this.getClass().getResource("resources/showinfo.png"));
        ImageIcon removeOneIcon = new ImageIcon(this.getClass().getResource("resources/clear.png"));
        ImageIcon removeAllIcon = new ImageIcon(this.getClass().getResource("resources/clearall.png"));
        this.createPlotBtn_ = new ToolbarButton(createPlotIcon, SOURCES_PROPS.getString("create-plot"), (Action)actionHash.get("create-plot"), SOURCES_PROPS.getString("create-plot-tip"));
        this.combinePlotBtn_ = new ToolbarButton(combinePlotIcon, SOURCES_PROPS.getString("combine-plot"), (Action)actionHash.get("combine-plot"), SOURCES_PROPS.getString("combine-plot-tip"));
        this.openDatasetBtn_ = new ToolbarButton(openDatasetIcon, SOURCES_PROPS.getString("open-catalog-data"), (Action)actionHash.get("open-catalog-data"), SOURCES_PROPS.getString("open-dataset-tip"));
        this.toggleInfoBtn_ = new ToolbarButton(this.hideInfoIcon_, SOURCES_PROPS.getString("toggle-info"), (Action)actionHash.get("toggle-info"), SOURCES_PROPS.getString("toggle-info-tip"));
        this.removeOneBtn_ = new ToolbarButton(removeOneIcon, SOURCES_PROPS.getString("remove-one"), (Action)actionHash.get("remove-one"), SOURCES_PROPS.getString("remove-one-tip"));
        this.removeAllBtn_ = new ToolbarButton(removeAllIcon, SOURCES_PROPS.getString("remove-all"), (Action)actionHash.get("remove-all"), SOURCES_PROPS.getString("remove-all-tip"));
        this.add(this.createPlotBtn_);
        this.add(this.combinePlotBtn_);
        this.add(this.openDatasetBtn_);
        this.add(Box.createHorizontalGlue());
        this.add(this.removeOneBtn_);
        this.add(this.removeAllBtn_);
        this.add(this.toggleInfoBtn_);
        this.lprefIconWidth_ = MathUtils.max(this.createPlotBtn_.getPreferredSize().width, this.combinePlotBtn_.getPreferredSize().width, this.openDatasetBtn_.getPreferredSize().width) + 4;
        this.rprefIconWidth_ = MathUtils.max(this.removeOneBtn_.getPreferredSize().width, this.removeAllBtn_.getPreferredSize().width, this.toggleInfoBtn_.getPreferredSize().width) + 4;
        this.refresh();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width = 10000;
        return d;
    }

    public final void refresh() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        if (prefs.getBoolean("sources:toolbar.labels")) {
            this.createPlotBtn_.setText(SOURCES_PROPS.getString("create-plot"));
            this.combinePlotBtn_.setText(SOURCES_PROPS.getString("combine-plot"));
            this.openDatasetBtn_.setText(SOURCES_PROPS.getString("open-catalog-data"));
            this.removeOneBtn_.setText(SOURCES_PROPS.getString("remove-one"));
            this.removeAllBtn_.setText(SOURCES_PROPS.getString("remove-all"));
            if (prefs.getBoolean("sources:info.vis")) {
                this.toggleInfoBtn_.setText(SOURCES_PROPS.getString("hide-info"));
            } else {
                this.toggleInfoBtn_.setText(SOURCES_PROPS.getString("show-info"));
            }
        } else {
            this.openDatasetBtn_.setText(null);
            this.createPlotBtn_.setText(null);
            this.combinePlotBtn_.setText(null);
            this.removeOneBtn_.setText(null);
            this.removeAllBtn_.setText(null);
            this.toggleInfoBtn_.setText(null);
        }
        if (prefs.getBoolean("sources:info.vis")) {
            this.toggleInfoBtn_.setIcon(this.hideInfoIcon_);
        } else {
            this.toggleInfoBtn_.setIcon(this.showInfoIcon_);
        }
        this.refreshCreatePlotButton();
        this.refreshCombinePlotButton();
        this.createPlotBtn_.setPreferredSize(null);
        Dimension psize = this.createPlotBtn_.getPreferredSize();
        psize.width = this.lprefIconWidth_;
        this.createPlotBtn_.setPreferredSize(psize);
        this.combinePlotBtn_.setPreferredSize(psize);
        this.openDatasetBtn_.setPreferredSize(psize);
        this.createPlotBtn_.setMaximumSize(psize);
        this.combinePlotBtn_.setMaximumSize(psize);
        this.openDatasetBtn_.setMaximumSize(psize);
        this.removeOneBtn_.setPreferredSize(null);
        psize = this.removeOneBtn_.getPreferredSize();
        psize.width = this.rprefIconWidth_;
        this.removeOneBtn_.setPreferredSize(psize);
        this.removeAllBtn_.setPreferredSize(psize);
        this.toggleInfoBtn_.setPreferredSize(psize);
        this.removeOneBtn_.setMaximumSize(psize);
        this.removeAllBtn_.setMaximumSize(psize);
        this.toggleInfoBtn_.setMaximumSize(psize);
    }

    private void refreshCreatePlotButton() {
        PanActionHash actionHash = this.parent_.getActionHash();
        final PanCreatePlotAction a = (PanCreatePlotAction)actionHash.get("create-plot");
        boolean createEnabled = a.isEnabled();
        this.createPlotBtn_.setEnabled(createEnabled);
        JPopupMenu popup = this.createPlotBtn_.getComponentPopupMenu();
        if (popup != null) {
            popup.setEnabled(createEnabled);
            for (Component c : popup.getComponents()) {
                if (c == null) continue;
                c.setEnabled(createEnabled);
            }
            return;
        }
        popup = new JPopupMenu("Create Plot");
        this.createPlotBtn_.setComponentPopupMenu(popup);
        popup.add(a);
        popup.addSeparator();
        AbstractAction size080Action = new AbstractAction(POPUP_PROPS.getString("size-080")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSizeFactor.SIZE_080);
            }
        };
        popup.add(size080Action);
        AbstractAction size100Action = new AbstractAction(POPUP_PROPS.getString("size-100")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSizeFactor.SIZE_100);
            }
        };
        popup.add(size100Action);
        AbstractAction size120Action = new AbstractAction(POPUP_PROPS.getString("size-120")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSizeFactor.SIZE_120);
            }
        };
        popup.add(size120Action);
        AbstractAction size140Action = new AbstractAction(POPUP_PROPS.getString("size-140")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSizeFactor.SIZE_140);
            }
        };
        popup.add(size140Action);
        AbstractAction size160Action = new AbstractAction(POPUP_PROPS.getString("size-160")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSizeFactor.SIZE_160);
            }
        };
        popup.add(size160Action);
        AbstractAction size180Action = new AbstractAction(POPUP_PROPS.getString("size-180")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSizeFactor.SIZE_180);
            }
        };
        popup.add(size180Action);
        AbstractAction size200Action = new AbstractAction(POPUP_PROPS.getString("size-200")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSizeFactor.SIZE_200);
            }
        };
        popup.add(size200Action);
        AbstractAction size240Action = new AbstractAction(POPUP_PROPS.getString("size-240")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSizeFactor.SIZE_240);
            }
        };
        popup.add(size240Action);
        AbstractAction size300Action = new AbstractAction(POPUP_PROPS.getString("size_300")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSizeFactor.SIZE_300);
            }
        };
        popup.add(size300Action);
        size080Action.setEnabled(false);
        size100Action.setEnabled(false);
        size120Action.setEnabled(false);
        size140Action.setEnabled(false);
        size160Action.setEnabled(false);
        size180Action.setEnabled(false);
        size200Action.setEnabled(false);
        size240Action.setEnabled(false);
        size300Action.setEnabled(false);
    }

    private void refreshCombinePlotButton() {
        PanActionHash actionHash = this.parent_.getActionHash();
        final PanCombinePlotAction a = (PanCombinePlotAction)actionHash.get("combine-plot");
        this.combinePlotBtn_.setEnabled(a.isEnabled());
        if (!this.combinePlotBtn_.isEnabled()) {
            return;
        }
        JPopupMenu popup = this.combinePlotBtn_.getComponentPopupMenu();
        if (popup == null) {
            popup = new JPopupMenu("Combine Plot");
            this.combinePlotBtn_.setComponentPopupMenu(popup);
        }
        popup.removeAll();
        final PanPlotFrame[] plotFrames = PanGuiUtils.getPlotFrames();
        int isize = plotFrames.length;
        for (int i = 0; i < isize; ++i) {
            final int ii = i;
            AbstractAction action = new AbstractAction("Combine in " + plotFrames[i].getTitle()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    a.addToExistingPlot(plotFrames[ii].getTitle());
                }
            };
            popup.add(action);
        }
    }
}

