/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.data.nc.NcCatalogNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.panoply.action.PanAddBookmarkAction;
import gov.nasa.giss.panoply.action.PanCombinePlotAction;
import gov.nasa.giss.panoply.action.PanCreatePlotAction;
import gov.nasa.giss.panoply.action.PanExportCdlAction;
import gov.nasa.giss.panoply.action.PanExportCsvAction;
import gov.nasa.giss.panoply.action.PanExportTextAction;
import gov.nasa.giss.panoply.action.PanOpenCatalogDatasetAction;
import gov.nasa.giss.panoply.action.PanRemoveAllSourcesAction;
import gov.nasa.giss.panoply.action.PanRemoveOneSourceAction;
import gov.nasa.giss.panoply.action.PanSourceFindAction;
import gov.nasa.giss.panoply.action.PanSourceFindNextAction;
import gov.nasa.giss.panoply.action.PanToggleSourcesInfoAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.prefs.PanBookmarksNode;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanBookmarksPanel;
import gov.nasa.giss.panoply.sources.PanCatalogsPanel;
import gov.nasa.giss.panoply.sources.PanDnVPanel;
import gov.nasa.giss.panoply.sources.PanSourcesPanel;
import gov.nasa.giss.panoply.sources.PanSourcesTabbedPane;
import gov.nasa.giss.panoply.sources.PanSourcesToolBar;
import gov.nasa.giss.panoply.ui.PanContentPanel;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.PropertyList;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.BoxLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanSourcesFrame
extends PanFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PropertyList SOURCES_PROPS = PanProperties.SOURCES_PROPS;
    private PanActionHash actionHash_;
    private PanContentPanel contentBox_;
    private PanSourcesToolBar toolbar_;
    private PanSourcesTabbedPane fTabbedPane_;
    private PanDnVPanel datasetsPanel_;
    private PanCatalogsPanel catalogsPanel_;
    private PanBookmarksPanel bookmarksPanel_;
    private Dimension minSize_;
    private int chromeWidth_;
    private int chromeHeight_;

    public static PanSourcesFrame getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanSourcesFrame() {
        block3: {
            super(PanProperties.SOURCES_PROPS.getString("frame-title"));
            this.setName(this.getTitle());
            if (PlatformUtils.isWindows()) {
                this.setTitle("Panoply: " + this.getTitle());
            }
            this.setResizable(true);
            try {
                this.createMenuBar();
                this.createLayout();
                this.placeOnScreen();
                this.attachListeners();
            }
            catch (Exception exc) {
                if (!LOGGER.isDebugEnabled()) break block3;
                exc.printStackTrace();
            }
        }
        this.refresh();
    }

    private PanMenuBar createMenuBar() {
        PanMenuBar mbar = new PanMenuBar(this);
        this.setPanMenuBar(mbar);
        this.actionHash_ = new PanActionHash(30);
        this.actionHash_.addChangeListener(e -> this.toolbar_.refresh());
        this.actionHash_.put("open-catalog-data", new PanOpenCatalogDatasetAction(this));
        this.actionHash_.put("create-plot", new PanCreatePlotAction(this));
        this.actionHash_.put("combine-plot", new PanCombinePlotAction(this));
        this.actionHash_.put("export-cdl", new PanExportCdlAction(this));
        this.actionHash_.put("export-csv", new PanExportCsvAction(this));
        this.actionHash_.put("export-text", new PanExportTextAction(this));
        this.actionHash_.put("add-bookmark", new PanAddBookmarkAction(this));
        this.actionHash_.put("remove-one", new PanRemoveOneSourceAction(this));
        this.actionHash_.put("remove-all", new PanRemoveAllSourcesAction(this));
        this.actionHash_.put("toggle-info", PanToggleSourcesInfoAction.getSharedInstance());
        this.actionHash_.put("find", new PanSourceFindAction(this));
        this.actionHash_.put("find-next", new PanSourceFindNextAction(this));
        mbar.getItemByName("file-export-menu", "export-cdl").setAction((Action)this.actionHash_.get("export-cdl"));
        mbar.getItemByName("file-export-menu", "export-csv").setAction((Action)this.actionHash_.get("export-csv"));
        mbar.getItemByName("file-export-menu", "export-text").setAction((Action)this.actionHash_.get("export-text"));
        mbar.getItemByName("edit-menu", "clear").setAction((Action)this.actionHash_.get("remove-one"));
        mbar.getItemByName("edit-menu", "clear").setText(SOURCES_PROPS.getString("remove-one"));
        mbar.getItemByName("edit-menu", "find").setAction((Action)this.actionHash_.get("find"));
        mbar.getItemByName("edit-menu", "find-next").setAction((Action)this.actionHash_.get("find-next"));
        mbar.getItemByName("bookmarks-menu", "add-bookmark").setAction((Action)this.actionHash_.get("add-bookmark"));
        mbar.getItemByName("plot-menu", "create-plot").setAction((Action)this.actionHash_.get("create-plot"));
        return mbar;
    }

    private void createLayout() {
        this.toolbar_ = new PanSourcesToolBar(this);
        this.datasetsPanel_ = new PanDnVPanel(this);
        this.catalogsPanel_ = new PanCatalogsPanel(this);
        this.bookmarksPanel_ = new PanBookmarksPanel(this);
        this.fTabbedPane_ = new PanSourcesTabbedPane();
        this.fTabbedPane_.addTab(SOURCES_PROPS.getString("datasets-tab-label"), this.datasetsPanel_);
        this.fTabbedPane_.addTab(SOURCES_PROPS.getString("catalogs-tab-label"), this.catalogsPanel_);
        this.fTabbedPane_.addTab(SOURCES_PROPS.getString("bookmarks-tab-label"), this.bookmarksPanel_);
        this.contentBox_ = new PanContentPanel(0);
        this.contentBox_.setLayout(new BoxLayout(this.contentBox_, 1));
        this.contentBox_.add(this.toolbar_);
        this.contentBox_.add(this.fTabbedPane_);
        this.contentBox_.add(this.getStatusBar());
        Dimension bbminsize = this.contentBox_.getMinimumSize();
        PanPreferences prefs = PanPreferences.getSharedInstance();
        int prefw = prefs.getInt("sources:bounds.width");
        int prefh = prefs.getInt("sources:bounds.height");
        int bbwidth = Math.max(bbminsize.width, prefw);
        int bbheight = Math.max(bbminsize.height, prefh);
        this.contentBox_.setPreferredSize(new Dimension(bbwidth, bbheight));
        this.contentBox_.setMaximumSize(new Dimension(9999, 9999));
        this.getContentPane().add(this.contentBox_);
        this.pack();
        Dimension dd = this.getSize();
        this.chromeWidth_ = dd.width - bbwidth;
        this.chromeHeight_ = dd.height - bbheight;
        this.minSize_ = new Dimension(bbminsize.width + this.chromeWidth_, bbminsize.height + this.chromeHeight_);
        if (PlatformUtils.isMacintosh() || PlatformUtils.isWindows()) {
            this.setMinimumSize(this.minSize_);
        }
    }

    @Override
    protected void placeOnScreen() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        try {
            int whereX = prefs.getInt("sources:bounds.left");
            int whereY = prefs.getInt("sources:bounds.top");
            if (whereX < 0 && whereY < 0) {
                Rectangle rr = GuiUtils.getActiveScreenBounds();
                Dimension psize = this.getSize();
                if (rr == null) {
                    whereX = 50;
                    whereY = 50;
                } else if (PlatformUtils.isMacintosh()) {
                    whereX = rr.x + (rr.width - psize.width) / 2;
                    whereY = rr.y + (rr.height - psize.height) / 2 + 10;
                } else {
                    whereX = rr.x + (rr.width - psize.width) / 2;
                    whereY = rr.y + (rr.height - psize.height) / 2;
                }
                prefs.setInt("sources:bounds.left", whereX);
                prefs.setInt("sources:bounds.top", whereY);
            }
            this.setLocation(new Point(whereX, whereY));
        }
        catch (Exception exc) {
            super.placeOnScreen();
        }
    }

    private void attachListeners() {
        final PanPreferences prefs = PanPreferences.getSharedInstance();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                PanSourcesFrame.this.datasetsPanel_.clearPopup();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                PanSourcesFrame.this.datasetsPanel_.clearPopup();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (!PanSourcesFrame.this.isVisible()) {
                    return;
                }
                Point p = PanSourcesFrame.this.getLocationOnScreen();
                prefs.setInt("sources:bounds.left", p.x);
                prefs.setInt("sources:bounds.top", p.y);
                if (PanSourcesFrame.this.needsResizeToFitDisplay()) {
                    PanSourcesFrame.this.resizeToFitDisplay();
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension dd = PanSourcesFrame.this.getSize();
                if (!(PlatformUtils.isMacintosh() || PlatformUtils.isWindows() || dd.width >= ((PanSourcesFrame)PanSourcesFrame.this).minSize_.width && dd.height >= ((PanSourcesFrame)PanSourcesFrame.this).minSize_.height)) {
                    dd.width = Math.max(((PanSourcesFrame)PanSourcesFrame.this).minSize_.width, dd.width);
                    dd.height = Math.max(((PanSourcesFrame)PanSourcesFrame.this).minSize_.height, dd.height);
                    PanSourcesFrame.this.setSize(dd);
                    dd.width -= PanSourcesFrame.this.chromeWidth_;
                    dd.height -= PanSourcesFrame.this.chromeHeight_;
                    PanSourcesFrame.this.contentBox_.setSize(dd);
                    PanSourcesFrame.this.getContentPane().validate();
                    return;
                }
                prefs.setInt("sources:bounds.width", PanSourcesFrame.this.contentBox_.getWidth());
                prefs.setInt("sources:bounds.height", PanSourcesFrame.this.contentBox_.getHeight());
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                PanSourcesFrame.this.datasetsPanel_.clearPopup();
            }
        });
    }

    @Override
    public void resizeToFitDisplay() {
        Dimension dd = this.getSize();
        Rectangle rr = this.isVisible() ? GuiUtils.getFrameScreenBounds(this) : GuiUtils.getMainScreenBounds();
        Insets ins = this.isVisible() ? GuiUtils.getFrameScreenInsets(this) : GuiUtils.getMainScreenInsets();
        int insW = Math.max(24, ins.left + ins.right);
        int insH = Math.max(24, ins.top + ins.bottom);
        int availW = rr.width - insW;
        int availH = rr.height - insH;
        int excessW = Math.max(0, dd.width - availW);
        int excessH = Math.max(0, dd.height - availH);
        Dimension bbSize = this.contentBox_.getSize();
        bbSize.width -= excessW;
        bbSize.height -= excessH;
        this.contentBox_.setPreferredSize(bbSize);
        this.contentBox_.invalidate();
        this.contentBox_.validate();
        this.pack();
        this.repaint();
    }

    public PanSourcesPanel getVisibleSubpanel() {
        if (this.fTabbedPane_ == null) {
            return null;
        }
        return this.fTabbedPane_.getVisibleSubpanel();
    }

    public PanSourcesPanel getSubpanel(Subpanel panelID) {
        switch (panelID) {
            case DATASETS: {
                return this.datasetsPanel_;
            }
            case CATALOGS: {
                return this.catalogsPanel_;
            }
            case BOOKMARKS: {
                return this.bookmarksPanel_;
            }
        }
        return null;
    }

    public void showSubpanel(Subpanel panelID) {
        EventQueue.invokeLater(() -> {
            switch (panelID) {
                case DATASETS: {
                    this.fTabbedPane_.setSelectedComponent(this.datasetsPanel_);
                    break;
                }
                case CATALOGS: {
                    this.fTabbedPane_.setSelectedComponent(this.catalogsPanel_);
                    break;
                }
                case BOOKMARKS: {
                    this.fTabbedPane_.setSelectedComponent(this.bookmarksPanel_);
                    break;
                }
            }
        });
    }

    public boolean isDatasetOpen() {
        return this.datasetsPanel_.isDatasetOpen();
    }

    public NcDataset addDataset(NcDataset ncd) throws IOException {
        this.showSubpanel(Subpanel.DATASETS);
        return this.datasetsPanel_.addDataset(ncd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NcCatalogNode addCatalog(URL url) throws IOException, URISyntaxException {
        PanSourcesFrame panSourcesFrame = this;
        synchronized (panSourcesFrame) {
            this.showSubpanel(Subpanel.CATALOGS);
            return this.catalogsPanel_.addCatalog(url);
        }
    }

    public PanBookmarksNode addBookmarksNode(PanBookmarksNode node) {
        if (node == null) {
            return null;
        }
        return this.bookmarksPanel_.addNode(node);
    }

    public void clear() {
        this.fTabbedPane_.getVisibleSubpanel().clear();
    }

    public TreeTableNode getSelectedNode() {
        return this.fTabbedPane_.getVisibleSubpanel().getSelectedNode();
    }

    public void showFind() {
        PanSourcesPanel pss = this.fTabbedPane_.getVisibleSubpanel();
        pss.showFind(true);
    }

    public void findNext() {
        PanSourcesPanel psp = this.fTabbedPane_.getVisibleSubpanel();
        psp.findNext();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.refresh();
        }
        super.setVisible(visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        PanSourcesFrame panSourcesFrame = this;
        synchronized (panSourcesFrame) {
            this.fTabbedPane_.getVisibleSubpanel().refreshActions();
            this.fTabbedPane_.getVisibleSubpanel().refreshInfoPane();
            this.toolbar_.refresh();
            int ph = this.toolbar_.getPreferredSize().height;
            this.toolbar_.setMinimumSize(new Dimension(540, ph));
            this.toolbar_.setMaximumSize(new Dimension(9999, ph));
            if (this.getSize() != null) {
                this.toolbar_.setSize(new Dimension(this.getWidth(), ph));
            }
            this.remakeLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remakeLayout() {
        PanSourcesFrame panSourcesFrame = this;
        synchronized (panSourcesFrame) {
            this.fTabbedPane_.getVisibleSubpanel().remakeLayout();
        }
    }

    public PanActionHash getActionHash() {
        return this.actionHash_;
    }

    private static class Singleton {
        private static final PanSourcesFrame INSTANCE = new PanSourcesFrame();

        private Singleton() {
        }
    }

    public static enum Subpanel {
        DATASETS,
        CATALOGS,
        BOOKMARKS;

    }
}

