/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.data.nc.NcCatalog;
import gov.nasa.giss.data.nc.NcCatalogDataset;
import gov.nasa.giss.data.nc.NcCatalogNode;
import gov.nasa.giss.data.nc.ui.NcCatalogTreeTablePanel;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefs.PanHistoryList;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.sources.PanSourcesPanel;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.event.TreeTableEvent;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCatalogsPanel
extends PanSourcesPanel
implements HyperlinkListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private NcCatalogNode oldNode_;

    public PanCatalogsPanel(PanSourcesFrame parent) {
        super(parent, true);
        this.infoPane_.addHyperlinkListener(this);
    }

    @Override
    protected JComponent makeTreeHolder() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        this.ttPanel_ = new NcCatalogTreeTablePanel();
        this.ttPanel_.setOpaque(true);
        this.ttPanel_.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
        this.ttPanel_.addTreeTableListener(this);
        ((NcCatalogTreeTablePanel)this.ttPanel_).setExpandNewNodes(prefs.getBoolean("sources:nodes.expanded"));
        return this.ttPanel_;
    }

    @Override
    public final void showFind(boolean visible) {
        super.showFind(visible);
        PanPreferences prefs = PanPreferences.getSharedInstance();
        if (visible && !prefs.getBoolean("sources:catalogs.find.warned")) {
            JOptionPane.showMessageDialog(this.parent_, "Please proceed with caution. Searching remote catalogs can\nbe extremely slow and may require making many, many network\nrequests.", "Caution", 2);
            prefs.setBoolean("sources:catalogs.find.warned", true);
        }
    }

    @Override
    synchronized void refreshActions() {
        if (this.ttPanel_ != null) {
            PanPreferences prefs = PanPreferences.getSharedInstance();
            ((NcCatalogTreeTablePanel)this.ttPanel_).setExpandNewNodes(prefs.getBoolean("sources:nodes.expanded"));
        }
        PanActionHash actionHash = this.parent_.getActionHash();
        actionHash.disableAll();
        actionHash.setEnabled("toggle-info", true);
        if (this.ttPanel_.getModel().getRowCount() > 0) {
            actionHash.setEnabled("remove-all", true);
            actionHash.setEnabled("find", true);
            actionHash.setEnabled("find-next", true);
        } else {
            actionHash.setEnabled("find", this.isFindVisible());
        }
        TreeTableNode node = this.getSelectedNode();
        if (node instanceof NcCatalog) {
            actionHash.setEnabled("add-bookmark", true);
            actionHash.setEnabled("remove-one", true);
        } else if (node instanceof NcCatalogDataset) {
            actionHash.setEnabled("open-catalog-data", ((NcCatalogDataset)node).getURI() != null);
            actionHash.setEnabled("add-bookmark", ((NcCatalogDataset)node).getAllowsChildren());
        }
    }

    @Override
    protected void refreshInfoPane() {
        TreeTableNode node = this.getSelectedNode();
        if (node == null) {
            this.infoPane_.setContentType("text/plain");
            this.infoPane_.setText("");
            this.oldNode_ = null;
        } else if (node != this.oldNode_) {
            String newText = ((NcCatalogNode)node).getDetail();
            if (newText == null) {
                this.infoPane_.setContentType("text/plain");
                this.infoPane_.setText("");
            } else {
                String newType = ((NcCatalogNode)node).getDetailType();
                this.infoPane_.setContentType(newType);
                this.infoPane_.setText(newText);
                this.infoPane_.setCaretPosition(0);
            }
            this.oldNode_ = (NcCatalogNode)node;
        }
    }

    @Override
    public void clear() {
        for (Object o : ((NcCatalogTreeTablePanel)this.ttPanel_).getCatalogs()) {
            this.removeNode((TreeTableNode)o);
        }
    }

    public synchronized NcCatalogNode addCatalog(URL url) throws MalformedURLException, URISyntaxException {
        if (url == null) {
            return null;
        }
        return ((NcCatalogTreeTablePanel)this.ttPanel_).addCatalog(url);
    }

    @Override
    public void removeNode(TreeTableNode node) {
        if (node == null) {
            return;
        }
        if (!(node instanceof NcCatalog)) {
            throw new IllegalArgumentException("Can only remove a Catalog");
        }
        ((NcCatalogTreeTablePanel)this.ttPanel_).removeCatalog((NcCatalog)node);
        this.refreshActions();
        this.refreshInfoPane();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCatalogCount() {
        PanCatalogsPanel panCatalogsPanel = this;
        synchronized (panCatalogsPanel) {
            return ((NcCatalogTreeTablePanel)this.ttPanel_).getCatalogCount();
        }
    }

    @Override
    public void selectionMade(TreeTableEvent e) {
        this.refreshActions();
        this.refreshInfoPane();
        NcCatalogNode node = (NcCatalogNode)e.getNode();
        if (node == null) {
            return;
        }
        int id = e.getID();
        if (id == 102 && node instanceof NcCatalogDataset) {
            URI uri = ((NcCatalogDataset)node).getURI();
            if (uri == null) {
                return;
            }
            PanActionHash actionHash = this.parent_.getActionHash();
            ((Action)actionHash.get("open-catalog-data")).actionPerformed(null);
        }
    }

    @Override
    public void itemAdded(TreeTableEvent e) {
        this.refreshActions();
        this.refreshInfoPane();
        this.repaint();
        TreeTableNode node = e.getNode();
        if (!(node instanceof NcCatalog)) {
            return;
        }
        PanHistoryList.getSharedInstance().addBookmark((NcCatalog)node);
        GuiUtils.refreshFrontFrameMenuBar();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        block5: {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (e instanceof HTMLFrameHyperlinkEvent) {
                return;
            }
            try {
                URL url = e.getURL();
                String s = url.toString();
                if (!s.startsWith("http:") && !s.startsWith("ftp:")) {
                    throw new RuntimeException("Unknown protocol in " + s);
                }
                PanFileUtils.openDataset(url);
            }
            catch (Exception exc) {
                if (!LOGGER.isTraceEnabled()) break block5;
                exc.printStackTrace();
            }
        }
    }
}

