/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.server;

import gov.nasa.giss.data.nc.NcFilenameFilter;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanProtocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String PROTOCOL_VERSION = "4.5";
    private State state_ = State.WAITING;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String processInput(String readFromClient) {
        LOGGER.trace("state '{}' -- process '{}'", (Object)this.state_, (Object)readFromClient);
        if (readFromClient != null && "bye.".equalsIgnoreCase(readFromClient)) {
            this.state_ = State.WAITING;
            return "Bye.";
        }
        Object sendToClient = null;
        switch (this.state_) {
            case WAITING: {
                sendToClient = "panoply";
                this.state_ = State.EXPECTING_PROTOCOL;
                return sendToClient;
            }
            case EXPECTING_PROTOCOL: {
                sendToClient = "version";
                this.state_ = State.EXPECTING_VERSION;
                return sendToClient;
            }
            case EXPECTING_VERSION: {
                LOGGER.trace("handling EXPECTING_VERSION, got {}", (Object)readFromClient);
                if (readFromClient.equalsIgnoreCase(PROTOCOL_VERSION)) {
                    sendToClient = "filepath";
                    this.state_ = State.EXPECTING_FILEPATH;
                    return sendToClient;
                }
                sendToClient = "Error. Panoply version mis-match.";
                this.state_ = State.WAITING;
                return sendToClient;
            }
            case EXPECTING_USERID: {
                LOGGER.trace("handling EXPECTING_USERID, got {}", (Object)readFromClient);
                return sendToClient;
            }
            case EXPECTING_FILEPATH: {
                LOGGER.trace("handling EXPECTING_FILEPATH, got {}", (Object)readFromClient);
                LOGGER.trace("finding sources frame");
                PanSourcesFrame sourcesFrame = PanSourcesFrame.getSharedInstance();
                LOGGER.trace("found sources frame");
                if (!NcFilenameFilter.accept(readFromClient)) return "Error opening " + readFromClient + ". Not a recognized dataset filename extension.";
                LOGGER.trace("adding dataset");
                try {
                    LOGGER.trace("making File object");
                    File f = new File(readFromClient);
                    LOGGER.trace("adding dataset");
                    PanFileUtils.openDataset(f);
                }
                catch (Exception exc) {
                    return "Error opening " + readFromClient + ": " + exc.toString();
                }
                sourcesFrame.repaint();
                sourcesFrame.setVisible(true);
                sourcesFrame.toFront();
                sendToClient = "continue?";
                this.state_ = State.CONTINUE;
                return sendToClient;
            }
            case CONTINUE: {
                if (readFromClient.equalsIgnoreCase("y")) {
                    sendToClient = "filepath";
                    this.state_ = State.EXPECTING_FILEPATH;
                    return sendToClient;
                }
                sendToClient = "Bye.";
                this.state_ = State.WAITING;
                return sendToClient;
            }
            case ERROR: {
                sendToClient = "continue?";
                this.state_ = State.CONTINUE;
                return sendToClient;
            }
            default: {
                LOGGER.error("Switch default case: How did we get here? {}", (Object)this.state_);
                return "Bye.";
            }
        }
    }

    private static enum State {
        WAITING,
        EXPECTING_PROTOCOL,
        EXPECTING_VERSION,
        EXPECTING_USERID,
        EXPECTING_FILEPATH,
        CONTINUE,
        ERROR;

    }
}

