/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanZonalAveragePlotPrefsPanel
extends PanAbstractPrefsPanel {
    private PanTextField lvalTF_;
    private PanTextField rvalTF_;
    private boolean refreshing_;

    public PanZonalAveragePlotPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lon-Lat Zonal Average Line Plots"));
        this.setOpaque(false);
        PanLabel topText = PanLabel.create("When creating a zonal average line plot, set\u2026");
        this.lvalTF_ = PanTextField.createDoubleField(null, -90.0);
        this.rvalTF_ = PanTextField.createDoubleField(null, 90.0);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 2, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        fgl.setRigidHeight(true);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 3, 1));
        this.add((Component)PanLabel.create("Lat Axis Left:\u2009"), new FGConstraint(0, 1, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.lvalTF_, PanLabel.create("\u00b0N, Right:\u2009"), this.rvalTF_, PanLabel.create("\u00b0N")), new FGConstraint(1, 1));
    }

    private void attachListeners() {
        FocusAdapter xRangeFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanZonalAveragePlotPrefsPanel.this.handleXExtrema();
            }
        };
        this.lvalTF_.addFocusListener(xRangeFL);
        this.rvalTF_.addFocusListener(xRangeFL);
        this.lvalTF_.addActionListener(e -> this.handleXExtrema());
        this.rvalTF_.addActionListener(e -> this.handleXExtrema());
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.lvalTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(prefs_.getDouble("plot:llzonal.xaxis.begin")));
        this.rvalTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(prefs_.getDouble("plot:llzonal.xaxis.end")));
        this.refreshing_ = false;
    }

    private void handleXExtrema() {
        double oldright;
        double oldleft;
        double left = oldleft = prefs_.getDouble("plot:llzonal.xaxis.begin");
        try {
            left = StringUtils.parseDouble(this.lvalTF_.getText());
        }
        catch (Exception exc) {
            this.lvalTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(oldleft));
            return;
        }
        if (left < -90.0 || left > 90.0) {
            left = MathUtils.constrain(-90.0, 90.0, left);
            this.lvalTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(left));
        }
        double right = oldright = prefs_.getDouble("plot:llzonal.xaxis.end");
        try {
            right = StringUtils.parseDouble(this.rvalTF_.getText());
        }
        catch (Exception exc) {
            this.rvalTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(oldright));
            return;
        }
        if (right < -90.0 || right > 90.0) {
            right = MathUtils.constrain(-90.0, 90.0, right);
            this.rvalTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(right));
        }
        if (left == right) {
            if (left == -90.0) {
                right = -89.999;
                this.rvalTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(right));
            } else if (left == 90.0) {
                left = 89.999;
                this.lvalTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(left));
            } else {
                right = left + 0.001;
                if (right >= 90.0) {
                    left = 89.999;
                    right = 90.0;
                }
                this.lvalTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(left));
                this.rvalTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(right));
            }
        }
        prefs_.setDouble("plot:llzonal.xaxis.begin", left);
        prefs_.setDouble("plot:llzonal.xaxis.end", right);
    }
}

