/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanTimeVertPrefsPanel
extends PanAbstractPrefsPanel {
    private PanEnumComboBox yMethodCombo_;
    private PanStringComboBox yFormatCombo_;
    private boolean refreshing_;

    public PanTimeVertPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Time-Vert Plots"));
        this.setOpaque(false);
        PanLabel topText = PanLabel.create("When creating a time-vert plot, set\u2026");
        this.yMethodCombo_ = PanEnumComboBox.create(PanAxisMethod.class);
        this.yFormatCombo_ = PanStringComboBox.createNumberFormatCombo(null);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 4, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 3, 1));
        this.add(Box.createVerticalStrut(2), new FGConstraint(1, 1));
        this.add((Component)PanLabel.create("Vert Axis Units:\u2009"), new FGConstraint(0, 2, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.yMethodCombo_, PanLabel.create(", Format:\u2009"), this.yFormatCombo_), new FGConstraint(1, 2));
        this.yMethodCombo_.setMaximumSize(this.yMethodCombo_.getPreferredSize());
        this.yFormatCombo_.setMaximumSize(this.yFormatCombo_.getPreferredSize());
    }

    private void attachListeners() {
        this.yMethodCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:timevert.yaxis.method", this.yMethodCombo_.getStringValue());
        });
        this.yFormatCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:timevert.yaxis.tick.format", this.yFormatCombo_.getSelectedString());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.yMethodCombo_.setSelectedItem(prefs_.getString("plot:timevert.yaxis.method"));
        this.yFormatCombo_.setSelectedItem(prefs_.getString("plot:timevert.yaxis.tick.format"));
        this.refreshing_ = false;
    }
}

