/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanScaleMethodComboBox;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanScalePrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox autoFitCB_;
    private PanScaleMethodComboBox methodCombo_;
    private PanIntSpinner scalingSpinner_;
    private PanIntSpinner majorDivSpinner_;
    private PanIntSpinner minorDivSpinner_;
    private PanStringComboBox tickFormatCombo_;
    private PanFloatComboBox tickSizeCombo_;
    private PanCheckBox minmaxCB_;
    private PanStringComboBox minmaxFormatCombo_;
    private boolean refreshing_;

    public PanScalePrefsPanel() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Plot Scale"));
        this.setOpaque(false);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        PanLabel topText = PanLabel.create("When creating a plot, set\u2026");
        this.setOpaque(false);
        this.autoFitCB_ = PanCheckBox.create("Always fit to data range");
        this.methodCombo_ = PanScaleMethodComboBox.create("plot:scale.method");
        this.scalingSpinner_ = PanIntSpinner.small("plot:scale.exponent", 0, -50, 50, 1);
        this.majorDivSpinner_ = PanIntSpinner.createDivs(null, 2);
        this.minorDivSpinner_ = PanIntSpinner.createDivs(null, 1);
        this.tickSizeCombo_ = PanFloatComboBox.create(7.0f, 16.0f);
        this.tickFormatCombo_ = PanStringComboBox.createNumberFormatCombo(null);
        this.minmaxCB_ = PanCheckBox.create("Show min-max footnote");
        this.minmaxFormatCombo_ = PanStringComboBox.createNumberFormatCombo("plot:footnote.minmax.format");
        this.minmaxFormatCombo_.insertItemAt("Same as scale ticks", 0);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 9, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 4, 1));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, ++row));
        this.add((Component)PanLabel.create("Scale Method:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.methodCombo_, new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Min/Max:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.autoFitCB_, new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Scaling:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("10^"), this.scalingSpinner_), new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Divisions:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Major:\u2009"), this.majorDivSpinner_, PanLabel.create(", Minor:\u2009"), this.minorDivSpinner_), new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Tick Labels:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Format:\u2009"), this.tickFormatCombo_, PanLabel.create(", Size:\u2009"), this.tickSizeCombo_), new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Footnote:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.minmaxCB_, new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(Box.createHorizontalStrut(36), PanLabel.small("Format:\u2009"), this.minmaxFormatCombo_), new FGConstraint(1, ++row));
    }

    private void attachListeners() {
        this.methodCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:scale.method", ((PanScaleMethod)this.methodCombo_.getSelectedItem()).name());
        });
        this.autoFitCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:scale.autofit", this.autoFitCB_.isSelected());
        });
        this.scalingSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:scale.exponent", this.scalingSpinner_.getIntValue());
        });
        this.majorDivSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:scale.div.major", this.majorDivSpinner_.getIntValue());
        });
        this.minorDivSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:scale.div.minor", this.minorDivSpinner_.getIntValue());
        });
        this.tickFormatCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:scale.tick.format", this.tickFormatCombo_.getSelectedString());
        });
        this.tickSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.tickSizeCombo_.getValue();
            prefs_.setFloat("plot:scale.tick.size", value);
        });
        this.minmaxCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:footnote.minmax.vis", this.minmaxCB_.isSelected());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        PanScaleMethod smethod = PanScaleMethod.matching(prefs_.getString("plot:scale.method"));
        this.autoFitCB_.setSelected(prefs_.getBoolean("plot:scale.autofit"));
        this.methodCombo_.setSelectedItem(smethod);
        this.scalingSpinner_.setValue(prefs_.getInt("plot:scale.exponent"));
        this.majorDivSpinner_.setValue(prefs_.getInt("plot:scale.div.major"));
        this.minorDivSpinner_.setValue(prefs_.getInt("plot:scale.div.minor"));
        this.tickFormatCombo_.setSelectedItem(prefs_.getString("plot:scale.tick.format"));
        this.tickSizeCombo_.setSelectedItem(prefs_.getFloat("plot:scale.tick.size"));
        this.minmaxCB_.setSelected(prefs_.getBoolean("plot:footnote.minmax.vis"));
        this.minmaxFormatCombo_.setEnabled(this.minmaxCB_.isSelected());
        String mmf = prefs_.getString("plot:footnote.minmax.format");
        if (mmf == null || mmf.isEmpty() || mmf.toLowerCase().startsWith("same")) {
            this.minmaxFormatCombo_.setSelectedIndex(0);
        } else {
            this.minmaxFormatCombo_.setSelectedItem(mmf);
        }
        this.refreshing_ = false;
    }
}

