/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.map.proj.ui.ProjListComponent;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.prefs.PanProjectionPrefs;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanGridLabelStepComboBox;
import gov.nasa.giss.panoply.ui.PanGridSpacingComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanLinkButton;
import gov.nasa.giss.panoply.ui.PanProjectionComboBox;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.JFrame;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatProjectionPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanProjectionComboBox projCombo_;
    private PanLabel centerLabel_;
    private PanTextField copLonTF_;
    private PanTextField copLatTF_;
    private QuickBox copLonBox_;
    private QuickBox copLatBox_;
    private PanGridSpacingComboBox gridLonSpacingCombo_;
    private PanGridSpacingComboBox gridLatSpacingCombo_;
    private PanCheckBox gridLatOffsetCB_;
    private PanLinkButton linkBtn_;
    private boolean linkedSpacing_;
    private PanGridLabelStepComboBox gridLabelStepCombo_;
    private PanLabel gridLabelSizeLabel_;
    private PanFloatComboBox gridLabelSizeCombo_;
    private PanIntSpinner bWeightSpinner_;
    private QuickBox[] paramBoxes_;
    private boolean refreshing_;

    public PanLonLatProjectionPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        PanLabel topText = PanLabel.create("When creating a map plot, set\u2026");
        this.setOpaque(false);
        this.projCombo_ = PanProjectionComboBox.create(null, true);
        this.centerLabel_ = PanLabel.create("Centered on:\u2009");
        PanLabel lonLabel = PanLabel.create("Lon.\u2009");
        PanLabel degELabel = PanLabel.create("\u00b0E");
        PanLabel latLabel = PanLabel.create(", Lat.\u2009");
        PanLabel degNLabel = PanLabel.create("\u00b0N");
        this.copLonTF_ = PanTextField.createDoubleField(null, 0.0, 6);
        this.copLatTF_ = PanTextField.createDoubleField(null, 0.0, 6);
        this.copLonTF_.setMaximumSize(this.copLonTF_.getPreferredSize());
        this.copLatTF_.setMaximumSize(this.copLatTF_.getPreferredSize());
        this.copLonBox_ = QuickBox.createLeftBox(lonLabel, this.copLonTF_, degELabel);
        this.copLatBox_ = QuickBox.createLeftBox(latLabel, this.copLatTF_, degNLabel);
        this.paramBoxes_ = new QuickBox[]{QuickBox.createHorizontalBox(new Component[0]), QuickBox.createHorizontalBox(new Component[0])};
        PanLabel spacingLabel = PanLabel.create("Spacing:\u2009");
        this.gridLonSpacingCombo_ = PanGridSpacingComboBox.create(null);
        this.gridLatSpacingCombo_ = PanGridSpacingComboBox.create(null);
        this.linkedSpacing_ = this.gridLonSpacingCombo_.getSpacing() == this.gridLatSpacingCombo_.getSpacing();
        this.linkBtn_ = new PanLinkButton(null);
        this.linkBtn_.setButtonSize(16);
        this.gridLatOffsetCB_ = PanCheckBox.create("Offset parallels from equator");
        this.gridLabelStepCombo_ = PanGridLabelStepComboBox.create(null);
        this.gridLabelSizeLabel_ = PanLabel.create(", Size:\u2009");
        this.gridLabelSizeCombo_ = PanFloatComboBox.create(5.0f, 16.0f);
        this.bWeightSpinner_ = PanIntSpinner.createWeight(null, prefs_.getInt("plot:lonlat.border.weight"), 250);
        PanLabel bottomText = PanLabel.small("See also the preferences for Map Overlay and Map Shading.");
        FlexingGridLayout fgl = new FlexingGridLayout(3, 13, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lon-Lat Map Plot Projection"));
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 3, 1));
        this.add((Component)PanLabel.create("Projection:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.projCombo_, new FGConstraint(1, row));
        this.add((Component)this.centerLabel_, new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.copLonBox_, this.copLatBox_), new FGConstraint(1, row));
        this.add((Component)this.paramBoxes_[0], new FGConstraint(1, ++row));
        this.add((Component)this.paramBoxes_[1], new FGConstraint(1, ++row));
        this.add(Box.createVerticalStrut(2), new FGConstraint(1, ++row));
        this.add((Component)PanLabel.create("Grid Lines:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(spacingLabel, this.gridLonSpacingCombo_, PanLabel.create("\u00b0E-W \u00d7"), this.gridLatSpacingCombo_, PanLabel.create("\u00b0N-S  "), this.linkBtn_), new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(Box.createHorizontalStrut(spacingLabel.getPreferredSize().width), this.gridLatOffsetCB_), new FGConstraint(1, ++row));
        this.add((Component)PanLabel.create("Grid Labels:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.gridLabelStepCombo_, this.gridLabelSizeLabel_, this.gridLabelSizeCombo_), new FGConstraint(1, row));
        this.add(Box.createVerticalStrut(2), new FGConstraint(1, ++row));
        this.add((Component)PanLabel.create("Border: "), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Weight:\u2009"), this.bWeightSpinner_, PanLabel.create("%")), new FGConstraint(1, row));
        ++row;
        this.add((Component)bottomText, new FGConstraint(0, ++row, 3, 1, 0.5, 1.0));
        this.projCombo_.setMaximumSize(this.projCombo_.getPreferredSize());
        this.gridLonSpacingCombo_.setMaximumSize(this.gridLonSpacingCombo_.getPreferredSize());
        this.gridLatSpacingCombo_.setMaximumSize(this.gridLatSpacingCombo_.getPreferredSize());
    }

    private void attachListeners() {
        TFFocusListener tfFL = new TFFocusListener();
        this.copLonTF_.addFocusListener(tfFL);
        this.copLatTF_.addFocusListener(tfFL);
        this.copLonTF_.addActionListener(e -> this.handleTF());
        this.copLatTF_.addActionListener(e -> this.handleTF());
        this.projCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.projectionChanged();
        });
        this.gridLonSpacingCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            float spacing = this.gridLonSpacingCombo_.getSpacing();
            prefs_.setFloat("plot:grid.spacing.lon", spacing);
            if (this.linkedSpacing_) {
                this.gridLatSpacingCombo_.setSpacing(spacing);
            }
        });
        this.gridLatSpacingCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            float spacing = this.gridLatSpacingCombo_.getSpacing();
            prefs_.setFloat("plot:grid.spacing.lat", spacing);
            if (this.linkedSpacing_) {
                this.gridLonSpacingCombo_.setSpacing(spacing);
            }
        });
        this.linkBtn_.addActionListener(e -> {
            this.linkedSpacing_ = !this.linkedSpacing_;
            this.linkBtn_.setLinked(this.linkedSpacing_);
            if (this.linkedSpacing_) {
                float spacing = this.gridLonSpacingCombo_.getSpacing();
                this.gridLatSpacingCombo_.setSpacing(spacing);
            }
        });
        this.gridLatOffsetCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:grid.offset.lat", e.getStateChange() == 1);
        });
        this.gridLabelStepCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:grid.label.step", this.gridLabelStepCombo_.getStep());
        });
        this.gridLabelSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.setFloat("plot:grid.label.size", this.gridLabelSizeCombo_.getValue());
        });
        this.bWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:lonlat.border.weight", this.bWeightSpinner_.getIntValue());
        });
    }

    private void validateCOP() {
        try {
            double lon;
            if (lon < -180.0 || lon > 180.0) {
                for (lon = StringUtils.parseDouble(this.copLonTF_.getText()); lon > 180.0; lon -= 360.0) {
                }
                while (lon < -180.0) {
                    lon += 360.0;
                }
                this.copLonTF_.setText(PrintfFormat.PFORMAT_4G.sprintfx(lon));
            }
        }
        catch (Exception exc) {
            this.copLonTF_.setText(PrintfFormat.PFORMAT_4G.sprintfx(0.0));
        }
        try {
            double lat = StringUtils.parseDouble(this.copLatTF_.getText());
            if (lat < -90.0 || lat > 90.0) {
                lat = MathUtils.constrain(-90.0, 90.0, lat);
                this.copLatTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(lat));
            }
        }
        catch (Exception exc) {
            this.copLatTF_.setText(PrintfFormat.PFORMAT_4G.sprintfx(0.0));
        }
    }

    private void projectionChanged() {
        PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
        String projname = this.projCombo_.getSelectedItem().toString();
        prefs_.set("plot:lonlat.proj.name", projname);
        AbstractProjection proj = projname.equals("Equirectangular Regional") ? new EquirectangularRegional(20, 10) : ProjectionFactory.create(projname, 20, 10);
        try {
            proj.setCenter(prefs_.getDouble("plot:lonlat.proj.lon0"), prefs_.getDouble("plot:lonlat.proj.lat0"));
        }
        catch (Exception exc) {
            proj.setCenter(0.0, 0.0);
        }
        if (proj.hasProperty(0x1000000)) {
            this.copLonTF_.setEnabled(proj.isRecenterableLon());
            this.copLatTF_.setEnabled(false);
            double clon = proj.getCenter().getLon();
            prefs_.setDouble("plot:lonlat.proj.lon0", clon);
            this.copLonTF_.setText(PrintfFormat.PFORMAT_4G.sprintfx(clon));
        } else {
            this.copLonTF_.setEnabled(proj.isRecenterableLon());
            this.copLatTF_.setEnabled(proj.isRecenterableLat());
        }
        this.centerLabel_.setVisible(true);
        this.copLonBox_.setVisible(true);
        this.copLatBox_.setVisible(true);
        boolean projCanLabel = proj.canLabelGrid();
        this.gridLabelStepCombo_.setEnabled(projCanLabel);
        this.gridLabelSizeLabel_.setEnabled(projCanLabel);
        this.gridLabelSizeCombo_.setEnabled(projCanLabel);
        this.paramBoxes_[0].removeAll();
        this.paramBoxes_[1].removeAll();
        int pcount = proj.getExtraParamCount();
        int pRow = 0;
        int pRowItem = 0;
        for (int i = 0; i < pcount; ++i) {
            if (pRowItem > 0) {
                this.paramBoxes_[pRow].add(PanLabel.create(",\u2009"));
            }
            ProjParamComponent pf = proj.getParamComponent(i);
            pf.setMaximumSize(pf.getPreferredSize());
            this.paramBoxes_[pRow].add(pf);
            int pid = i;
            pf.addChangeListener(e -> {
                pprefs.setParam(projname, pid, pf.getStringValue());
                if (proj.hasProperty(0x1000000)) {
                    this.copLonTF_.setEnabled(proj.isRecenterableLon());
                    double clon = proj.getCenter().getLon();
                    prefs_.setDouble("plot:lonlat.proj.lon0", clon);
                    this.copLonTF_.setText(PrintfFormat.PFORMAT_4G.sprintfx(clon));
                }
            });
            if (pf instanceof ProjListComponent) {
                ++pRow;
                pRowItem = 0;
            } else if (++pRowItem > 1) {
                ++pRow;
                pRowItem = 0;
            }
            String sval = pprefs.getParam(projname, i);
            if (sval == null || sval.isEmpty()) continue;
            try {
                pf.setValue(sval);
                continue;
            }
            catch (Exception exc) {
                LOGGER.trace("exc = {}", (Object)exc.toString());
            }
        }
        this.paramBoxes_[0].add(Box.createHorizontalGlue());
        this.paramBoxes_[1].add(Box.createHorizontalGlue());
        this.paramBoxes_[0].invalidate();
        this.paramBoxes_[1].invalidate();
        this.invalidate();
        JFrame jf = (JFrame)this.getTopLevelAncestor();
        if (jf != null) {
            this.invalidate();
            jf.validate();
            jf.pack();
        }
        this.repaint();
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.refreshProjList();
        this.projCombo_.setSelectedItem(prefs_.getString("plot:lonlat.proj.name"));
        this.projectionChanged();
        this.copLonTF_.setText(PrintfFormat.PFORMAT_4G.sprintfx(prefs_.getDouble("plot:lonlat.proj.lon0")));
        this.copLatTF_.setText(PrintfFormat.PFORMAT_4G.sprintfx(prefs_.getDouble("plot:lonlat.proj.lat0")));
        this.gridLonSpacingCombo_.setSpacing(prefs_.getFloat("plot:grid.spacing.lon"));
        this.gridLatSpacingCombo_.setSpacing(prefs_.getFloat("plot:grid.spacing.lat"));
        this.gridLatOffsetCB_.setSelected(prefs_.getBoolean("plot:grid.offset.lat"));
        this.linkedSpacing_ = this.gridLonSpacingCombo_.getSpacing() == this.gridLatSpacingCombo_.getSpacing();
        this.linkBtn_.setLinked(this.linkedSpacing_);
        this.gridLabelSizeCombo_.setValue(prefs_.getFloat("plot:grid.label.size"));
        this.gridLabelStepCombo_.setStep(prefs_.getInt("plot:grid.label.step"));
        this.bWeightSpinner_.setValue(prefs_.getInt("plot:lonlat.border.weight"));
        this.refreshing_ = false;
    }

    private void refreshProjList() {
        if (this.refreshing_) {
            return;
        }
        String oldName = this.projCombo_.getSelectedItem().toString();
        this.projCombo_.refresh();
        String newName = this.projCombo_.getSelectedItem().toString();
        if (!newName.equals(oldName)) {
            prefs_.set("plot:lonlat.proj.name", newName);
        }
    }

    private void handleTF() {
        this.validateCOP();
        prefs_.setDouble("plot:lonlat.proj.lon0", this.copLonTF_.getText());
        prefs_.setDouble("plot:lonlat.proj.lat0", this.copLatTF_.getText());
    }

    class TFFocusListener
    extends FocusAdapter {
        TFFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            PanLonLatProjectionPrefsPanel.this.handleTF();
        }
    }
}

