/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.SymbolID;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.ShapefileOverlay;
import gov.nasa.giss.panoply.overlay.PanMaskOverlay;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanOverlayComboBox;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSeparator;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatOverlaysPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanOverlayComboBox[] overlayCombo_;
    private PanColorComboBox[] overlayColorCombo_;
    private PanLabel[] overlayWeightLabel_;
    private PanIntSpinner[] overlayWeightSpinner_;
    private PanCheckBox[] overlayMaskInvertCB_;
    private PanEnumComboBox[] overlayStyleCombo_;
    private PanEnumComboBox[] overlaySymbolCombo_;
    private PanFloatComboBox[] overlaySymbolSizeCombo_;
    private JComponent[] overlayColorBox_;
    private JComponent[] overlayWeightBox_;
    private JComponent[] overlayMaskBox_;
    private JComponent[] overlayStrokeBox_;
    private JComponent[] overlaySymbolBox_;
    private JComponent[] row3Box_;
    private boolean refreshing_;

    public PanLonLatOverlaysPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lon-Lat Map Plot Overlay"));
        this.setOpaque(false);
        PanLabel topText = PanLabel.create("When creating a map plot, set\u2026");
        int ocount = 3;
        this.overlayCombo_ = new PanOverlayComboBox[3];
        this.overlayColorCombo_ = new PanColorComboBox[3];
        this.overlayWeightLabel_ = new PanLabel[3];
        this.overlayWeightSpinner_ = new PanIntSpinner[3];
        this.overlayMaskInvertCB_ = new PanCheckBox[3];
        this.overlayStyleCombo_ = new PanEnumComboBox[3];
        this.overlaySymbolCombo_ = new PanEnumComboBox[3];
        this.overlaySymbolSizeCombo_ = new PanFloatComboBox[3];
        this.overlayColorBox_ = new JComponent[3];
        this.overlayWeightBox_ = new JComponent[3];
        this.overlayMaskBox_ = new JComponent[3];
        this.overlayStrokeBox_ = new JComponent[3];
        this.overlaySymbolBox_ = new JComponent[3];
        this.row3Box_ = new JComponent[3];
        for (int i = 0; i < 3; ++i) {
            this.overlayCombo_[i] = PanOverlayComboBox.create(true);
            this.overlayColorCombo_[i] = PanColorComboBox.createRainbow(null);
            this.overlayWeightLabel_[i] = PanLabel.create(", Weight:\u2009");
            this.overlayWeightSpinner_[i] = PanIntSpinner.createWeight(null, prefs_.getInt(PanParamKeys.P_OVERLAY_WGT[i]), 400);
            this.overlayMaskInvertCB_[i] = PanCheckBox.create("Invert");
            this.overlayStyleCombo_[i] = PanEnumComboBox.create(PanStrokePattern.class);
            this.overlaySymbolCombo_[i] = PanEnumComboBox.create(PanParamKeys.P_OVERLAY_SYMBOL_ID[i], SymbolID.class);
            this.overlaySymbolCombo_[i].removeItem(SymbolID.NONE);
            this.overlaySymbolSizeCombo_[i] = PanFloatComboBox.create(3.0f, 9.0f);
            this.overlayCombo_[i].setToolTipText("Select " + (i + 1) + "st overlay to apply to new map plots");
            this.overlayColorBox_[i] = QuickBox.createLeftBox(PanLabel.create("Color:\u2009"), this.overlayColorCombo_[i]);
            this.overlayWeightBox_[i] = QuickBox.createLeftBox(this.overlayWeightLabel_[i], this.overlayWeightSpinner_[i]);
            this.overlayMaskBox_[i] = QuickBox.createLeftBox(PanLabel.create("Mask:\u2009"), this.overlayMaskInvertCB_[i]);
            this.overlayStrokeBox_[i] = QuickBox.createLeftBox(PanLabel.create("Stroke Style:\u2009"), this.overlayStyleCombo_[i]);
            this.overlaySymbolBox_[i] = QuickBox.createLeftBox(PanLabel.create("Point Symbol:\u2009"), this.overlaySymbolCombo_[i], PanLabel.create(", Size:\u2009"), this.overlaySymbolSizeCombo_[i]);
            this.row3Box_[i] = QuickBox.createLeftBox(this.overlayStrokeBox_[i]);
        }
        FlexingGridLayout fgl = new FlexingGridLayout(3, 12, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setRigidHeight(true);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 2, 1));
        for (int i = 0; i < 3; ++i) {
            int row1 = i * 4 + 1;
            this.add((Component)PanLabel.create("Overlay " + (i + 1) + ":\u2009"), new FGConstraint(0, row1, 1.0));
            this.add((Component)this.overlayCombo_[i], new FGConstraint(1, row1));
            this.add((Component)this.overlayColorBox_[i], new FGConstraint(1, row1 + 1));
            this.add((Component)this.row3Box_[i], new FGConstraint(1, row1 + 2));
            if (i >= 2) continue;
            this.add((Component)new JSeparator(), new FGConstraint(0, row1 + 3, 3, 1));
        }
    }

    private void attachListeners() {
        int ii = 0;
        while (ii < 3) {
            int i = ii++;
            this.overlayCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                String oname = (String)this.overlayCombo_[i].getSelectedItem();
                LOGGER.trace("combo {}, {}", (Object)PanParamKeys.P_OVERLAY_NAME[i], (Object)oname);
                prefs_.setString(PanParamKeys.P_OVERLAY_NAME[i], oname);
                this.refreshPrivate();
            });
            this.overlayStyleCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParamKeys.P_OVERLAY_STYLE[i], this.overlayStyleCombo_[i].getStringValue());
            });
            this.overlayWeightSpinner_[i].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                prefs_.setInt(PanParamKeys.P_OVERLAY_WGT[i], this.overlayWeightSpinner_[i].getIntValue());
            });
            this.overlayMaskInvertCB_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                prefs_.setBoolean(PanParamKeys.P_OVERLAY_INVERT[i], this.overlayMaskInvertCB_[i].isSelected());
            });
            this.overlayColorCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParamKeys.P_OVERLAY_COLOR[i], this.overlayColorCombo_[i].getSelectedColor());
            });
            this.overlaySymbolCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParamKeys.P_OVERLAY_SYMBOL_ID[i], this.overlaySymbolCombo_[i].getStringValue());
            });
            this.overlaySymbolSizeCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.setFloat(PanParamKeys.P_OVERLAY_SYMBOL_SIZE[i], this.overlaySymbolSizeCombo_[i].getValue());
            });
        }
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        for (int i = 0; i < 3; ++i) {
            int row1 = i * 5 + 1;
            MapOverlay oo = this.overlayCombo_[i].getSelectedOverlay();
            boolean isMask = oo instanceof PanMaskOverlay;
            boolean isShapefile = oo instanceof ShapefileOverlay;
            PanStrokePattern ostyle = PanStrokePattern.matching(prefs_.getString(PanParamKeys.P_OVERLAY_STYLE[i]));
            this.row3Box_[i].removeAll();
            this.remove(this.overlaySymbolBox_[i]);
            if (isMask) {
                this.row3Box_[i].add(this.overlayMaskBox_[i]);
                this.row3Box_[i].add(this.overlayWeightBox_[i]);
                this.row3Box_[i].add(Box.createHorizontalGlue());
                this.overlayWeightLabel_[i].setText(", Opacity:\u2009");
            } else {
                this.row3Box_[i].add(this.overlayStrokeBox_[i]);
                this.row3Box_[i].add(this.overlayWeightBox_[i]);
                this.row3Box_[i].add(Box.createHorizontalGlue());
                this.overlayWeightLabel_[i].setText(", Weight:\u2009");
                if (isShapefile) {
                    this.add((Component)this.overlaySymbolBox_[i], new FGConstraint(1, row1 + 3));
                }
            }
            this.overlayCombo_[i].setEnabled(true);
            this.overlayColorCombo_[i].setEnabled(oo != null);
            this.overlayWeightSpinner_[i].setEnabled(oo != null);
            this.overlayMaskInvertCB_[i].setEnabled(isMask);
            this.overlayStyleCombo_[i].setEnabled(oo != null && !isMask);
            this.overlaySymbolCombo_[i].setEnabled(isShapefile);
            this.overlaySymbolSizeCombo_[i].setEnabled(isShapefile);
            this.overlayCombo_[i].setSelectedItem(prefs_.getString(PanParamKeys.P_OVERLAY_NAME[i]));
            this.overlayMaskInvertCB_[i].setSelected(prefs_.getBoolean(PanParamKeys.P_OVERLAY_INVERT[i]));
            this.overlayColorCombo_[i].setSelectedColor(prefs_.getColor(PanParamKeys.P_OVERLAY_COLOR[i]));
            this.overlayWeightSpinner_[i].setValue(prefs_.getInt(PanParamKeys.P_OVERLAY_WGT[i]));
            this.overlayStyleCombo_[i].setSelectedItem(ostyle);
            this.overlaySymbolCombo_[i].setSelectedItem(prefs_.getString(PanParamKeys.P_OVERLAY_SYMBOL_ID[i]));
            this.overlaySymbolSizeCombo_[i].setValue(prefs_.getFloat(PanParamKeys.P_OVERLAY_SYMBOL_SIZE[i]));
        }
        JFrame jf = (JFrame)this.getTopLevelAncestor();
        if (jf != null) {
            this.invalidate();
            jf.validate();
            jf.pack();
        }
        this.refreshing_ = false;
    }
}

