/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanColorContourPlotPrefsPanel
extends PanAbstractPrefsPanel {
    private static final String UP = "Up";
    private static final String DOWN = "Down";
    private PanIntSpinner xmajorDivSpinner_;
    private PanIntSpinner xminorDivSpinner_;
    private PanIntSpinner ymajorDivSpinner_;
    private PanIntSpinner yminorDivSpinner_;
    private PanStringComboBox xFormatCombo_;
    private PanStringComboBox yFormatCombo_;
    private PanStringComboBox yPositiveCombo_;
    private boolean refreshing_;

    public PanColorContourPlotPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Other Color Contour Plots"));
        this.setOpaque(false);
        PanLabel topText = PanLabel.create("When creating a non-map color contour plot, set\u2026");
        this.xmajorDivSpinner_ = PanIntSpinner.createDivs(null, 2);
        this.xminorDivSpinner_ = PanIntSpinner.createDivs(null, 2);
        this.ymajorDivSpinner_ = PanIntSpinner.createDivs(null, 2);
        this.yminorDivSpinner_ = PanIntSpinner.createDivs(null, 2);
        PanLabel xdivLabel1 = PanLabel.create("Divisions: Major:\u2009");
        PanLabel xdivLabel2 = PanLabel.create(", Minor:\u2009");
        PanLabel ydivLabel1 = PanLabel.create("Divisions: Major:\u2009");
        PanLabel ydivLabel2 = PanLabel.create(", Minor:\u2009");
        QuickBox xdivBox = QuickBox.createLeftBox(xdivLabel1, this.xmajorDivSpinner_, xdivLabel2, this.xminorDivSpinner_);
        QuickBox ydivBox = QuickBox.createLeftBox(ydivLabel1, this.ymajorDivSpinner_, ydivLabel2, this.yminorDivSpinner_);
        this.xFormatCombo_ = PanStringComboBox.createNumberFormatCombo(null);
        this.yFormatCombo_ = PanStringComboBox.createNumberFormatCombo(null);
        this.yPositiveCombo_ = PanStringComboBox.create();
        this.yPositiveCombo_.addItem(UP);
        this.yPositiveCombo_.addItem(DOWN);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 12, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 3, 1));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, ++row));
        this.add((Component)PanLabel.create("X Axis:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)xdivBox, new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Tick Label Format:\u2009"), this.xFormatCombo_), new FGConstraint(1, ++row));
        this.add((Component)PanLabel.create("Y Axis:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)ydivBox, new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Tick Label Format:\u2009"), this.yFormatCombo_), new FGConstraint(1, ++row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Treat Y axis as positive "), this.yPositiveCombo_, PanLabel.create(" if not apparent")), new FGConstraint(1, ++row));
    }

    private void attachListeners() {
        this.xmajorDivSpinner_.addChangeListener(e -> prefs_.setInt("plot:xy.xaxis.div.major", this.xmajorDivSpinner_.getIntValue()));
        this.xminorDivSpinner_.addChangeListener(e -> prefs_.setInt("plot:xy.xaxis.div.minor", this.xminorDivSpinner_.getIntValue()));
        this.ymajorDivSpinner_.addChangeListener(e -> prefs_.setInt("plot:xy.yaxis.div.major", this.ymajorDivSpinner_.getIntValue()));
        this.yminorDivSpinner_.addChangeListener(e -> prefs_.setInt("plot:xy.yaxis.div.minor", this.yminorDivSpinner_.getIntValue()));
        this.xFormatCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:xy.xaxis.tick.format", this.xFormatCombo_.getSelectedString());
        });
        this.yFormatCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:xy.yaxis.tick.format", this.yFormatCombo_.getSelectedString());
        });
        this.yPositiveCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            boolean posup = this.yPositiveCombo_.getSelectedItem().equals(UP);
            prefs_.set("plot:xy.yaxis.posup", posup);
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.xmajorDivSpinner_.setValue(prefs_.getInt("plot:xy.xaxis.div.major"));
        this.xminorDivSpinner_.setValue(prefs_.getInt("plot:xy.xaxis.div.minor"));
        this.ymajorDivSpinner_.setValue(prefs_.getInt("plot:xy.yaxis.div.major"));
        this.yminorDivSpinner_.setValue(prefs_.getInt("plot:xy.yaxis.div.minor"));
        this.xFormatCombo_.setSelectedItem(prefs_.getString("plot:xy.xaxis.tick.format"));
        this.yFormatCombo_.setSelectedItem(prefs_.getString("plot:xy.yaxis.tick.format"));
        if (prefs_.getBoolean("plot:xy.yaxis.posup")) {
            this.yPositiveCombo_.setSelectedItem(UP);
        } else {
            this.yPositiveCombo_.setSelectedItem(DOWN);
        }
        this.refreshing_ = false;
    }
}

