/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanAxisTickColor;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class Pan2DGridPrefsPanel
extends PanAbstractPrefsPanel {
    private PanEnumComboBox gridStyleCombo_;
    private PanColorComboBox gridColorCombo_;
    private PanIntSpinner gridWeightSpinner_;
    private PanCheckBox axesOffsetCB_;
    private PanEnumComboBox tickColorCombo_;
    private PanIntSpinner tickWeightSpinner_;
    private PanFloatComboBox xtickSizeCombo_;
    private PanFloatComboBox ytickSizeCombo_;
    private boolean refreshing_;

    public Pan2DGridPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Color Contour Plot Grid"));
        this.setOpaque(false);
        PanLabel topText = PanLabel.create("When creating a color contour plot, set\u2026");
        this.gridStyleCombo_ = PanEnumComboBox.create(PanStrokePattern.class);
        this.gridColorCombo_ = PanColorComboBox.createRainbow(null);
        this.gridColorCombo_.setSelectedColor(prefs_.getColor("plot:ccplot.grid.color"));
        this.gridWeightSpinner_ = PanIntSpinner.createWeight(null, prefs_.getInt("plot:ccplot.grid.weight"), 200);
        this.axesOffsetCB_ = PanCheckBox.create("Offset axes from grid edges", prefs_.getBoolean("plot:ccplot.axes.offset"));
        this.tickColorCombo_ = PanEnumComboBox.create("plot:ccplot.axes.tickmark.color", PanAxisTickColor.class);
        this.tickWeightSpinner_ = PanIntSpinner.createWeight("plot:ccplot.axes.tickmark.weight", 50, 200);
        QuickBox tickBox = QuickBox.createLeftBox(PanLabel.create("Color:\u2009"), this.tickColorCombo_, PanLabel.create(", Weight\u2009"), this.tickWeightSpinner_, PanLabel.create("%"));
        this.xtickSizeCombo_ = PanFloatComboBox.create("plot:ccplot.xaxis.tick.size", 5.0f, 16.0f);
        this.ytickSizeCombo_ = PanFloatComboBox.create("plot:ccplot.yaxis.tick.size", 5.0f, 16.0f);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 8, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 3, 1));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, ++row));
        this.add((Component)PanLabel.create("Grid: "), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Style:\u2009"), this.gridStyleCombo_), new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Color:\u2009"), this.gridColorCombo_, PanLabel.create(", Weight:\u2009"), this.gridWeightSpinner_, PanLabel.create("%")), new FGConstraint(1, ++row));
        this.add((Component)this.axesOffsetCB_, new FGConstraint(1, ++row));
        this.add((Component)PanLabel.create("Axes Ticks: "), new FGConstraint(0, ++row, 1.0));
        this.add((Component)tickBox, new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("X Axis Tick Label Size:\u2009"), this.xtickSizeCombo_), new FGConstraint(1, ++row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Y Axis Tick Label Size:\u2009"), this.ytickSizeCombo_), new FGConstraint(1, ++row));
    }

    private void attachListeners() {
        this.gridStyleCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:ccplot.grid.style", this.gridStyleCombo_.getStringValue());
        });
        this.gridColorCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:ccplot.grid.color", this.gridColorCombo_.getSelectedColor());
        });
        this.gridWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:ccplot.grid.weight", this.gridWeightSpinner_.getIntValue());
        });
        this.axesOffsetCB_.addItemListener(e -> prefs_.set("plot:ccplot.axes.offset", this.axesOffsetCB_.isSelected()));
        this.tickColorCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:ccplot.axes.tickmark.color", this.tickColorCombo_.getStringValue());
        });
        this.tickWeightSpinner_.addChangeListener(e -> prefs_.setInt("plot:ccplot.axes.tickmark.weight", this.tickWeightSpinner_.getIntValue()));
        this.xtickSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.xtickSizeCombo_.getValue();
            prefs_.setFloat("plot:ccplot.xaxis.tick.size", value);
        });
        this.ytickSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.ytickSizeCombo_.getValue();
            prefs_.setFloat("plot:ccplot.yaxis.tick.size", value);
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.gridStyleCombo_.setSelectedItem(prefs_.getString("plot:ccplot.grid.style"));
        this.gridColorCombo_.setSelectedColor(prefs_.getColor("plot:ccplot.grid.color"));
        this.gridWeightSpinner_.setValue(prefs_.getInt("plot:ccplot.grid.weight"));
        this.axesOffsetCB_.setSelected(prefs_.getBoolean("plot:ccplot.axes.offset"));
        this.xtickSizeCombo_.setValue(prefs_.getFloat("plot:ccplot.xaxis.tick.size"));
        this.ytickSizeCombo_.setValue(prefs_.getFloat("plot:ccplot.yaxis.tick.size"));
        this.tickColorCombo_.setSelectedItem(prefs_.getString("plot:ccplot.axes.tickmark.color"));
        this.tickWeightSpinner_.setValue(prefs_.getInt("plot:ccplot.axes.tickmark.weight"));
        this.refreshing_ = false;
    }
}

