/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.panoply.prefs.PanFavoritesEvent;
import gov.nasa.giss.panoply.prefs.PanFavoritesListener;
import gov.nasa.giss.panoply.prefs.PanProjectionInfo;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanProjectionPrefs {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ArrayList<PanProjectionInfo> projinfo_;
    private final EventListenerList listenerList_ = new EventListenerList();

    public static PanProjectionPrefs getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanProjectionPrefs() {
    }

    private void initList() {
        String[] projections = ProjectionFactory.getNames();
        this.projinfo_ = new ArrayList(projections.length);
        for (String pname : projections) {
            PanProjectionInfo pi = new PanProjectionInfo(pname, true);
            this.projinfo_.add(pi);
        }
    }

    public void reset() {
        this.projinfo_ = null;
        this.initList();
    }

    public void printList() {
        if (this.projinfo_ == null) {
            this.initList();
        }
        for (PanProjectionInfo item : this.projinfo_) {
            System.out.println(item.getName());
        }
    }

    public PanProjectionInfo[] getInfoArray() {
        if (this.projinfo_ == null) {
            this.initList();
        }
        return this.projinfo_.toArray(new PanProjectionInfo[0]);
    }

    public String[] getAllNames() {
        if (this.projinfo_ == null) {
            this.initList();
        }
        ArrayList<String> v = new ArrayList<String>(this.projinfo_.size());
        for (PanProjectionInfo item : this.projinfo_) {
            v.add(item.getName());
        }
        return v.toArray(new String[0]);
    }

    public String[] getFavorites() {
        if (this.projinfo_ == null) {
            this.initList();
        }
        ArrayList<String> v = new ArrayList<String>(this.projinfo_.size());
        for (PanProjectionInfo item : this.projinfo_) {
            if (!item.isFavorite()) continue;
            v.add(item.getName());
        }
        return v.toArray(new String[0]);
    }

    public boolean isFavorite(String pname) {
        if (this.projinfo_ == null) {
            this.initList();
        }
        for (PanProjectionInfo item : this.projinfo_) {
            if (!item.getName().equalsIgnoreCase(pname)) continue;
            return item.isFavorite();
        }
        return false;
    }

    public void setFavorite(String pname, String s) {
        this.setFavorite(pname, Boolean.valueOf(s));
    }

    public void setFavorite(String pname, boolean b) {
        if (pname.toLowerCase().indexOf("equirect") == 0) {
            return;
        }
        PanProjectionInfo info = this.getInfo(pname);
        if (info != null) {
            info.setFavorite(b);
            this.fireStatusChanged(info);
        }
    }

    public String getParam(String projname, int id) {
        PanProjectionInfo info = this.getInfo(projname);
        if (info != null) {
            return info.getParam(id);
        }
        return null;
    }

    public void setParam(String projname, int id, String value) {
        PanProjectionInfo info = this.getInfo(projname);
        if (info != null) {
            info.setParam(id, value);
        }
    }

    private PanProjectionInfo getInfo(String projname) {
        if (this.projinfo_ == null) {
            this.initList();
        }
        for (PanProjectionInfo item : this.projinfo_) {
            if (!item.getName().equalsIgnoreCase(projname)) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFavoritesListener(PanFavoritesListener l) {
        PanProjectionPrefs panProjectionPrefs = this;
        synchronized (panProjectionPrefs) {
            this.listenerList_.add(PanFavoritesListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFavoritesListener(PanFavoritesListener l) {
        PanProjectionPrefs panProjectionPrefs = this;
        synchronized (panProjectionPrefs) {
            this.listenerList_.remove(PanFavoritesListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFavoritesListeners() {
        PanProjectionPrefs panProjectionPrefs = this;
        synchronized (panProjectionPrefs) {
            for (PanFavoritesListener listener : (PanFavoritesListener[])this.listenerList_.getListeners(PanFavoritesListener.class)) {
                this.removeFavoritesListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStatusChanged(PanProjectionInfo item) {
        PanFavoritesEvent e = new PanFavoritesEvent(item);
        PanProjectionPrefs panProjectionPrefs = this;
        synchronized (panProjectionPrefs) {
            for (PanFavoritesListener listener : (PanFavoritesListener[])this.listenerList_.getListeners(PanFavoritesListener.class)) {
                listener.statusChanged(e);
            }
        }
    }

    final void read(Element projElement) {
        for (String pname : this.getAllNames()) {
            this.setFavorite(pname, true);
        }
        for (Element lchild : projElement.getChildren()) {
            String lchildName = lchild.getName();
            if ("projection".equals(lchildName)) {
                this.initProjection(lchild);
                continue;
            }
            LOGGER.debug("Unrecognized child element name: {}", (Object)lchildName);
        }
    }

    private void initProjection(Element elem) {
        String elemName = elem.getName();
        if (!elemName.equals("projection")) {
            LOGGER.warn("Does not appear to be a projection element: {}", (Object)elemName);
            return;
        }
        Attribute nameA = elem.getAttribute("name");
        if (nameA == null) {
            return;
        }
        String lname = nameA.getValue();
        if (lname == null || lname.isEmpty()) {
            return;
        }
        String isFavorite = "true";
        Attribute faveA = elem.getAttribute("fave");
        if (faveA == null) {
            faveA = elem.getAttribute("favorite");
        }
        if (faveA == null) {
            faveA = elem.getAttribute("visible");
        }
        if (faveA == null) {
            faveA = elem.getAttribute("vis");
        }
        if (faveA != null && (isFavorite = faveA.getValue()) == null) {
            isFavorite = "true";
        }
        this.setFavorite(lname, isFavorite);
        for (int i = 0; i < 5; ++i) {
            Attribute paramA = elem.getAttribute("param" + i);
            if (paramA == null) continue;
            this.setParam(lname, i, paramA.getValue());
        }
    }

    final void write(Element parent) throws IOException {
        Element group = new Element("group");
        group.setAttribute("key", "projections");
        PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
        for (String pname : pprefs.getAllNames()) {
            Element fex = new Element("projection");
            fex.setAttribute("name", pname);
            boolean fave = pprefs.isFavorite(pname);
            if (!fave) {
                fex.setAttribute("fave", Boolean.toString(fave));
            }
            boolean hasParams = false;
            for (int i = 0; i < 5; ++i) {
                String pval = pprefs.getParam(pname, i);
                if (pval == null) continue;
                fex.setAttribute("param" + i, pval);
                hasParams = true;
            }
            if (!hasParams && fave) continue;
            group.addContent(fex);
        }
        parent.addContent(group);
    }

    private static class Singleton {
        private static final PanProjectionPrefs INSTANCE = new PanProjectionPrefs();

        private Singleton() {
        }
    }
}

