/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefs.PanProjectionPrefs;
import gov.nasa.giss.panoply.prefsui.PanPreferencesFrame;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPrefsCopier {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPreferences prefs_;
    private final PanPlotMeta pmeta_;
    protected final PanPlotType ptype_;

    public PanPrefsCopier(PanPlotMeta pmeta) {
        this.pmeta_ = pmeta;
        this.ptype_ = this.pmeta_.getType();
        this.prefs_ = PanPreferences.getSharedInstance();
    }

    public void copySettingsToPrefs() {
        this.setPref("plot:size.factor", "size.factor");
        this.setPref("plot:color.background", "color.background");
        this.setPref("plot:labels.font", "labels.font");
        this.setPref("plot:labels.super10", "labels.super10");
        this.setPref("plot:scale.method", "scale.method");
        this.setPref("plot:scale.exponent", "scale.exponent");
        this.setPref("plot:scale.div.major", "scale.div.major");
        this.setPref("plot:scale.div.minor", "scale.div.minor");
        this.setPref("plot:scale.tick.format", "scale.tick.format");
        this.setPref("plot:footnote.minmax.vis", "footnote.minmax.vis");
        this.setPref("plot:footnote.minmax.format", "footnote.minmax.format");
        if (this.ptype_.isLinePlot()) {
            this.setPref("plot:lineplot.axes.offset", "axes.offset");
            this.setPref("plot:lineplot.axes.tickmark.weight", "axes.tickmark.weight");
            this.setPref("plot:lineplot.axes.tickmark.color", "axes.tickmark.color");
            this.setPref("plot:lineplot.grid.weight", "grid.weight");
            this.setPref("plot:lineplot.grid.style", "grid.style");
            for (int i = 0; i < 2; ++i) {
                this.setPref(PanParamKeys.P_LINE_STROKE_COLOR[i], PanParamKeys.STROKE_COLOR[i]);
                this.setPref(PanParamKeys.P_LINE_STROKE_STYLE[i], PanParamKeys.STROKE_STYLE[i]);
                this.setPref(PanParamKeys.P_LINE_STROKE_WGT[i], PanParamKeys.STROKE_WGT[i]);
            }
            if (this.ptype_ == PanPlotType.HORZ_LINE) {
                this.setPref("plot:lineplot.xaxis.tick.size", "xaxis.tick.size");
                this.setPref("plot:lineplot.yaxis.tick.size", "scale.tick.size");
            } else if (this.ptype_ == PanPlotType.HORZ_LINE) {
                this.setPref("plot:llzonal.xaxis.begin", "xaxis.begin");
                this.setPref("plot:llzonal.xaxis.end", "xaxis.end");
            } else {
                this.setPref("plot:lineplot.xaxis.tick.size", "scale.tick.size");
                this.setPref("plot:lineplot.yaxis.tick.size", "yaxis.tick.size");
            }
        } else {
            this.setPref("plot:ccplot.grid.color", "grid.color");
            this.setPref("plot:ccplot.grid.weight", "grid.weight");
            this.setPref("plot:ccplot.grid.style", "grid.style");
            this.setPref("plot:interpolate", "interpolate");
            this.setPref("plot:scale.autofit", "scale.autofit");
            this.setPref("plot:colorbar.name", "colorbar.name");
            this.setPref("plot:colorbar.invalids", "colorbar.invalids");
            this.setPref("plot:colorbar.reverse", "colorbar.reverse");
            this.setPref("plot:colorbar.length", "colorbar.length");
            this.setPref("plot:colorbar.border.weight", "colorbar.border.weight");
            this.setPref("plot:colorbar.outlier.shape", "colorbar.outlier.shape");
            this.setPref("plot:colorbar.outlier.side", "colorbar.outlier.side");
            this.setPref("plot:colorbar.outlier.gap", "colorbar.outlier.gap");
            this.setPref("plot:scale.tick.size", "scale.tick.size");
            this.setPref("plot:scale.label.location", "scale.label.location");
            if (!this.ptype_.isLonLatMap()) {
                this.setPref("plot:ccplot.axes.offset", "axes.offset");
                this.setPref("plot:ccplot.axes.tickmark.weight", "axes.tickmark.weight");
                this.setPref("plot:ccplot.axes.tickmark.color", "axes.tickmark.color");
                this.setPref("plot:ccplot.xaxis.tick.size", "xaxis.tick.size");
                this.setPref("plot:ccplot.yaxis.tick.size", "yaxis.tick.size");
            }
            if (this.ptype_ == PanPlotType.LL_TRAJ) {
                this.setPref("plot:contour.weight", "contour.weight");
                this.setPref("plot:contour.style", "contour.style");
                this.setPref("plot:contour.color", "contour.color");
                this.setPref("plot:contour.location", "contour.location");
                this.setPref("plot:contour.label.vis", "contour.label.vis");
                this.setPref("plot:contour.label.size", "contour.label.size");
            }
        }
        if (this.ptype_ == PanPlotType.LON_LAT || this.ptype_ == PanPlotType.LAT_VERT || this.ptype_ == PanPlotType.LON_VERT) {
            this.setPref("plot:vector.weight", "vector.weight");
            this.setPref("plot:vector.style", "vector.style");
            this.setPref("plot:vector.color", "vector.color");
            this.setPref("plot:vector.spacing", "vector.spacing");
            this.setPref("plot:vector.sample", "vector.sample");
        }
        if (this.ptype_.isLonLatMap()) {
            int i;
            PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
            this.setPref("plot:lonlat.proj.name", "lonlat.proj.name");
            this.setPref("plot:lonlat.proj.lon0", "lonlat.proj.lon0");
            this.setPref("plot:lonlat.proj.lat0", "lonlat.proj.lat0");
            String pname = this.pmeta_.getString("lonlat.proj.name");
            for (i = 0; i < 5; ++i) {
                Object o = this.pmeta_.get("lonlat.proj.xparam." + (i + 1));
                if (o == null) continue;
                if (o instanceof Double) {
                    pprefs.setParam(pname, i, PrintfFormat.PFORMAT_10G.sprintfx(o));
                    continue;
                }
                pprefs.setParam(pname, i, o.toString());
            }
            this.setPref("plot:grid.spacing.lon", "grid.spacing.lon");
            this.setPref("plot:grid.spacing.lat", "grid.spacing.lat");
            this.setPref("plot:grid.offset.lat", "grid.offset.lat");
            this.setPref("plot:grid.label.step", "grid.label.step");
            this.setPref("plot:grid.label.size", "grid.label.size");
            this.setPref("plot:lonlat.border.weight", "lonlat.border.weight");
            for (i = 0; i < 3; ++i) {
                this.setPref(PanParamKeys.P_OVERLAY_NAME[i], PanParamKeys.OVERLAY_NAME[i]);
                this.setPref(PanParamKeys.P_OVERLAY_COLOR[i], PanParamKeys.OVERLAY_COLOR[i]);
                this.setPref(PanParamKeys.P_OVERLAY_INVERT[i], PanParamKeys.OVERLAY_INVERT[i]);
                this.setPref(PanParamKeys.P_OVERLAY_STYLE[i], PanParamKeys.OVERLAY_STYLE[i]);
                this.setPref(PanParamKeys.P_OVERLAY_SYMBOL_ID[i], PanParamKeys.OVERLAY_SYMBOL_ID[i]);
                this.setPref(PanParamKeys.P_OVERLAY_SYMBOL_SIZE[i], PanParamKeys.OVERLAY_SYMBOL_SIZE[i]);
                this.setPref(PanParamKeys.P_OVERLAY_WGT[i], PanParamKeys.OVERLAY_WGT[i]);
            }
            this.setPref("plot:lonlat.proj.shading.vis", "lonlat.proj.shading.vis");
            this.setPref("plot:lonlat.proj.shading.opacity", "lonlat.proj.shading.opacity");
            this.setPref("plot:lonlat.proj.subsolar.lon", "lonlat.proj.subsolar.lon");
            this.setPref("plot:lonlat.proj.subsolar.lat", "lonlat.proj.subsolar.lat");
        } else if (this.ptype_ == PanPlotType.LAT_TIME) {
            this.setPref("plot:lattime.xaxis.begin", "xaxis.begin");
            this.setPref("plot:lattime.xaxis.end", "xaxis.end");
        } else if (this.ptype_ == PanPlotType.LAT_VERT) {
            this.setPref("plot:latvert.xaxis.begin", "xaxis.begin");
            this.setPref("plot:latvert.xaxis.end", "xaxis.end");
            this.setPref("plot:latvert.yaxis.method", "yaxis.method");
            this.setPref("plot:latvert.yaxis.tick.format", "yaxis.tick.format");
        } else if (this.ptype_ == PanPlotType.LON_TIME) {
            this.setPref("plot:lontime.xaxis.begin", "xaxis.begin");
            this.setPref("plot:lontime.xaxis.end", "xaxis.end");
        } else if (this.ptype_ == PanPlotType.LON_VERT) {
            this.setPref("plot:lonvert.xaxis.begin", "xaxis.begin");
            this.setPref("plot:lonvert.xaxis.end", "xaxis.end");
            this.setPref("plot:lonvert.yaxis.method", "yaxis.method");
            this.setPref("plot:lonvert.yaxis.tick.format", "yaxis.tick.format");
        } else if (this.ptype_ == PanPlotType.TIME_LAT) {
            this.setPref("plot:timelat.yaxis.end", "yaxis.end");
            this.setPref("plot:timelat.yaxis.begin", "yaxis.begin");
        } else if (this.ptype_ == PanPlotType.TIME_VERT) {
            this.setPref("plot:lonvert.yaxis.method", "yaxis.method");
            this.setPref("plot:lonvert.yaxis.tick.format", "yaxis.tick.format");
        } else if (this.ptype_ == PanPlotType.COLOR_CONTOUR) {
            this.setPref("plot:xy.xaxis.div.major", "xaxis.div.major");
            this.setPref("plot:xy.xaxis.div.minor", "xaxis.div.minor");
            this.setPref("plot:xy.yaxis.div.major", "yaxis.div.major");
            this.setPref("plot:xy.yaxis.div.minor", "yaxis.div.minor");
            this.setPref("plot:xy.yaxis.tick.format", "yaxis.tick.format");
            this.setPref("plot:xy.yaxis.tick.format", "yaxis.tick.format");
        }
        if (this.ptype_ == PanPlotType.LL_TRAJ) {
            this.setPref("plot:feature.background", "feature.background");
            this.setPref("plot:feature.nanskip", "feature.nanskip");
            for (int i = 0; i < 2; ++i) {
                this.setPref(PanParamKeys.P_FEATURE_SYMBOL_ID[i], PanParamKeys.FEATURE_SYMBOL_ID[i]);
                this.setPref(PanParamKeys.P_FEATURE_SYMBOL_SIZE[i], PanParamKeys.FEATURE_SYMBOL_SIZE[i]);
                this.setPref(PanParamKeys.P_FEATURE_SYMBOL_FILL[i], PanParamKeys.FEATURE_SYMBOL_FILL[i]);
                this.setPref(PanParamKeys.P_TRAJ_STROKE_COLOR[i], PanParamKeys.STROKE_COLOR[i]);
                this.setPref(PanParamKeys.P_TRAJ_STROKE_STYLE[i], PanParamKeys.STROKE_STYLE[i]);
                this.setPref(PanParamKeys.P_TRAJ_STROKE_WGT[i], PanParamKeys.STROKE_WGT[i]);
            }
        }
        if (PanPreferencesFrame.instanceExists()) {
            PanPreferencesFrame.getSharedInstance().refresh();
        }
    }

    private void setPref(String prefKey, String plotKey) {
        if (!this.pmeta_.containsKey(plotKey)) {
            LOGGER.warn("Plot meta does not contain key {}", (Object)plotKey);
            return;
        }
        Object o = this.pmeta_.get(plotKey);
        this.prefs_.set(prefKey, o);
    }
}

