/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.util.PlatformUtils;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanPreferenceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String APPNAME = "Panoply";
    public static final String DOMAIN = "gov.nasa.giss";
    static final String ALTDIR = ".gissjava";
    private static boolean supportDirChecked_;
    private static File supportDir_;

    static synchronized File findSavedSettingsFile(String type, int majorVersion) {
        Objects.requireNonNull(type, "Settings type cannot be null.");
        File supportDir = PanPreferenceUtils.findSupportDirectory();
        if (supportDir == null) {
            LOGGER.warn("Unable to find/access/create support directory.");
            LOGGER.warn("Saved settings file Object {} will be null.", (Object)type);
            return null;
        }
        StringBuilder fnameSB = new StringBuilder();
        if (PlatformUtils.isMacintosh()) {
            fnameSB.append(DOMAIN).append('.').append(APPNAME);
        } else {
            fnameSB.append(APPNAME.toLowerCase());
        }
        if (majorVersion > 0) {
            fnameSB.append('.').append(majorVersion);
        }
        fnameSB.append('.').append(type).append(".xml");
        String fname = fnameSB.toString();
        try {
            return new File(supportDir, fname);
        }
        catch (Exception ignore) {
            throw new RuntimeException("Unable to create saved settings File object.");
        }
    }

    static synchronized File findSupportDirectory() {
        if (supportDir_ != null) {
            return supportDir_;
        }
        if (supportDirChecked_) {
            return supportDir_;
        }
        supportDirChecked_ = true;
        File supportDir = null;
        try {
            File gissSupportDir = FileUtils.getGISSAppSupportDirectory();
            supportDir = new File(gissSupportDir, APPNAME);
        }
        catch (Exception exc) {
            throw new RuntimeException("Unable to create support directory File object.");
        }
        if (supportDir == null) {
            throw new RuntimeException("Created null support directory File object?");
        }
        if (!supportDir.exists()) {
            LOGGER.debug("support dir not present; trying to create it.");
            try {
                supportDir.mkdirs();
            }
            catch (SecurityException exc) {
                LOGGER.warn("SecurityException creating support directory");
                supportDir = null;
            }
            catch (Exception exc) {
                LOGGER.warn("Unexpected exception creating support directory");
                supportDir = null;
            }
        }
        supportDir_ = supportDir;
        return supportDir;
    }

    private PanPreferenceUtils() {
    }
}

