/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefs.PanBookmarkType;
import gov.nasa.giss.panoply.prefs.PanBookmarksNode;
import gov.nasa.giss.panoply.ui.PanFrame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBookmark
extends PanBookmarksNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String UNNAMED = "Unnamed";
    private static String homeDir_ = System.getProperty("user.home");
    private PanBookmarkType btype_;
    private URI uri_;

    private PanBookmark() {
    }

    public PanBookmark(PanBookmarksNode parent, PanBookmarkType btype, Object address, String name) throws IOException, URISyntaxException {
        this(btype, address, name);
        super.setParent(parent);
    }

    public PanBookmark(String btype, Object address, String name) throws IOException, URISyntaxException {
        Objects.requireNonNull(btype, "Null bookmark type");
        if ("local".equals(btype) || "file".equals(btype)) {
            this.initMe(PanBookmarkType.LOCAL_DATASET, address, name);
        } else if ("remote".equals(btype)) {
            this.initMe(PanBookmarkType.REMOTE_DATASET, address, name);
        } else if ("catalog".equals(btype)) {
            this.initMe(PanBookmarkType.CATALOG, address, name);
        } else {
            throw new IllegalArgumentException("Uknown bookmark type");
        }
    }

    public PanBookmark(PanBookmarkType btype, Object address, String name) throws IOException, URISyntaxException {
        this.initMe(btype, address, name);
    }

    private void initMe(PanBookmarkType btype, Object address, String name) throws FileNotFoundException, IOException, URISyntaxException {
        this.btype_ = btype;
        this.setName(name);
        if (address instanceof URI) {
            this.uri_ = (URI)address;
        } else if (address instanceof URL) {
            this.uri_ = ((URL)address).toURI();
        } else if (address instanceof File) {
            this.uri_ = ((File)address).toURI();
        } else if (address instanceof String) {
            String saddress = (String)address;
            switch (btype) {
                case LOCAL_DATASET: {
                    saddress = saddress.replaceFirst("file:", "");
                    saddress = saddress.replaceAll("/+", "/");
                    URI uri = new URI("file:" + saddress);
                    File f = new File(uri);
                    if (!f.exists()) {
                        throw new FileNotFoundException("No local file for address " + address);
                    }
                    this.uri_ = uri;
                    break;
                }
                case REMOTE_DATASET: 
                case CATALOG: {
                    this.uri_ = new URI(saddress);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown bookmark type");
                }
            }
        } else {
            throw new IllegalArgumentException("Bookmark address must be a File, URL, or URI, or a String that may be parsed asone of those types.");
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public Object getObject() {
        return this.uri_;
    }

    @Override
    public String getName() {
        if (this.isNameSet()) {
            return super.getName();
        }
        Object s = null;
        try {
            s = this.uri_.toURL().getFile();
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return "URI Error";
        }
        if (s == null || ((String)s).isEmpty()) {
            return UNNAMED;
        }
        if (this.btype_ == PanBookmarkType.LOCAL_DATASET) {
            if (((String)s).startsWith("file:")) {
                s = ((String)s).substring(5);
            }
            if (((String)s).startsWith(homeDir_)) {
                s = "~" + ((String)s).substring(homeDir_.length());
            }
        }
        s = ((String)s).replaceAll("%20", " ");
        return s;
    }

    @Override
    public String getAddress() {
        if (this.uri_ == null) {
            return "Null address";
        }
        Object s = this.uri_.toString();
        if (s == null) {
            return "Null address";
        }
        if (((String)s).startsWith("file:") && ((String)(s = ((String)s).substring(5))).startsWith(homeDir_)) {
            s = "~" + ((String)s).substring(homeDir_.length());
        }
        s = ((String)s).replaceAll("%20", " ");
        return s;
    }

    public PanBookmarkType getAccessType() {
        return this.btype_;
    }

    public void open(PanFrame pframe) {
        switch (this.btype_) {
            case LOCAL_DATASET: {
                PanFileUtils.openLocalDataset(pframe, this.uri_);
                break;
            }
            case REMOTE_DATASET: {
                PanFileUtils.openDataset(this.uri_);
                break;
            }
            case CATALOG: {
                PanFileUtils.openRemoteCatalog(pframe, this.uri_);
                break;
            }
            default: {
                LOGGER.debug("Switch default case: How did we get here? {}", (Object)this.btype_);
            }
        }
    }

    public PanBookmark copy() {
        try {
            String name = this.isNameSet() ? this.getName() : null;
            return new PanBookmark(this.getAccessType(), this.getObject(), name);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not copy bookmark: {}", exc);
            return null;
        }
    }
}

