/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui.table;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayDiscreteTrajectory;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.panoply.plotui.table.PanArrayTableModel;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanArrayLonLatTrajectoryTableModel
extends PanArrayTableModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected NcArrayDiscreteTrajectory array_;

    public PanArrayLonLatTrajectoryTableModel(NcArray array) {
        if (!(array instanceof NcArrayDiscreteTrajectory)) {
            throw new IllegalArgumentException("NcArray is not an NcArrayDiscreteTrajectory.");
        }
        this.array_ = (NcArrayDiscreteTrajectory)array;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        try {
            return this.array_.getLength();
        }
        catch (Exception exc) {
            LOGGER.trace("exc {}", exc);
            return 0;
        }
    }

    public Class<String> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Time";
            }
            case 1: {
                return "Lon";
            }
            case 2: {
                return "Lat";
            }
            case 3: {
                return "Value";
            }
        }
        return "";
    }

    @Override
    public String getRowName(int row) {
        int rowx = this.flippedBT_ ? this.getRowCount() - 1 - row : row;
        return Integer.toString(rowx + 1);
    }

    @Override
    public Object getValueAt(int row, int col) {
        int rowx = this.flippedBT_ ? this.getRowCount() - 1 - row : row;
        switch (col) {
            case 0: {
                Object t = this.array_.timeAt(rowx);
                if (t == null) {
                    return "null";
                }
                return t.toString();
            }
            case 1: {
                PointLL llon = this.array_.lonLatAt(rowx);
                if (llon != null) {
                    return this.valFormatter_.sprintfx(llon.getLon());
                }
                return "\u2014";
            }
            case 2: {
                PointLL llat = this.array_.lonLatAt(rowx);
                if (llat != null) {
                    return this.valFormatter_.sprintfx(llat.getLat());
                }
                return "\u2014";
            }
            case 3: {
                return this.valFormatter_.sprintfx(this.array_.valueAt(rowx));
            }
        }
        return "ERR";
    }

    @Override
    public void setFlipBT(boolean flipped) {
        this.flippedBT_ = flipped;
        this.fireTableDataChanged();
    }

    @Override
    public void setFlipLR(boolean flipped) {
    }
}

