/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui.table;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereCAMSE;
import gov.nasa.giss.panoply.plotui.table.PanArrayTableModel;

public class PanArrayCubedSphereCAMSETableModel
extends PanArrayTableModel {
    protected NcArrayLonLatCubedSphereCAMSE array_;

    public PanArrayCubedSphereCAMSETableModel(NcArray array) {
        if (!(array instanceof NcArrayLonLatCubedSphereCAMSE)) {
            throw new IllegalArgumentException("NcArray is not an NcArrayLonLatCubedSphereCAMSE.");
        }
        this.array_ = (NcArrayLonLatCubedSphereCAMSE)array;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        try {
            return this.array_.getNumCorners();
        }
        catch (Exception exc) {
            return 0;
        }
    }

    public Class<String> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Lon";
            }
            case 1: {
                return "Lat";
            }
            case 2: {
                return "Value";
            }
        }
        return "";
    }

    @Override
    public String getRowName(int row) {
        int rowx = this.flippedBT_ ? this.getRowCount() - 1 - row : row;
        return Integer.toString(rowx + 1);
    }

    @Override
    public Object getValueAt(int row, int col) {
        int rowx = this.flippedBT_ ? this.getRowCount() - 1 - row : row;
        switch (col) {
            case 0: {
                return this.valFormatter_.sprintfx(this.array_.getCornerLongitudeAt(rowx));
            }
            case 1: {
                return this.valFormatter_.sprintfx(this.array_.getCornerLatitudeAt(rowx));
            }
            case 2: {
                return this.valFormatter_.sprintfx(this.array_.valueAt(rowx));
            }
        }
        return "ERR";
    }

    @Override
    public void setFlipBT(boolean flipped) {
        this.flippedBT_ = flipped;
        this.fireTableDataChanged();
    }

    @Override
    public void setFlipLR(boolean flipped) {
    }
}

