/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanDataGeneral2D;
import gov.nasa.giss.panoply.data.PanDataLonLatTrajectory;
import gov.nasa.giss.panoply.data.PanDataLonLatZonal;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanAxisMethodComboBox;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanCaptionListener;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanRadioButton;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanConstants;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.Unit;

public abstract class PanZoomableAxisControls
extends PanAbstractControlsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String NONE = "None";
    protected Hashtable<String, String> paramKeys_;
    protected PanPlotType ptype_;
    protected NcAxisType axisType_;
    protected boolean axisIsPressure_;
    protected boolean axisIsHeight_;
    protected boolean axisIsTime_;
    protected boolean isLog_;
    protected PanTextField val1TF_;
    protected PanTextField val2TF_;
    protected PanButton swapBtn_;
    protected PanButton resetBtn_;
    protected PanAxisMethodComboBox methodCombo_;
    protected PanStringComboBox unitsCombo_;
    protected PanStringComboBox tickFormatCombo_;
    protected PanIntSpinner majorDivSpinner_;
    protected PanIntSpinner minorDivSpinner_;
    protected PanFloatComboBox tickSizeCombo_;
    protected PanRadioButton dfltCaptionBtn_;
    protected PanRadioButton customCaptionBtn_;
    protected PanTextField captionTF_;
    protected PanFloatComboBox captionSizeCombo_;
    private boolean refreshing_;

    public PanZoomableAxisControls(String name, PanPlotMeta pmeta, PanMenuBar mbar) {
        super(name, pmeta, mbar);
        this.ptype_ = pmeta.getType();
        this.axisType_ = this.getAxisType();
        LOGGER.trace("Axis type {}", (Object)this.axisType_);
    }

    protected abstract boolean isHorizontal();

    protected abstract NcAxisType getAxisType();

    protected void createLayout(Hashtable<String, String> paramKeys) {
        QuickBox unitsBox;
        this.paramKeys_ = paramKeys;
        String swapKey = paramKeys.get("swap-axis-bounds");
        SwapBoundsAction swapAction = new SwapBoundsAction(swapKey);
        this.pmeta_.putAction(swapKey, swapAction);
        GissMenu plotMenu = this.mbar_.getMenuByName("plot-menu");
        plotMenu.getItemByName(swapKey).setAction(swapAction);
        plotMenu.getItemByName(swapKey).setEnabled(true);
        String val1Key = paramKeys.get("axis.begin");
        String val2Key = paramKeys.get("axis.end");
        this.val1TF_ = PanTextField.smallDoubleField(val1Key, this.pmeta_.getDouble(val1Key));
        this.val2TF_ = PanTextField.smallDoubleField(val2Key, this.pmeta_.getDouble(val2Key));
        this.swapBtn_ = this.isHorizontal() ? PanButton.small(swapAction, "Swap L/R") : PanButton.small(swapAction, "Swap B/T");
        this.resetBtn_ = PanButton.small("Reset");
        PanLabel axisLabel = this.isHorizontal() ? PanLabel.small("X Axis:\u2009") : PanLabel.small("Y Axis:\u2009");
        PanLabel rangeLabel1 = this.isHorizontal() ? PanLabel.small("Left:\u2009") : PanLabel.small("Bottom:\u2009");
        PanLabel rangeLabel2 = this.isHorizontal() ? PanLabel.small(", Right:\u2009") : PanLabel.small(", Top:\u2009");
        QuickBox rangeBox = QuickBox.createLeftBox(rangeLabel1, this.val1TF_, rangeLabel2, this.val2TF_, this.swapBtn_, this.resetBtn_);
        String methodKey = paramKeys.get("axis.method");
        String unitsKey = paramKeys.get("axis.units");
        String method = this.pmeta_.getString(methodKey);
        this.methodCombo_ = PanAxisMethodComboBox.small(methodKey, !this.ptype_.isLinePlot());
        this.methodCombo_.setSelectedItem(method);
        PanLabel unitsLabel1 = PanLabel.small("Units:\u2009");
        this.unitsCombo_ = PanStringComboBox.small(unitsKey);
        if (this.axisIsTime_) {
            String unitsStr;
            this.methodCombo_.setEnabled(false);
            if (this.data_ instanceof PanDataGeneral2D) {
                PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
                unitsStr = this.isHorizontal() ? data2d.getDataXAxisUnits() : data2d.getDataYAxisUnits();
            } else if (this.data_ instanceof PanData1D) {
                PanData1D data1d = (PanData1D)this.data_;
                unitsStr = data1d.getDataAxisUnits();
            } else {
                LOGGER.warn("Time axis but unknown data type: {}", (Object)this.data_.getClass());
                unitsStr = "-";
            }
            PanLabel unitsLabel2 = PanLabel.small(unitsStr);
            unitsBox = QuickBox.createLeftBox(unitsLabel1, unitsLabel2);
        } else {
            PanLabel unitsLabel2 = PanLabel.small(" of\u2009");
            this.populateUnitsCombo();
            unitsBox = QuickBox.createLeftBox(unitsLabel1, this.methodCombo_, unitsLabel2, this.unitsCombo_);
            this.isLog_ = PanAxisMethod.LOG10.matches(method);
            this.unitsCombo_.setEnabled(!PanAxisMethod.INDEX.matches(method));
            PanGuiUtils.setMaxWidth(this.unitsCombo_, 240);
        }
        String formatKey = paramKeys.get("axis.tick.format");
        if (this.axisIsTime_) {
            LOGGER.trace("axis looks like time");
            this.tickFormatCombo_ = PanStringComboBox.smallTimeFormatCombo(formatKey);
            this.tickFormatCombo_.insertItemAt(NONE, 0);
            String formatStr = this.pmeta_.getString(formatKey);
            LOGGER.trace("Set time combo format '{}'", (Object)formatStr);
            this.tickFormatCombo_.setSelectedItem(formatStr);
            String xformat = this.tickFormatCombo_.getSelectedString();
            if (!xformat.equals(formatStr)) {
                LOGGER.trace("Combo cannot display format '{}'", (Object)formatStr);
                this.tickFormatCombo_.setSelectedItem("yyyy-MM-dd HH:mm:ss");
                String pkey = this.tickFormatCombo_.getName();
                this.pmeta_.setString(pkey, "yyyy-MM-dd HH:mm:ss");
            }
            NcAxis ncax = null;
            if (this.data_ instanceof PanDataGeneral2D) {
                PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
                ncax = this.isHorizontal() ? data2d.getXAxis() : data2d.getYAxis();
            } else if (this.data_ instanceof PanData1D) {
                PanData1D data1d = (PanData1D)this.data_;
                ncax = data1d.getAxis();
            }
            boolean isUT = ncax instanceof NcTimeAxis && ((NcTimeAxis)ncax).isUnixTime();
            this.tickFormatCombo_.setEnabled(isUT);
        } else {
            this.tickFormatCombo_ = PanStringComboBox.smallNumberFormatCombo(formatKey);
            this.tickFormatCombo_.setSelectedItem(this.pmeta_.getString(formatKey));
        }
        PanGuiUtils.setMaxWidth(this.tickFormatCombo_, 144);
        String majorDivKey = paramKeys.get("axis.div.major");
        String minorDivKey = paramKeys.get("axis.div.minor");
        String tickSizeKey = paramKeys.get("axis.tick.size");
        this.majorDivSpinner_ = PanIntSpinner.smallDivs(majorDivKey, this.pmeta_.getInt(majorDivKey));
        this.minorDivSpinner_ = PanIntSpinner.smallDivs(minorDivKey, this.pmeta_.getInt(minorDivKey));
        this.majorDivSpinner_.setEnabled(!this.isLog_);
        this.minorDivSpinner_.setEnabled(!this.isLog_);
        this.tickSizeCombo_ = PanFloatComboBox.small(tickSizeKey, 5.0f, 14.0f);
        this.tickSizeCombo_.setValue(this.pmeta_.getFloat(tickSizeKey));
        PanLabel formatLabel1 = PanLabel.small("Ticks:\u2009");
        PanLabel formatLabel2 = PanLabel.small("Format:\u2009");
        PanLabel formatLabel3 = PanLabel.small("\u2014 ");
        PanLabel formatLabel4 = PanLabel.small("Divisions: Major:\u2009");
        PanLabel formatLabel5 = PanLabel.small(", Minor:\u2009");
        PanLabel formatLabel6 = PanLabel.small("\u2014 Size:\u2009");
        QuickBox formatBox = QuickBox.createLeftBox(formatLabel1, formatLabel2, this.tickFormatCombo_, formatLabel3, formatLabel4, this.majorDivSpinner_, formatLabel5, this.minorDivSpinner_, formatLabel6, this.tickSizeCombo_);
        String captionIsCustomKey = paramKeys.get("axis.label.custom");
        String captionTextKey = paramKeys.get("axis.label.text");
        String captionSizeKey = paramKeys.get("axis.label.size");
        this.dfltCaptionBtn_ = PanRadioButton.small(captionIsCustomKey, "Default", !this.pmeta_.getBoolean(captionIsCustomKey));
        this.customCaptionBtn_ = PanRadioButton.small(captionIsCustomKey, "Custom:", this.pmeta_.getBoolean(captionIsCustomKey));
        ButtonGroup axisChoices = new ButtonGroup();
        axisChoices.add(this.dfltCaptionBtn_);
        axisChoices.add(this.customCaptionBtn_);
        this.captionTF_ = PanTextField.small(captionTextKey, this.pmeta_.getString(captionTextKey), 20);
        this.captionSizeCombo_ = PanFloatComboBox.small(captionSizeKey, 5.0f, 20.0f);
        this.captionSizeCombo_.setValue(this.pmeta_.getFloat(captionSizeKey));
        PanLabel captionLabel1 = PanLabel.small("Caption:\u2009");
        PanLabel captionLabel2 = PanLabel.small("\u2014 Size:\u2009");
        QuickBox captionBox = QuickBox.createLeftBox(captionLabel1, this.dfltCaptionBtn_, this.customCaptionBtn_, this.captionTF_, captionLabel2, this.captionSizeCombo_);
        int tfh = this.captionTF_.getPreferredSize().height;
        this.captionTF_.setMinimumSize(new Dimension(150, tfh));
        this.captionTF_.setPreferredSize(new Dimension(225, tfh));
        this.captionTF_.setMaximumSize(new Dimension(1000, tfh));
        GuiUtils.matchLabelWidths(rangeLabel1, unitsLabel1, formatLabel1, captionLabel1);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 4, 0, 2);
        fgl.setColumnWeight(1, 9999.0f);
        fgl.setRigidHeight(true);
        this.setLayout(fgl);
        this.setBorder(null);
        this.add((Component)axisLabel, new FGConstraint(0, 0));
        this.add((Component)rangeBox, new FGConstraint(1, 0));
        this.add((Component)unitsBox, new FGConstraint(1, 1));
        this.add((Component)formatBox, new FGConstraint(1, 2));
        this.add((Component)captionBox, new FGConstraint(1, 3));
        Dimension dd = this.getPreferredSize();
        dd.width = axisLabel.getPreferredSize().width + formatBox.getPreferredSize().width + 8;
        this.setPreferredSize(dd);
        this.attachListeners();
    }

    private void populateUnitsCombo() {
        String unitsStr = "";
        if (this.data_ instanceof PanDataGeneral2D) {
            PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
            unitsStr = this.isHorizontal() ? data2d.getDataXAxisUnits() : data2d.getDataYAxisUnits();
        } else if (this.data_ instanceof PanData1D) {
            PanData1D data1d = (PanData1D)this.data_;
            unitsStr = data1d.getDataAxisUnits();
        } else if (!(this.data_ instanceof PanDataLonLatZonal)) {
            if (this.data_ instanceof PanDataLonLatTrajectory) {
                throw new RuntimeException("No axis units coded to handle LL-Trajectory");
            }
            throw new RuntimeException("No axis units coded to handle " + this.data_.getClass());
        }
        if (this.axisType_ == NcAxisType.LON || NcUnitUtils.isDegreesEast(unitsStr)) {
            this.unitsCombo_.addItem("degree_east");
            this.methodCombo_.setEnabled(false);
            return;
        }
        if (this.axisType_ == NcAxisType.LAT || NcUnitUtils.isDegreesNorth(unitsStr)) {
            this.unitsCombo_.addItem("degree_north");
            this.methodCombo_.setEnabled(false);
            return;
        }
        if (unitsStr != null) {
            this.unitsCombo_.addItem(unitsStr);
        }
        if (this.axisIsPressure_ || this.axisIsHeight_) {
            String[] ss = this.axisIsPressure_ ? PanConstants.PRESSURE_UNITS : PanConstants.DISTANCE_UNITS;
            boolean added = false;
            try {
                Unit yuu = NcUnitUtils.parse(unitsStr);
                for (String s : ss) {
                    this.unitsCombo_.addItem(s);
                    Unit suu = NcUnitUtils.parse(s);
                    if (!yuu.equals(suu)) continue;
                    this.unitsCombo_.setSelectedItem(s);
                    added = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!added) {
                this.unitsCombo_.insertItemAt(unitsStr, 0);
                this.unitsCombo_.setSelectedIndex(0);
            }
        } else {
            if (unitsStr == null || unitsStr.isEmpty()) {
                unitsStr = "1";
            }
            this.unitsCombo_.addItem(unitsStr);
        }
    }

    protected void attachListeners() {
        FocusAdapter rangeFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanZoomableAxisControls.this.handleAxisBoundsEvent(e);
            }
        };
        ActionListener rangeAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanZoomableAxisControls.this.handleAxisBoundsEvent(e);
            }
        };
        this.val1TF_.addFocusListener(rangeFL);
        this.val2TF_.addFocusListener(rangeFL);
        this.val1TF_.addActionListener(rangeAL);
        this.val2TF_.addActionListener(rangeAL);
        this.resetBtn_.addActionListener(e -> this.resetAxisBounds());
        if (this.methodCombo_ != null) {
            this.methodCombo_.addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.handleAxisMethodEvent();
            });
        }
        if (this.unitsCombo_ != null) {
            this.unitsCombo_.addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                String pkey = this.unitsCombo_.getName();
                this.pmeta_.setString(pkey, this.unitsCombo_.getSelectedString());
            });
        }
        this.majorDivSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            String pkey = this.majorDivSpinner_.getName();
            this.pmeta_.setInt(pkey, this.majorDivSpinner_.getIntValue());
        });
        this.minorDivSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            String pkey = this.minorDivSpinner_.getName();
            this.pmeta_.setInt(pkey, this.minorDivSpinner_.getIntValue());
        });
        if (this.tickFormatCombo_ != null) {
            this.tickFormatCombo_.addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                String pkey = this.tickFormatCombo_.getName();
                String format = this.tickFormatCombo_.getSelectedString();
                if (format == NONE) {
                    format = "";
                }
                this.pmeta_.setString(pkey, format);
            });
        }
        if (this.tickSizeCombo_ != null) {
            this.tickSizeCombo_.addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                String pkey = this.tickSizeCombo_.getName();
                float value = this.tickSizeCombo_.getValue();
                this.pmeta_.setFloat(pkey, value);
            });
        }
        this.dfltCaptionBtn_.addActionListener(e -> {
            if (this.refreshing_) {
                return;
            }
            String pkey = this.dfltCaptionBtn_.getName();
            this.pmeta_.setBoolean(pkey, !this.dfltCaptionBtn_.isSelected());
        });
        this.customCaptionBtn_.addActionListener(e -> {
            if (this.refreshing_) {
                return;
            }
            String pkey = this.customCaptionBtn_.getName();
            this.pmeta_.setBoolean(pkey, this.customCaptionBtn_.isSelected());
        });
        this.captionTF_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PanZoomableAxisControls.this.refreshing_) {
                    return;
                }
                if (PanZoomableAxisControls.this.captionTF_ == null || PanZoomableAxisControls.this.pmeta_ == null) {
                    return;
                }
                String pkey = PanZoomableAxisControls.this.captionTF_.getName();
                PanZoomableAxisControls.this.pmeta_.setString(pkey, PanZoomableAxisControls.this.captionTF_.getText());
            }
        });
        this.captionTF_.addActionListener(e -> {
            if (this.refreshing_) {
                return;
            }
            String pkey = this.captionTF_.getName();
            this.pmeta_.setString(pkey, this.captionTF_.getText());
        });
        if (this.captionSizeCombo_ != null) {
            this.captionSizeCombo_.addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                String pkey = this.captionSizeCombo_.getName();
                float value = this.captionSizeCombo_.getValue();
                this.pmeta_.setFloat(pkey, value);
            });
        }
        this.captionTF_.getDocument().addDocumentListener(new PanCaptionListener(this.captionTF_, this.pmeta_, this.captionTF_.getName()));
    }

    public void recenter(double center) {
        this.zoom(1.0, center);
    }

    public void zoom(double factor) {
        this.zoom(factor, Double.NaN);
    }

    public void zoom(double factor, double center) {
        double bb;
        double aa;
        double[] dd = this.getAxisBounds();
        if (dd == null) {
            LOGGER.debug("Cannot zoom -- current axis bounds are null.");
            return;
        }
        if (Double.isNaN(dd[0]) || Double.isNaN(dd[0])) {
            LOGGER.debug("Cannot zoom -- one or both of current axis bounds is null.");
            return;
        }
        double xcenter = center;
        if (Double.isNaN(xcenter)) {
            if (this.isLog_) {
                dd[0] = Math.log10(dd[0]);
                dd[1] = Math.log10(dd[1]);
                double logCenter = 0.5 * (dd[0] + dd[1]);
                xcenter = Math.pow(10.0, logCenter);
            } else {
                xcenter = 0.5 * (dd[0] + dd[1]);
            }
        }
        if (this.isLog_) {
            double logcenter = Math.log10(xcenter);
            dd[0] = Math.log10(dd[0]);
            dd[1] = Math.log10(dd[1]);
            double diff = dd[1] - dd[0];
            double newdiff = diff / factor;
            double halfdiff = 0.5 * newdiff;
            double logaa = logcenter - halfdiff;
            double logbb = logcenter + halfdiff;
            aa = Math.pow(10.0, logaa);
            bb = Math.pow(10.0, logbb);
        } else {
            double diff = dd[1] - dd[0];
            double newdiff = diff / factor;
            double halfdiff = 0.5 * newdiff;
            aa = xcenter - halfdiff;
            bb = xcenter + halfdiff;
            if (this.axisType_ == NcAxisType.LAT) {
                if (!(Math.abs(aa) <= 90.0) || !(Math.abs(bb) <= 90.0)) {
                    if (Math.abs(bb - aa) > 180.0) {
                        if (aa > bb) {
                            aa = 90.0;
                            bb = -90.0;
                        } else {
                            aa = -90.0;
                            bb = 90.0;
                        }
                    } else if (aa > 90.0 || bb > 90.0) {
                        double sub = Math.max(aa - 90.0, bb - 90.0);
                        aa -= sub;
                        bb -= sub;
                    } else if (aa < -90.0 || bb < -90.0) {
                        double add = Math.max(-90.0 - aa, -90.0 - bb);
                        aa += add;
                        bb += add;
                    } else {
                        aa = MathUtils.constrain(-90.0, 90.0, aa);
                        bb = MathUtils.constrain(-90.0, 90.0, bb);
                    }
                }
            } else if (this.axisType_ == NcAxisType.LON) {
                if (Math.abs(aa - bb) > 360.0) {
                    if (bb > aa) {
                        aa = xcenter - 180.0;
                        bb = xcenter + 180.0;
                    } else {
                        aa = xcenter + 180.0;
                        bb = xcenter - 180.0;
                    }
                }
                while (aa < -360.0) {
                    aa += 360.0;
                    bb += 360.0;
                }
                while (bb > 360.0) {
                    aa -= 360.0;
                    bb -= 360.0;
                }
            } else if (this.axisIsPressure_ && (aa < 0.0 || bb < 0.0)) {
                double shift = Math.max(0.0 - aa, 0.0 - bb);
                aa += shift;
                bb += shift;
            }
        }
        this.setAxisBounds(aa, bb);
    }

    public double[] getAxisBounds() {
        String val1Key = this.paramKeys_.get("axis.begin");
        String val2Key = this.paramKeys_.get("axis.end");
        return new double[]{this.pmeta_.getDouble(val1Key), this.pmeta_.getDouble(val2Key)};
    }

    protected void setAxisBounds(double val1, double val2) {
        double xval1 = val1;
        double xval2 = val2;
        if (this.axisType_ == NcAxisType.LAT) {
            xval1 = MathUtils.constrain(-90.0, 90.0, xval1);
            xval2 = MathUtils.constrain(-90.0, 90.0, xval2);
        }
        if (xval1 == xval2) {
            if (xval1 < 90.0) {
                xval2 += 1.0E-25;
            } else {
                xval1 -= 1.0E-25;
            }
        }
        this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(xval1));
        this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(xval2));
        if (this.isHorizontal()) {
            this.pmeta_.setGridLeftAndRight(xval1, xval2);
        } else {
            this.pmeta_.setGridBottomAndTop(xval1, xval2);
        }
    }

    protected void handleAxisBoundsEvent(EventObject e) {
        double oldval2;
        double oldval1;
        if (this.refreshing_) {
            return;
        }
        if (this.val1TF_ == null || this.val2TF_ == null || this.pmeta_ == null) {
            return;
        }
        String val1Key = this.val1TF_.getName();
        Object source = e == null ? null : e.getSource();
        double val1 = oldval1 = this.pmeta_.getDouble(val1Key);
        if (source == null || source == this.val1TF_) {
            try {
                val1 = StringUtils.parseDouble(this.val1TF_.getText());
            }
            catch (Exception exc) {
                this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(oldval1));
                return;
            }
            if (this.axisType_ == NcAxisType.LAT) {
                if (val1 < -90.0 || val1 > 90.0) {
                    val1 = MathUtils.constrain(-90.0, 90.0, val1);
                    this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val1));
                }
            } else if (this.axisType_ == NcAxisType.LON) {
                if (val1 < -360.0) {
                    val1 = -360.0;
                    this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val1));
                } else if (val1 >= 360.0) {
                    val1 = 360.0;
                    this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val1));
                }
            }
        }
        String val2Key = this.val2TF_.getName();
        double val2 = oldval2 = this.pmeta_.getDouble(val2Key);
        if (source == null || source == this.val2TF_) {
            try {
                val2 = StringUtils.parseDouble(this.val2TF_.getText());
            }
            catch (Exception exc) {
                this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(oldval2));
                return;
            }
            if (this.axisType_ == NcAxisType.LAT) {
                if (val2 < -90.0 || val2 > 90.0) {
                    val2 = MathUtils.constrain(-90.0, 90.0, val2);
                    this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val2));
                }
            } else if (this.axisType_ == NcAxisType.LON) {
                if (val2 < -360.0) {
                    val2 = -360.0;
                    this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val2));
                } else if (val2 >= 360.0) {
                    val2 = 360.0;
                    this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val2));
                }
            }
        }
        if (this.axisType_ == NcAxisType.LAT) {
            if (val1 == val2) {
                if (val1 == -90.0) {
                    val2 = -89.999;
                    this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val2));
                } else if (val1 == 90.0) {
                    val1 = 89.999;
                    this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val1));
                } else {
                    val2 = val1 + 0.001;
                    if (val2 >= 90.0) {
                        val1 = 89.999;
                        val2 = 90.0;
                    }
                    this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val1));
                    this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val2));
                }
            }
        } else if (this.axisType_ == NcAxisType.LON) {
            if (val1 == val2) {
                if (val1 <= 0.0) {
                    this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val2 += -360.0));
                } else {
                    this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val1 -= -360.0));
                }
            } else if (Math.abs(val2 - val1) > 360.0) {
                boolean pval2;
                boolean bl = pval2 = val2 - val1 > 0.0;
                if (e == null) {
                    val2 = pval2 ? val1 + 360.0 : val1 - 360.0;
                    this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val2));
                } else if (e.getSource() == this.val1TF_) {
                    val2 = pval2 ? val1 + 360.0 : val1 - 360.0;
                    this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val2));
                } else if (e.getSource() == this.val2TF_) {
                    val1 = pval2 ? val2 - 360.0 : val2 + 360.0;
                    this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val1));
                }
            }
        }
        this.setAxisBounds(val1, val2);
    }

    public abstract void resetAxisBounds();

    private void handleAxisMethodEvent() {
        String methodKey = this.paramKeys_.get("axis.method");
        PanAxisMethod method = this.methodCombo_.getSelectedMethod();
        this.pmeta_.setString(methodKey, method.name());
        this.isLog_ = method == PanAxisMethod.LOG10;
        this.majorDivSpinner_.setEnabled(!this.isLog_);
        this.minorDivSpinner_.setEnabled(!this.isLog_);
        String val1Key = this.paramKeys_.get("axis.begin");
        String val2Key = this.paramKeys_.get("axis.end");
        double val1 = this.pmeta_.getDouble(val1Key);
        double val2 = this.pmeta_.getDouble(val2Key);
        this.setAxisBounds(val1, val2);
        if (this.unitsCombo_ != null) {
            this.unitsCombo_.setEnabled(method != PanAxisMethod.INDEX);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.refreshing_ = false;
    }

    class SwapBoundsAction
    extends AbstractAction {
        private boolean busy_;

        SwapBoundsAction(String actionID) {
            super(PanProperties.MENU_PROPS.getString(actionID));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            String val1Key = PanZoomableAxisControls.this.paramKeys_.get("axis.begin");
            String val2Key = PanZoomableAxisControls.this.paramKeys_.get("axis.end");
            double oldval1 = PanZoomableAxisControls.this.pmeta_.getDouble(val1Key);
            double oldval2 = PanZoomableAxisControls.this.pmeta_.getDouble(val2Key);
            String str1 = PanZoomableAxisControls.this.val1TF_.getText();
            String str2 = PanZoomableAxisControls.this.val2TF_.getText();
            PanZoomableAxisControls.this.val1TF_.setText(str2);
            PanZoomableAxisControls.this.val2TF_.setText(str1);
            if (PanZoomableAxisControls.this.isHorizontal()) {
                PanZoomableAxisControls.this.pmeta_.setGridLeftAndRight(oldval2, oldval1);
            } else {
                PanZoomableAxisControls.this.pmeta_.setGridBottomAndTop(oldval2, oldval1);
            }
            this.busy_ = false;
        }
    }
}

