/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataListener;
import gov.nasa.giss.panoply.data.PanDataLonLatGridded;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanVectorStyle;
import gov.nasa.giss.panoply.util.PanVectorType;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanVectorControls
extends PanAbstractControlsPanel
implements PanDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanPlotType ptype_;
    private PanEnumComboBox styleCombo_;
    private PanIntSpinner spacingSpinner_;
    private PanColorComboBox colorCombo_;
    private PanIntSpinner weightSpinner_;
    private PanTextField lengthTF_;
    private PanCheckBox sampleVisCB_;
    private PanStringComboBox component1Combo_;
    private PanStringComboBox component2Combo_;
    private boolean busyUpdating_;
    private PanVectorType vectorType_ = PanVectorType.XY;
    private boolean refreshing_;

    public PanVectorControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("vector-controls", pmeta, mbar);
        this.ptype_ = this.pmeta_.getType();
        if (!this.ptype_.supportsVectorPlots()) {
            throw new UnsupportedOperationException("Cannot create vector controls for plot type " + this.ptype_);
        }
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        PanLabel styleLabel = PanLabel.small("Vector Style:\u2009");
        PanLabel spacingLabel = PanLabel.small(", Spacing:\u2009");
        PanLabel spPctLabel = PanLabel.small("%,\u2009");
        this.styleCombo_ = PanEnumComboBox.small("vector.style", PanVectorStyle.class);
        this.styleCombo_.setSelectedItem(this.pmeta_.getString("vector.style"));
        this.spacingSpinner_ = PanIntSpinner.small("vector.spacing", this.pmeta_.getInt("vector.spacing"), 25, 250, 1);
        QuickBox vbox1 = QuickBox.createLeftBox(styleLabel, this.styleCombo_, spacingLabel, this.spacingSpinner_, spPctLabel);
        PanLabel colorLabel1 = PanLabel.small("Color:\u2009");
        PanLabel colorLabel2 = PanLabel.small(", Weight:\u2009");
        PanLabel colorLabel3 = PanLabel.small("%");
        this.colorCombo_ = PanColorComboBox.smallRainbow("vector.color");
        this.weightSpinner_ = PanIntSpinner.smallPct("vector.weight", this.pmeta_.getInt("vector.weight"));
        this.colorCombo_.setSelectedColor(this.pmeta_.getColor("vector.color"));
        QuickBox vbox2 = QuickBox.createLeftBox(colorLabel1, this.colorCombo_, colorLabel2, this.weightSpinner_, colorLabel3);
        PanLabel lengthLabel = PanLabel.small("Reference Value:\u2009");
        this.lengthTF_ = PanTextField.small("vector.refvalue", "1000.00", 8);
        this.lengthTF_.setHorizontalAlignment(4);
        this.lengthTF_.setText(PrintfFormat.PFORMAT_10G.sprintfx(this.pmeta_.getDouble("vector.refvalue")));
        QuickBox vbox3 = QuickBox.createLeftBox(lengthLabel, this.lengthTF_);
        PanLabel sampleLabel = PanLabel.small("Scale Sample:\u2009");
        this.sampleVisCB_ = PanCheckBox.small("vector.sample", "Visible", this.pmeta_.getBoolean("vector.sample"));
        QuickBox vbox4 = QuickBox.createLeftBox(sampleLabel, this.sampleVisCB_);
        PanLabel array1Label = PanLabel.small("Array 1 values are positive\u2009");
        PanLabel array2Label = PanLabel.small("Array 2 values are positive\u2009");
        this.component1Combo_ = PanStringComboBox.small("vector.dir1", new String[0]);
        this.component2Combo_ = PanStringComboBox.small("vector.dir2", new String[0]);
        this.updateXYCombos();
        this.component1Combo_.setEnabled(false);
        this.component2Combo_.setEnabled(false);
        QuickBox vboxA1 = QuickBox.createLeftBox(array1Label, this.component1Combo_);
        QuickBox vboxA2 = QuickBox.createLeftBox(array2Label, this.component2Combo_);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 4, 0, 2);
        this.setLayout(fgl);
        this.setBorder(PanGuiUtils.STD_BORDER);
        fgl.setRigidWidth(true);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.add((Component)vbox1, new FGConstraint(0, 0));
        this.add((Component)vbox2, new FGConstraint(0, 1));
        this.add((Component)vbox3, new FGConstraint(0, 2));
        this.add((Component)vbox4, new FGConstraint(0, 3));
        this.add((Component)vboxA1, new FGConstraint(1, 0));
        this.add((Component)vboxA2, new FGConstraint(1, 1));
        GuiUtils.matchLabelWidths(styleLabel, colorLabel1, lengthLabel, sampleLabel);
    }

    private void attachListeners() {
        this.component1Combo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            LOGGER.trace("c1");
            String[] dirs = this.handleCombo1();
            if (dirs == null) {
                LOGGER.trace("null");
            } else if (dirs.length > 1) {
                LOGGER.trace("{}, {}", (Object)dirs[0], (Object)dirs[1]);
                this.pmeta_.setGroup({"vector.dir1", dirs[0]}, {"vector.dir2", dirs[1]});
            } else if (dirs.length == 1) {
                LOGGER.trace("{}", (Object)dirs[0]);
                this.pmeta_.put("vector.dir1", (Object)dirs[0]);
            }
        });
        this.component2Combo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            LOGGER.trace("c2");
            String val = this.component2Combo_.getSelectedItem().toString();
            this.pmeta_.put("vector.dir2", (Object)val);
        });
        this.styleCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("vector.style", (Object)this.styleCombo_.getStringValue());
        });
        this.colorCombo_.addItemListener(e -> {
            Color cold;
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.colorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("vector.color"))) {
                this.pmeta_.setColor("vector.color", cnew);
            }
        });
        this.weightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("vector.weight", this.weightSpinner_.getIntValue());
        });
        this.lengthTF_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanVectorControls.this.handleVectorLength();
            }
        });
        this.lengthTF_.addActionListener(e -> this.handleVectorLength());
        this.spacingSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("vector.spacing", this.spacingSpinner_.getIntValue());
        });
        this.sampleVisCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setBoolean("vector.sample", this.sampleVisCB_.isSelected());
        });
    }

    private void handleVectorLength() {
        if (this.lengthTF_ == null || this.pmeta_ == null) {
            return;
        }
        boolean badEntry = false;
        try {
            double value = StringUtils.parseDouble(this.lengthTF_.getText());
            if (value < 0.0) {
                badEntry = true;
            } else {
                this.pmeta_.setDouble("vector.refvalue", value);
            }
        }
        catch (Exception exc) {
            badEntry = true;
        }
        if (badEntry) {
            this.lengthTF_.setText(PrintfFormat.PFORMAT_10G.sprintfx(this.pmeta_.getDouble("vector.refvalue")));
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        PanCombinationType ctype = PanCombinationType.matching(this.pmeta_.getString("combination"));
        boolean enabled = ctype != null && ctype == PanCombinationType.VECTOR;
        this.styleCombo_.setEnabled(enabled);
        this.spacingSpinner_.setEnabled(enabled);
        this.colorCombo_.setEnabled(enabled);
        this.weightSpinner_.setEnabled(enabled);
        this.lengthTF_.setEnabled(enabled);
        this.sampleVisCB_.setEnabled(enabled);
        this.component1Combo_.setEnabled(enabled);
        this.component2Combo_.setEnabled(enabled);
        if (enabled) {
            this.updateCombos();
        }
        this.refreshing_ = false;
    }

    @Override
    public void dataChanged(PanDataEvent e) {
        if (e == null) {
            return;
        }
        this.updateCombos();
    }

    private String[] handleCombo1() {
        LOGGER.trace("busy? {}", (Object)this.busyUpdating_);
        if (this.busyUpdating_) {
            return null;
        }
        String val1 = this.component1Combo_.getSelectedItem().toString();
        String val2 = this.component2Combo_.getSelectedItem().toString();
        String[] newvals2 = null;
        switch (this.ptype_) {
            case LON_LAT: {
                LOGGER.trace("LON_LAT");
                if (this.vectorType_ == PanVectorType.XY) {
                    if ((val1.equals("East") || val1.equals("West")) && (val2.equals("East") || val2.equals("West"))) {
                        newvals2 = new String[]{"North", "South"};
                        break;
                    }
                    if (!val1.equals("North") && !val1.equals("South") || !val2.equals("North") && !val2.equals("South")) break;
                    newvals2 = new String[]{"East", "West"};
                    break;
                }
                LOGGER.trace("PanVectorType not XY. No need to refresh second combo.");
                break;
            }
            case LAT_VERT: {
                if ((val1.equals("Up") || val1.equals("Down")) && (val2.equals("Up") || val2.equals("Down"))) {
                    newvals2 = new String[]{"North", "South"};
                    break;
                }
                if (!val1.equals("North") && !val1.equals("South") || !val2.equals("North") && !val2.equals("South")) break;
                newvals2 = new String[]{"Up", "Down"};
                break;
            }
            case LON_VERT: {
                if ((val1.equals("Up") || val1.equals("Down")) && (val2.equals("Up") || val2.equals("Down"))) {
                    newvals2 = new String[]{"West", "East"};
                    break;
                }
                if (!val1.equals("West") && !val1.equals("East") || !val2.equals("West") && !val2.equals("East")) break;
                newvals2 = new String[]{"Up", "Down"};
                break;
            }
            case COLOR_CONTOUR: {
                if ((val1.equals("Up") || val1.equals("Down")) && (val2.equals("Up") || val2.equals("Down"))) {
                    newvals2 = new String[]{"Left", "Right"};
                    break;
                }
                if (!val1.equals("Left") && !val1.equals("Right") || !val2.equals("Left") && !val2.equals("Right")) break;
                newvals2 = new String[]{"Up", "Down"};
                break;
            }
            default: {
                LOGGER.debug("Switch default case: How did we get here? {}", (Object)this.ptype_);
            }
        }
        if (newvals2 != null) {
            this.component2Combo_.removeAllItems();
            for (String ss : newvals2) {
                this.component2Combo_.addItem(ss);
            }
            this.component2Combo_.setSelectedItem(newvals2[0]);
            this.pmeta_.put("vector.dir2", (Object)newvals2[0]);
            GuiUtils.restrictSize(this.component2Combo_);
            LOGGER.trace("Setting dir1 {}, dir2 {}", (Object)val1, (Object)newvals2[0]);
            return new String[]{val1, newvals2[0]};
        }
        LOGGER.trace("Setting vector component direction 1, but not 2");
        return new String[]{val1};
    }

    private void updateCombos() {
        PanCombinationType ctype = PanCombinationType.matching(this.pmeta_.getString("combination"));
        LOGGER.trace("{}", (Object)ctype);
        boolean isVector = ctype == PanCombinationType.VECTOR;
        this.component1Combo_.setEnabled(isVector);
        this.component2Combo_.setEnabled(isVector);
        if (!isVector) {
            return;
        }
        if (this.data_ instanceof PanDataLonLatGridded) {
            PanDataLonLatGridded lldata = (PanDataLonLatGridded)this.data_;
            PanVectorType vtype = lldata.getVectorType();
            if (vtype == this.vectorType_) {
                LOGGER.trace("vtype did not change");
                return;
            }
            LOGGER.trace("vtype changed from {} to {}", (Object)this.vectorType_, (Object)vtype);
            this.vectorType_ = vtype;
            this.busyUpdating_ = true;
            if (vtype == PanVectorType.XY) {
                this.updateXYCombos();
            } else {
                this.updateMagAngleCombos();
            }
            this.busyUpdating_ = false;
        }
    }

    private void updateXYCombos() {
        this.component1Combo_.removeAllItems();
        this.component2Combo_.removeAllItems();
        if (this.ptype_ == PanPlotType.LON_LAT) {
            this.component1Combo_.addItem("East");
            this.component1Combo_.addItem("North");
            this.component1Combo_.addItem("West");
            this.component1Combo_.addItem("South");
            this.component2Combo_.addItem("North");
            this.component2Combo_.addItem("South");
        } else if (this.ptype_ == PanPlotType.LAT_VERT) {
            this.component1Combo_.addItem("North");
            this.component1Combo_.addItem("Up");
            this.component1Combo_.addItem("South");
            this.component1Combo_.addItem("Down");
            this.component2Combo_.addItem("Up");
            this.component2Combo_.addItem("Down");
        } else if (this.ptype_ == PanPlotType.LON_VERT) {
            this.component1Combo_.addItem("West");
            this.component1Combo_.addItem("Up");
            this.component1Combo_.addItem("East");
            this.component1Combo_.addItem("Down");
            this.component2Combo_.addItem("Up");
            this.component2Combo_.addItem("Down");
        } else if (this.ptype_ == PanPlotType.COLOR_CONTOUR) {
            this.component1Combo_.addItem("Right");
            this.component1Combo_.addItem("Up");
            this.component1Combo_.addItem("Left");
            this.component1Combo_.addItem("Down");
            this.component2Combo_.addItem("Up");
            this.component2Combo_.addItem("Down");
        }
        this.component1Combo_.setSelectedItem(this.pmeta_.getString("vector.dir1"));
        this.component2Combo_.setSelectedItem(this.pmeta_.getString("vector.dir2"));
    }

    private void updateMagAngleCombos() {
        this.component1Combo_.removeAllItems();
        this.component2Combo_.removeAllItems();
        if (this.vectorType_ == PanVectorType.ANGLE_MAG) {
            this.component1Combo_.addItem("Downstream");
            this.component1Combo_.addItem("Upstream");
            this.component2Combo_.addItem("Magnitude");
        } else if (this.vectorType_ == PanVectorType.MAG_ANGLE) {
            this.component1Combo_.addItem("Magnitude");
            this.component2Combo_.addItem("Downstream");
            this.component2Combo_.addItem("Upstream");
        }
        this.component1Combo_.setSelectedItem(this.pmeta_.getString("vector.dir1"));
        this.component2Combo_.setSelectedItem(this.pmeta_.getString("vector.dir2"));
    }
}

