/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCaptionListener;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanRadioButton;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.ButtonGroup;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanStrokeControls1D
extends PanAbstractControlsPanel {
    private PanColorComboBox[] sColorCombo_ = new PanColorComboBox[2];
    private PanEnumComboBox[] sStyleCombo_ = new PanEnumComboBox[2];
    private PanIntSpinner[] sWeightSpinner_ = new PanIntSpinner[2];
    private PanRadioButton[] dfltCapBtn_ = new PanRadioButton[2];
    private PanRadioButton[] userCapBtn_ = new PanRadioButton[2];
    private PanTextField[] captionTF_ = new PanTextField[2];
    private boolean refreshing_;

    public PanStrokeControls1D(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("stroke-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        PanLabel[] sLabel = new PanLabel[2];
        QuickBox[] styleBox = new QuickBox[2];
        QuickBox[] colorBox = new QuickBox[2];
        QuickBox[] captionBox = new QuickBox[2];
        for (int i = 0; i < 2; ++i) {
            sLabel[i] = PanLabel.small("Stroke " + (i + 1) + ":\u2009");
            PanLabel styleLabel = PanLabel.small("Style:\u2009");
            this.sStyleCombo_[i] = PanEnumComboBox.small(PanParamKeys.STROKE_STYLE[i], PanStrokePattern.class);
            this.sStyleCombo_[i].removeItem(PanStrokePattern.NONE);
            PanLabel colorLabel = PanLabel.small("Color:\u2009");
            this.sColorCombo_[i] = PanColorComboBox.smallRainbow(PanParamKeys.STROKE_COLOR[i]);
            PanLabel weightLabel = PanLabel.small(", Weight:\u2009");
            this.sWeightSpinner_[i] = PanIntSpinner.smallWeightX5(PanParamKeys.STROKE_WGT[i], this.pmeta_.getInt(PanParamKeys.STROKE_WGT[i]), 500);
            PanLabel pctLabel = PanLabel.small("%");
            styleBox[i] = QuickBox.createLeftBox(styleLabel, this.sStyleCombo_[i]);
            colorBox[i] = QuickBox.createLeftBox(colorLabel, this.sColorCombo_[i], weightLabel, this.sWeightSpinner_[i], pctLabel);
            PanLabel capLabel = PanLabel.small("Caption:\u2009");
            this.dfltCapBtn_[i] = PanRadioButton.small(PanParamKeys.STROKE_LABEL_CUSTOM[i], "Default", !this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[i]));
            this.userCapBtn_[i] = PanRadioButton.small(PanParamKeys.STROKE_LABEL_CUSTOM[i], "Custom:", this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[i]));
            ButtonGroup capChoices = new ButtonGroup();
            capChoices.add(this.dfltCapBtn_[i]);
            capChoices.add(this.userCapBtn_[i]);
            this.captionTF_[i] = PanTextField.small(PanParamKeys.STROKE_LABEL_TEXT[i], this.pmeta_.getString(PanParamKeys.STROKE_LABEL_TEXT[i]), 20);
            captionBox[i] = QuickBox.createLeftBox(capLabel, this.dfltCapBtn_[i], this.userCapBtn_[i], this.captionTF_[i]);
            int tfh = this.captionTF_[i].getPreferredSize().height;
            this.captionTF_[i].setMinimumSize(new Dimension(150, tfh));
            this.captionTF_[i].setPreferredSize(new Dimension(225, tfh));
            this.captionTF_[i].setMaximumSize(new Dimension(1000, tfh));
        }
        FlexingGridLayout fgl = new FlexingGridLayout(4, 3, 0, 2);
        fgl.setColumnWeight(1, 9999.0f);
        fgl.setColumnWeight(3, 9999.0f);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiUtils.STD_BORDER);
        this.add((Component)sLabel[0], new FGConstraint(0, 0));
        this.add((Component)styleBox[0], new FGConstraint(1, 0));
        this.add((Component)colorBox[0], new FGConstraint(1, 1));
        this.add((Component)captionBox[0], new FGConstraint(1, 2));
        this.add((Component)sLabel[1], new FGConstraint(2, 0));
        this.add((Component)styleBox[1], new FGConstraint(3, 0));
        this.add((Component)colorBox[1], new FGConstraint(3, 1));
        this.add((Component)captionBox[1], new FGConstraint(3, 2));
    }

    private void attachListeners() {
        int ii = 0;
        while (ii < 2) {
            final int i = ii++;
            this.sColorCombo_[i].addItemListener(e -> {
                Color cold;
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                int index = this.sColorCombo_[i].getSelectedIndex();
                if (index < 0 || index >= this.sColorCombo_[i].getItemCount()) {
                    return;
                }
                Color cnew = this.sColorCombo_[i].getSelectedColor();
                if (!cnew.equals(cold = this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[i]))) {
                    this.pmeta_.setColor(PanParamKeys.STROKE_COLOR[i], cnew);
                }
            });
            this.sStyleCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.set(PanParamKeys.STROKE_STYLE[i], this.sStyleCombo_[i].getStringValue());
            });
            this.sWeightSpinner_[i].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setInt(PanParamKeys.STROKE_WGT[i], this.sWeightSpinner_[i].getIntValue());
            });
            this.dfltCapBtn_[i].addActionListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[i], this.userCapBtn_[i].isSelected());
            });
            this.userCapBtn_[i].addActionListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[i], this.userCapBtn_[i].isSelected());
            });
            this.captionTF_[i].addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (PanStrokeControls1D.this.refreshing_) {
                        return;
                    }
                    if (PanStrokeControls1D.this.captionTF_[i] == null || PanStrokeControls1D.this.pmeta_ == null) {
                        return;
                    }
                    PanStrokeControls1D.this.pmeta_.setString(PanParamKeys.STROKE_LABEL_TEXT[i], PanStrokeControls1D.this.captionTF_[i].getText());
                }
            });
            this.captionTF_[i].addActionListener(e -> this.pmeta_.setString(PanParamKeys.STROKE_LABEL_TEXT[i], this.captionTF_[i].getText()));
            this.captionTF_[i].getDocument().addDocumentListener(new PanCaptionListener(this.captionTF_[i], this.pmeta_, PanParamKeys.STROKE_LABEL_TEXT[i]));
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        PanCombinationType ctype = PanCombinationType.matching(this.pmeta_.getString("combination"));
        boolean[] enable = new boolean[]{true, false};
        if (ctype == PanCombinationType.COMPARE) {
            enable[1] = true;
        } else if (ctype == PanCombinationType.A2_ONLY) {
            enable[0] = false;
            enable[1] = true;
        }
        for (int i = 0; i < 2; ++i) {
            this.sColorCombo_[i].setEnabled(enable[i]);
            this.sStyleCombo_[i].setEnabled(enable[i]);
            this.sWeightSpinner_[i].setEnabled(enable[i]);
            this.dfltCapBtn_[i].setEnabled(enable[i]);
            this.userCapBtn_[i].setEnabled(enable[i]);
            this.captionTF_[i].setEnabled(enable[i]);
            this.sStyleCombo_[i].setSelectedItem(this.pmeta_.getString(PanParamKeys.STROKE_STYLE[i]));
            this.sColorCombo_[i].setSelectedColor(this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[i]));
            this.sWeightSpinner_[i].setValue(this.pmeta_.getInt(PanParamKeys.STROKE_WGT[i]));
            this.dfltCapBtn_[i].setSelected(!this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[i]));
            this.userCapBtn_[i].setSelected(this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[i]));
            this.captionTF_[i].setText(this.pmeta_.getString(PanParamKeys.STROKE_LABEL_TEXT[i]));
        }
        this.refreshing_ = false;
    }
}

