/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableOutlierShape;
import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.panoply.action.PanFitScaleToClutAction;
import gov.nasa.giss.panoply.action.PanReverseColorbarAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanScaleControls;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanColorTableComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanColorbarLabelLocation;
import gov.nasa.giss.panoply.util.PanColorbarOutlierGap;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.PaletteType;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanScaleControls2D
extends PanScaleControls
implements PlotPropertyListener,
ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanColorTableComboBox clutCombo_;
    private PanCheckBox reversedCB_;
    private PanIntSpinner cbarLengthSpinner_;
    private PanColorComboBox invColorCombo_;
    private PanEnumComboBox outlierShapeCombo_;
    private PanEnumComboBox outlierSideCombo_;
    private PanEnumComboBox outlierGapCombo_;
    private PanEnumComboBox cbarLabelPlaceCombo_;
    private PanIntSpinner borderWgtSpinner_;
    private boolean refreshing_;

    public PanScaleControls2D(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        this.createActions(mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
        this.data_.addDataListener(this);
        this.pmeta_.addPlotPropertyListener(this);
        PanUtils.getColorTableResourceList().addListDataListener(this);
    }

    private void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        AbstractAction a = new PanReverseColorbarAction(this.pmeta_);
        this.pmeta_.putAction("reverse-scale", a);
        plotMenu.getItemByName("reverse-scale").setAction(a);
        plotMenu.getItemByName("reverse-scale").setSelected(this.pmeta_.getBoolean("colorbar.reverse"));
        a = new PanFitScaleToClutAction(this.pmeta_, this);
        plotMenu.getItemByName("fit-scale-to-clut").setAction(a);
        this.pmeta_.putAction("fit-scale-to-clut", a);
    }

    private void createLayout() {
        PanLabel rangeLabel = PanLabel.small("Scale Range: ");
        PanLabel minLabel = PanLabel.small("Min.:\u2009");
        PanLabel maxLabel = PanLabel.small(", Max.:\u2009");
        QuickBox rangeBox = QuickBox.createLeftBox(rangeLabel, minLabel, this.val1TF_, maxLabel, this.val2TF_, this.fitToDataBtn_);
        PanLabel unitsLabel1 = PanLabel.small("Units:\u2009");
        PanLabel unitsLabel2 = PanLabel.small("of\u2009");
        PanLabel scalingLabel = PanLabel.small("\u00d7 Scaling:\u2009");
        PanLabel tenLabel = PanLabel.small("10^");
        QuickBox unitsBox = QuickBox.createLeftBox(unitsLabel1, this.methodCombo_, unitsLabel2, this.unitsCombo_, scalingLabel, tenLabel, this.scalingSpinner_);
        PanLabel formatLabel = PanLabel.small("Tick Format:\u2009");
        PanLabel divLabel1 = PanLabel.small("\u2014 Divisions, Major:\u2009");
        PanLabel divLabel2 = PanLabel.small(", Minor:\u2009");
        PanLabel tickSizeLabel = PanLabel.small("\u2014 Size:\u2009");
        QuickBox formatBox = QuickBox.createLeftBox(formatLabel, this.tickFormatCombo_, divLabel1, this.majorDivSpinner_, divLabel2, this.minorDivSpinner_, tickSizeLabel, this.tickSizeCombo_);
        PanLabel captionLabel = PanLabel.small("Scale Caption:\u2009");
        QuickBox captionBox = QuickBox.createLeftBox(captionLabel, this.dfltCaptionBtn_, this.customCaptionBtn_, this.captionTF_);
        PanLabel captionPadLabel = PanLabel.small(" ");
        PanLabel captionPlaceLabel = PanLabel.small("Location:\u2009");
        this.cbarLabelPlaceCombo_ = PanEnumComboBox.small("scale.label.location", PanColorbarLabelLocation.class);
        this.cbarLabelPlaceCombo_.setSelectedItem(this.pmeta_.getString("scale.label.location"));
        QuickBox captionPlaceBox = QuickBox.createLeftBox(captionPadLabel, captionPlaceLabel, this.cbarLabelPlaceCombo_);
        PanLabel cbarLabel = PanLabel.small("Colorbar: ");
        PanLabel ctableLabel = PanLabel.small("Color Table:\u2009");
        this.clutCombo_ = PanColorTableComboBox.small("colorbar.name", true);
        PanLabel reversedLabel = PanLabel.small(" \u2014 ");
        this.reversedCB_ = PanCheckBox.small("colorbar.reverse", this.pmeta_.getAction("reverse-scale"));
        this.reversedCB_.setText("Reverse colors");
        QuickBox ctableBox = QuickBox.createLeftBox(cbarLabel, ctableLabel, this.clutCombo_, reversedLabel, this.reversedCB_);
        PanLabel invalidsPadLabel = PanLabel.small(" ");
        PanLabel invalidsLabel = PanLabel.small("Fill Color:\u2009");
        this.invColorCombo_ = PanColorComboBox.small("colorbar.invalids", PaletteType.GRAYSCALE);
        QuickBox invalidsBox = QuickBox.createLeftBox(invalidsPadLabel, invalidsLabel, this.invColorCombo_);
        PanLabel cbarLocPadLabel = PanLabel.small(" ");
        PanLabel widthLabel = PanLabel.small("Length:\u2009");
        this.cbarLengthSpinner_ = PanIntSpinner.small("colorbar.length", this.pmeta_.getInt("colorbar.length"), 25, 100, 5);
        PanLabel widthPctLabel = PanLabel.small("%");
        QuickBox widthBox = QuickBox.createLeftBox(cbarLocPadLabel, widthLabel, this.cbarLengthSpinner_, widthPctLabel);
        this.outlierSideCombo_ = PanEnumComboBox.small("colorbar.outlier.side", PanColorbarOutlierSide.class);
        this.outlierShapeCombo_ = PanEnumComboBox.small("colorbar.outlier.shape", ColorTableOutlierShape.class);
        this.outlierGapCombo_ = PanEnumComboBox.small("colorbar.outlier.gap", PanColorbarOutlierGap.class);
        this.outlierSideCombo_.setSelectedItem(this.pmeta_.getString("colorbar.outlier.side"));
        this.outlierShapeCombo_.setSelectedItem(this.pmeta_.getString("colorbar.outlier.shape"));
        this.outlierGapCombo_.setSelectedItem(this.pmeta_.getString("colorbar.outlier.gap"));
        PanLabel outlierPadLabel = PanLabel.small(" ");
        PanLabel outlierLabel1 = PanLabel.small("Outliers on:\u2009");
        PanLabel outlierLabel2 = PanLabel.small(", Shape:\u2009");
        PanLabel outlierLabel3 = PanLabel.small(", Gap:\u2009");
        QuickBox outlierBox = QuickBox.createLeftBox(outlierPadLabel, outlierLabel1, this.outlierSideCombo_, outlierLabel2, this.outlierShapeCombo_, outlierLabel3, this.outlierGapCombo_);
        PanLabel borderPadLabel = PanLabel.small(" ");
        PanLabel borderWgtLabel = PanLabel.small("Border Weight:\u2009");
        this.borderWgtSpinner_ = PanIntSpinner.small("colorbar.border.weight", this.pmeta_.getInt("colorbar.border.weight"), 0, 150, 1);
        QuickBox borderWgtBox = QuickBox.createLeftBox(borderPadLabel, borderWgtLabel, this.borderWgtSpinner_);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiUtils.STD_BORDER);
        this.add((Component)rangeBox, new FGConstraint(0, 0));
        this.add((Component)unitsBox, new FGConstraint(0, 1));
        this.add((Component)formatBox, new FGConstraint(0, 2));
        this.add((Component)captionBox, new FGConstraint(0, 3));
        this.add((Component)captionPlaceBox, new FGConstraint(0, 4));
        this.add((Component)ctableBox, new FGConstraint(1, 0));
        this.add((Component)invalidsBox, new FGConstraint(1, 1));
        this.add((Component)widthBox, new FGConstraint(1, 2));
        this.add((Component)outlierBox, new FGConstraint(1, 3));
        this.add((Component)borderWgtBox, new FGConstraint(1, 4));
        GuiUtils.matchLabelWidths(rangeLabel, unitsLabel1, formatLabel, captionLabel, captionPadLabel);
        GuiUtils.matchLabelWidths(cbarLabel, invalidsPadLabel, cbarLocPadLabel, outlierPadLabel, borderPadLabel);
        this.val1TF_.setMaximumSize(this.val1TF_.getPreferredSize());
        this.val2TF_.setMaximumSize(this.val2TF_.getPreferredSize());
        int tfh = this.captionTF_.getPreferredSize().height;
        this.captionTF_.setMinimumSize(new Dimension(150, tfh));
        this.captionTF_.setPreferredSize(new Dimension(225, tfh));
        this.captionTF_.setMaximumSize(new Dimension(1000, tfh));
    }

    private void attachListeners() {
        this.clutCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            Object item = this.clutCombo_.getSelectedItem();
            this.pmeta_.setString("colorbar.name", item.toString());
            this.refreshActions();
        });
        this.cbarLengthSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("colorbar.length", this.cbarLengthSpinner_.getIntValue());
        });
        this.invColorCombo_.addItemListener(e -> {
            Color cold;
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.invColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("colorbar.invalids"))) {
                this.pmeta_.setColor("colorbar.invalids", cnew);
            }
        });
        this.outlierShapeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("colorbar.outlier.shape", this.outlierShapeCombo_.getStringValue());
        });
        this.outlierSideCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("colorbar.outlier.side", this.outlierSideCombo_.getStringValue());
        });
        this.outlierGapCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("colorbar.outlier.gap", this.outlierGapCombo_.getStringValue());
        });
        this.cbarLabelPlaceCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("scale.label.location", this.cbarLabelPlaceCombo_.getStringValue());
            this.refresh();
        });
        this.borderWgtSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("colorbar.border.weight", this.borderWgtSpinner_.getIntValue());
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        LOGGER.trace("Will refresh {}", (Object)(!this.refreshing_ ? 1 : 0));
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.clutCombo_.setSelectedItemByName(this.pmeta_.getString("colorbar.name"));
        this.reversedCB_.setSelected(this.pmeta_.getBoolean("colorbar.reverse"));
        this.invColorCombo_.setSelectedColor(this.pmeta_.getColor("colorbar.invalids"));
        this.cbarLengthSpinner_.setValue(this.pmeta_.getInt("colorbar.length"));
        this.borderWgtSpinner_.setValue(this.pmeta_.getInt("colorbar.border.weight"));
        this.outlierSideCombo_.setSelectedItem(this.pmeta_.getString("colorbar.outlier.side"));
        this.outlierShapeCombo_.setSelectedItem(this.pmeta_.getString("colorbar.outlier.shape"));
        this.outlierGapCombo_.setSelectedItem(this.pmeta_.getString("colorbar.outlier.gap"));
        boolean capVis = !this.cbarLabelPlaceCombo_.getSelectedItem().equals(PanColorbarLabelLocation.NONE);
        this.customCaptionBtn_.setEnabled(capVis);
        this.captionTF_.setEnabled(capVis);
        this.refreshActions();
        this.refreshing_ = false;
    }

    private void refreshActions() {
        this.pmeta_.getAction("reverse-scale").setEnabled(true);
        AbstractColorTable clut = (AbstractColorTable)this.clutCombo_.getSelectedItem();
        boolean clutHasRange = clut.hasRangeLimits();
        boolean autoScaleOn = this.pmeta_.getBoolean("scale.autofit");
        this.pmeta_.getAction("fit-scale-to-clut").setEnabled(clutHasRange && !autoScaleOn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanScaleControls2D panScaleControls2D = this;
        synchronized (panScaleControls2D) {
            if (this.clutCombo_ != null) {
                this.clutCombo_.flush();
                this.clutCombo_ = null;
            }
            this.invColorCombo_ = null;
            super.flush();
        }
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        if (e == null) {
            return;
        }
        Component cc = e.getComponent();
        if (cc == null) {
            return;
        }
        JFrame jf = null;
        if (cc instanceof JFrame) {
            jf = (JFrame)cc;
        } else if (cc instanceof JComponent) {
            jf = GuiUtils.getParentFrame((JComponent)cc);
        } else {
            return;
        }
        JFrame pframe = GuiUtils.getParentFrame(this);
        if (jf == pframe) {
            AbstractColorTable clut = (AbstractColorTable)PanUtils.getColorTableResourceList().getBackingObject(e.getIndex0());
            EventQueue.invokeLater(() -> this.clutCombo_.setSelectedItem(clut));
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        boolean changeAll = false;
        if (pname.contains("colorbar.reverse")) {
            boolean oldval = this.reversedCB_.isSelected();
            boolean newval = this.pmeta_.getBoolean("colorbar.reverse");
            if (newval ^ oldval) {
                this.reversedCB_.setSelected(newval);
            }
        }
    }
}

