/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.panoply.action.PanFitScaleToDataAction;
import gov.nasa.giss.panoply.action.PanLogScaleAction;
import gov.nasa.giss.panoply.action.PanToggleAutoscaleAction;
import gov.nasa.giss.panoply.action.PanZeroCenterScaleAction;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataListener;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanCaptionListener;
import gov.nasa.giss.panoply.ui.PanEditableComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanRadioButton;
import gov.nasa.giss.panoply.ui.PanScaleMethodComboBox;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.panoply.util.PanDevoMode;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.ButtonGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanScaleControls
extends PanAbstractControlsPanel
implements PanDataListener,
PlotPropertyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PanTextField val1TF_;
    protected PanTextField val2TF_;
    protected PanScaleMethodComboBox methodCombo_;
    protected PanButton fitToDataBtn_;
    protected PanIntSpinner scalingSpinner_;
    protected PanEditableComboBox unitsCombo_;
    protected PanIntSpinner majorDivSpinner_;
    protected PanIntSpinner minorDivSpinner_;
    protected PanStringComboBox tickFormatCombo_;
    protected PanFloatComboBox tickSizeCombo_;
    protected PanRadioButton dfltCaptionBtn_;
    protected PanRadioButton customCaptionBtn_;
    protected PanTextField captionTF_;
    protected PanFloatComboBox captionSizeCombo_;
    private boolean refreshing_;

    public PanScaleControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("scale-controls", pmeta, mbar);
        this.createCommonActions(mbar);
        this.createCommonComponents();
        this.attachCommonListeners();
    }

    private void createCommonActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        PanToggleAutoscaleAction autoScaleAction = new PanToggleAutoscaleAction(this.pmeta_, this);
        PanFitScaleToDataAction fitScaleToDataAction = new PanFitScaleToDataAction(this.pmeta_, this);
        PanZeroCenterScaleAction zeroScaleAction = new PanZeroCenterScaleAction(this.pmeta_, this);
        PanLogScaleAction logScaleAction = new PanLogScaleAction(this.pmeta_, this);
        plotMenu.getItemByName("autofit-scale").setAction(autoScaleAction);
        plotMenu.getItemByName("fit-scale-to-data").setAction(fitScaleToDataAction);
        plotMenu.getItemByName("center-on-zero").setAction(zeroScaleAction);
        plotMenu.getItemByName("log-scale").setAction(logScaleAction);
        PanScaleMethod smethod = PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
        boolean islog10 = smethod == PanScaleMethod.LOG10;
        plotMenu.getItemByName("autofit-scale").setSelected(this.pmeta_.getBoolean("scale.autofit"));
        plotMenu.getItemByName("log-scale").setSelected(islog10);
        this.pmeta_.putAction("autofit-scale", autoScaleAction);
        this.pmeta_.putAction("fit-scale-to-data", fitScaleToDataAction);
        this.pmeta_.putAction("center-on-zero", zeroScaleAction);
        this.pmeta_.putAction("log-scale", logScaleAction);
        plotMenu.getItemByName("autofit-scale").setEnabled(true);
        plotMenu.getItemByName("fit-scale-to-data").setEnabled(true);
        plotMenu.getItemByName("log-scale").setEnabled(true);
        plotMenu.getItemByName("center-on-zero").setEnabled(true);
    }

    private void createCommonComponents() {
        double min = this.pmeta_.getDouble("scale.min");
        double max = this.pmeta_.getDouble("scale.max");
        if (Double.isNaN(min)) {
            min = -0.1;
            max = 0.1;
        }
        this.val1TF_ = PanTextField.small("scale.min", this.tinyNumberFormat(min), 9);
        this.val2TF_ = PanTextField.small("scale.max", this.tinyNumberFormat(max), 9);
        this.val1TF_.setHorizontalAlignment(4);
        this.val2TF_.setHorizontalAlignment(4);
        this.fitToDataBtn_ = PanButton.small(this.pmeta_.getAction("fit-scale-to-data"), "Fit to Data");
        this.methodCombo_ = PanScaleMethodComboBox.small("scale.method");
        PanScaleMethod smethod = PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
        this.methodCombo_.setSelectedItem(smethod);
        this.dfltCaptionBtn_ = PanRadioButton.small("scale.label.custom", "Default", !this.pmeta_.getBoolean("scale.label.custom"));
        this.customCaptionBtn_ = PanRadioButton.small("scale.label.custom", "Custom:", this.pmeta_.getBoolean("scale.label.custom"));
        this.captionTF_ = PanTextField.small("scale.label.text", this.pmeta_.getString("scale.label.text"), 20);
        this.captionSizeCombo_ = PanDevoMode.isVersion5() ? PanFloatComboBox.small("scale.label.size", 5.0f, 28.0f) : PanFloatComboBox.small("scale.label.size", 5.0f, 20.0f);
        this.captionSizeCombo_.setValue(this.pmeta_.getFloat("scale.label.size"));
        ButtonGroup scaleChoices = new ButtonGroup();
        scaleChoices.add(this.dfltCaptionBtn_);
        scaleChoices.add(this.customCaptionBtn_);
        this.unitsCombo_ = new PanEditableComboBox(PanGuiSize.SMALL, "scale.units", this.data_.getUnitsChoices());
        this.unitsCombo_.setPreferredSize(null);
        Dimension ucsize = this.unitsCombo_.getPreferredSize();
        ucsize.width = Math.max(172, ucsize.width);
        this.unitsCombo_.setPreferredSize(ucsize);
        this.unitsCombo_.setSelectedIndex(0);
        this.scalingSpinner_ = PanIntSpinner.small("scale.exponent", this.pmeta_.getInt("scale.exponent"), -50, 50, 1);
        this.majorDivSpinner_ = PanIntSpinner.smallDivs("scale.div.major", this.pmeta_.getInt("scale.div.major"));
        this.minorDivSpinner_ = PanIntSpinner.smallDivs("scale.div.minor", this.pmeta_.getInt("scale.div.minor"));
        this.majorDivSpinner_.setName("scale.div.major");
        this.minorDivSpinner_.setName("scale.div.minor");
        this.tickFormatCombo_ = PanStringComboBox.smallNumberFormatCombo("scale.tick.format");
        this.tickFormatCombo_.setSelectedItem(this.pmeta_.getString("scale.tick.format"));
        this.tickFormatCombo_.setMaximumRowCount(32);
        this.tickSizeCombo_ = PanDevoMode.isVersion5() ? PanFloatComboBox.small("scale.tick.size", 5.0f, 20.0f) : PanFloatComboBox.small("scale.tick.size", 5.0f, 14.0f);
        this.tickSizeCombo_.setValue(this.pmeta_.getFloat("scale.tick.size"));
    }

    private void attachCommonListeners() {
        this.methodCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("scale.method", (Object)this.methodCombo_.getStringValue());
            this.scheduleRefreshTask();
        });
        FocusAdapter rangeFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanScaleControls.this.validateRange();
            }
        };
        this.val1TF_.addFocusListener(rangeFL);
        this.val2TF_.addFocusListener(rangeFL);
        this.val1TF_.addActionListener(e -> this.validateRange());
        this.val2TF_.addActionListener(e -> this.validateRange());
        this.unitsCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            String unitsStr = this.unitsCombo_.getSelectedItem().toString();
            this.pmeta_.setScaleUnits(unitsStr, null);
        });
        this.scalingSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("scale.exponent", this.scalingSpinner_.getIntValue());
        });
        this.majorDivSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("scale.div.major", this.majorDivSpinner_.getIntValue());
        });
        this.minorDivSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("scale.div.minor", this.minorDivSpinner_.getIntValue());
        });
        this.tickFormatCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            String format = this.tickFormatCombo_.getSelectedString();
            this.pmeta_.setString("scale.tick.format", format);
            this.data_.setScaleFormat(format);
        });
        this.tickSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.tickSizeCombo_.getValue();
            this.pmeta_.setFloat("scale.tick.size", value);
        });
        this.dfltCaptionBtn_.addActionListener(e -> this.pmeta_.setBoolean("scale.label.custom", !this.dfltCaptionBtn_.isSelected()));
        this.customCaptionBtn_.addActionListener(e -> this.pmeta_.setBoolean("scale.label.custom", this.customCaptionBtn_.isSelected()));
        this.captionTF_.getDocument().addDocumentListener(new PanCaptionListener(this.captionTF_, this.pmeta_, "scale.label.text"));
        if (this.captionSizeCombo_ != null) {
            this.captionSizeCombo_.addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                float value = this.captionSizeCombo_.getValue();
                this.pmeta_.setFloat("scale.label.size", value);
            });
        }
    }

    public void setScaleRange(double val1, double val2) {
        if (!Double.isNaN(val1) && !Double.isNaN(val1)) {
            this.val1TF_.setText(this.tinyNumberFormat(val1));
            this.val2TF_.setText(this.tinyNumberFormat(val2));
        }
        this.validateRange();
    }

    public void setScaleLogarithmic(boolean islog10) {
        if (islog10) {
            this.methodCombo_.setSelectedItem(PanScaleMethod.LOG10);
        } else {
            this.methodCombo_.setSelectedItem(PanScaleMethod.SCALAR);
        }
        this.scheduleRefreshTask();
    }

    private void validateRange() {
        if (this.val1TF_ == null || this.val2TF_ == null || this.pmeta_ == null) {
            return;
        }
        if (this.pmeta_.getBoolean("scale.autofit")) {
            return;
        }
        double oldval1 = this.pmeta_.getDouble("scale.min");
        double oldval2 = this.pmeta_.getDouble("scale.max");
        double val1 = oldval1;
        double val2 = oldval2;
        try {
            val1 = StringUtils.parseDouble(this.val1TF_.getText());
        }
        catch (Exception exc) {
            val1 = this.pmeta_.getDouble("scale.min");
            if (Double.isNaN(val1)) {
                val1 = -0.1;
            }
            this.val1TF_.setText(this.tinyNumberFormat(val1));
        }
        try {
            val2 = StringUtils.parseDouble(this.val2TF_.getText());
        }
        catch (Exception exc) {
            val2 = this.pmeta_.getDouble("scale.max");
            if (Double.isNaN(val2)) {
                val2 = -0.1;
            }
            this.val2TF_.setText(this.tinyNumberFormat(val2));
        }
        PanScaleMethod smethod = PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
        switch (smethod) {
            case LOG10: 
            case LOG_E: {
                if (val1 <= 0.0) {
                    val1 = 1.0E-50;
                    this.val1TF_.setText(this.tinyNumberFormat(val1));
                }
                if (!(val2 <= 1.0E-50)) break;
                val2 = 1.0E-25;
                this.val2TF_.setText(this.tinyNumberFormat(val2));
                break;
            }
        }
        if (val1 == oldval1 && val2 == oldval2) {
            LOGGER.trace("no change");
            return;
        }
        this.pmeta_.setGroup({"scale.min", val1}, {"scale.max", val2});
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        PanScaleMethod smethod = this.methodCombo_.getSelectedMethod();
        if (smethod == PanScaleMethod.LOG10) {
            this.validateRange();
        }
        boolean autoScaleOn = this.pmeta_.getBoolean("scale.autofit");
        boolean logScaleOn = smethod == PanScaleMethod.LOG10 || smethod == PanScaleMethod.LOG_E;
        this.val1TF_.setEnabled(!autoScaleOn);
        this.val2TF_.setEnabled(!autoScaleOn);
        this.majorDivSpinner_.setEnabled(!logScaleOn);
        this.minorDivSpinner_.setEnabled(!logScaleOn);
        this.pmeta_.getAction("fit-scale-to-data").setEnabled(!autoScaleOn);
        this.pmeta_.getAction("center-on-zero").setEnabled(!autoScaleOn && !logScaleOn);
        this.refreshing_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanScaleControls panScaleControls = this;
        synchronized (panScaleControls) {
            if (this.pmeta_ != null) {
                this.pmeta_.removePlotPropertyListener(this);
                this.pmeta_ = null;
            }
            super.flush();
        }
    }

    protected String tinyNumberFormat(double value) {
        String result = PrintfFormat.PFORMAT_7G.sprintfx(value);
        if (result.equals("0") && value != 0.0) {
            result = PrintfFormat.PFORMAT_2E.sprintfx(value);
        }
        return result;
    }

    @Override
    public void dataChanged(PanDataEvent e) {
        if (e == null) {
            LOGGER.trace("null PanDataEvent");
            return;
        }
        PanDataEvent.EType eid = e.getID();
        if (eid != PanDataEvent.EType.UNITS_CHANGED && (eid == PanDataEvent.EType.VARIABLE_CHANGED || eid == PanDataEvent.EType.COMBINATION_CHANGED)) {
            Object oldItem = this.unitsCombo_.getSelectedItem();
            String oldChoice = oldItem == null ? "" : oldItem.toString();
            boolean isReset = false;
            this.unitsCombo_.removeAllItems();
            for (String choice : this.data_.getUnitsChoices()) {
                this.unitsCombo_.addItem(choice);
                if (!choice.equals(oldChoice)) continue;
                this.unitsCombo_.setSelectedItem(choice);
                isReset = true;
            }
            if (!isReset) {
                this.unitsCombo_.setSelectedIndex(0);
                String unitsStr = this.unitsCombo_.getSelectedItem().toString();
                this.pmeta_.setScaleUnits(unitsStr, null);
            }
            GuiUtils.restrictSize(this.unitsCombo_);
        }
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        boolean changeAll;
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll) {
            this.refresh();
        }
        this.repaint();
    }
}

