/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.map.SymbolID;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanRadioButton;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JSeparator;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLonLatTrajectoryControls
extends PanAbstractControlsPanel {
    private PanColorComboBox[] strColorCombos_ = new PanColorComboBox[2];
    private PanEnumComboBox[] strStyleMenus_ = new PanEnumComboBox[2];
    private PanIntSpinner[] strWeightSpinners_ = new PanIntSpinner[2];
    private PanEnumComboBox[] ptSymbolMenus_ = new PanEnumComboBox[2];
    private PanFloatComboBox[] ptSymbolSizeCombos_ = new PanFloatComboBox[2];
    private PanRadioButton[] capDfltButtons_ = new PanRadioButton[2];
    private PanRadioButton[] capUserButtons_ = new PanRadioButton[2];
    private PanTextField[] captionTF_ = new PanTextField[2];
    private PanColorComboBox backgroundCombo_;
    private PanCheckBox skipNaNsCB_;
    private boolean refreshing_;

    public PanLonLatTrajectoryControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("trajectory-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        PanLabel bgLabel1 = PanLabel.small("Background:\u2009");
        this.backgroundCombo_ = PanColorComboBox.smallGrayscale("feature.background");
        this.backgroundCombo_.setSelectedColor(this.pmeta_.getColor("feature.background"));
        this.skipNaNsCB_ = PanCheckBox.small("feature.nanskip", "Skip points with NaN value", this.pmeta_.getBoolean("feature.nanskip"));
        QuickBox topBox = QuickBox.createCenterBox(bgLabel1, this.backgroundCombo_, Box.createHorizontalStrut(30), this.skipNaNsCB_);
        PanLabel t1Label = PanLabel.small("Trajectory 1:\u2009");
        PanLabel t2Label = PanLabel.small("Trajectory 2:\u2009");
        QuickBox[] strokeStyleBoxes = new QuickBox[2];
        QuickBox[] strokeColorBoxes = new QuickBox[2];
        QuickBox[] symbolBoxes = new QuickBox[2];
        QuickBox[] captionBoxes = new QuickBox[2];
        for (int i = 0; i < 2; ++i) {
            PanLabel t1SymbolLabel1 = PanLabel.small("Point:\u2009");
            PanLabel t1SymbolLabel2 = PanLabel.small("Symbol:\u2009");
            PanLabel t1SymbolLabel3 = PanLabel.small(", Size:\u2009");
            this.ptSymbolMenus_[i] = PanEnumComboBox.small(PanParamKeys.FEATURE_SYMBOL_ID[i], SymbolID.class);
            this.ptSymbolSizeCombos_[i] = PanFloatComboBox.small(PanParamKeys.FEATURE_SYMBOL_SIZE[i], 1.0f, 20.0f);
            this.ptSymbolMenus_[i].setSelectedItem(this.pmeta_.getString(PanParamKeys.FEATURE_SYMBOL_ID[i]));
            this.ptSymbolSizeCombos_[i].setValue(this.pmeta_.getFloat(PanParamKeys.FEATURE_SYMBOL_SIZE[i]));
            symbolBoxes[i] = QuickBox.createLeftBox(t1SymbolLabel1, t1SymbolLabel2, this.ptSymbolMenus_[i], t1SymbolLabel3, this.ptSymbolSizeCombos_[i]);
            PanLabel t1StrokeLabel1 = PanLabel.small("Stroke:\u2009");
            PanLabel t1StrokeLabel2 = PanLabel.small("Style:\u2009");
            PanLabel t2StrokeLabel1 = PanLabel.small(" ");
            PanLabel t2StrokeLabel2 = PanLabel.small("Color:\u2009");
            PanLabel t2StrokeLabel3 = PanLabel.small(", Weight:\u2009");
            PanLabel t2StrokeLabel4 = PanLabel.small("%");
            this.strStyleMenus_[i] = PanEnumComboBox.small(PanParamKeys.STROKE_STYLE[i], PanStrokePattern.class);
            this.strStyleMenus_[i].setSelectedItem(this.pmeta_.getString(PanParamKeys.STROKE_STYLE[i]));
            this.strColorCombos_[i] = PanColorComboBox.smallRainbow(PanParamKeys.STROKE_COLOR[i]);
            this.strColorCombos_[i].setSelectedColor(this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[i]));
            this.strWeightSpinners_[i] = PanIntSpinner.smallWeightX5(PanParamKeys.STROKE_WGT[i], this.pmeta_.getInt(PanParamKeys.STROKE_WGT[i]), 500);
            strokeStyleBoxes[i] = QuickBox.createLeftBox(t1StrokeLabel1, t1StrokeLabel2, this.strStyleMenus_[i]);
            strokeColorBoxes[i] = QuickBox.createLeftBox(t2StrokeLabel1, t2StrokeLabel2, this.strColorCombos_[i], t2StrokeLabel3, this.strWeightSpinners_[i], t2StrokeLabel4, Box.createHorizontalStrut(12));
            PanLabel t1CapLabel = PanLabel.small("Caption:\u2009");
            boolean customLabel = this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[i]);
            this.capDfltButtons_[i] = PanRadioButton.small(PanParamKeys.STROKE_LABEL_CUSTOM[i], "Default", !customLabel);
            this.capUserButtons_[i] = PanRadioButton.small(PanParamKeys.STROKE_LABEL_CUSTOM[i], "Custom:", customLabel);
            ButtonGroup t1CapChoices = new ButtonGroup();
            t1CapChoices.add(this.capDfltButtons_[i]);
            t1CapChoices.add(this.capUserButtons_[i]);
            this.captionTF_[i] = PanTextField.small(PanParamKeys.STROKE_LABEL_TEXT[i], this.pmeta_.getString(PanParamKeys.STROKE_LABEL_TEXT[i]), 20);
            captionBoxes[i] = QuickBox.createLeftBox(t1CapLabel, this.capDfltButtons_[i], this.capUserButtons_[i], this.captionTF_[i]);
            GuiUtils.matchLabelWidths(t1SymbolLabel1, t1StrokeLabel1, t2StrokeLabel1);
            GuiUtils.matchLabelWidths(t1SymbolLabel2, t1StrokeLabel2, t2StrokeLabel2);
        }
        int tfh = this.captionTF_[0].getPreferredSize().height;
        this.captionTF_[0].setMinimumSize(new Dimension(150, tfh));
        this.captionTF_[0].setPreferredSize(new Dimension(225, tfh));
        this.captionTF_[0].setMaximumSize(new Dimension(1000, tfh));
        this.captionTF_[1].setMinimumSize(new Dimension(150, tfh));
        this.captionTF_[1].setPreferredSize(new Dimension(225, tfh));
        this.captionTF_[1].setMaximumSize(new Dimension(1000, tfh));
        FlexingGridLayout fgl = new FlexingGridLayout(4, 5, 0, 2);
        fgl.setColumnWeight(1, 9999.0f);
        fgl.setColumnWeight(3, 9999.0f);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiUtils.STD_BORDER);
        this.add((Component)topBox, new FGConstraint(0, 0, 4, 1, 0.5, 0.5));
        this.add((Component)new JSeparator(), new FGConstraint(0, 1, 4, 1));
        this.add((Component)t1Label, new FGConstraint(0, 2));
        this.add((Component)symbolBoxes[0], new FGConstraint(1, 2));
        this.add((Component)strokeStyleBoxes[0], new FGConstraint(1, 3));
        this.add((Component)strokeColorBoxes[0], new FGConstraint(1, 4));
        this.add((Component)t2Label, new FGConstraint(2, 2));
        this.add((Component)symbolBoxes[1], new FGConstraint(3, 2));
        this.add((Component)strokeStyleBoxes[1], new FGConstraint(3, 3));
        this.add((Component)strokeColorBoxes[1], new FGConstraint(3, 4));
    }

    private void attachListeners() {
        this.backgroundCombo_.addItemListener(e -> {
            Color cold;
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            int index = this.backgroundCombo_.getSelectedIndex();
            if (index < 0 || index >= this.backgroundCombo_.getItemCount()) {
                return;
            }
            Color cnew = this.backgroundCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("feature.background"))) {
                this.pmeta_.setColor("feature.background", cnew);
            }
        });
        this.skipNaNsCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean checked = this.skipNaNsCB_.isSelected();
            this.pmeta_.setBoolean("feature.nanskip", checked);
        });
        int i = 0;
        while (i < 2) {
            final int ii = i++;
            this.strColorCombos_[ii].addItemListener(e -> {
                Color cold;
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                int index = this.strColorCombos_[ii].getSelectedIndex();
                if (index < 0 || index >= this.strColorCombos_[ii].getItemCount()) {
                    return;
                }
                Color cnew = this.strColorCombos_[ii].getSelectedColor();
                if (!cnew.equals(cold = this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[ii]))) {
                    this.pmeta_.setColor(PanParamKeys.STROKE_COLOR[ii], cnew);
                }
            });
            this.strStyleMenus_[ii].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.set(PanParamKeys.STROKE_STYLE[ii], this.strStyleMenus_[ii].getStringValue());
            });
            this.strWeightSpinners_[ii].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setInt(PanParamKeys.STROKE_WGT[ii], this.strWeightSpinners_[ii].getIntValue());
            });
            this.ptSymbolMenus_[ii].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.set(PanParamKeys.FEATURE_SYMBOL_ID[ii], this.ptSymbolMenus_[ii].getStringValue());
            });
            this.ptSymbolSizeCombos_[ii].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.setFloat(PanParamKeys.FEATURE_SYMBOL_SIZE[ii], this.ptSymbolSizeCombos_[ii].getValue());
            });
            this.capDfltButtons_[0].addActionListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[0], this.capUserButtons_[0].isSelected());
            });
            this.capUserButtons_[ii].addActionListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[ii], this.capUserButtons_[ii].isSelected());
            });
            this.captionTF_[ii].addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (PanLonLatTrajectoryControls.this.refreshing_) {
                        return;
                    }
                    if (PanLonLatTrajectoryControls.this.captionTF_[ii] == null || PanLonLatTrajectoryControls.this.pmeta_ == null) {
                        return;
                    }
                    PanLonLatTrajectoryControls.this.pmeta_.setString(PanParamKeys.STROKE_LABEL_TEXT[ii], PanLonLatTrajectoryControls.this.captionTF_[ii].getText());
                }
            });
            this.captionTF_[ii].addActionListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setString(PanParamKeys.STROKE_LABEL_TEXT[ii], this.captionTF_[ii].getText());
            });
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.backgroundCombo_.setSelectedColor(this.pmeta_.getColor("feature.background"));
        this.skipNaNsCB_.setSelected(this.pmeta_.getBoolean("feature.nanskip"));
        for (int i = 0; i < 2; ++i) {
            this.ptSymbolMenus_[i].setSelectedItem(this.pmeta_.getString(PanParamKeys.FEATURE_SYMBOL_ID[i]));
            this.ptSymbolSizeCombos_[i].setValue(this.pmeta_.getFloat(PanParamKeys.FEATURE_SYMBOL_SIZE[i]));
            this.strStyleMenus_[i].setSelectedItem(this.pmeta_.getString(PanParamKeys.STROKE_STYLE[i]));
            this.strColorCombos_[i].setSelectedColor(this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[i]));
            this.strWeightSpinners_[i].setValue(this.pmeta_.getInt(PanParamKeys.STROKE_WGT[i]));
            boolean customLabel = this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[i]);
            this.capDfltButtons_[i] = PanRadioButton.small(PanParamKeys.STROKE_LABEL_CUSTOM[i], "Default", !customLabel);
            this.capUserButtons_[i] = PanRadioButton.small(PanParamKeys.STROKE_LABEL_CUSTOM[i], "Custom:", customLabel);
            this.captionTF_[i].setText(this.pmeta_.getString(PanParamKeys.STROKE_LABEL_TEXT[i]));
        }
        PanCombinationType ctype = PanCombinationType.matching(this.pmeta_.getString("combination"));
        boolean[] enable = new boolean[]{true, false};
        if (ctype == PanCombinationType.COMPARE) {
            enable[1] = true;
        } else if (ctype == PanCombinationType.A2_ONLY) {
            enable[0] = false;
            enable[1] = true;
        }
        for (int i = 0; i < 2; ++i) {
            this.ptSymbolMenus_[i].setEnabled(enable[i]);
            this.ptSymbolSizeCombos_[i].setEnabled(enable[i]);
            this.strColorCombos_[i].setEnabled(enable[i]);
            this.strStyleMenus_[i].setEnabled(enable[i]);
            this.strWeightSpinners_[i].setEnabled(enable[i]);
            this.capDfltButtons_[i].setEnabled(enable[i]);
            this.capUserButtons_[i].setEnabled(enable[i]);
            this.captionTF_[i].setEnabled(enable[i]);
        }
        this.refreshing_ = false;
    }
}

