/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.map.SymbolID;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.map.overlay.ShapefileOverlay;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.overlay.PanMaskOverlay;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanOverlayComboBox;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLonLatOverlayControls
extends PanAbstractControlsPanel
implements ResourceListDataListener {
    private static final int MAX_OVERLAYS = 3;
    private JComponent[] olayRow_;
    private PanOverlayComboBox[] olayCombo_;
    private PanColorComboBox[] olayColorCombo_;
    private PanLabel[] olayWeightLabel_;
    private PanIntSpinner[] olayWeightSpinner_;
    private PanCheckBox[] olayMaskInvertCB_;
    private PanEnumComboBox[] olayStyleCombo_;
    private PanEnumComboBox[] olaySymbolCombo_;
    private PanFloatComboBox[] olaySymbolSizeCombo_;
    private JComponent[] olayNameBox_;
    private JComponent[] olayColorBox_;
    private JComponent[] olayWeightBox_;
    private JComponent[] olayMaskBox_;
    private JComponent[] olayStrokeBox_;
    private JComponent[] olaySymbolBox_;
    private boolean refreshing_;

    public PanLonLatOverlayControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("overlay-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
        PanUtils.getOverlayResourceList().addListDataListener(this);
    }

    private void createLayout() {
        this.olayRow_ = new JComponent[3];
        this.olayCombo_ = new PanOverlayComboBox[3];
        this.olayColorCombo_ = new PanColorComboBox[3];
        this.olayWeightLabel_ = new PanLabel[3];
        this.olayWeightSpinner_ = new PanIntSpinner[3];
        this.olayMaskInvertCB_ = new PanCheckBox[3];
        this.olayStyleCombo_ = new PanEnumComboBox[3];
        this.olaySymbolCombo_ = new PanEnumComboBox[3];
        this.olaySymbolSizeCombo_ = new PanFloatComboBox[3];
        this.olayNameBox_ = new JComponent[3];
        this.olayColorBox_ = new JComponent[3];
        this.olayWeightBox_ = new JComponent[3];
        this.olayMaskBox_ = new JComponent[3];
        this.olayStrokeBox_ = new JComponent[3];
        this.olaySymbolBox_ = new JComponent[3];
        FlexingGridLayout fgl = new FlexingGridLayout(2, 4, 0, 2);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiUtils.STD_BORDER);
        for (int i = 0; i < 3; ++i) {
            this.olayRow_[i] = this.createRow(i);
            this.add((Component)this.olayRow_[i], new FGConstraint(0, i));
        }
    }

    private JComponent createRow(int row) {
        PanLabel oLabel = PanLabel.small("Overlay " + (row + 1) + ":\u2009");
        this.olayCombo_[row] = PanOverlayComboBox.small(PanParamKeys.OVERLAY_NAME[row], true);
        this.olayNameBox_[row] = QuickBox.createLeftBox(oLabel, this.olayCombo_[row]);
        PanLabel oColorLabel = PanLabel.small(", Color:\u2009");
        this.olayColorCombo_[row] = PanColorComboBox.smallRainbow(PanParamKeys.OVERLAY_COLOR[row]);
        this.olayColorBox_[row] = QuickBox.createLeftBox(oColorLabel, this.olayColorCombo_[row]);
        this.olayWeightLabel_[row] = PanLabel.small(", Weight:\u2009");
        this.olayWeightSpinner_[row] = PanIntSpinner.smallWeight(PanParamKeys.OVERLAY_WGT[row], this.pmeta_.getInt(PanParamKeys.OVERLAY_WGT[row]), 400);
        PanLabel oPctLabel = PanLabel.small("%");
        this.olayWeightBox_[row] = QuickBox.createLeftBox(this.olayWeightLabel_[row], this.olayWeightSpinner_[row], oPctLabel);
        PanLabel oMaskLabel = PanLabel.small(", ");
        this.olayMaskInvertCB_[row] = PanCheckBox.small(PanParamKeys.OVERLAY_INVERT[row], "Invert");
        this.olayMaskBox_[row] = QuickBox.createLeftBox(oMaskLabel, this.olayMaskInvertCB_[row]);
        PanLabel oStyleLabel = PanLabel.small("; Style:\u2009");
        this.olayStyleCombo_[row] = PanEnumComboBox.small(PanParamKeys.OVERLAY_STYLE[row], PanStrokePattern.class);
        this.olayStrokeBox_[row] = QuickBox.createLeftBox(oStyleLabel, this.olayStyleCombo_[row]);
        PanLabel oSymbolLabel = PanLabel.small("; Pt. Symbol:\u2009");
        PanLabel oSymbolSizeLabel = PanLabel.small(", Size:\u2009");
        this.olaySymbolCombo_[row] = PanEnumComboBox.small(PanParamKeys.OVERLAY_SYMBOL_ID[row], SymbolID.class);
        this.olaySymbolCombo_[row].removeItem(SymbolID.NONE);
        this.olaySymbolSizeCombo_[row] = PanFloatComboBox.small(PanParamKeys.OVERLAY_SYMBOL_SIZE[row], 3.0f, 8.0f);
        this.olaySymbolBox_[row] = QuickBox.createLeftBox(oSymbolLabel, this.olaySymbolCombo_[row], oSymbolSizeLabel, this.olaySymbolSizeCombo_[row]);
        return QuickBox.createLeftBox(this.olayNameBox_[row], this.olayColorBox_[row], this.olayMaskBox_[row], this.olayStrokeBox_[row], this.olayWeightBox_[row], this.olaySymbolBox_[row]);
    }

    private void attachListeners() {
        int ii = 0;
        while (ii < 3) {
            int i = ii++;
            this.olayCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.olayCombo_[i].isRefreshing()) {
                    return;
                }
                Object o = this.olayCombo_[i].getSelectedItem();
                String oname = (String)o;
                this.pmeta_.setString(PanParamKeys.OVERLAY_NAME[i], oname);
                this.scheduleRefreshTask();
            });
            this.olayMaskInvertCB_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setBoolean(PanParamKeys.OVERLAY_INVERT[i], this.olayMaskInvertCB_[i].isSelected());
            });
            this.olayStyleCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.put(PanParamKeys.OVERLAY_STYLE[i], (Object)this.olayStyleCombo_[i].getStringValue());
            });
            this.olayColorCombo_[i].addItemListener(e -> {
                Color cold;
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                Color cnew = this.olayColorCombo_[i].getSelectedColor();
                if (!cnew.equals(cold = this.pmeta_.getColor(PanParamKeys.OVERLAY_COLOR[i]))) {
                    this.pmeta_.setColor(PanParamKeys.OVERLAY_COLOR[i], cnew);
                }
            });
            this.olayWeightSpinner_[i].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setInt(PanParamKeys.OVERLAY_WGT[i], this.olayWeightSpinner_[i].getIntValue());
            });
            this.olaySymbolCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.set(PanParamKeys.OVERLAY_SYMBOL_ID[i], this.olaySymbolCombo_[i].getStringValue());
            });
            this.olaySymbolSizeCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.setFloat(PanParamKeys.OVERLAY_SYMBOL_SIZE[i], this.olaySymbolSizeCombo_[i].getValue());
            });
        }
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        Object source;
        if (e == null) {
            return;
        }
        Component cc = e.getComponent();
        if (cc == null) {
            return;
        }
        JFrame jf = null;
        if (cc instanceof JFrame) {
            jf = (JFrame)cc;
        } else if (cc instanceof JComponent) {
            jf = GuiUtils.getParentFrame((JComponent)cc);
        } else {
            return;
        }
        JFrame pframe = GuiUtils.getParentFrame(this);
        if (jf == pframe && (source = e.getSource()) instanceof OverlayResourceList) {
            MapOverlay olay = (MapOverlay)PanUtils.getOverlayResourceList().getBackingObject(e.getIndex0());
            EventQueue.invokeLater(() -> this.olayCombo_[0].setSelectedItem(olay));
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanLonLatOverlayControls panLonLatOverlayControls = this;
        synchronized (panLonLatOverlayControls) {
            for (int i = 0; i < 3; ++i) {
                this.olayCombo_[i].flush();
                this.olayCombo_[i] = null;
            }
            super.flush();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        int i;
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        for (i = 0; i < 3; ++i) {
            String oname = this.pmeta_.getString(PanParamKeys.OVERLAY_NAME[i]);
            MapOverlay oo = PanUtils.getOverlay(oname);
            if (oo == null) {
                this.olayCombo_[i].setSelectedItem("None");
            } else {
                this.olayCombo_[i].setSelectedItem(oname);
            }
            this.olayColorCombo_[i].setSelectedColor(this.pmeta_.getColor(PanParamKeys.OVERLAY_COLOR[i]));
            this.olayMaskInvertCB_[i].setSelected(this.pmeta_.getBoolean(PanParamKeys.OVERLAY_INVERT[i]));
            this.olayStyleCombo_[i].setSelectedItem(this.pmeta_.getString(PanParamKeys.OVERLAY_STYLE[i]));
            this.olaySymbolCombo_[i].setSelectedItem(this.pmeta_.getString(PanParamKeys.OVERLAY_SYMBOL_ID[i]));
            this.olaySymbolSizeCombo_[i].setValue(this.pmeta_.getFloat(PanParamKeys.OVERLAY_SYMBOL_SIZE[i]));
        }
        for (i = 0; i < 3; ++i) {
            MapOverlay oo = this.olayCombo_[i].getSelectedOverlay();
            boolean isMask = oo instanceof PanMaskOverlay;
            boolean isShapefile = oo instanceof ShapefileOverlay;
            this.olayRow_[i].removeAll();
            this.olayRow_[i].add(this.olayNameBox_[i]);
            this.olayRow_[i].add(this.olayColorBox_[i]);
            if (isMask) {
                this.olayRow_[i].add(this.olayWeightBox_[i]);
                this.olayRow_[i].add(this.olayMaskBox_[i]);
                this.olayWeightLabel_[i].setText(", Mask Opacity:\u2009");
            } else {
                this.olayRow_[i].add(this.olayStrokeBox_[i]);
                this.olayRow_[i].add(this.olayWeightBox_[i]);
                this.olayWeightLabel_[i].setText(", Weight:\u2009");
                if (isShapefile) {
                    this.olayRow_[i].add(this.olaySymbolBox_[i]);
                }
            }
            this.olayRow_[i].add(Box.createHorizontalGlue());
            this.olayCombo_[i].setEnabled(true);
            this.olayColorCombo_[i].setEnabled(oo != null);
            this.olayWeightSpinner_[i].setEnabled(oo != null);
            this.olayMaskInvertCB_[i].setEnabled(isMask);
            this.olayStyleCombo_[i].setEnabled(oo != null && !isMask);
            this.olaySymbolCombo_[i].setEnabled(isShapefile);
            this.olaySymbolSizeCombo_[i].setEnabled(isShapefile);
        }
        this.refreshing_ = false;
        this.invalidate();
        this.validate();
        this.repaint();
    }
}

