/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.panoply.action.PanBackgroundAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanCaptionListener;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanFontComboBox;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.PaletteType;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JMenuItem;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLabelControls
extends PanAbstractControlsPanel
implements PlotPropertyListener {
    private PanTextField titleTF_;
    private PanTextField subtitleTF_;
    private PanTextField lfnTF_;
    private PanTextField rfnTF_;
    private PanCheckBox minmaxNoteCB_;
    private PanStringComboBox minmaxFormatCombo_;
    private PanFontComboBox fontCombo_;
    private PanColorComboBox backgroundCombo_;
    private PanCheckBox super10CB_;
    private boolean refreshing_;

    public PanLabelControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("label-controls", pmeta, mbar);
        this.createActions(mbar);
        this.createLayout();
        this.attachListeners();
        this.refreshPrivate();
        this.pmeta_.addPlotPropertyListener(this);
    }

    private void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        PanBackgroundAction a = new PanBackgroundAction(this.pmeta_);
        this.pmeta_.putAction("background", a);
        plotMenu.getItemByName("background").setAction(a);
    }

    private void createLayout() {
        PanLabel titleLabel = PanLabel.small("Title:\u2009");
        this.titleTF_ = PanTextField.small("title.text", this.pmeta_.getString("title.text"), 0);
        QuickBox titleBox = QuickBox.createHorizontalBox(titleLabel, this.titleTF_);
        PanLabel subtitleLabel = PanLabel.small("Subtitle:\u2009");
        this.subtitleTF_ = PanTextField.small("subtitle.text", "", 0);
        QuickBox subtitleBox = QuickBox.createHorizontalBox(subtitleLabel, this.subtitleTF_);
        PanLabel footnotesLabel = PanLabel.small("Footnotes:\u2009");
        PanLabel cfnPadLabel = PanLabel.small(" ");
        PanLabel rfnPadLabel = PanLabel.small(" ");
        PanLabel lfnLabel = PanLabel.small("Left:\u2009");
        PanLabel cfnLabel = PanLabel.small("Center:\u2009");
        PanLabel rfnLabel = PanLabel.small("Right:\u2009");
        PanLabel formatFnLabel = PanLabel.small(" \u2014 Format:\u2009");
        this.lfnTF_ = PanTextField.small("footnote.left", "", 30);
        this.rfnTF_ = PanTextField.small("footnote.right", "", 30);
        this.minmaxNoteCB_ = PanCheckBox.small("footnote.minmax.vis", "Show data min-max", this.pmeta_.getBoolean("footnote.minmax.vis"));
        this.minmaxFormatCombo_ = PanStringComboBox.smallNumberFormatCombo("footnote.minmax.format");
        this.minmaxFormatCombo_.insertItemAt("Same as scale ticks", 0);
        this.minmaxFormatCombo_.setEnabled(this.minmaxNoteCB_.isSelected());
        String mmf = this.pmeta_.getString("footnote.minmax.format");
        if (mmf == null || mmf.isEmpty() || mmf.toLowerCase().startsWith("same")) {
            this.minmaxFormatCombo_.setSelectedIndex(0);
        } else {
            this.minmaxFormatCombo_.setSelectedItem(mmf);
        }
        QuickBox lfnBox = QuickBox.createLeftBox(footnotesLabel, lfnLabel, this.lfnTF_);
        QuickBox cfnBox = QuickBox.createLeftBox(cfnPadLabel, cfnLabel, this.minmaxNoteCB_, formatFnLabel, this.minmaxFormatCombo_);
        QuickBox rfnBox = QuickBox.createLeftBox(rfnPadLabel, rfnLabel, this.rfnTF_);
        PanLabel fontLabel = PanLabel.small("Labels Typeface:\u2009");
        this.fontCombo_ = new PanFontComboBox(PanGuiSize.SMALL, "labels.font");
        this.fontCombo_.setSelectedItem(this.pmeta_.getString("labels.font"));
        QuickBox fontBox = QuickBox.createLeftBox(fontLabel, this.fontCombo_);
        PanLabel super10Label = PanLabel.small("Exponents:\u2009");
        this.super10CB_ = PanCheckBox.small("labels.super10", "Replace \"E\" notation with superscripted 10", this.pmeta_.getBoolean("labels.super10"));
        QuickBox super10Box = QuickBox.createLeftBox(super10Label, this.super10CB_);
        PanLabel backgroundLabel = PanLabel.small("Background:\u2009");
        this.backgroundCombo_ = PanColorComboBox.small("color.background", PaletteType.BLACK_WHITE);
        this.backgroundCombo_.setSelectedColor(this.pmeta_.getColor("color.background"));
        this.backgroundCombo_.setAction(this.pmeta_.getAction("background"));
        QuickBox backgroundBox = QuickBox.createLeftBox(backgroundLabel, this.backgroundCombo_);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 2);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiUtils.STD_BORDER);
        this.add((Component)titleBox, new FGConstraint(0, 0));
        this.add((Component)subtitleBox, new FGConstraint(0, 1));
        this.add((Component)lfnBox, new FGConstraint(0, 2));
        this.add((Component)cfnBox, new FGConstraint(0, 3));
        this.add((Component)rfnBox, new FGConstraint(0, 4));
        this.add((Component)fontBox, new FGConstraint(1, 0));
        this.add((Component)super10Box, new FGConstraint(1, 1));
        this.add((Component)backgroundBox, new FGConstraint(1, 2));
        GuiUtils.matchLabelWidths(titleLabel, subtitleLabel, footnotesLabel, cfnPadLabel, rfnPadLabel);
        GuiUtils.matchLabelWidths(lfnLabel, cfnLabel, rfnLabel);
        GuiUtils.matchLabelWidths(fontLabel, super10Label, backgroundLabel);
        int tfh = this.titleTF_.getPreferredSize().height;
        Dimension ddpref = new Dimension(480, tfh);
        Dimension ddmax = new Dimension(1000, tfh);
        Dimension ddmin = new Dimension(400, tfh);
        this.titleTF_.setPreferredSize(ddpref);
        this.titleTF_.setMinimumSize(ddmin);
        this.titleTF_.setMaximumSize(ddmax);
        this.subtitleTF_.setPreferredSize(ddpref);
        this.subtitleTF_.setMinimumSize(ddmin);
        this.subtitleTF_.setMaximumSize(ddmax);
        backgroundLabel.setPreferredSize(fontLabel.getPreferredSize());
        backgroundLabel.setMaximumSize(backgroundLabel.getPreferredSize());
        Dimension dd = this.fontCombo_.getPreferredSize();
        if (dd.width > 240) {
            dd.width = 240;
            this.fontCombo_.setPreferredSize(dd);
            this.fontCombo_.setMaximumSize(dd);
        }
    }

    private void attachListeners() {
        this.titleTF_.getDocument().addDocumentListener(new PanCaptionListener(this.titleTF_, this.pmeta_, "title.text"));
        this.subtitleTF_.getDocument().addDocumentListener(new PanCaptionListener(this.subtitleTF_, this.pmeta_, "subtitle.text"));
        this.lfnTF_.getDocument().addDocumentListener(new PanCaptionListener(this.lfnTF_, this.pmeta_, "footnote.left"));
        this.rfnTF_.getDocument().addDocumentListener(new PanCaptionListener(this.rfnTF_, this.pmeta_, "footnote.right"));
        this.fontCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("labels.font", this.fontCombo_.getSelectedItem().toString());
        });
        this.super10CB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.super10CB_.isSelected();
            this.pmeta_.setBoolean("labels.super10", bb);
        });
        this.minmaxNoteCB_.addItemListener(e -> {
            boolean bb = this.minmaxNoteCB_.isSelected();
            this.pmeta_.setBoolean("footnote.minmax.vis", bb);
            this.minmaxFormatCombo_.setEnabled(bb);
        });
        this.minmaxFormatCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            String format = this.minmaxFormatCombo_.getSelectedString();
            this.pmeta_.setString("footnote.minmax.format", format);
        });
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        PanPlotFrame pframe = this.pmeta_.getFrame();
        PanMenuBar mbar = pframe.getPanMenuBar();
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        JMenuItem jmi = plotMenu.getItemByName("background");
        jmi.setEnabled(true);
        this.pmeta_.getAction("background").actionPerformed(null);
        Color cnew = this.pmeta_.getColor("color.background");
        this.backgroundCombo_.setSelectedColor(cnew);
        this.refreshing_ = false;
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        boolean changeAll = false;
        if (pname.contains("color.background")) {
            Color cold = this.backgroundCombo_.getSelectedColor();
            Color cnew = this.pmeta_.getColor("color.background");
            if (!cnew.equals(cold)) {
                this.backgroundCombo_.setSelectedColor(cnew);
            }
        }
    }
}

