/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.action.PanPlotZoomInAction;
import gov.nasa.giss.panoply.action.PanPlotZoomOutAction;
import gov.nasa.giss.panoply.action.PanPlotZoomResetAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanCommonXAxisControls;
import gov.nasa.giss.panoply.plotui.PanCommonYAxisControls;
import gov.nasa.giss.panoply.plotui.PanGridControls;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanAxisTickColor;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Color;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JSeparator;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanGridControls2D
extends PanGridControls {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanCommonXAxisControls xaxisCtrls_;
    private PanCommonYAxisControls yaxisCtrls_;
    private PanEnumComboBox gridStyleCombo_;
    private PanColorComboBox gridColorCombo_;
    private PanIntSpinner gridWeightSpinner_;
    private PanCheckBox axesOffsetCB_;
    private PanIntSpinner tickWeightSpinner_;
    private PanEnumComboBox tickColorCombo_;
    private boolean refreshing_;

    public PanGridControls2D(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        this.createActions(mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        AbstractAction a = new PanPlotZoomResetAction(this);
        this.pmeta_.putAction("reset-bounds", a);
        plotMenu.getItemByName("reset-bounds").setAction(a);
        a = new PanPlotZoomInAction(this);
        this.pmeta_.putAction("zoom-plot-in", a);
        plotMenu.getItemByName("zoom-plot-in").setAction(a);
        a = new PanPlotZoomOutAction(this);
        this.pmeta_.putAction("zoom-plot-out", a);
        plotMenu.getItemByName("zoom-plot-out").setAction(a);
    }

    private void createLayout() {
        PanLabel gStyleLabel = PanLabel.small("Grid Style:\u2009");
        this.gridStyleCombo_ = PanEnumComboBox.small("grid.style", PanStrokePattern.class);
        PanLabel gColorLabel = PanLabel.small(", Color:\u2009");
        this.gridColorCombo_ = PanColorComboBox.smallRainbow("grid.color");
        PanLabel gWeightLabel = PanLabel.small(", Weight:\u2009");
        this.gridWeightSpinner_ = PanIntSpinner.smallWeight("grid.weight", this.pmeta_.getInt("grid.weight"), 200);
        PanLabel gPctLabel = PanLabel.small("%");
        this.axesOffsetCB_ = PanCheckBox.small("axes.offset", "Offset axes from grid edges", this.pmeta_.getBoolean("axes.offset"));
        PanLabel tickColorLabel = PanLabel.small("Tickmark Color:\u2009");
        this.tickColorCombo_ = PanEnumComboBox.small("axes.tickmark.color", PanAxisTickColor.class);
        PanLabel tickWeightLabel = PanLabel.small(", Weight");
        this.tickWeightSpinner_ = PanIntSpinner.smallWeight("axes.tickmark.weight", this.pmeta_.getInt("axes.tickmark.weight"), 200);
        PanLabel tickPctLabel = PanLabel.small("%");
        QuickBox topBox = QuickBox.createCenterBox(gStyleLabel, this.gridStyleCombo_, gColorLabel, this.gridColorCombo_, gWeightLabel, this.gridWeightSpinner_, gPctLabel, Box.createHorizontalStrut(36), PanLabel.small(" \u2014 "), Box.createHorizontalStrut(36), this.axesOffsetCB_, Box.createHorizontalStrut(36), PanLabel.small(" \u2014 "), Box.createHorizontalStrut(36), tickColorLabel, this.tickColorCombo_, tickWeightLabel, this.tickWeightSpinner_, tickPctLabel);
        switch (this.ptype_) {
            case LAT_VERT: 
            case LON_VERT: 
            case LAT_TIME: 
            case LON_TIME: 
            case TIME_LAT: 
            case TIME_VERT: 
            case COLOR_CONTOUR: {
                this.xaxisCtrls_ = new PanCommonXAxisControls(this.pmeta_, this.mbar_);
                this.yaxisCtrls_ = new PanCommonYAxisControls(this.pmeta_, this.mbar_);
                break;
            }
            default: {
                LOGGER.error("I cannot create axes grid controls for {}.", (Object)this.ptype_);
                LOGGER.error("Does not look like a known general 2D plot type.");
            }
        }
        FlexingGridLayout fgl = new FlexingGridLayout(2, 3, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiUtils.STD_BORDER);
        this.add((Component)topBox, new FGConstraint(0, 0, 2, 1, 0.5, 0.0));
        this.add((Component)new JSeparator(), new FGConstraint(0, 1, 2, 1));
        this.add((Component)this.xaxisCtrls_, new FGConstraint(0, 2, 0.0, 0.0));
        this.add((Component)this.yaxisCtrls_, new FGConstraint(1, 2, 0.0, 0.0));
    }

    private void attachListeners() {
        this.gridStyleCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("grid.style", (Object)this.gridStyleCombo_.getStringValue());
        });
        this.gridColorCombo_.addItemListener(e -> {
            Color cold;
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.gridColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("grid.color"))) {
                this.pmeta_.setColor("grid.color", cnew);
            }
        });
        this.gridWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("grid.weight", this.gridWeightSpinner_.getIntValue());
        });
        this.axesOffsetCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean checked = this.axesOffsetCB_.isSelected();
            this.pmeta_.setBoolean("axes.offset", checked);
            this.tickColorCombo_.setEnabled(!checked);
            this.tickWeightSpinner_.setEnabled(!checked);
        });
        this.tickColorCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("axes.tickmark.color", (Object)this.tickColorCombo_.getStringValue());
        });
        this.tickWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("axes.tickmark.weight", this.tickWeightSpinner_.getIntValue());
        });
    }

    @Override
    public void refreshZoomEnabling() {
    }

    @Override
    public void recenter(double x, double y) {
        this.xaxisCtrls_.recenter(x);
        this.yaxisCtrls_.recenter(y);
    }

    @Override
    public void zoomIn() {
        this.zoom(1.5);
    }

    @Override
    public void zoomOut() {
        this.zoom(0.6666666666666666);
    }

    @Override
    public void zoomIn(double centerx, double centery) {
        this.zoom(1.5, centerx, centery);
    }

    @Override
    public void zoomOut(double centerx, double centery) {
        this.zoom(0.6666666666666666, centerx, centery);
    }

    @Override
    public void zoom(double factor) {
        this.xaxisCtrls_.zoom(factor);
        this.yaxisCtrls_.zoom(factor);
    }

    @Override
    public void zoom(double factor, double centerx, double centery) {
        this.xaxisCtrls_.zoom(factor, centerx);
        this.yaxisCtrls_.zoom(factor, centery);
    }

    @Override
    public void dragZoom(double centerx, double centery, double leftx, double topy, double rightx, double bottomy) {
        this.xaxisCtrls_.setAxisBounds(leftx, rightx);
        this.yaxisCtrls_.setAxisBounds(bottomy, topy);
    }

    @Override
    public void resetGridBounds() {
        this.xaxisCtrls_.resetAxisBounds();
        this.yaxisCtrls_.resetAxisBounds();
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.gridStyleCombo_.setSelectedItem(this.pmeta_.getString("grid.style"));
        this.gridColorCombo_.setSelectedColor(this.pmeta_.getColor("grid.color"));
        this.gridWeightSpinner_.setValue(this.pmeta_.getInt("grid.weight"));
        this.axesOffsetCB_.setSelected(this.pmeta_.getBoolean("axes.offset"));
        this.tickColorCombo_.setEnabled(!this.axesOffsetCB_.isSelected());
        this.tickColorCombo_.setSelectedItem(this.pmeta_.getString("axes.tickmark.color"));
        this.tickWeightSpinner_.setEnabled(!this.axesOffsetCB_.isSelected());
        this.refreshing_ = false;
    }
}

