/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.panoply.action.PanShowPlotControlsTabAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.plotui.PanArrayControls;
import gov.nasa.giss.panoply.plotui.PanContourControls;
import gov.nasa.giss.panoply.plotui.PanGridControls1D;
import gov.nasa.giss.panoply.plotui.PanGridControls2D;
import gov.nasa.giss.panoply.plotui.PanLabelControls;
import gov.nasa.giss.panoply.plotui.PanLonLatMapControls;
import gov.nasa.giss.panoply.plotui.PanLonLatOverlayControls;
import gov.nasa.giss.panoply.plotui.PanLonLatShadingControls;
import gov.nasa.giss.panoply.plotui.PanLonLatTrajectoryControls;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanScaleControls2D;
import gov.nasa.giss.panoply.plotui.PanStrokeControls1D;
import gov.nasa.giss.panoply.plotui.PanVectorControls;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.ui.tabbedpane.FolderTabbedPane;
import java.awt.Container;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanControlsTabbedPane
extends FolderTabbedPane
implements PlotPropertyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotFrame parent_;
    private final PanPlotMeta pmeta_;
    private final Hashtable<String, PanAbstractControlsPanel> tabsHash_ = new Hashtable(20);
    private int maxPaneWidth_;

    public PanControlsTabbedPane(PanPlotFrame parent, PanPlotMeta pmeta) {
        this.setFixedButtonWidth(false);
        this.parent_ = parent;
        this.pmeta_ = pmeta;
        this.createTabs();
        this.createActions();
        this.attachListeners();
        this.pmeta_.addPlotPropertyListener(this);
        LOGGER.trace("pref {},{}", (Object)this.getPreferredSize().width, (Object)this.getPreferredSize().height);
    }

    private void createTabs() {
        PanMenuBar mbar = this.parent_.getPanMenuBar();
        PanPlotType ptype = this.pmeta_.getType();
        PanAbstractControlsPanel cc = new PanArrayControls(this.pmeta_, mbar);
        this.tabsHash_.put("array-controls", cc);
        this.addTab(PanProperties.CONTROL_PROPS.getString("array-controls"), cc);
        if (!ptype.isLinePlot()) {
            cc = new PanScaleControls2D(this.pmeta_, mbar);
            this.tabsHash_.put("scale-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("scale-controls"), cc);
        }
        if (ptype == PanPlotType.LL_TRAJ) {
            cc = new PanLonLatTrajectoryControls(this.pmeta_, mbar);
            this.tabsHash_.put("trajectory-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("trajectory-controls"), cc);
        }
        if (ptype.isLonLatMap()) {
            cc = new PanLonLatMapControls(this.pmeta_, mbar);
            this.tabsHash_.put("map-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("map-controls"), cc);
            cc = new PanLonLatOverlayControls(this.pmeta_, mbar);
            this.tabsHash_.put("overlay-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("overlay-controls"), cc);
            cc = new PanLonLatShadingControls(this.pmeta_, mbar);
            this.tabsHash_.put("shading-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("shading-controls"), cc);
        } else if (!ptype.isLinePlot()) {
            cc = new PanGridControls2D(this.pmeta_, mbar);
            this.tabsHash_.put("grid-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("grid-controls"), cc);
        }
        if (ptype.isLinePlot()) {
            cc = new PanGridControls1D(this.pmeta_, mbar);
            this.tabsHash_.put("grid-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("grid-controls"), cc);
            LOGGER.trace("Creating PanStrokeControls1D");
            cc = new PanStrokeControls1D(this.pmeta_, mbar);
            this.tabsHash_.put("stroke-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("stroke-controls"), cc);
        }
        if (ptype.isColorContour()) {
            cc = new PanContourControls(this.pmeta_, mbar);
            this.tabsHash_.put("contour-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("contour-controls"), cc);
        }
        if (ptype.supportsVectorPlots()) {
            cc = new PanVectorControls(this.pmeta_, mbar);
            this.tabsHash_.put("vector-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("vector-controls"), cc);
        }
        cc = new PanLabelControls(this.pmeta_, mbar);
        this.tabsHash_.put("label-controls", cc);
        this.addTab(PanProperties.CONTROL_PROPS.getString("label-controls"), cc);
        Dimension paneSize = GuiUtils.matchComponentWidths(this.tabsHash_.values());
        this.maxPaneWidth_ = paneSize.width;
    }

    private void createActions() {
        PanShowPlotControlsTabAction a;
        PanMenuBar mbar = this.parent_.getPanMenuBar();
        GissMenu viewMenu = mbar.getMenuByName("view-menu");
        GissMenu viewPMenu = (GissMenu)viewMenu.getItemByName("view-plot-menu");
        if (this.tabsHash_.get("array-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-array-controls", "array-controls");
            viewPMenu.getItemByName("show-array-controls").setAction(a);
        }
        if (this.tabsHash_.get("scale-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-scale-controls", "scale-controls");
            viewPMenu.getItemByName("show-scale-controls").setAction(a);
        }
        if (this.tabsHash_.get("grid-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-grid-controls", "grid-controls");
            viewPMenu.getItemByName("show-grid-controls").setAction(a);
        }
        if (this.tabsHash_.get("stroke-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-stroke-controls", "stroke-controls");
            viewPMenu.getItemByName("show-stroke-controls").setAction(a);
        }
        if (this.tabsHash_.get("overlay-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-overlay-controls", "overlay-controls");
            viewPMenu.getItemByName("show-overlay-controls").setAction(a);
        }
        if (this.tabsHash_.get("shading-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-shading-controls", "shading-controls");
            viewPMenu.getItemByName("show-shading-controls").setAction(a);
        }
        if (this.tabsHash_.get("contour-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-contour-controls", "contour-controls");
            viewPMenu.getItemByName("show-contour-controls").setAction(a);
        }
        if (this.tabsHash_.get("vector-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-vector-controls", "vector-controls");
            viewPMenu.getItemByName("show-vector-controls").setAction(a);
        }
        if (this.tabsHash_.get("label-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-label-controls", "label-controls");
            viewPMenu.getItemByName("show-label-controls").setAction(a);
        }
        if (this.tabsHash_.get("alpha-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-alpha-controls", "alpha-controls");
            viewPMenu.getItemByName("show-alpha-controls").setAction(a);
        }
        if (this.tabsHash_.get("numberlay-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-numberlay-controls", "numberlay-controls");
            viewPMenu.getItemByName("show-numberlay-controls").setAction(a);
        }
        viewPMenu.refresh();
    }

    private void attachListeners() {
        this.addChangeListener(e -> this.refresh());
    }

    public int getMaxPaneWidth() {
        return this.maxPaneWidth_;
    }

    public void setSelectedComponent(String tabname) {
        PanAbstractControlsPanel acp = this.getComponent(tabname);
        if (acp != null) {
            this.setSelectedComponent(acp);
        }
    }

    public PanAbstractControlsPanel getComponent(String tabname) {
        if (tabname == null) {
            return null;
        }
        PanPlotType ptype = this.pmeta_.getType();
        if (tabname.equals("array-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("array-controls"))) {
            return this.tabsHash_.get("array-controls");
        }
        if (tabname.equals("scale-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("scale-controls"))) {
            return this.tabsHash_.get("scale-controls");
        }
        if (tabname.equals("grid-controls") || tabname.equals("map-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("grid-controls")) || tabname.equals(PanProperties.CONTROL_PROPS.getString("map-controls"))) {
            if (ptype == PanPlotType.LON_LAT) {
                int mapIndex;
                PanAbstractControlsPanel llmapcc = this.tabsHash_.get("map-controls");
                PanAbstractControlsPanel zonalcc = this.tabsHash_.get("grid-controls");
                int n = mapIndex = llmapcc == null ? -1 : this.indexOfComponent(llmapcc);
                if (mapIndex > -1) {
                    return llmapcc;
                }
                return zonalcc;
            }
            if (ptype == PanPlotType.LL_TRAJ) {
                return this.tabsHash_.get("map-controls");
            }
            return this.tabsHash_.get("grid-controls");
        }
        if (tabname.equals("overlay-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("overlay-controls"))) {
            return this.tabsHash_.get("overlay-controls");
        }
        if (tabname.equals("shading-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("shading-controls"))) {
            return this.tabsHash_.get("shading-controls");
        }
        if (tabname.equals("stroke-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("stroke-controls"))) {
            return this.tabsHash_.get("stroke-controls");
        }
        if (tabname.equals("contour-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("contour-controls"))) {
            return this.tabsHash_.get("contour-controls");
        }
        if (tabname.equals("vector-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("vector-controls"))) {
            return this.tabsHash_.get("vector-controls");
        }
        if (tabname.equals("label-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("label-controls"))) {
            return this.tabsHash_.get("label-controls");
        }
        if (tabname.equals("numberlay-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("numberlay-controls"))) {
            return this.tabsHash_.get("numberlay-controls");
        }
        return null;
    }

    public void refresh() {
        Container c = this.getTopLevelAncestor();
        if (c == null) {
            return;
        }
        PanMenuBar mbar = this.parent_.getPanMenuBar();
        GissMenu viewPMenu = mbar.getMenuByName("view-plot-menu");
        if (viewPMenu == null) {
            return;
        }
        PanAbstractControlsPanel tab = (PanAbstractControlsPanel)this.getSelectedComponent();
        if (tab == null) {
            return;
        }
        tab.refresh();
        JMenuItem item = null;
        item = tab == this.tabsHash_.get("array-controls") ? viewPMenu.getItemByName("show-array-controls") : (tab == this.tabsHash_.get("scale-controls") ? viewPMenu.getItemByName("show-scale-controls") : (tab == this.tabsHash_.get("grid-controls") ? viewPMenu.getItemByName("show-grid-controls") : (tab == this.tabsHash_.get("stroke-controls") ? viewPMenu.getItemByName("show-stroke-controls") : (tab == this.tabsHash_.get("overlay-controls") ? viewPMenu.getItemByName("show-overlay-controls") : (tab == this.tabsHash_.get("shading-controls") ? viewPMenu.getItemByName("show-shading-controls") : (tab == this.tabsHash_.get("contour-controls") ? viewPMenu.getItemByName("show-contour-controls") : (tab == this.tabsHash_.get("vector-controls") ? viewPMenu.getItemByName("show-vector-controls") : (tab == this.tabsHash_.get("label-controls") ? viewPMenu.getItemByName("show-label-controls") : viewPMenu.getItemByName("show-grid-controls")))))))));
        if (item != null) {
            ((JRadioButtonMenuItem)item).setSelected(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanControlsTabbedPane panControlsTabbedPane = this;
        synchronized (panControlsTabbedPane) {
            for (String key : this.tabsHash_.keySet()) {
                PanAbstractControlsPanel acp = this.tabsHash_.get(key);
                if (acp == null) continue;
                acp.flush();
            }
            this.tabsHash_.clear();
            if (this.pmeta_ != null) {
                this.pmeta_.flush();
            }
        }
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        if (pname == null) {
            return;
        }
    }
}

