/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.array.NcArrayDiscreteTrajectory;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCartesian;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereCAMSE;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereGMAO;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReduced;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReduced2D;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataListener;
import gov.nasa.giss.panoply.plotui.table.PanArray1DTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArray2DAverageTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArray2DTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArrayCubedSphereCAMSETableModel;
import gov.nasa.giss.panoply.plotui.table.PanArrayCubedSphereGMAOTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArrayDataTable;
import gov.nasa.giss.panoply.plotui.table.PanArrayLLReducedTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArrayLonLatTrajectoryTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArrayTableModel;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.label.VerticalLabel;
import gov.nasa.giss.ui.table.TableRowHeader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanArrayDataPanel
extends JPanel
implements PanDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotType ptype_;
    private final NcArray array_;
    private NcAxis xAxis_;
    private NcAxis yAxis_;
    private JScrollPane spane1_;
    private JScrollPane spane2_;
    private PanArrayDataTable table1_;
    private PanArrayDataTable table2_;
    private PanArrayTableModel tmodel1_;
    private PanArrayTableModel tmodel2_;
    private TableRowHeader table1RowHeader_;
    private JLabel[] sliceLabels_;
    private JLabel xAxisLabel_;
    private VerticalLabel yAxisLabel_;
    private PanStringComboBox valFormatCombo_;
    private PanStringComboBox hdrFormatCombo_;
    private boolean changeableHeaders_;
    private PanCheckBox flipbtCB_;
    private PanCheckBox fliplrCB_;
    private PanCheckBox showIndicesCB_;

    public PanArrayDataPanel(PanPlotType type, PanData data, int vindex) {
        this.ptype_ = type;
        this.array_ = data.getArray(vindex);
        if (this.array_ == null) {
            throw new IllegalArgumentException("Array " + vindex + " is null");
        }
        if (this.array_ instanceof NcArray2D) {
            this.xAxis_ = ((NcArray2D)this.array_).getXAxis();
            this.yAxis_ = ((NcArray2D)this.array_).getYAxis();
        } else if (this.array_ instanceof NcArray1D) {
            if (this.ptype_ == PanPlotType.HORZ_LINE) {
                this.xAxis_ = ((NcArray1D)this.array_).getAxis();
            } else {
                this.yAxis_ = ((NcArray1D)this.array_).getAxis();
            }
        } else if (!(this.array_ instanceof NcArrayLonLatReduced || this.array_ instanceof NcArrayLonLatReduced2D || this.array_ instanceof NcArrayLonLatCubedSphereCAMSE || this.array_ instanceof NcArrayDiscreteTrajectory)) {
            LOGGER.debug("Not a recognized NcArray");
        }
        this.setLayout(new BorderLayout());
        this.setBorder(PanGuiUtils.STD_BORDER);
        this.setOpaque(false);
        JPanel topPanel = this.constructTopPanel();
        JPanel tablePanel = this.constructTablePanel();
        this.add((Component)topPanel, "North");
        this.add((Component)tablePanel, "Center");
        this.attachListeners();
        data.addDataListener(this);
    }

    private JPanel constructTopPanel() {
        NcDimension[] freeDims = this.array_.getFreeDimensions();
        int scount = freeDims.length;
        this.sliceLabels_ = new JLabel[scount];
        for (int i = 0; i < scount; ++i) {
            this.sliceLabels_[i] = freeDims[i] == null ? null : new JLabel("");
        }
        this.updateLabels();
        int rows = this.array_ instanceof NcArray1D ? Math.max(5, scount - 1) : Math.max(5, scount - 2);
        FlexingGridLayout fglTop = new FlexingGridLayout(2, rows, 2, 1);
        fglTop.setRigidWidth(true);
        fglTop.setRigidHeight(true);
        JPanel panel = new JPanel(fglTop);
        JLabel datasetLabel = new JLabel("Dataset:\u2009" + this.array_.getDataset().getName());
        StringBuilder sb = new StringBuilder("Variable:\u2009").append(this.array_.getShortName());
        if (this.array_.getLongName() != null) {
            sb.append(", ").append(this.array_.getLongName());
        }
        JLabel varLabel = new JLabel(sb.toString());
        panel.add((Component)datasetLabel, new FGConstraint(0, 0));
        panel.add((Component)varLabel, new FGConstraint(0, 1));
        String unitsStr = this.array_.getUnitsString();
        if (unitsStr != null && !unitsStr.isEmpty() && !unitsStr.equals("1")) {
            JLabel unitsLabel = new JLabel("Units:\u2009" + unitsStr);
            panel.add((Component)unitsLabel, new FGConstraint(0, 2));
        }
        if (this.sliceLabels_ != null) {
            int row = 0;
            for (JLabel label : this.sliceLabels_) {
                if (label == null) continue;
                panel.add((Component)label, new FGConstraint(1, row));
                ++row;
            }
        }
        panel.setOpaque(false);
        return panel;
    }

    private JPanel constructTablePanel() {
        StringBuilder sb;
        String uu;
        String nn;
        String headerFormat = "%.7G";
        if (this.array_ instanceof NcArray1D) {
            this.tmodel1_ = this.ptype_ == PanPlotType.HORZ_LINE ? new PanArray1DTableModel((NcArray1D)this.array_, PanArray1DTableModel.Direction.HORIZONTAL) : new PanArray1DTableModel((NcArray1D)this.array_, PanArray1DTableModel.Direction.VERTICAL);
            this.table1_ = new PanArrayDataTable(this.tmodel1_);
            this.table1RowHeader_ = this.ptype_ == PanPlotType.VERT_LINE ? new TableRowHeader((JTable)this.table1_, this.getRowHeaders(this.tmodel1_)) : new TableRowHeader((JTable)this.table1_, new String[]{"Val"});
            this.changeableHeaders_ = true;
            headerFormat = "%.4f";
        } else if (this.array_ instanceof NcArrayLonLatReduced) {
            this.tmodel1_ = new PanArrayLLReducedTableModel(this.array_);
            this.table1_ = new PanArrayDataTable(this.tmodel1_);
            this.table1RowHeader_ = new TableRowHeader((JTable)this.table1_, this.getRowHeaders(this.tmodel1_));
        } else if (this.array_ instanceof NcArrayLonLatCubedSphereCAMSE) {
            this.tmodel1_ = new PanArrayCubedSphereCAMSETableModel(this.array_);
            this.table1_ = new PanArrayDataTable(this.tmodel1_);
            this.table1RowHeader_ = new TableRowHeader((JTable)this.table1_, this.getRowHeaders(this.tmodel1_));
        } else if (this.array_ instanceof NcArrayLonLatCubedSphereGMAO) {
            this.tmodel1_ = new PanArrayCubedSphereGMAOTableModel((NcArrayLonLatCubedSphereGMAO)this.array_);
            this.table1_ = new PanArrayDataTable(this.tmodel1_);
            this.table1RowHeader_ = new TableRowHeader((JTable)this.table1_, this.getRowHeaders(this.tmodel1_));
        } else if (this.array_ instanceof NcArray2D) {
            this.tmodel1_ = new PanArray2DTableModel((NcArray2D)this.array_);
            this.table1_ = new PanArrayDataTable(this.tmodel1_);
            if (this.array_ instanceof NcArrayLonLatCartesian) {
                this.tmodel2_ = new PanArray2DAverageTableModel((NcArray2D)this.array_);
                this.table2_ = new PanArrayDataTable(this.tmodel2_);
            }
            this.table1RowHeader_ = new TableRowHeader((JTable)this.table1_, this.getRowHeaders(this.tmodel1_));
            this.changeableHeaders_ = true;
        } else if (this.array_ instanceof NcArrayDiscreteTrajectory) {
            this.tmodel1_ = new PanArrayLonLatTrajectoryTableModel(this.array_);
            this.table1_ = new PanArrayDataTable(this.tmodel1_);
            this.table1RowHeader_ = new TableRowHeader((JTable)this.table1_, this.getRowHeaders(this.tmodel1_));
            for (int i = 0; i < this.tmodel1_.getColumnCount(); ++i) {
                TableColumnModel tcm = this.table1_.getColumnModel();
                TableColumn column = tcm.getColumn(i);
                TableCellRenderer tcr = this.table1_.getCellRenderer(0, i);
                Object value = this.table1_.getValueAt(0, i);
                Component c = tcr.getTableCellRendererComponent(this.table1_, value, false, false, 0, i);
                int ww = c.getPreferredSize().width + 24;
                column.setPreferredWidth(ww);
            }
        } else {
            LOGGER.debug("Apaprently I don't know how to create a table model for this array type.");
        }
        this.spane1_ = new JScrollPane(this.table1_);
        if (this.table1RowHeader_ != null) {
            this.spane1_.setRowHeaderView(this.table1RowHeader_);
        }
        this.spane2_ = null;
        if (this.table2_ != null) {
            this.spane2_ = new JScrollPane(this.table2_);
            this.spane2_.setVerticalScrollBarPolicy(this.spane1_.getVerticalScrollBarPolicy());
            JScrollBar vbar = this.spane1_.getVerticalScrollBar();
            this.spane2_.setVerticalScrollBar(vbar);
            this.spane2_.updateUI();
            this.spane1_.updateUI();
            int xWidth = this.spane2_.getInsets().left + this.table2_.getPreferredSize().width + vbar.getPreferredSize().width + this.spane2_.getInsets().right;
            this.spane2_.setPreferredSize(new Dimension(xWidth, this.spane2_.getPreferredSize().height));
            this.spane2_.setMaximumSize(new Dimension(xWidth, this.spane2_.getMaximumSize().height));
            this.spane2_.setMinimumSize(new Dimension(xWidth, this.spane2_.getMinimumSize().height));
        }
        FlexingGridLayout fglbottom = new FlexingGridLayout(3, 3, 2, 2);
        fglbottom.setColumnWeight(1, 9999.0f);
        fglbottom.setRowWeight(1, 9999.0f);
        JPanel panel = new JPanel(fglbottom);
        panel.setOpaque(false);
        if (this.xAxis_ != null) {
            nn = this.xAxis_.getLongName();
            uu = this.xAxis_.getUnitsString();
            sb = new StringBuilder("X Axis");
            if (nn != null && !nn.isEmpty() || uu != null && !uu.isEmpty()) {
                sb.append(":");
                if (nn != null && !nn.isEmpty()) {
                    sb.append(' ').append(nn);
                }
                if (uu != null && !uu.isEmpty()) {
                    sb.append(" (").append(uu).append(")");
                }
            }
            this.xAxisLabel_ = new JLabel(sb.toString());
            panel.add((Component)this.xAxisLabel_, new FGConstraint(0, 0, 3, 1, 0.5, 0.5));
        }
        if (this.yAxis_ != null) {
            nn = this.yAxis_.getLongName();
            uu = this.yAxis_.getUnitsString();
            sb = new StringBuilder("Y Axis");
            if (nn != null && !nn.isEmpty() || uu != null && !uu.isEmpty()) {
                sb.append(":");
                if (nn != null && !nn.isEmpty()) {
                    sb.append(' ').append(nn);
                }
                if (uu != null && !uu.isEmpty()) {
                    sb.append(" (").append(uu).append(")");
                }
            }
            this.yAxisLabel_ = new VerticalLabel(sb.toString());
            panel.add((Component)this.yAxisLabel_, new FGConstraint(0, 1));
        }
        if (this.table2_ != null) {
            panel.add((Component)this.spane1_, new FGConstraint(1, 1, 1, 1, true));
            panel.add((Component)this.spane2_, new FGConstraint(2, 1, 1, 1, true));
        } else {
            panel.add((Component)this.spane1_, new FGConstraint(1, 1, 2, 1, 1.0, 1.0, true));
        }
        String pfFormat = PanPreferences.getSharedInstance().getString("plot:scale.tick.format");
        PanLabel valFormatLabel = PanLabel.small("Data Format:\u2009");
        PanLabel hdrFormatLabel = PanLabel.small("Row/Col Header Format:\u2009");
        this.valFormatCombo_ = PanStringComboBox.smallNumberFormatCombo(null);
        this.hdrFormatCombo_ = PanStringComboBox.smallNumberFormatCombo(null);
        this.valFormatCombo_.setSelectedItem(pfFormat);
        this.valFormatCombo_.setMaximumSize(this.valFormatCombo_.getPreferredSize());
        this.hdrFormatCombo_.setSelectedItem(headerFormat);
        this.hdrFormatCombo_.setMaximumSize(this.hdrFormatCombo_.getPreferredSize());
        this.hdrFormatCombo_.setEnabled(this.changeableHeaders_);
        if (this.table1_ != null) {
            PrintfFormat formatter = new PrintfFormat(pfFormat);
            this.table1_.setDataFormatter(formatter);
            this.table1_.setHeaderFormatter(new PrintfFormat(headerFormat));
            if (this.table2_ != null) {
                this.table2_.setDataFormatter(formatter);
            }
        }
        this.flipbtCB_ = PanCheckBox.small("Flip table B/T");
        this.fliplrCB_ = PanCheckBox.small("Flip table L/R");
        this.showIndicesCB_ = PanCheckBox.small("Show cell indices");
        if (this.ptype_ == PanPlotType.HORZ_LINE) {
            this.flipbtCB_.setEnabled(false);
        } else if (this.ptype_ == PanPlotType.VERT_LINE) {
            this.fliplrCB_.setEnabled(false);
        }
        if (this.array_ instanceof NcArrayLonLatReduced || this.array_ instanceof NcArrayLonLatCubedSphereCAMSE || this.array_ instanceof NcArrayDiscreteTrajectory) {
            this.fliplrCB_.setEnabled(false);
            this.showIndicesCB_.setEnabled(false);
        }
        QuickBox formatBox = QuickBox.createCenterBox(valFormatLabel, this.valFormatCombo_, Box.createHorizontalStrut(100), this.flipbtCB_, this.fliplrCB_, Box.createHorizontalStrut(100), this.showIndicesCB_, Box.createHorizontalStrut(100), hdrFormatLabel, this.hdrFormatCombo_);
        panel.add((Component)formatBox, new FGConstraint(0, 2, 3, 1, 0.5, 0.5));
        return panel;
    }

    private void attachListeners() {
        this.valFormatCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            PrintfFormat formatter = new PrintfFormat(this.valFormatCombo_.getSelectedString());
            if (this.table1_ != null) {
                this.table1_.setDataFormatter(formatter);
            }
            if (this.table2_ != null) {
                this.table2_.setDataFormatter(formatter);
            }
        });
        this.hdrFormatCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            PrintfFormat formatter = new PrintfFormat(this.hdrFormatCombo_.getSelectedString());
            if (this.table1_ != null) {
                this.table1_.setHeaderFormatter(formatter);
            }
            if (this.table1RowHeader_ != null) {
                this.table1RowHeader_.setValues(this.getRowHeaders(this.tmodel1_));
            }
        });
        this.flipbtCB_.addItemListener(e -> {
            boolean checked = this.flipbtCB_.isSelected();
            if (this.tmodel1_ != null) {
                this.tmodel1_.setFlipBT(checked);
            }
            if (this.tmodel2_ != null) {
                this.tmodel2_.setFlipBT(checked);
            }
            if (this.table1RowHeader_ != null) {
                this.table1RowHeader_.setValues(this.getRowHeaders(this.tmodel1_));
            }
        });
        this.fliplrCB_.addItemListener(e -> {
            boolean checked = this.fliplrCB_.isSelected();
            if (this.tmodel1_ != null) {
                this.tmodel1_.setFlipLR(checked);
            }
            if (this.tmodel2_ != null) {
                this.tmodel2_.setFlipLR(checked);
            }
        });
        this.showIndicesCB_.addItemListener(e -> {
            boolean checked = this.showIndicesCB_.isSelected();
            if (this.tmodel1_ != null) {
                this.tmodel1_.setShowCellIndices(checked);
            }
            if (this.tmodel2_ != null) {
                this.tmodel2_.setShowCellIndices(checked);
            }
            if (this.table1RowHeader_ != null) {
                this.table1RowHeader_.setValues(this.getRowHeaders(this.tmodel1_));
            }
            if (checked) {
                this.hdrFormatCombo_.setEnabled(false);
                if (this.xAxis_ != null) {
                    this.xAxisLabel_.setText("X Axis:\u2009" + this.xAxis_.getLongName() + " - Cell Index");
                }
                if (this.yAxis_ != null) {
                    this.yAxisLabel_.setText("Y Axis:\u2009" + this.yAxis_.getLongName() + " - Cell Index");
                }
            } else {
                this.hdrFormatCombo_.setEnabled(this.changeableHeaders_);
                if (this.xAxis_ != null) {
                    this.xAxisLabel_.setText("X Axis:\u2009" + this.xAxis_.getLongName() + " (" + this.xAxis_.getUnitsString() + ") ");
                }
                if (this.yAxis_ != null) {
                    this.yAxisLabel_.setText("Y Axis:\u2009" + this.yAxis_.getLongName() + " (" + this.yAxis_.getUnitsString() + ")");
                }
            }
        });
    }

    public void refresh() {
        if (this.spane2_ != null) {
            if (this.spane1_.getHorizontalScrollBar().isVisible()) {
                this.spane2_.setHorizontalScrollBarPolicy(32);
            } else {
                this.spane2_.setHorizontalScrollBarPolicy(31);
            }
        }
        if (this.table1_ != null) {
            this.table1_.repaint();
        }
        if (this.table2_ != null) {
            this.table2_.repaint();
        }
    }

    private String[] getRowHeaders(PanArrayTableModel model) {
        int irows = model.getRowCount();
        String[] headers = new String[irows];
        for (int j = 0; j < irows; ++j) {
            headers[j] = model.getRowName(j);
        }
        return headers;
    }

    public final void updateLabels() {
        NcDimension[] freeDims = this.array_.getFreeDimensions();
        for (int i = 0; i < freeDims.length; ++i) {
            if (this.sliceLabels_[i] == null) continue;
            int numIndices = freeDims[i].getLength();
            int index = this.array_.getSliceIndex(i);
            if (index > numIndices) {
                this.sliceLabels_[i].setText("Zonal Average");
            } else {
                StringBuilder sb = new StringBuilder("Slice:\u2009").append(freeDims[i].getLongName()).append(' ');
                if (index == -1) {
                    sb.append(", Average over ").append(numIndices).append(" indices in dimension");
                } else if (index < numIndices) {
                    sb.append('[').append(index + 1).append(" of ").append(numIndices).append("] = ");
                    if (freeDims[i].hasBounds()) {
                        sb.append(freeDims[i].formattedBoundsAt(index));
                    } else {
                        sb.append(freeDims[i].formattedValueAt(index));
                    }
                    String us = freeDims[i].getUnitsString();
                    if (us != null && us.length() > 0) {
                        sb.append(' ').append(us);
                    }
                } else {
                    LOGGER.warn("Weird value for 'index'");
                }
                this.sliceLabels_[i].setText(sb.toString() + "  ");
            }
            this.sliceLabels_[i].repaint();
        }
    }

    @Override
    public void dataChanged(PanDataEvent e) {
        if (e == null) {
            LOGGER.trace("null PanDataEvent");
            return;
        }
        EventQueue.invokeLater(() -> {
            this.updateLabels();
            this.refresh();
        });
    }
}

