/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanPanel;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.util.task.Task;
import java.awt.Component;
import java.awt.Container;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanAbstractControlsPanel
extends PanPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    protected PanPlotMeta pmeta_;
    protected PanPlotType ptype_;
    protected PanData data_;
    protected PanMenuBar mbar_;

    public PanAbstractControlsPanel(String name, PanPlotMeta pmeta, PanMenuBar mbar) {
        this.setName(name);
        this.setOpaque(false);
        this.pmeta_ = pmeta;
        this.data_ = pmeta.getData();
        this.ptype_ = pmeta.getType();
        this.mbar_ = mbar;
    }

    public PanPlotFrame getParentFrame() {
        Container tla = this.getTopLevelAncestor();
        if (tla instanceof PanPlotFrame) {
            return (PanPlotFrame)tla;
        }
        return null;
    }

    public void scheduleRefreshTask() {
        PanPlotFrame pf = this.getParentFrame();
        if (pf != null) {
            Task task = new Task("Update controls"){

                @Override
                protected void finishTask() {
                    PanAbstractControlsPanel.this.refresh();
                }
            };
            pf.addTask(task);
        }
    }

    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanAbstractControlsPanel panAbstractControlsPanel = this;
        synchronized (panAbstractControlsPanel) {
            for (Component child : this.getComponents()) {
                if (child == null || !(child instanceof PanAbstractControlsPanel)) continue;
                ((PanAbstractControlsPanel)child).flush();
            }
            this.removeAll();
        }
    }
}

