/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.data.PanDataLonLatZonal;
import gov.nasa.giss.panoply.plot.PanAxisTickFomatter;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotScaleMeta;
import gov.nasa.giss.panoply.plot.PanScaleTick;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanStringUtils;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.text.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanZonalAverageLinePlot
extends PanPlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanDataLonLatZonal dataLL_;
    private boolean isCompare_;
    private double lBound_ = -90.0;
    private double rBound_ = 90.0;
    protected PanAxisTickFomatter xAxisFormatter_;
    private boolean includeAxes_;
    private boolean axesOffset_;
    private float yAxisX_;
    private float xAxisY_;
    private Color[] lineColors_ = new Color[2];
    private BasicStroke[] lineStrokes_ = new BasicStroke[2];
    private float sLabelY_;
    private float sStrokeY_;
    private Font strokeLabelFont_;
    private float strokeLabelFhgt_;
    private boolean[] useCustomStrokeLabel_ = new boolean[2];
    private String[] customStrokeLabelText_ = new String[2];

    public PanZonalAverageLinePlot(PanPlotMeta pmeta) {
        super(pmeta);
        this.dataLL_ = (PanDataLonLatZonal)pmeta.getData();
        this.xAxisFormatter_ = new PanAxisTickFomatter(this.dataLL_.getXAxis());
        this.parameterChangedPrivate("all");
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        double yval;
        this.prepareToPaint();
        if (x < (double)this.gridLeft_ || x > (double)this.gridRight_) {
            return null;
        }
        if (y < (double)this.gridTop_ || y > (double)this.gridBottom_) {
            return null;
        }
        double xval = this.lBound_ + (this.rBound_ - this.lBound_) * (x - (double)this.gridLeft_) / (double)this.gridWidth_;
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        double logScaleMin = 0.0;
        double logScaleMax = 0.0;
        switch (smethod) {
            case LOG10: {
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
                yval = logScaleMin - (logScaleMax - logScaleMin) * (y - (double)this.gridBottom_) / (double)this.gridHeight_;
                yval = Math.pow(10.0, yval);
                break;
            }
            case LOG_E: {
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                yval = logScaleMin - (logScaleMax - logScaleMin) * (y - (double)this.gridBottom_) / (double)this.gridHeight_;
                yval = Math.pow(Math.E, yval);
                break;
            }
            default: {
                yval = scaleMin - (scaleMax - scaleMin) * (y - (double)this.gridBottom_) / (double)this.gridHeight_;
            }
        }
        return new Point2D.Double(xval, yval);
    }

    @Override
    protected void prepareToPaint() {
        super.prepareToPaint();
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        this.includeAxes_ = this.pmeta_.getBoolean("include.axes");
        this.axesOffset_ = this.pmeta_.getBoolean("axes.offset");
        Rectangle mfBounds = this.pmeta_.getLayout().getRect("bounds.figure");
        Dimension gsize = this.pmeta_.getLayout().getDimension("size.gridding");
        Rectangle sBounds = this.pmeta_.getLayout().getRect("bounds.strokeinfo");
        this.gridWidth_ = gsize.width;
        this.gridHeight_ = gsize.height;
        this.gridLeft_ = (float)mfBounds.x + 0.5f * (float)(mfBounds.width - gsize.width);
        this.gridTop_ = mfBounds.y;
        this.gridRight_ = this.gridLeft_ + this.gridWidth_;
        this.gridBottom_ = this.gridTop_ + this.gridHeight_;
        this.tickLengthMajor_ = Math.max(4.0f, scaling * 6.0f);
        this.tickLengthMinor_ = Math.max(2.0f, scaling * 3.0f);
        this.tickLabelOffset_ = Math.max(2.0f, scaling * 3.0f);
        int tickWeight = MathUtils.constrain0(200, this.pmeta_.getInt("axes.tickmark.weight"));
        this.tickStroke_ = this.axesOffset_ ? this.borderStroke_ : PanGraphicUtils.tickStroke((int)(0.01 * (double)tickWeight * (double)sfactor));
        this.yAxisX_ = this.axesOffset_ ? this.gridLeft_ - this.tickLengthMajor_ : this.gridLeft_;
        this.xAxisY_ = this.axesOffset_ ? this.gridBottom_ + this.tickLengthMajor_ : this.gridBottom_;
        this.sLabelY_ = (float)sBounds.y + 0.5f * (float)sBounds.height;
        this.sStrokeY_ = this.sLabelY_ - 0.4f * this.strokeLabelFhgt_;
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        Graphics2D g2d = (Graphics2D)gx.create();
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.borderStroke_);
        GraphicUtils.drawRect(g2d, this.gridLeft_, this.gridTop_, this.gridWidth_, this.gridHeight_);
        this.drawXAxis(g2d);
        if (this.includeAxes_) {
            this.drawXAxisLabel(g2d);
        }
        int maxLabelWidth = this.drawYAxis(g2d);
        if (this.includeAxes_) {
            this.drawYAxisLabel(g2d, maxLabelWidth);
        }
        this.drawCurve(g2d);
        if (this.pmeta_.getBoolean("include.strokeinfo")) {
            this.drawCurveLabels(g2d);
        }
        g2d.dispose();
        this.needsDataRedraw_ = false;
    }

    protected void drawXAxis(Graphics2D g2d) {
        if (this.axesOffset_ && this.includeAxes_) {
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.borderStroke_);
            GraphicUtils.drawLine(g2d, this.gridLeft_, this.xAxisY_, this.gridRight_, this.xAxisY_);
        }
        this.drawScalarXAxisTicks(g2d);
    }

    private void drawScalarXAxisTicks(Graphics2D g2d) {
        int divs = this.xMajorDiv_ * this.xMinorDiv_;
        double invDivs = 1.0 / (double)divs;
        float invDivsF = (float)invDivs;
        double delta = (this.rBound_ - this.lBound_) * invDivs;
        for (int i = 0; i <= divs; ++i) {
            boolean isMajor;
            float x = this.gridLeft_ + (float)i * this.gridWidth_ * invDivsF;
            boolean isNearEdge = Math.abs(x - this.gridLeft_) < EDGE_TOLERANCE || Math.abs(x - this.gridRight_) < EDGE_TOLERANCE;
            boolean bl = isMajor = i % this.xMinorDiv_ == 0;
            if (isMajor) {
                double axisVal = this.lBound_ + (double)i * delta;
                String labelstr = this.xAxisFormatter_.format(axisVal);
                this.drawXAxisTickLabel(g2d, labelstr, x);
                if (this.gridStroke_ != null && !isNearEdge) {
                    g2d.setColor(this.getForeground());
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridBottom_);
                }
            }
            float tt = isMajor ? this.tickLengthMajor_ : this.tickLengthMinor_;
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.tickStroke_);
            if (this.axesOffset_ && this.includeAxes_) {
                GraphicUtils.drawLine(g2d, x, this.xAxisY_ + 0.5f * tt, x, this.xAxisY_ - 0.5f * tt);
                continue;
            }
            if (isNearEdge) continue;
            GraphicUtils.drawLine(g2d, x, this.gridTop_, x, this.gridTop_ + tt);
            GraphicUtils.drawLine(g2d, x, this.gridBottom_, x, this.gridBottom_ - tt);
        }
    }

    private String getXAxisLabelStr() {
        if (this.xAxisLabelText_ != null) {
            return this.xAxisLabelText_;
        }
        return "Latitude (\u00b0N)";
    }

    private int drawXAxisTickLabel(Graphics2D g2d, String labelstr, float tickX) {
        String label;
        if (!this.includeAxes_) {
            return 0;
        }
        g2d.setFont(this.xAxisTickFont_);
        g2d.setColor(this.getForeground());
        String string = label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertENotationToSuperscript(labelstr, g2d) : labelstr;
        if (label == null) {
            return 0;
        }
        float labelWidth = GraphicUtils.stringWidth(label, g2d);
        float x = tickX - 0.5f * labelWidth;
        float y = this.xAxisY_ + 1.5f * this.tickLabelOffset_ + this.xAxisTickFhgt_;
        GraphicUtils.drawString(g2d, (Object)label, x, y);
        return Math.round(labelWidth);
    }

    protected void drawXAxisLabel(Graphics2D g2d) {
        if (!this.includeAxes_) {
            return;
        }
        String labelstr = this.getXAxisLabelStr();
        if (labelstr == null || labelstr.isEmpty()) {
            return;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.xAxisLabelFont_);
        labelstr = GraphicUtils.trimStringToFit(labelstr, g2d, (int)this.gridWidth_);
        String label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertCaretNotationToSuperscript(labelstr, g2d) : labelstr;
        int labelWidth = (int)GraphicUtils.stringWidth(label, g2d);
        float x = this.gridLeft_ + 0.5f * (this.gridWidth_ - (float)labelWidth);
        float y = this.xAxisY_ + this.tickLabelOffset_ + this.xAxisTickFhgt_ + 0.33f * this.xAxisTickFhgt_ + this.xAxisLabelFhgt_;
        GraphicUtils.drawString(g2d, (Object)label, x, y);
    }

    private int drawYAxis(Graphics2D g2d) {
        return this.drawYAxisTicks(g2d);
    }

    private int drawYAxisTicks(Graphics2D g2d) {
        PanScaleTick[] ticks;
        double ydelta;
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        PrintfFormat formatter = smeta.getFormatter();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        double logScaleMin = 0.0;
        double logScaleMax = 0.0;
        switch (smethod) {
            case LOG10: {
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
                ydelta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
                break;
            }
            case LOG_E: {
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                ydelta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
                break;
            }
            default: {
                ydelta = (scaleMax - scaleMin) / (double)this.gridHeight_;
            }
        }
        double yscale = 1.0 / ydelta;
        int maxLabelWidth = 0;
        if (this.axesOffset_ && this.includeAxes_) {
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.borderStroke_);
            GraphicUtils.drawLine(g2d, this.yAxisX_, this.gridTop_, this.yAxisX_, this.gridBottom_);
        }
        for (PanScaleTick tick : ticks = smeta.getTicks()) {
            boolean isNearEdge;
            float y;
            double value = tick.getValue();
            double logValue = tick.getAlternativeValue();
            switch (smethod) {
                case LOG10: 
                case LOG_E: {
                    y = (float)((logValue - logScaleMin) * yscale);
                    break;
                }
                default: {
                    y = (float)((value - scaleMin) * yscale);
                }
            }
            y = this.gridBottom_ - y;
            boolean bl = isNearEdge = Math.abs(y - this.gridTop_) < EDGE_TOLERANCE || Math.abs(y - this.gridBottom_) < EDGE_TOLERANCE;
            if (tick.isMajor()) {
                int labelWidth = 0;
                switch (smethod) {
                    case LOG_E: {
                        labelWidth = this.drawYAxisTickLabelE(g2d, logValue, y);
                        break;
                    }
                    default: {
                        String labelstr = formatter.sprintfx(value);
                        labelWidth = this.drawYAxisTickLabel(g2d, labelstr, y);
                    }
                }
                maxLabelWidth = Math.max(maxLabelWidth, labelWidth);
                if (this.gridStroke_ != null && !isNearEdge) {
                    g2d.setColor(this.getForeground());
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridRight_, y);
                }
            }
            float tt = tick.isMajor() ? this.tickLengthMajor_ : this.tickLengthMinor_;
            g2d.setColor(this.getForeground());
            g2d.setStroke(this.tickStroke_);
            if (this.axesOffset_ && this.includeAxes_) {
                GraphicUtils.drawLine(g2d, this.yAxisX_ - 0.5f * tt, y, this.yAxisX_ + 0.5f * tt, y);
                continue;
            }
            if (isNearEdge) continue;
            GraphicUtils.drawLine(g2d, this.gridLeft_, y, this.gridLeft_ + tt, y);
            GraphicUtils.drawLine(g2d, this.gridRight_, y, this.gridRight_ - tt, y);
        }
        return maxLabelWidth;
    }

    protected String getYAxisLabelStr() {
        if (this.pmeta_.getBoolean("scale.label.custom")) {
            return this.pmeta_.getString("scale.label.text");
        }
        return this.data_.getDescription();
    }

    protected int drawYAxisTickLabel(Graphics2D g2d, String labelstr, double tickY) {
        String label;
        if (!this.includeAxes_) {
            return 0;
        }
        g2d.setFont(this.yAxisTickFont_);
        g2d.setColor(this.getForeground());
        String string = label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertENotationToSuperscript(labelstr, g2d) : labelstr;
        if (label == null) {
            return 0;
        }
        float labelWidth = GraphicUtils.stringWidth(label, g2d);
        float x = this.yAxisX_ - 1.5f * this.tickLabelOffset_ - labelWidth;
        float y = (float)tickY + 0.5f * this.yAxisTickFhgt_ - 1.0f;
        GraphicUtils.drawString(g2d, (Object)label, x, y);
        return Math.round(labelWidth);
    }

    protected int drawYAxisTickLabelE(Graphics2D g2d, double logValue, float tickY) {
        if (!this.includeAxes_) {
            return 0;
        }
        g2d.setFont(this.xAxisTickFont_);
        g2d.setColor(this.getForeground());
        AttributedString label = PanStringUtils.getSuperscriptedE(logValue, g2d);
        float labelWidth = GraphicUtils.stringWidth(label, g2d);
        float x = this.yAxisX_ - 1.5f * this.tickLabelOffset_ - labelWidth;
        float y = tickY + 0.5f * this.yAxisTickFhgt_ - 1.0f;
        GraphicUtils.drawString(g2d, (Object)label, x, y);
        return Math.round(labelWidth);
    }

    protected void drawYAxisLabel(Graphics2D g2d, int maxLabelWidth) {
        if (!this.includeAxes_) {
            return;
        }
        String labelstr = this.getYAxisLabelStr();
        if (labelstr == null || labelstr.isEmpty()) {
            return;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.yAxisLabelFont_);
        labelstr = GraphicUtils.trimStringToFit(labelstr, g2d, (int)this.gridHeight_);
        String label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertCaretNotationToSuperscript(labelstr, g2d) : labelstr;
        int labelWidth = (int)GraphicUtils.stringWidth(label, g2d);
        float x = this.yAxisX_ - 1.5f * this.tickLabelOffset_ - (float)maxLabelWidth - 0.67f * this.yAxisTickFhgt_;
        float y = this.gridBottom_ - 0.5f * (this.gridHeight_ - (float)labelWidth);
        g2d.translate(x, y);
        g2d.rotate(-1.5707963267948966);
        GraphicUtils.drawString(g2d, (Object)label, 0, 0);
        g2d.rotate(1.5707963267948966);
        g2d.translate(-x, -y);
    }

    protected void drawCurve(Graphics2D g2d) {
        double ydelta;
        Rectangle oldClip = g2d.getClipBounds();
        Rectangle rr = new Rectangle((int)this.gridLeft_, (int)this.gridTop_ - 8, (int)this.gridWidth_, (int)this.gridHeight_ + 16);
        Rectangle ri = oldClip.intersection(rr);
        g2d.setClip(ri);
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        boolean isLogScale = false;
        double logScaleMin = 0.0;
        double logScaleMax = 0.0;
        switch (smethod) {
            case LOG10: {
                isLogScale = true;
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
                ydelta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
                break;
            }
            case LOG_E: {
                isLogScale = true;
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                ydelta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
                break;
            }
            default: {
                isLogScale = false;
                ydelta = (scaleMax - scaleMin) / (double)this.gridHeight_;
            }
        }
        double yscale = 1.0 / ydelta;
        double xdelta = (this.rBound_ - this.lBound_) / (double)this.gridWidth_;
        double xscale = 1.0 / xdelta;
        int istrokes = this.isCompare_ ? 2 : 1;
        for (int istroke = 0; istroke < istrokes; ++istroke) {
            if (this.lineStrokes_[istroke] == null) continue;
            double value = this.dataLL_.getRowAverageAt(istroke, 0);
            g2d.setColor(this.lineColors_[istroke]);
            g2d.setStroke(this.lineStrokes_[istroke]);
            boolean lastPtWasGood = false;
            GeneralPath path = new GeneralPath();
            int numPts = this.dataLL_.getHeight();
            for (int j = 0; j < numPts; ++j) {
                double axisX = this.dataLL_.getLatitude(j);
                value = this.dataLL_.getRowAverageAt(istroke, j);
                if (!Double.isNaN(value) && !Double.isInfinite(value)) {
                    switch (smethod) {
                        case LOG10: {
                            value = Math.log10(value);
                            break;
                        }
                        case LOG_E: {
                            value = Math.log(value);
                            break;
                        }
                    }
                }
                if (Double.isNaN(value)) {
                    if (lastPtWasGood) {
                        g2d.draw(path);
                        path.reset();
                    }
                    lastPtWasGood = false;
                    continue;
                }
                float y = Double.isInfinite(value) ? (value < 0.0 ? -1.0E9f : 1.0E9f) : (isLogScale ? (float)((value - logScaleMin) * yscale) : (float)((value - scaleMin) * yscale));
                float x = (float)((axisX - this.lBound_) * xscale);
                if (lastPtWasGood) {
                    path.lineTo(this.gridLeft_ + x, this.gridBottom_ - y);
                } else {
                    path.moveTo(this.gridLeft_ + x, this.gridBottom_ - y);
                }
                lastPtWasGood = true;
            }
            g2d.draw(path);
            path.reset();
        }
        g2d.setClip(oldClip);
    }

    protected void drawCurveLabels(Graphics2D g2d) {
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        int strokeLength = (int)(scaling * 20.0f);
        int lspace = (int)(scaling * 24.0f);
        g2d.setFont(this.strokeLabelFont_);
        String[] labels = new String[2];
        if (this.isCompare_) {
            String labelstr1 = this.useCustomStrokeLabel_[0] ? this.customStrokeLabelText_[0] : this.data_.getVarShortName(0);
            String labelstr2 = this.useCustomStrokeLabel_[1] ? this.customStrokeLabelText_[1] : this.data_.getVarShortName(1);
            int maxLWidth = (int)(0.5f * (this.gridWidth_ - 2.0f * (float)lspace));
            int maxTWidth = (int)(0.5f * (this.gridWidth_ - 2.0f * (float)lspace) - (float)lspace);
            labelstr1 = GraphicUtils.trimStringToFit(labelstr1, g2d, maxTWidth);
            labelstr2 = GraphicUtils.trimStringToFit(labelstr2, g2d, maxTWidth);
            int twidth1 = Math.min(maxTWidth, (int)GraphicUtils.stringWidth(labelstr1, g2d));
            int twidth2 = Math.min(maxTWidth, (int)GraphicUtils.stringWidth(labelstr2, g2d));
            int left1 = (int)(this.gridLeft_ + 0.5f * (float)(maxLWidth - twidth1));
            int left2 = (int)(this.gridLeft_ + (float)maxLWidth + (float)lspace + 0.5f * (float)(maxLWidth - twidth2));
            if (labelstr1.length() > 0 && this.lineStrokes_[0] != null) {
                g2d.setColor(this.lineColors_[0]);
                g2d.setStroke(this.lineStrokes_[0]);
                GraphicUtils.drawLine(g2d, left1, this.sStrokeY_, left1 + strokeLength, this.sStrokeY_);
                g2d.setColor(this.getForeground());
                String label1 = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertCaretNotationToSuperscript(labelstr1, g2d) : labelstr1;
                GraphicUtils.drawString(g2d, (Object)label1, (float)(left1 + lspace), this.sLabelY_);
            }
            if (labelstr2.length() > 0 && this.lineStrokes_[1] != null) {
                g2d.setColor(this.lineColors_[1]);
                g2d.setStroke(this.lineStrokes_[1]);
                GraphicUtils.drawLine(g2d, left2, this.sStrokeY_, left2 + strokeLength, this.sStrokeY_);
                g2d.setColor(this.getForeground());
                String label2 = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertCaretNotationToSuperscript(labelstr2, g2d) : labelstr2;
                GraphicUtils.drawString(g2d, (Object)label2, (float)(left2 + lspace), this.sLabelY_);
            }
        } else {
            String labelstr1;
            String string = labelstr1 = this.useCustomStrokeLabel_[0] ? this.customStrokeLabelText_[0] : this.data_.getDescription();
            if (labelstr1.length() > 0 && this.lineStrokes_[0] != null) {
                int maxTWidth = (int)(0.75f * this.gridWidth_ - (float)lspace);
                labelstr1 = GraphicUtils.trimStringToFit(labelstr1, g2d, maxTWidth);
                int tlength = Math.min(maxTWidth, (int)GraphicUtils.stringWidth(labelstr1, g2d));
                int totWidth = lspace + tlength;
                int left1 = (int)(this.gridLeft_ + 0.5f * (this.gridWidth_ - (float)totWidth));
                g2d.setColor(this.lineColors_[0]);
                g2d.setStroke(this.lineStrokes_[0]);
                GraphicUtils.drawLine(g2d, left1, this.sStrokeY_, left1 + strokeLength, this.sStrokeY_);
                g2d.setColor(this.getForeground());
                String label1 = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertCaretNotationToSuperscript(labelstr1, g2d) : labelstr1;
                GraphicUtils.drawString(g2d, (Object)label1, (float)(left1 + lspace), this.sLabelY_);
            }
        }
    }

    @Override
    public String describePoint(int x, int y) {
        Point2D.Double p2dClose;
        double ydelta;
        Point2D.Double p2d = this.transformXY2GridCoords(x, y);
        if (p2d == null) {
            return null;
        }
        double latitude = p2d.x;
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        double logScaleMin = 0.0;
        double logScaleMax = 0.0;
        switch (smethod) {
            case LOG10: {
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
                ydelta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
                break;
            }
            case LOG_E: {
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                ydelta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
                break;
            }
            default: {
                ydelta = (scaleMax - scaleMin) / (double)this.gridHeight_;
            }
        }
        double yscale = 1.0 / ydelta;
        double leastDY = -1.0;
        int dixForLeast = -1;
        int istrokes = this.isCompare_ ? 2 : 1;
        for (int istroke = 0; istroke < istrokes; ++istroke) {
            for (int dix = -3; dix <= 3; ++dix) {
                float dy;
                double value;
                p2dClose = this.transformXY2GridCoords(x + dix, y);
                if (p2dClose == null || Double.isNaN(value = this.dataLL_.getRowAverageAtAxisPt(istroke, p2dClose.x)) || Double.isInfinite(value)) continue;
                switch (smethod) {
                    case LOG10: {
                        value = Math.log10(value);
                        break;
                    }
                    case LOG_E: {
                        value = Math.log(value);
                        break;
                    }
                }
                if (Double.isNaN(value)) continue;
                switch (smethod) {
                    case LOG10: 
                    case LOG_E: {
                        dy = Double.isNaN(value) ? 1000.0f : (float)((double)y - ((double)this.gridBottom_ - (value - logScaleMin) * yscale));
                        break;
                    }
                    default: {
                        dy = Double.isNaN(value) ? 1000.0f : (float)((double)y - ((double)this.gridBottom_ - (value - scaleMin) * yscale));
                    }
                }
                double absDY = Math.abs(dy);
                if (!(leastDY < 0.0) && !(absDY < leastDY)) continue;
                leastDY = absDY;
                dixForLeast = dix;
            }
        }
        if (leastDY < 0.0 || leastDY > 10.0) {
            return null;
        }
        p2dClose = this.transformXY2GridCoords(x + dixForLeast, y);
        StringBuilder sb = new StringBuilder();
        sb.append("X: ").append(this.xAxisFormatter_.formatRaw(p2dClose.x)).append("\u00b0N").append('\n');
        this.dataLL_.describeDataAtAxisPt(sb, latitude);
        return sb.toString();
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        String fn;
        boolean changeAll = pname == null || "all".equals(pname);
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        if (changeAll || pname.contains("combination")) {
            String ctype = this.pmeta_.getString("combination");
            this.isCompare_ = PanCombinationType.COMPARE.matches(ctype);
        }
        if (changeAll || pname.contains(PanParamKeys.STROKE_COLOR[0]) || pname.contains(PanParamKeys.STROKE_STYLE[0]) || pname.contains(PanParamKeys.STROKE_WGT[0])) {
            this.lineColors_[0] = this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[0]);
            this.lineStrokes_[0] = PanGraphicUtils.roundStroke(this.pmeta_.getString(PanParamKeys.STROKE_STYLE[0]), this.pmeta_.getInt(PanParamKeys.STROKE_WGT[0]), sfactor);
        }
        if (changeAll || pname.contains(PanParamKeys.STROKE_COLOR[1]) || pname.contains(PanParamKeys.STROKE_STYLE[1]) || pname.contains(PanParamKeys.STROKE_WGT[1])) {
            this.lineColors_[1] = this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[1]);
            this.lineStrokes_[1] = PanGraphicUtils.roundStroke(this.pmeta_.getString(PanParamKeys.STROKE_STYLE[1]), this.pmeta_.getInt(PanParamKeys.STROKE_WGT[1]), sfactor);
        }
        if (changeAll || pname.contains(PanParamKeys.STROKE_LABEL_CUSTOM[0]) || pname.contains(PanParamKeys.STROKE_LABEL_CUSTOM[1]) || pname.contains(PanParamKeys.STROKE_LABEL_TEXT[0]) || pname.contains(PanParamKeys.STROKE_LABEL_TEXT[1])) {
            this.useCustomStrokeLabel_[0] = this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[0]);
            this.useCustomStrokeLabel_[1] = this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[1]);
            this.customStrokeLabelText_[0] = this.pmeta_.getString(PanParamKeys.STROKE_LABEL_TEXT[0]);
            this.customStrokeLabelText_[1] = this.pmeta_.getString(PanParamKeys.STROKE_LABEL_TEXT[1]);
        }
        if (changeAll || pname.contains("grid.style") || pname.contains("grid.weight")) {
            this.gridWeight_ = MathUtils.constrain0(200, this.pmeta_.getInt("grid.weight"));
            String gs = this.pmeta_.getString("grid.style");
            this.gridStroke_ = this.gridWeight_ > 0 ? PanGraphicUtils.buttMiterStroke(gs, this.gridWeight_, sfactor) : null;
            int borderWgt = Math.max(75, this.gridWeight_);
            this.borderStroke_ = PanGraphicUtils.solidStroke(borderWgt, sfactor);
        }
        if (changeAll || pname.contains("interpolate")) {
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("labels.font") || pname.contains("size.factor") || pname.contains("stroke.label.size")) {
            fn = this.pmeta_.getString("labels.font");
            this.strokeLabelFhgt_ = scaling * this.pmeta_.getFloat("stroke.label.size");
            this.strokeLabelFont_ = PanGraphicUtils.getFont(fn, this.strokeLabelFhgt_);
        }
        if (changeAll || pname.contains("labels.font") || pname.contains("size.factor") || pname.contains("xaxis.label.size") || pname.contains("xaxis.tick.size") || pname.contains("scale.tick.size") || pname.contains("scale.label.size")) {
            fn = this.pmeta_.getString("labels.font");
            this.xAxisLabelFhgt_ = scaling * this.pmeta_.getFloat("xaxis.label.size");
            this.xAxisTickFhgt_ = scaling * this.pmeta_.getFloat("xaxis.tick.size");
            this.xAxisLabelFont_ = PanGraphicUtils.getFont(fn, this.xAxisLabelFhgt_);
            this.xAxisTickFont_ = PanGraphicUtils.getFont(fn, this.xAxisTickFhgt_);
            LOGGER.trace("x tick hgt {}", (Object)Float.valueOf(this.xAxisTickFhgt_));
            this.yAxisLabelFhgt_ = scaling * this.pmeta_.getFloat("scale.label.size");
            this.yAxisTickFhgt_ = scaling * this.pmeta_.getFloat("scale.tick.size");
            this.yAxisLabelFont_ = PanGraphicUtils.getFont(fn, this.yAxisLabelFhgt_);
            this.yAxisTickFont_ = PanGraphicUtils.getFont(fn, this.yAxisTickFhgt_);
        }
        if (changeAll || pname.contains("xaxis.begin") || pname.contains("xaxis.end")) {
            this.lBound_ = this.pmeta_.getDouble("xaxis.begin");
            this.rBound_ = this.pmeta_.getDouble("xaxis.end");
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("xaxis.div.major") || pname.contains("xaxis.div.minor")) {
            int major = this.pmeta_.getInt("xaxis.div.major");
            int minor = this.pmeta_.getInt("xaxis.div.minor");
            major = Math.min(major, 25);
            major = Math.max(major, 1);
            minor = Math.min(minor, 25);
            minor = Math.max(minor, 1);
            this.xMajorDiv_ = major;
            this.xMinorDiv_ = minor;
        }
        if (changeAll || pname.contains("xaxis.tick.format")) {
            String s = this.pmeta_.getString("xaxis.tick.format");
            this.xAxisFormatter_.setPattern(s);
        }
        if (changeAll || pname.contains("xaxis.label.custom") || pname.contains("xaxis.label.text")) {
            this.xAxisLabelText_ = this.pmeta_.getBoolean("xaxis.label.custom") ? this.pmeta_.getString("xaxis.label.text") : null;
        }
    }
}

