/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.data.PanDataTimeY;
import gov.nasa.giss.panoply.plot.PanColorContourPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanTimeYPlot
extends PanColorContourPlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PanTimeYPlot(PanPlotMeta pmeta) {
        super(pmeta);
        if (this.xAxisFormatter_.isFormattedTime()) {
            String pattern = this.xAxisFormatter_.getPattern();
            LOGGER.trace("Time axis pattern {}", (Object)pattern);
            if (pattern != null) {
                if (pattern.endsWith("Z")) {
                    pattern = pattern.replace(" Z", "");
                    pattern = pattern.replace("Z", "");
                    this.xAxisFormatter_.setPattern(pattern);
                }
                this.pmeta_.setString("xaxis.tick.format", pattern);
            }
        }
        this.parameterChangedPrivate("all");
    }

    @Override
    protected String getXAxisLabelStr() {
        if (this.xAxisLabelText_ != null) {
            return this.xAxisLabelText_;
        }
        if (this.xAxisFormatter_.isFormattedTime()) {
            if (this.xAxisFormatter_.getPattern().startsWith("%")) {
                return "Time (" + this.xAxisFormatter_.getUnitsStr() + ")";
            }
            return "Time";
        }
        NcAxis xaxis = ((PanData2D)this.data_).getXAxis();
        String unitsStr = xaxis.getUnitsString();
        if (unitsStr == null || unitsStr.isEmpty()) {
            return "Time";
        }
        return "Time (" + unitsStr + ")";
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("xaxis.tick.format")) {
            String pattern = this.pmeta_.getString("xaxis.tick.format");
            this.xAxisFormatter_.setPattern(pattern);
            if (pattern != null && !pattern.isEmpty()) {
                ((PanDataTimeY)this.data_).setTimeFormat(pattern);
            }
        }
    }
}

