/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.ColorUtils;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.plot.PlotPiece;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.util.PanDevoMode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;

public abstract class PanPlotPiece
extends PlotPiece {
    public static final BasicStroke DEBUG_STROKE = GraphicUtils.buttMiterStroke(100.0f);
    protected static long pieceID_;
    protected PanPlotMeta pmeta_;

    public PanPlotPiece() {
        throw new IllegalArgumentException("Don't use this constructor");
    }

    public PanPlotPiece(PanPlotMeta pmeta) {
        ++pieceID_;
        this.pmeta_ = pmeta;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (c != null) {
            this.setForeground(ColorUtils.getXORColor(c));
        }
    }

    protected final void parameterChanged(String pname) {
        this.parameterChangedSelf(pname);
        this.parameterChangedChildren(pname);
    }

    protected void parameterChangedSelf(String pname) {
    }

    protected final void parameterChangedChildren(String pname) {
        ArrayList<PlotPiece> children = this.getChildren();
        if (children == null) {
            return;
        }
        for (PlotPiece child : children) {
            if (!(child instanceof PanPlotPiece)) continue;
            ((PanPlotPiece)child).parameterChanged(pname);
        }
    }

    @Override
    protected void paint(Graphics2D g2d, boolean printing) {
        super.paint(g2d, printing);
        if (PanDevoMode.isDebugBorders()) {
            g2d.setStroke(DEBUG_STROKE);
            g2d.setColor(Color.RED);
            GraphicUtils.drawRect(g2d, 0.5, 0.5, this.getWidth() - 1, this.getHeight() - 1);
        }
    }
}

