/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.plot.PlotPropertyMap;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataGeneral2D;
import gov.nasa.giss.panoply.data.PanDataLatTime;
import gov.nasa.giss.panoply.data.PanDataLatVert;
import gov.nasa.giss.panoply.data.PanDataLonLatGridded;
import gov.nasa.giss.panoply.data.PanDataLonLatTrajectory;
import gov.nasa.giss.panoply.data.PanDataLonLatZonal;
import gov.nasa.giss.panoply.data.PanDataLonTime;
import gov.nasa.giss.panoply.data.PanDataLonVert;
import gov.nasa.giss.panoply.data.PanDataTime1D;
import gov.nasa.giss.panoply.data.PanDataTimeLat;
import gov.nasa.giss.panoply.data.PanDataTimeVert;
import gov.nasa.giss.panoply.plot.PanColorContourPlot;
import gov.nasa.giss.panoply.plot.PanHorizontalLinePlot;
import gov.nasa.giss.panoply.plot.PanLatTimePlot;
import gov.nasa.giss.panoply.plot.PanLatVertPlot;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plot.PanLonTimePlot;
import gov.nasa.giss.panoply.plot.PanLonVertPlot;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plot.PanPlotLayoutMeta;
import gov.nasa.giss.panoply.plot.PanPlotScaleMeta;
import gov.nasa.giss.panoply.plot.PanPlotUtils;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.plot.PanTimeLatPlot;
import gov.nasa.giss.panoply.plot.PanTimeYPlot;
import gov.nasa.giss.panoply.plot.PanVerticalLinePlot;
import gov.nasa.giss.panoply.plot.PanZonalAverageLinePlot;
import gov.nasa.giss.panoply.plotui.PanControlsTabbedPane;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotHolder;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.panoply.util.PanVectorType;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.time.UnixTimeFormatter;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.task.Task;
import gov.nasa.giss.util.task.TaskListener;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import javax.swing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotMeta
extends PlotPropertyMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean NO_TASKS = true;
    private final PanPlotType ptype_;
    private PanData data_;
    private PanPlot plot_;
    private PanPlotFrame pframe_;
    private PanPlotScaleMeta smeta_;
    private PanProjectionMeta projmeta_;
    private PanPlotLayoutMeta layout_;
    private final PanActionHash actionHash_ = new PanActionHash(50);
    private boolean initializing_;
    private boolean replacing_;

    public PanPlotMeta(PanPlotType ptype, int sizeFactor) {
        this.ptype_ = ptype;
        this.layout_ = new PanPlotLayoutMeta(this);
        this.init(sizeFactor);
    }

    protected void init(int sizeFactor) {
        int hFactor;
        int wFactor;
        this.initializing_ = true;
        PanPreferences prefs = PanPreferences.getSharedInstance();
        switch (this.ptype_) {
            case LON_LAT: {
                wFactor = prefs.getInt("plot:lonlat.size.width");
                hFactor = prefs.getInt("plot:lonlat.size.height");
                break;
            }
            case LL_TRAJ: {
                wFactor = prefs.getInt("plot:lonlat.size.width");
                hFactor = prefs.getInt("plot:lonlat.size.height");
                break;
            }
            case LAT_TIME: {
                wFactor = prefs.getInt("plot:lattime.size.width");
                hFactor = prefs.getInt("plot:lattime.size.height");
                break;
            }
            case LAT_VERT: {
                wFactor = prefs.getInt("plot:latvert.size.width");
                hFactor = prefs.getInt("plot:latvert.size.height");
                break;
            }
            case LON_TIME: {
                wFactor = prefs.getInt("plot:lontime.size.width");
                hFactor = prefs.getInt("plot:lontime.size.height");
                break;
            }
            case LON_VERT: {
                wFactor = prefs.getInt("plot:lonvert.size.width");
                hFactor = prefs.getInt("plot:lonvert.size.height");
                break;
            }
            case TIME_LAT: {
                wFactor = prefs.getInt("plot:timelat.size.width");
                hFactor = prefs.getInt("plot:timelat.size.height");
                break;
            }
            case TIME_VERT: {
                wFactor = prefs.getInt("plot:timevert.size.width");
                hFactor = prefs.getInt("plot:timevert.size.height");
                break;
            }
            case COLOR_CONTOUR: {
                wFactor = prefs.getInt("plot:xy.size.width");
                hFactor = prefs.getInt("plot:xy.size.height");
                break;
            }
            case HORZ_LINE: 
            case LL_ZONAL: {
                wFactor = prefs.getInt("plot:lineplot.horz.size.width");
                hFactor = prefs.getInt("plot:lineplot.horz.size.height");
                break;
            }
            case VERT_LINE: {
                wFactor = prefs.getInt("plot:lineplot.vert.size.width");
                hFactor = prefs.getInt("plot:lineplot.vert.size.height");
                break;
            }
            default: {
                LOGGER.trace("Uncoded plot type {}", (Object)this.ptype_);
                wFactor = 80;
                hFactor = 45;
            }
        }
        if (wFactor < 20) {
            LOGGER.warn("Width factor {} too small; using min {}.", (Object)wFactor, (Object)20);
            wFactor = 20;
        } else if (wFactor > 100) {
            LOGGER.warn("Width factor {} too big; using max {}.", (Object)wFactor, (Object)100);
            wFactor = 100;
        }
        if (hFactor < 20) {
            LOGGER.warn("Height factor {} too small; using min {}.", (Object)hFactor, (Object)20);
            hFactor = 20;
        } else if (hFactor > 400) {
            LOGGER.warn("Height factor {} too big; using max {}.", (Object)hFactor, (Object)400);
            hFactor = 400;
        }
        this.setInt("size.factor", sizeFactor);
        this.setInt("size.height", hFactor);
        this.setInt("size.width", wFactor);
        this.set("combination", PanCombinationType.A1_ONLY.name());
        this.initCommonParams(prefs);
        this.initAxesParams(prefs);
        if (this.ptype_.isLinePlot()) {
            this.initLinePlotParams(prefs);
        } else {
            this.initColorContourParams(prefs);
            this.initVectorParams(prefs);
        }
        if (this.ptype_.isLonLatMap()) {
            this.initMapParams(prefs);
            if (this.ptype_ == PanPlotType.LL_TRAJ) {
                this.initTrajectoryParams(prefs);
            }
        }
        this.layout_.setInitialized();
        this.initializing_ = false;
    }

    private void initCommonParams(PanPreferences prefs) {
        this.setFloat("title.size", 16.0f);
        this.setFloat("subtitle.size", 12.0f);
        this.setFloat("footnote.size", 8.0f);
        this.setBoolean("include.title", true);
        this.setBoolean("include.scale", true);
        this.setBoolean("include.strokeinfo", true);
        this.setBoolean("include.axes", true);
        this.setBoolean("include.footnotes", true);
        this.setBoolean("include.margins", true);
        this.setColor("color.background", prefs.getColor("plot:color.background"));
        this.setString("labels.font", prefs.getString("plot:labels.font"));
        this.setBoolean("labels.super10", prefs.getBoolean("plot:labels.super10"));
        this.setString("title.text", "PLOT TITLE");
        this.setString("subtitle.text", "");
        this.setString("footnote.left", "");
        this.setString("footnote.right", "");
        this.setDouble("scale.min", 0.0);
        this.setDouble("scale.max", 1.0);
        this.setInt("scale.exponent", 0);
        this.setString("scale.units", "XXX");
        this.setString("scale.method", prefs.getString("plot:scale.method"));
        this.setInt("scale.div.major", prefs.getInt("plot:scale.div.major"));
        this.setInt("scale.div.minor", prefs.getInt("plot:scale.div.minor"));
        this.setString("scale.tick.format", prefs.getString("plot:scale.tick.format"));
        this.setFloat("scale.tick.size", prefs.getFloat("plot:scale.tick.size"));
        this.setBoolean("scale.label.custom", false);
        this.setString("scale.label.text", "SCALE CAPTION");
        this.setBoolean("footnote.minmax.vis", prefs.getBoolean("plot:footnote.minmax.vis"));
        this.setString("footnote.minmax.format", prefs.getString("plot:footnote.minmax.format"));
    }

    private void initAxesParams(PanPreferences prefs) {
        if (this.ptype_.isLonLatMap()) {
            return;
        }
        this.setString("xaxis.method", PanAxisMethod.SCALAR.name());
        this.setDouble("xaxis.begin", 0.0);
        this.setDouble("xaxis.end", 0.1);
        this.setString("xaxis.units", "");
        this.setString("xaxis.tick.format", "%.1f");
        this.setInt("xaxis.div.major", prefs.getInt("plot:xaxis.div.major"));
        this.setInt("xaxis.div.minor", prefs.getInt("plot:xaxis.div.minor"));
        this.setBoolean("xaxis.label.custom", false);
        this.setString("xaxis.label.text", "X AXIS");
        this.setString("yaxis.method", PanAxisMethod.SCALAR.name());
        this.setDouble("yaxis.begin", 0.0);
        this.setDouble("yaxis.end", 0.1);
        this.setString("yaxis.units", "");
        this.setInt("yaxis.div.major", prefs.getInt("plot:yaxis.div.major"));
        this.setInt("yaxis.div.minor", prefs.getInt("plot:yaxis.div.minor"));
        this.setString("yaxis.tick.format", "%.1f");
        this.setBoolean("yaxis.label.custom", false);
        this.setString("yaxis.label.text", "Y AXIS");
        if (this.ptype_.isLinePlot()) {
            this.setFloat("xaxis.label.size", prefs.getFloat("plot:lineplot.xaxis.label.size"));
            this.setFloat("yaxis.label.size", prefs.getFloat("plot:lineplot.yaxis.label.size"));
            this.setBoolean("axes.offset", prefs.getBoolean("plot:lineplot.axes.offset"));
            this.setInt("axes.tickmark.weight", prefs.getInt("plot:lineplot.axes.tickmark.weight"));
            this.setString("axes.tickmark.color", prefs.getString("plot:lineplot.axes.tickmark.color"));
            this.setFloat("xaxis.tick.size", prefs.getFloat("plot:lineplot.xaxis.tick.size"));
            this.setFloat("yaxis.tick.size", prefs.getFloat("plot:lineplot.yaxis.tick.size"));
            switch (this.ptype_) {
                case VERT_LINE: {
                    this.setString("scale.method", PanScaleMethod.SCALAR.name().toLowerCase());
                    this.setFloat("scale.label.size", prefs.getFloat("plot:lineplot.xaxis.label.size"));
                    this.setFloat("scale.tick.size", prefs.getFloat("plot:lineplot.xaxis.tick.size"));
                    break;
                }
                case HORZ_LINE: 
                case LL_ZONAL: {
                    this.setFloat("scale.label.size", prefs.getFloat("plot:lineplot.yaxis.label.size"));
                    this.setFloat("scale.tick.size", prefs.getFloat("plot:lineplot.yaxis.tick.size"));
                    break;
                }
            }
        } else {
            this.setFloat("xaxis.label.size", prefs.getFloat("plot:ccplot.xaxis.label.size"));
            this.setFloat("yaxis.label.size", prefs.getFloat("plot:ccplot.yaxis.label.size"));
            this.setBoolean("axes.offset", prefs.getBoolean("plot:ccplot.axes.offset"));
            this.setInt("axes.tickmark.weight", prefs.getInt("plot:ccplot.axes.tickmark.weight"));
            this.setString("axes.tickmark.color", prefs.getString("plot:ccplot.axes.tickmark.color"));
            this.setFloat("xaxis.tick.size", prefs.getFloat("plot:ccplot.xaxis.tick.size"));
            this.setFloat("yaxis.tick.size", prefs.getFloat("plot:ccplot.yaxis.tick.size"));
            switch (this.ptype_) {
                case LAT_TIME: {
                    this.setDouble("xaxis.begin", prefs.getDouble("plot:lattime.xaxis.begin"));
                    this.setDouble("xaxis.end", prefs.getDouble("plot:lattime.xaxis.end"));
                    this.setString("xaxis.label.text", "Latitude (\u00b0N)");
                    this.setString("yaxis.tick.format", "yyyy-MM-dd");
                    this.setString("yaxis.label.text", "TIME AXIS");
                    break;
                }
                case LAT_VERT: {
                    this.setDouble("xaxis.begin", prefs.getDouble("plot:latvert.xaxis.begin"));
                    this.setDouble("xaxis.end", prefs.getDouble("plot:latvert.xaxis.end"));
                    this.setString("xaxis.label.text", "Latitude (\u00b0N)");
                    this.setString("yaxis.method", prefs.getString("plot:latvert.yaxis.method"));
                    this.setString("yaxis.label.text", "VERTICAL AXIS");
                    this.setString("yaxis.tick.format", prefs.getString("plot:latvert.yaxis.tick.format"));
                    break;
                }
                case LON_TIME: {
                    this.setDouble("xaxis.begin", prefs.getDouble("plot:lontime.xaxis.begin"));
                    this.setDouble("xaxis.end", prefs.getDouble("plot:lontime.xaxis.end"));
                    this.setString("xaxis.label.text", "Longitude (\u00b0E)");
                    this.setString("yaxis.label.text", "TIME AXIS");
                    break;
                }
                case LON_VERT: {
                    this.setDouble("xaxis.begin", prefs.getDouble("plot:lonvert.xaxis.begin"));
                    this.setDouble("xaxis.end", prefs.getDouble("plot:lonvert.xaxis.end"));
                    this.setString("xaxis.label.text", "Longitude (\u00b0E)");
                    this.setString("yaxis.method", prefs.getString("plot:lonvert.yaxis.method"));
                    this.setString("yaxis.label.text", "VERTICAL AXIS");
                    this.setString("yaxis.tick.format", prefs.getString("plot:lonvert.yaxis.tick.format"));
                    break;
                }
                case TIME_LAT: {
                    this.setString("xaxis.tick.format", "yyyy-MM-dd");
                    this.setInt("xaxis.div.major", prefs.getInt("plot:timelat.xaxis.div.major"));
                    this.setInt("xaxis.div.minor", prefs.getInt("plot:timelat.xaxis.div.minor"));
                    this.setString("xaxis.label.text", "TIME AXIS");
                    this.setDouble("yaxis.end", prefs.getDouble("plot:timelat.yaxis.end"));
                    this.setDouble("yaxis.begin", prefs.getDouble("plot:timelat.yaxis.begin"));
                    this.setString("yaxis.label.text", "Latitude (\u00b0N)");
                    break;
                }
                case TIME_VERT: {
                    this.setString("xaxis.tick.format", "yyyy-MM-dd");
                    this.setInt("xaxis.div.major", prefs.getInt("plot:timevert.xaxis.div.major"));
                    this.setInt("xaxis.div.minor", prefs.getInt("plot:timevert.xaxis.div.minor"));
                    this.setString("xaxis.label.text", "TIME AXIS");
                    this.setString("yaxis.method", prefs.getString("plot:timevert.yaxis.method"));
                    this.setString("yaxis.label.text", "VERTICAL AXIS");
                    this.setString("yaxis.tick.format", prefs.getString("plot:timevert.yaxis.tick.format"));
                    break;
                }
                case COLOR_CONTOUR: {
                    this.setInt("xaxis.div.major", prefs.getInt("plot:xy.xaxis.div.major"));
                    this.setInt("xaxis.div.minor", prefs.getInt("plot:xy.xaxis.div.minor"));
                    this.setString("xaxis.tick.format", prefs.getString("plot:xy.xaxis.tick.format"));
                    this.setInt("yaxis.div.major", prefs.getInt("plot:xy.yaxis.div.major"));
                    this.setInt("yaxis.div.minor", prefs.getInt("plot:xy.yaxis.div.minor"));
                    this.setString("yaxis.tick.format", prefs.getString("plot:xy.yaxis.tick.format"));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown plot type enum");
                }
            }
        }
    }

    private void initLinePlotParams(PanPreferences prefs) {
        this.setBoolean("scale.autofit", false);
        this.setInt("grid.weight", prefs.getInt("plot:lineplot.grid.weight"));
        this.setString("grid.style", prefs.getString("plot:lineplot.grid.style"));
        this.setFloat("stroke.label.size", 11.0f);
        this.setColor(PanParamKeys.STROKE_COLOR[0], prefs.getColor(PanParamKeys.P_LINE_STROKE_COLOR[0]));
        this.setColor(PanParamKeys.STROKE_COLOR[1], prefs.getColor(PanParamKeys.P_LINE_STROKE_COLOR[1]));
        this.setString(PanParamKeys.STROKE_STYLE[0], prefs.getString(PanParamKeys.P_LINE_STROKE_STYLE[0]));
        this.setString(PanParamKeys.STROKE_STYLE[1], prefs.getString(PanParamKeys.P_LINE_STROKE_STYLE[1]));
        this.setInt(PanParamKeys.STROKE_WGT[0], prefs.getInt(PanParamKeys.P_LINE_STROKE_WGT[0]));
        this.setInt(PanParamKeys.STROKE_WGT[1], prefs.getInt(PanParamKeys.P_LINE_STROKE_WGT[1]));
        this.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[0], false);
        this.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[1], false);
        this.setString(PanParamKeys.STROKE_LABEL_TEXT[0], "STROKE 1 CAPTION");
        this.setString(PanParamKeys.STROKE_LABEL_TEXT[1], "STROKE 2 CAPTION");
    }

    private void initColorContourParams(PanPreferences prefs) {
        this.setBoolean("interpolate", prefs.getBoolean("plot:interpolate"));
        this.setBoolean("scale.autofit", prefs.getBoolean("plot:scale.autofit"));
        this.setColor("colorbar.invalids", prefs.getColor("plot:colorbar.invalids"));
        this.setColor("grid.color", prefs.getColor("plot:ccplot.grid.color"));
        this.setInt("grid.weight", prefs.getInt("plot:ccplot.grid.weight"));
        this.setString("grid.style", prefs.getString("plot:ccplot.grid.style"));
        this.setString("colorbar.name", prefs.getString("plot:colorbar.name"));
        this.setBoolean("colorbar.reverse", prefs.getBoolean("plot:colorbar.reverse"));
        this.set("colorbar.length", prefs.getInt("plot:colorbar.length"));
        this.set("colorbar.border.weight", prefs.getInt("plot:colorbar.border.weight"));
        this.setString("colorbar.outlier.shape", prefs.getString("plot:colorbar.outlier.shape"));
        this.setString("colorbar.outlier.side", prefs.getString("plot:colorbar.outlier.side"));
        this.setString("colorbar.outlier.gap", prefs.getString("plot:colorbar.outlier.gap"));
        this.setString("scale.label.location", prefs.getString("plot:scale.label.location"));
        this.setFloat("scale.label.size", 14.0f);
        this.setInt("contour.weight", prefs.getInt("plot:contour.weight"));
        this.setString("contour.style", prefs.getString("plot:contour.style"));
        this.setColor("contour.color", prefs.getColor("plot:contour.color"));
        this.setString("contour.location", prefs.getString("plot:contour.location"));
        this.setBoolean("contour.label.vis", prefs.getBoolean("plot:contour.label.vis"));
        this.setFloat("contour.label.size", prefs.getFloat("plot:contour.label.size"));
        this.setInt("vector.weight", prefs.getInt("plot:vector.weight"));
        this.setString("vector.style", prefs.getString("plot:vector.style"));
        this.setColor("vector.color", prefs.getColor("plot:vector.color"));
        this.setInt("vector.spacing", prefs.getInt("plot:vector.spacing"));
        this.setDouble("vector.refvalue", 1.0);
        this.setBoolean("vector.sample", prefs.getBoolean("plot:vector.sample"));
    }

    private void initVectorParams(PanPreferences prefs) {
        if (!this.ptype_.supportsVectorPlots()) {
            return;
        }
        switch (this.ptype_) {
            case LON_LAT: {
                this.setString("vector.dir1", prefs.getString("plot:lonlat.vector.dir1"));
                this.setString("vector.dir2", prefs.getString("plot:lonlat.vector.dir2"));
                break;
            }
            case LAT_VERT: {
                this.setString("vector.dir1", "North");
                this.setString("vector.dir2", "Up");
                break;
            }
            case LON_VERT: {
                this.setString("vector.dir1", "East");
                this.setString("vector.dir2", "Up");
                break;
            }
            case COLOR_CONTOUR: {
                this.setString("vector.dir1", "Right");
                this.setString("vector.dir2", "Up");
                break;
            }
            default: {
                LOGGER.debug("Plot type {} does not have vectors", (Object)this.ptype_);
            }
        }
    }

    private void initMapParams(PanPreferences prefs) {
        int i;
        String pname = prefs.getString("plot:lonlat.proj.name");
        this.projmeta_ = new PanProjectionMeta();
        this.projmeta_.setProjection(pname);
        this.setString("lonlat.proj.name", pname);
        this.setDouble("lonlat.proj.lon0", prefs.getDouble("plot:lonlat.proj.lon0"));
        this.setDouble("lonlat.proj.lat0", prefs.getDouble("plot:lonlat.proj.lat0"));
        for (i = 0; i < 5; ++i) {
            Object s = this.projmeta_.getXParamValue(i);
            if (s == null) continue;
            String k = "lonlat.proj.xparam." + (i + 1);
            try {
                this.set(k, s);
                continue;
            }
            catch (Exception exc) {
                LOGGER.debug("Unable to init map param {}, {}", (Object)i, (Object)exc.toString());
            }
        }
        this.setInt("lonlat.border.weight", prefs.getInt("plot:lonlat.border.weight"));
        this.setFloat("grid.spacing.lon", prefs.getFloat("plot:grid.spacing.lon"));
        this.setFloat("grid.spacing.lat", prefs.getFloat("plot:grid.spacing.lat"));
        this.setBoolean("grid.offset.lat", prefs.getBoolean("plot:grid.offset.lat"));
        this.setInt("grid.label.step", prefs.getInt("plot:grid.label.step"));
        this.setFloat("grid.label.size", prefs.getFloat("plot:grid.label.size"));
        for (i = 0; i < 3; ++i) {
            this.setString(PanParamKeys.OVERLAY_NAME[i], prefs.getString(PanParamKeys.P_OVERLAY_NAME[i]));
            this.setColor(PanParamKeys.OVERLAY_COLOR[i], prefs.getColor(PanParamKeys.P_OVERLAY_COLOR[i]));
            this.setBoolean(PanParamKeys.OVERLAY_INVERT[i], prefs.getBoolean(PanParamKeys.P_OVERLAY_INVERT[i]));
            this.set(PanParamKeys.OVERLAY_STYLE[i], prefs.get(PanParamKeys.P_OVERLAY_STYLE[i]));
            this.set(PanParamKeys.OVERLAY_SYMBOL_ID[i], prefs.get(PanParamKeys.P_OVERLAY_SYMBOL_ID[i]));
            this.setFloat(PanParamKeys.OVERLAY_SYMBOL_SIZE[i], prefs.getFloat(PanParamKeys.P_OVERLAY_SYMBOL_SIZE[i]));
            this.setInt(PanParamKeys.OVERLAY_WGT[i], prefs.getInt(PanParamKeys.P_OVERLAY_WGT[i]));
        }
        this.setBoolean("lonlat.proj.shading.vis", prefs.getBoolean("plot:lonlat.proj.shading.vis"));
        this.setInt("lonlat.proj.shading.opacity", prefs.getInt("plot:lonlat.proj.shading.opacity"));
        this.setDouble("lonlat.proj.subsolar.lon", prefs.getDouble("plot:lonlat.proj.subsolar.lon"));
        this.setDouble("lonlat.proj.subsolar.lat", prefs.getDouble("plot:lonlat.proj.subsolar.lat"));
    }

    private void initTrajectoryParams(PanPreferences prefs) {
        this.setColor("feature.background", prefs.getColor("plot:feature.background"));
        this.setBoolean("feature.nanskip", prefs.getBoolean("plot:feature.nanskip"));
        this.set(PanParamKeys.FEATURE_SYMBOL_ID[0], prefs.get(PanParamKeys.P_FEATURE_SYMBOL_ID[0]));
        this.set(PanParamKeys.FEATURE_SYMBOL_ID[1], prefs.get(PanParamKeys.P_FEATURE_SYMBOL_ID[1]));
        this.setFloat(PanParamKeys.FEATURE_SYMBOL_SIZE[0], prefs.getFloat(PanParamKeys.P_FEATURE_SYMBOL_SIZE[0]));
        this.setFloat(PanParamKeys.FEATURE_SYMBOL_SIZE[1], prefs.getFloat(PanParamKeys.P_FEATURE_SYMBOL_SIZE[1]));
        this.setBoolean(PanParamKeys.FEATURE_SYMBOL_FILL[0], prefs.getBoolean(PanParamKeys.P_FEATURE_SYMBOL_FILL[0]));
        this.setBoolean(PanParamKeys.FEATURE_SYMBOL_FILL[1], prefs.getBoolean(PanParamKeys.P_FEATURE_SYMBOL_FILL[1]));
        this.setColor(PanParamKeys.STROKE_COLOR[0], prefs.getColor(PanParamKeys.P_TRAJ_STROKE_COLOR[0]));
        this.setColor(PanParamKeys.STROKE_COLOR[1], prefs.getColor(PanParamKeys.P_TRAJ_STROKE_COLOR[1]));
        this.setString(PanParamKeys.STROKE_STYLE[0], prefs.getString(PanParamKeys.P_TRAJ_STROKE_STYLE[0]));
        this.setString(PanParamKeys.STROKE_STYLE[1], prefs.getString(PanParamKeys.P_TRAJ_STROKE_STYLE[1]));
        this.setInt(PanParamKeys.STROKE_WGT[0], prefs.getInt(PanParamKeys.P_TRAJ_STROKE_WGT[0]));
        this.setInt(PanParamKeys.STROKE_WGT[1], prefs.getInt(PanParamKeys.P_TRAJ_STROKE_WGT[1]));
        this.setFloat("stroke.label.size", 11.0f);
        this.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[0], false);
        this.setBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[1], false);
        this.setString(PanParamKeys.STROKE_LABEL_TEXT[0], "STROKE 1 CAPTION");
        this.setString(PanParamKeys.STROKE_LABEL_TEXT[1], "STROKE 2 CAPTION");
    }

    public PanPlotType getType() {
        return this.ptype_;
    }

    public PanData getData() {
        return this.data_;
    }

    public PanPlot getPlot() {
        return this.plot_;
    }

    public PanPlotLayoutMeta getLayout() {
        return this.layout_;
    }

    public PanPlotScaleMeta getScaleMeta() {
        return this.smeta_;
    }

    public PanProjectionMeta getProjectionMeta() {
        return this.projmeta_;
    }

    public PanPlotFrame getFrame() {
        return this.pframe_;
    }

    public void setFrame(PanPlotFrame pf) {
        this.pframe_ = pf;
    }

    public PanActionHash getActionHash() {
        return this.actionHash_;
    }

    public Action getAction(String key) {
        return (Action)this.actionHash_.get(key);
    }

    public void putAction(String key, Action action) {
        this.actionHash_.put(key, action);
    }

    public PanData createData(NcVariable ncvar) {
        LOGGER.trace("{}", (Object)ncvar);
        PanData data = this.createData(ncvar, new Object[0]);
        return data;
    }

    public PanData createData(NcVariable ncvar, Object ... axisInfo) {
        LOGGER.trace("{}, {}", (Object)ncvar, (Object)axisInfo);
        if (this.data_ != null) {
            throw new IllegalArgumentException("Data object already exists.");
        }
        NcArray ncarray = null;
        try {
            ncarray = PanPlotUtils.createArray(ncvar, this.ptype_, axisInfo);
        }
        catch (IllegalArgumentException exc) {
            throw exc;
        }
        catch (Exception exc) {
            String msg = exc.toString().replaceFirst(".*: ", "");
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new RuntimeException(msg);
        }
        if (ncarray == null) {
            throw new RuntimeException("Array creation returned null object.");
        }
        Dimension dsize = (Dimension)this.layout_.get("size.gridding");
        try {
            switch (this.ptype_) {
                case LON_LAT: {
                    this.data_ = new PanDataLonLatGridded(ncarray, dsize);
                    break;
                }
                case LAT_TIME: {
                    this.data_ = new PanDataLatTime(ncarray, dsize);
                    this.setAxisFormatPatternIfTime(((NcArray2D)ncarray).getYAxis(), "yaxis.tick.format");
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(this.getDouble("xaxis.begin"), this.getDouble("xaxis.end"));
                    break;
                }
                case LAT_VERT: {
                    this.data_ = new PanDataLatVert(ncarray, dsize);
                    ((PanDataLatVert)this.data_).setYAxisMethod(PanAxisMethod.matching(this.getString("yaxis.method")));
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(this.getDouble("xaxis.begin"), this.getDouble("xaxis.end"));
                    break;
                }
                case LON_TIME: {
                    this.data_ = new PanDataLonTime(ncarray, dsize);
                    this.setAxisFormatPatternIfTime(((NcArray2D)ncarray).getYAxis(), "yaxis.tick.format");
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(this.getDouble("xaxis.begin"), this.getDouble("xaxis.end"));
                    break;
                }
                case LON_VERT: {
                    this.data_ = new PanDataLonVert(ncarray, dsize);
                    ((PanDataLonVert)this.data_).setYAxisMethod(PanAxisMethod.matching(this.getString("yaxis.method")));
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(this.getDouble("xaxis.begin"), this.getDouble("xaxis.end"));
                    break;
                }
                case TIME_LAT: {
                    this.data_ = new PanDataTimeLat(ncarray, dsize);
                    this.setAxisFormatPatternIfTime(((NcArray2D)ncarray).getXAxis(), "xaxis.tick.format");
                    ((PanDataGeneral2D)this.data_).setGridBottomAndTop(this.getDouble("yaxis.begin"), this.getDouble("yaxis.end"));
                    break;
                }
                case TIME_VERT: {
                    this.data_ = new PanDataTimeVert(ncarray, dsize);
                    this.setAxisFormatPatternIfTime(((NcArray2D)ncarray).getXAxis(), "xaxis.tick.format");
                    ((PanDataTimeVert)this.data_).setYAxisMethod(PanAxisMethod.matching(this.getString("yaxis.method")));
                    ((PanDataGeneral2D)this.data_).setGridBottomAndTop(this.getDouble("yaxis.begin"), this.getDouble("yaxis.end"));
                    break;
                }
                case COLOR_CONTOUR: {
                    this.data_ = new PanDataGeneral2D(ncarray, dsize);
                    this.setAxisFormatPatternIfTime(((NcArray2D)ncarray).getXAxis(), "xaxis.tick.format");
                    this.setAxisFormatPatternIfTime(((NcArray2D)ncarray).getYAxis(), "yaxis.tick.format");
                    break;
                }
                case HORZ_LINE: 
                case VERT_LINE: {
                    NcAxis axis = ((NcArray1D)ncarray).getAxis();
                    boolean axisIsTime = axis instanceof NcTimeAxis;
                    LOGGER.trace("Axis is NcTimeAxis = {}.", (Object)axisIsTime);
                    if (axisIsTime && ((NcTimeAxis)axis).isUnixTime()) {
                        LOGGER.trace("Looks like a PanDataTime1D.");
                        this.data_ = new PanDataTime1D(ncarray);
                        if (this.ptype_ == PanPlotType.HORZ_LINE) {
                            this.setAxisFormatPatternIfTime(axis, "xaxis.tick.format");
                            break;
                        }
                        this.setAxisFormatPatternIfTime(axis, "yaxis.tick.format");
                        break;
                    }
                    LOGGER.trace("Looks like a plain PanData1D.");
                    this.data_ = new PanData1D(ncarray);
                    break;
                }
                case LL_ZONAL: {
                    LOGGER.trace("Creating PanDataLonLatZonal");
                    this.data_ = new PanDataLonLatZonal(ncarray, dsize);
                    break;
                }
                case LL_TRAJ: {
                    this.data_ = new PanDataLonLatTrajectory(ncarray);
                    break;
                }
                default: {
                    LOGGER.error("Default reached. Data obj not created");
                    break;
                }
            }
        }
        catch (Exception exc) {
            String msg;
            LOGGER.error("Exception cresting data object: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            if ((msg = exc.toString().replaceAll(".*: ", "")).contains("EOF")) {
                msg = "End of file exception.";
            }
            throw new RuntimeException(msg);
        }
        return this.data_;
    }

    private void setAxisFormatPatternIfTime(NcAxis axis, String axisFormatKey) {
        if (axis instanceof NcTimeAxis && ((NcTimeAxis)axis).isUnixTime()) {
            NcTimeAxis tax = (NcTimeAxis)axis;
            String s = ((UnixTimeFormatter)tax.getFormatter()).getPattern();
            this.setString(axisFormatKey, s);
        }
    }

    public PanPlot createPlot() {
        double[] range;
        PanAxisMethod method;
        LOGGER.trace("Creating {}", (Object)this.ptype_);
        if (this.data_ == null) {
            throw new RuntimeException("Data object not yet created.");
        }
        PanPreferences prefs = PanPreferences.getSharedInstance();
        this.smeta_ = new PanPlotScaleMeta(this, this.data_);
        this.setString("title.text", this.data_.getArray(0).getLongName());
        if (this.ptype_ == PanPlotType.COLOR_CONTOUR || this.ptype_ == PanPlotType.TIME_LAT || this.ptype_ == PanPlotType.TIME_VERT) {
            method = PanAxisMethod.matching(this.getString("xaxis.method"));
            range = ((PanDataGeneral2D)this.data_).getDefaultLeftAndRight(method);
            String xunits = ((PanDataGeneral2D)this.data_).getDataXAxisUnits();
            this.setGridLeftAndRight(range[0], range[1]);
            this.setString("xaxis.units", xunits);
            ((PanDataGeneral2D)this.data_).setGridLeftAndRight(range[0], range[1]);
        }
        if (this.ptype_ == PanPlotType.COLOR_CONTOUR || this.ptype_ == PanPlotType.LAT_VERT || this.ptype_ == PanPlotType.LON_VERT || this.ptype_ == PanPlotType.TIME_VERT || this.ptype_ == PanPlotType.LAT_TIME || this.ptype_ == PanPlotType.LON_TIME) {
            method = PanAxisMethod.matching(this.getString("yaxis.method"));
            range = ((PanDataGeneral2D)this.data_).getDefaultBottomAndTop(method);
            String yunits = ((PanDataGeneral2D)this.data_).getDataYAxisUnits();
            this.setGridBottomAndTop(range[0], range[1]);
            this.setString("yaxis.units", yunits);
        }
        if (this.ptype_.isLinePlot()) {
            switch (this.ptype_) {
                case VERT_LINE: {
                    PanAxisMethod ymethod = PanAxisMethod.matching(this.getString("yaxis.method"));
                    double[] yrange = ((PanData1D)this.data_).getDefaultAxisRange(ymethod);
                    ((PanData1D)this.data_).setAxisBounds(yrange[0], yrange[1]);
                    this.setDouble("yaxis.begin", yrange[0]);
                    this.setDouble("yaxis.end", yrange[1]);
                    this.setString("yaxis.units", ((PanData1D)this.data_).getAxisUnits());
                    break;
                }
                case HORZ_LINE: {
                    PanAxisMethod xmethod = PanAxisMethod.matching(this.getString("xaxis.method"));
                    double[] xrange = ((PanData1D)this.data_).getDefaultAxisRange(xmethod);
                    ((PanData1D)this.data_).setAxisBounds(xrange[0], xrange[1]);
                    this.setDouble("xaxis.begin", xrange[0]);
                    this.setDouble("xaxis.end", xrange[1]);
                    this.setString("xaxis.units", ((PanData1D)this.data_).getAxisUnits());
                    break;
                }
                case LL_ZONAL: {
                    this.setDouble("xaxis.begin", prefs.getDouble("plot:llzonal.xaxis.begin"));
                    this.setDouble("xaxis.end", prefs.getDouble("plot:llzonal.xaxis.end"));
                    this.setString("xaxis.label.text", "Latitude (\u00b0N)");
                    break;
                }
                default: {
                    LOGGER.debug("Switch default case: How did we get here? {}", (Object)this.ptype_);
                }
            }
        }
        this.setInt("scale.exponent", prefs.getInt("plot:scale.exponent"));
        double dmin = this.data_.getMinValue();
        double dmax = this.data_.getMaxValue();
        if (Double.isNaN(dmin)) {
            dmin = 0.0;
            dmax = 1.0E-25;
        }
        if (dmax == dmin) {
            dmax = dmin + 1.0E-25;
        }
        this.setDouble("scale.min", dmin);
        this.setDouble("scale.max", dmax);
        double dmag = 0.75 * MathUtils.max(1.0, Math.abs(dmin), Math.abs(dmax));
        if (this.ptype_ == PanPlotType.LON_LAT || this.ptype_ == PanPlotType.LAT_VERT || this.ptype_ == PanPlotType.LON_VERT || this.ptype_ == PanPlotType.COLOR_CONTOUR) {
            this.setDouble("vector.refvalue", dmag);
        }
        switch (this.ptype_) {
            case LON_LAT: 
            case LL_TRAJ: {
                this.plot_ = new PanLonLatPlot(this);
                break;
            }
            case LAT_TIME: {
                this.plot_ = new PanLatTimePlot(this);
                break;
            }
            case LAT_VERT: {
                this.plot_ = new PanLatVertPlot(this);
                break;
            }
            case LON_TIME: {
                this.plot_ = new PanLonTimePlot(this);
                break;
            }
            case LON_VERT: {
                this.plot_ = new PanLonVertPlot(this);
                break;
            }
            case TIME_LAT: {
                this.plot_ = new PanTimeLatPlot(this);
                break;
            }
            case TIME_VERT: {
                this.plot_ = new PanTimeYPlot(this);
                break;
            }
            case COLOR_CONTOUR: {
                this.plot_ = new PanColorContourPlot(this);
                break;
            }
            case HORZ_LINE: {
                this.plot_ = new PanHorizontalLinePlot(this);
                break;
            }
            case VERT_LINE: {
                this.plot_ = new PanVerticalLinePlot(this);
                break;
            }
            case LL_ZONAL: {
                LOGGER.trace("Creating PanZonalAverageLinePlot");
                this.plot_ = new PanZonalAverageLinePlot(this);
                break;
            }
            default: {
                throw new RuntimeException("Unknown plot type enum");
            }
        }
        LOGGER.trace("Created {}", (Object)(this.plot_ != null ? 1 : 0));
        this.plot_.setSize((Dimension)this.layout_.get("size.pixels"));
        return this.plot_;
    }

    @Override
    public Object put(final String key, final Object value) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (onEDT && this.pframe_ != null) {
            String s = key.replaceAll(".*\\.", "");
            Task task = new Task("Setting parameter " + s){

                @Override
                protected Object beginTask() {
                    return PanPlotMeta.this.beginPut(key, value);
                }

                @Override
                protected void finishTask() {
                    PanPlotMeta.this.refreshRefresh();
                }
            };
            this.pframe_.addTask(task);
            return null;
        }
        Object o = this.beginPut(key, value);
        if (this.pframe_ != null) {
            this.refreshRefresh();
        }
        return o;
    }

    protected Object beginPut(String key, Object value) {
        try {
            if (this.isProjectionNameKey(key) || this.isProjectionParamKey(key)) {
                this.handleProjectionParam(key, value);
            }
            return super.put(key, value);
        }
        catch (IllegalArgumentException exc) {
            throw exc;
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    protected synchronized void firePropertyChanged(String key) {
        super.firePropertyChanged(key);
    }

    @Override
    public Object setGroup(final Object[] ... keyValuePairs) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (onEDT && this.pframe_ != null) {
            Task task = new Task("Setting parameter group"){

                @Override
                protected Object beginTask() {
                    return PanPlotMeta.this.beginSetGroup(keyValuePairs);
                }

                @Override
                protected void finishTask() {
                    PanPlotMeta.this.refreshRefresh();
                }
            };
            this.pframe_.addTask(task);
            return null;
        }
        Object o = this.beginSetGroup(keyValuePairs);
        this.refreshRefresh();
        return o;
    }

    protected Object beginSetGroup(Object[] ... keyValuePairs) {
        int i;
        for (i = 0; i < keyValuePairs.length; ++i) {
            if (!this.isProjectionNameKey((String)keyValuePairs[i][0])) continue;
            this.handleProjectionName((String)keyValuePairs[i][1]);
        }
        for (i = 0; i < keyValuePairs.length; ++i) {
            if (!this.isProjectionParamKey((String)keyValuePairs[i][0])) continue;
            this.handleProjectionParam((String)keyValuePairs[i][0], keyValuePairs[i][1]);
        }
        return super.setGroup(keyValuePairs);
    }

    private boolean isProjectionNameKey(String key) {
        return key.equals("lonlat.proj.name");
    }

    private boolean isProjectionParamKey(String key) {
        return key.equals("lonlat.proj.lon0") || key.equals("lonlat.proj.lat0") || key.contains("lonlat.proj.xparam");
    }

    private void handleProjectionName(String name) {
        if (!(this.plot_ instanceof PanLonLatPlot)) {
            return;
        }
        this.projmeta_.setProjection(name);
        AbstractProjection proj = this.projmeta_.getProjection();
        int pcount = proj.getExtraParamCount();
        for (int i = 0; i < pcount; ++i) {
            String pkeyx = "lonlat.proj.xparam." + (i + 1);
            Object value = this.projmeta_.getXParamValue(i);
            super.set(pkeyx, value);
        }
    }

    private boolean handleProjectionParam(String pkey, Object value) {
        if (this.isProjectionNameKey(pkey)) {
            this.handleProjectionName((String)value);
        } else if (pkey.equals("lonlat.proj.lon0")) {
            if (value instanceof Double) {
                this.projmeta_.setCenterLon((Double)value);
            } else {
                this.projmeta_.setCenterLon(StringUtils.parseDouble(value.toString()));
            }
        } else if (pkey.equals("lonlat.proj.lat0")) {
            if (value instanceof Double) {
                this.projmeta_.setCenterLat((Double)value);
            } else {
                this.projmeta_.setCenterLat(StringUtils.parseDouble(value.toString()));
            }
        } else if (pkey.contains("lonlat.proj.xparam")) {
            int pid = Integer.valueOf(pkey.substring(pkey.length() - 1)) - 1;
            if (value == null) {
                return this.projmeta_.setExtraParameter(pid, null);
            }
            return this.projmeta_.setExtraParameter(pid, value);
        }
        return true;
    }

    @Override
    public void setBoolean(String pkey, boolean pvalue) {
        if (pkey.equals("interpolate")) {
            this.setDataInterpolated(pvalue, null);
        } else if (pkey.equals("include.title") || pkey.equals("include.scale") || pkey.equals("include.strokeinfo") || pkey.equals("include.axes") || pkey.equals("include.footnotes") || pkey.equals("include.margins")) {
            this.layout_.set(pkey, pvalue);
            super.setBoolean(pkey, pvalue);
            return;
        }
        super.setBoolean(pkey, pvalue);
    }

    @Override
    public void setDouble(String pkey, double pvalue) {
        if (this.initializing_) {
            super.setDouble(pkey, pvalue);
            return;
        }
        switch (pkey) {
            case "xaxis.begin": {
                if (this.ptype_ == PanPlotType.VERT_LINE) {
                    LOGGER.trace("Trying to set X axis range on vert line plot");
                    return;
                }
                double rval = this.getDouble("xaxis.end");
                this.setGridLeftAndRight(pvalue, rval);
                break;
            }
            case "xaxis.end": {
                if (this.ptype_ == PanPlotType.VERT_LINE) {
                    LOGGER.trace("Trying to set X axis range on vert line plot");
                    return;
                }
                double lval = this.getDouble("xaxis.begin");
                this.setGridLeftAndRight(lval, pvalue);
                break;
            }
            case "yaxis.begin": {
                if (this.ptype_ == PanPlotType.HORZ_LINE) {
                    LOGGER.trace("Trying to set Y axis range on horizontal line plot");
                    return;
                }
                double tval = this.getDouble("yaxis.end");
                this.setGridBottomAndTop(pvalue, tval);
                break;
            }
            case "yaxis.end": {
                if (this.ptype_ == PanPlotType.HORZ_LINE) {
                    LOGGER.trace("Trying to set Y axis range on horizontal line plot");
                    return;
                }
                double bval = this.getDouble("yaxis.begin");
                this.setGridBottomAndTop(bval, pvalue);
                break;
            }
        }
        super.setDouble(pkey, pvalue);
    }

    @Override
    public void setFloat(String pkey, float pvalue) {
        if (pkey.equals("title.size") || pkey.equals("subtitle.size") || pkey.equals("footnote.size")) {
            this.layout_.set(pkey, Float.valueOf(pvalue));
            super.setFloat(pkey, pvalue);
        } else {
            super.setFloat(pkey, pvalue);
        }
    }

    @Override
    public void setInt(String pkey, int pvalue) {
        switch (pkey) {
            case "size.factor": {
                int sfactor = this.constrainSizeFactor(pvalue);
                this.layout_.set(pkey, sfactor);
                super.setInt(pkey, sfactor);
                this.resizeFrameIfNecessary();
                break;
            }
            case "size.width": 
            case "size.height": {
                this.layout_.set(pkey, pvalue);
                super.setInt(pkey, pvalue);
                this.resizeFrameIfNecessary();
                break;
            }
            case "scale.exponent": {
                LOGGER.trace("{} {}", (Object)pkey, (Object)pvalue);
                super.setInt(pkey, pvalue);
                this.setDataScalingExponent(pvalue, null);
                break;
            }
            default: {
                super.setInt(pkey, pvalue);
            }
        }
    }

    private int constrainSizeFactor(int szfactor) {
        int sfactor = szfactor;
        if (sfactor == 0) {
            PanPreferences prefs = PanPreferences.getSharedInstance();
            sfactor = prefs.getInt("plot:size.factor");
        } else if (sfactor < 80) {
            LOGGER.warn("Size factor {} too small; using min {}.", (Object)sfactor, (Object)80);
            sfactor = 80;
        } else if (PlatformUtils.isHeadless() && sfactor > 500) {
            LOGGER.warn("Size factor {} too big; using CL max {}.", (Object)sfactor, (Object)500);
            sfactor = 500;
        } else if (sfactor > 300) {
            LOGGER.warn("Size factor {} too big; using max {}.", (Object)sfactor, (Object)300);
            sfactor = 300;
        }
        return sfactor;
    }

    @Override
    public void setString(String pkey, String ppvalue) {
        String pvalue = StringUtils.unescapeUnicode(ppvalue);
        switch (pkey) {
            case "xaxis.method": {
                this.handleXAxisMethod(pvalue);
                break;
            }
            case "yaxis.method": {
                this.handleYAxisMethod(pvalue);
                break;
            }
            case "xaxis.units": {
                if (this.data_ != null) {
                    if (this.data_ instanceof PanDataGeneral2D) {
                        ((PanDataGeneral2D)this.data_).setXAxisUnits(pvalue);
                    } else if (!this.ptype_.isLonLatZonal()) {
                        ((PanData1D)this.data_).setAxisUnits(pvalue);
                    }
                }
                super.setString(pkey, pvalue);
                break;
            }
            case "yaxis.units": {
                if (this.data_ != null) {
                    if (this.data_ instanceof PanDataGeneral2D) {
                        ((PanDataGeneral2D)this.data_).setYAxisUnits(pvalue);
                    } else {
                        ((PanData1D)this.data_).setAxisUnits(pvalue);
                    }
                }
                super.setString(pkey, pvalue);
                break;
            }
            case "xaxis.tick.format": 
            case "yaxis.tick.format": {
                LOGGER.trace("Param key is {}", (Object)pkey);
                super.setString(pkey, pvalue);
                break;
            }
            case "combination": {
                this.setDataCombination(pvalue, null);
                break;
            }
            case "scale.units": {
                LOGGER.trace("Param key is SCALE_UNITS");
                this.setScaleUnits(pvalue, null);
                break;
            }
            case "colorbar.name": {
                AbstractColorTable o = PanUtils.getColorTable(pvalue);
                if (o == null) {
                    LOGGER.warn("No color table matching {}", (Object)pvalue);
                    return;
                }
                super.setString(pkey, pvalue);
                break;
            }
            default: {
                super.setString(pkey, pvalue);
            }
        }
    }

    private void handleXAxisMethod(String newName) {
        double newVal2;
        double newVal1;
        double[] range;
        String oldName = this.getString("xaxis.method");
        PanAxisMethod newMethod = PanAxisMethod.matching(newName);
        String xnewName = newMethod.name();
        if (this.data_ == null) {
            super.set("xaxis.method", xnewName);
            return;
        }
        if (this.data_ instanceof PanDataGeneral2D) {
            PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
            range = data2d.getDefaultLeftAndRight(newMethod);
        } else if (this.ptype_ == PanPlotType.HORZ_LINE) {
            PanData1D data1d = (PanData1D)this.data_;
            range = data1d.getDefaultAxisRange(newMethod);
        } else {
            if (this.ptype_ == PanPlotType.VERT_LINE) {
                throw new RuntimeException("Y axis for 1D plot is the scale");
            }
            if (this.ptype_ == PanPlotType.LL_ZONAL) {
                LOGGER.info("Option does not apply to plot type");
                return;
            }
            throw new RuntimeException("Mystery case");
        }
        double oldVal1 = this.getDouble("xaxis.begin");
        double oldVal2 = this.getDouble("xaxis.end");
        if (Double.isNaN(oldVal1)) {
            oldVal1 = range[0];
        }
        if (Double.isNaN(oldVal2)) {
            oldVal2 = range[1];
        }
        PanAxisMethod oldMethod = PanAxisMethod.matching(oldName);
        if (newMethod == PanAxisMethod.INDEX || oldMethod == null || oldMethod == PanAxisMethod.INDEX) {
            newVal1 = range[0];
            newVal2 = range[1];
        } else if (newMethod == PanAxisMethod.LOG10) {
            newVal1 = oldVal1;
            newVal2 = oldVal2;
            if (newVal1 <= 0.0) {
                newVal1 = 1.0E-50;
            }
            if (newVal2 <= 0.0) {
                newVal2 = 1.0E-50;
            }
            if (newVal2 == newVal1) {
                newVal2 += 1.0E-25;
            }
        } else {
            newVal1 = oldVal1;
            newVal2 = oldVal2;
        }
        this.setGroup({"xaxis.method", xnewName}, {"xaxis.begin", newVal1}, {"xaxis.end", newVal2});
        if (this.data_ instanceof PanDataGeneral2D) {
            PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
            data2d.setXAxisMethod(newMethod);
            data2d.setGridLeftAndRight(newVal1, newVal2);
        } else if (this.ptype_ == PanPlotType.HORZ_LINE) {
            PanData1D data1d = (PanData1D)this.data_;
            data1d.setAxisMethod(newMethod);
            data1d.setAxisBounds(newVal1, newVal2);
        }
    }

    private void handleYAxisMethod(String newName) {
        double newVal2;
        double newVal1;
        double[] range;
        PanAxisMethod newMethod = PanAxisMethod.matching(newName);
        String ynewName = newMethod.name();
        if (this.data_ == null) {
            super.set("yaxis.method", ynewName);
            return;
        }
        if (this.data_ instanceof PanDataGeneral2D) {
            PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
            range = data2d.getDefaultBottomAndTop(newMethod);
        } else if (this.ptype_ == PanPlotType.VERT_LINE) {
            PanData1D data1d = (PanData1D)this.data_;
            range = data1d.getDefaultAxisRange(newMethod);
        } else {
            if (this.ptype_ == PanPlotType.HORZ_LINE) {
                throw new RuntimeException("X axis for 1D plot is the scale");
            }
            throw new RuntimeException("Mystery case");
        }
        double oldVal1 = this.getDouble("yaxis.begin");
        double oldVal2 = this.getDouble("yaxis.end");
        if (Double.isNaN(oldVal1)) {
            oldVal1 = range[0];
        }
        if (Double.isNaN(oldVal2)) {
            oldVal2 = range[1];
        }
        String oldName = this.getString("yaxis.method");
        PanAxisMethod oldMethod = PanAxisMethod.matching(oldName);
        if (newMethod == PanAxisMethod.INDEX || oldMethod == null || oldMethod == PanAxisMethod.INDEX) {
            newVal1 = range[0];
            newVal2 = range[1];
        } else if (newMethod == PanAxisMethod.LOG10) {
            newVal1 = oldVal1;
            newVal2 = oldVal2;
            if (newVal2 <= 0.0) {
                newVal2 = 1.0E-50;
            }
            if (newVal1 <= 0.0) {
                newVal1 = 1.0E-50;
            }
            if (newVal2 == newVal1) {
                newVal2 += 1.0E-25;
            }
        } else {
            newVal1 = oldVal1;
            newVal2 = oldVal2;
        }
        this.setGroup({"yaxis.method", ynewName}, {"yaxis.begin", newVal1}, {"yaxis.end", newVal2});
        if (this.data_ instanceof PanDataGeneral2D) {
            PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
            data2d.setYAxisMethod(newMethod);
            data2d.setGridBottomAndTop(newVal1, newVal2);
        } else if (this.ptype_ == PanPlotType.VERT_LINE) {
            PanData1D data1d = (PanData1D)this.data_;
            data1d.setAxisMethod(newMethod);
            data1d.setAxisBounds(newVal1, newVal2);
        }
    }

    public void setGridLeftAndRight(double left, double right) {
        if (this.data_ == null) {
            return;
        }
        this.setGroup({"xaxis.begin", left}, {"xaxis.end", right});
        switch (this.ptype_) {
            case HORZ_LINE: {
                ((PanData1D)this.data_).setAxisBounds(left, right);
                break;
            }
            case VERT_LINE: {
                LOGGER.trace("How did we get here? Should have gone to setting scale min/max.");
                break;
            }
            case LL_ZONAL: {
                ((PanDataLonLatZonal)this.data_).setAxisBounds(left, right);
                break;
            }
            default: {
                if (this.data_ instanceof PanDataGeneral2D) {
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(left, right);
                    break;
                }
                LOGGER.trace("called for plot type {}", (Object)this.ptype_);
            }
        }
    }

    public void setGridBottomAndTop(double bottom, double top) {
        this.setGroup({"yaxis.begin", bottom}, {"yaxis.end", top});
        if (this.data_ == null) {
            return;
        }
        switch (this.ptype_) {
            case VERT_LINE: {
                ((PanData1D)this.data_).setAxisBounds(bottom, top);
                break;
            }
            case HORZ_LINE: 
            case LL_ZONAL: {
                LOGGER.trace("How did we get here? Should have gone to setting scale min/max.");
                break;
            }
            default: {
                if (this.data_ instanceof PanDataGeneral2D) {
                    ((PanDataGeneral2D)this.data_).setGridBottomAndTop(bottom, top);
                    break;
                }
                LOGGER.trace("called for plot type {}", (Object)this.ptype_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNcArray(final int idx, final NcArray nca, TaskListener tl) {
        PanPlotMeta panPlotMeta = this;
        synchronized (panPlotMeta) {
            if (this.data_ == null) {
                return;
            }
            if (this.pframe_ == null) {
                this.beginSetNcArray(idx, nca);
                this.finishSetNcArray(idx);
            } else {
                Task task = new Task("Adding variable"){

                    @Override
                    protected Object beginTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var now null; canceling setNcArray task.");
                            this.cancel(true);
                            return null;
                        }
                        PanPlotMeta.this.beginSetNcArray(idx, nca);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var now null; canceling setNcArray completion.");
                            return;
                        }
                        PanPlotMeta.this.finishSetNcArray(idx);
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
    }

    private void beginSetNcArray(int idx, NcArray nca) {
        this.data_.setArray(idx, nca);
    }

    private void finishSetNcArray(int idx) {
        if (this.pframe_ == null) {
            return;
        }
        this.pframe_.updateArrayDataPanel(idx);
        this.refreshRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSlice(final int arrayNum, final int dimNum, final int index, TaskListener tl) {
        PanPlotMeta panPlotMeta = this;
        synchronized (panPlotMeta) {
            if (this.data_ == null) {
                return;
            }
            if (this.pframe_ == null) {
                this.beginSetDataSlice(arrayNum, dimNum, index);
                this.finishSetDataSlice();
            } else {
                Task task = new Task("Changing array slice"){

                    @Override
                    protected Object beginTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataSlice task.");
                            this.cancel(true);
                            return null;
                        }
                        PanPlotMeta.this.beginSetDataSlice(arrayNum, dimNum, index);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataSlice completion.");
                            return;
                        }
                        PanPlotMeta.this.finishSetDataSlice();
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
    }

    private void beginSetDataSlice(int arrayNum, int dimNum, int index) {
        this.data_.setSlice(arrayNum, dimNum, index);
    }

    private void finishSetDataSlice() {
        this.data_.fireDataEvent(PanDataEvent.EType.SLICE_CHANGED);
        this.refreshPlot();
    }

    public synchronized void setDataCombination(String value, TaskListener tl) {
        if (this.replacing_) {
            LOGGER.trace("called while applying saved settings");
        }
        final PanCombinationType ctype = PanCombinationType.matching(value);
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ == null) {
            LOGGER.trace("data object is still null");
        } else if (this.pframe_ == null || this.replacing_ || onEDT) {
            this.beginSetDataCombination(ctype);
            this.finishSetDataCombination();
        } else {
            Task task = new Task("Changing array combination type"){

                @Override
                protected Object beginTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataCombination task.");
                        this.cancel(true);
                        return null;
                    }
                    PanPlotMeta.this.beginSetDataCombination(ctype);
                    return null;
                }

                @Override
                protected void finishTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataCombination completion.");
                        return;
                    }
                    PanPlotMeta.this.finishSetDataCombination();
                }
            };
            if (tl != null) {
                task.addTaskListener(tl);
            }
            this.pframe_.addTask(task);
        }
        super.set("combination", value);
    }

    private void beginSetDataCombination(PanCombinationType ctype) {
        this.data_.setCombinationType(ctype);
    }

    private void finishSetDataCombination() {
        this.data_.fireDataEvent(PanDataEvent.EType.COMBINATION_CHANGED);
        PanCombinationType ctype = this.data_.getCombinationType();
        if (ctype == PanCombinationType.VECTOR) {
            this.validateComboVectorComponents();
        }
        this.refreshPlot();
    }

    private void validateComboVectorComponents() {
        if (!(this.data_ instanceof PanDataLonLatGridded)) {
            return;
        }
        PanDataLonLatGridded lldata = (PanDataLonLatGridded)this.data_;
        lldata.getUnitsChoices();
        PanVectorType vtype = lldata.getVectorType();
        String dir1 = this.getString("vector.dir1");
        String dir2 = this.getString("vector.dir2");
        if (vtype == PanVectorType.XY) {
            if ("magnitude".equalsIgnoreCase(dir1) || "magnitude".equalsIgnoreCase(dir2)) {
                this.setGroup({"vector.dir1", this.getString("plot:lonlat.vector.dir1")}, {"vector.dir2", this.getString("plot:lonlat.vector.dir2")});
            }
        } else if (!"magnitude".equalsIgnoreCase(dir1) && !"magnitude".equalsIgnoreCase(dir2)) {
            String vdir;
            String string = vdir = lldata.isVectorAngleUpstream() ? "Upstream" : "Downstream";
            if (vtype == PanVectorType.MAG_ANGLE) {
                this.setGroup({"vector.dir1", "Magnitude"}, {"vector.dir2", vdir});
            } else {
                this.setGroup({"vector.dir1", vdir}, {"vector.dir2", "Magnitude"});
            }
        }
    }

    public synchronized void setDataInterpolated(final boolean interpolated, TaskListener tl) {
        if (this.replacing_) {
            LOGGER.trace("called while applying saved settings");
        }
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ == null) {
            LOGGER.trace("data object is still null");
        } else if (this.pframe_ == null || this.replacing_ || onEDT) {
            this.beginSetDataInterpolated(interpolated);
            this.finishSetDataInterpolated();
        } else {
            Task task = new Task("Toggling interpolation"){

                @Override
                protected Object beginTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataInterpolation task.");
                        this.cancel(true);
                        return null;
                    }
                    PanPlotMeta.this.beginSetDataInterpolated(interpolated);
                    return null;
                }

                @Override
                protected void finishTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataInterpolated completion.");
                        return;
                    }
                    PanPlotMeta.this.finishSetDataInterpolated();
                }
            };
            if (tl != null) {
                task.addTaskListener(tl);
            }
            this.pframe_.addTask(task);
        }
        super.setBoolean("interpolate", interpolated);
    }

    private void beginSetDataInterpolated(boolean interpolated) {
        this.data_.setInterpolated(interpolated);
    }

    private void finishSetDataInterpolated() {
        this.data_.fireDataEvent(PanDataEvent.EType.INTERPOLATION_CHANGED);
        this.refreshPlot();
    }

    public synchronized void setScaleUnits(final String units, TaskListener tl) {
        LOGGER.trace("");
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ == null) {
            LOGGER.trace("data object is still null");
        } else if (this.pframe_ == null || onEDT) {
            this.beginSetDataUnits(units);
            this.finishSetDataUnits();
        } else {
            Task task = new Task("Setting units"){

                @Override
                protected Object beginTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataUnits task.");
                        this.cancel(true);
                        return null;
                    }
                    PanPlotMeta.this.beginSetDataUnits(units);
                    return null;
                }

                @Override
                protected void finishTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataUnits completion.");
                        return;
                    }
                    PanPlotMeta.this.finishSetDataUnits();
                }
            };
            if (tl != null) {
                task.addTaskListener(tl);
            }
            this.pframe_.addTask(task);
        }
        super.setString("scale.units", units);
    }

    private void beginSetDataUnits(String unitsStr) {
        this.data_.setUnits(unitsStr);
    }

    private void finishSetDataUnits() {
        this.data_.fireDataEvent(PanDataEvent.EType.UNITS_CHANGED);
        this.refreshPlot();
    }

    public synchronized void setDataScalingExponent(final int tenPower, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ == null) {
            LOGGER.trace("data object is still null");
        } else if (this.pframe_ == null || this.replacing_ || onEDT) {
            this.beginSetDataScalingExponent(tenPower);
            this.finishSetDataScalingExponent();
        } else {
            Task task = new Task("Setting scaling"){

                @Override
                protected Object beginTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataScalingExponent task.");
                        this.cancel(true);
                        return null;
                    }
                    PanPlotMeta.this.beginSetDataScalingExponent(tenPower);
                    return null;
                }

                @Override
                protected void finishTask() {
                    if (PanPlotMeta.this.data_ == null) {
                        LOGGER.warn("Data var is null; canceling setDataScalingExponent completion.");
                        return;
                    }
                    PanPlotMeta.this.finishSetDataScalingExponent();
                }
            };
            if (tl != null) {
                task.addTaskListener(tl);
            }
            this.pframe_.addTask(task);
        }
        super.setInt("scale.exponent", tenPower);
    }

    private void beginSetDataScalingExponent(int tenPower) {
        this.data_.setScalingExponent(tenPower);
    }

    private void finishSetDataScalingExponent() {
        this.data_.fireDataEvent(PanDataEvent.EType.SCALING_CHANGED);
        this.refreshPlot();
    }

    private void refreshRefresh() {
        this.refreshControls();
        this.refreshPlot();
    }

    private void refreshControls() {
        if (this.pframe_ == null) {
            return;
        }
        PanControlsTabbedPane ctp = this.pframe_.getControlsTabbedPane();
        if (ctp == null) {
            return;
        }
        EventQueue.invokeLater(() -> {
            ctp.refresh();
            ctp.repaint();
        });
    }

    private void refreshPlot() {
        if (this.pframe_ == null) {
            return;
        }
        if (this.replacing_) {
            return;
        }
        PanPlotHolder ph = this.pframe_.getPlotHolder();
        if (ph == null) {
            return;
        }
        EventQueue.invokeLater(() -> ph.repaint());
    }

    private void resizeFrameIfNecessary() {
        if (this.pframe_ == null) {
            return;
        }
        if (this.replacing_) {
            return;
        }
        EventQueue.invokeLater(() -> this.pframe_.resizeToFitDisplay());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanActionHash panActionHash = this.actionHash_;
        synchronized (panActionHash) {
            this.actionHash_.clear();
        }
        this.removePlotPropertyListeners();
    }
}

