/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanToggleToolbarLabelsAction;
import gov.nasa.giss.panoply.action.PanViewZoomInAction;
import gov.nasa.giss.panoply.action.PanViewZoomOutAction;
import gov.nasa.giss.panoply.action.PanViewZoomResetAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.menu.PanViewPlotMenu;
import gov.nasa.giss.panoply.menu.PanViewSourcesMenu;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanZoomableFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class PanViewMenu
extends PanMenu {
    private final JMenuItem miToggleToolbarLabels_;
    private final JMenuItem miZoomReset_;
    private final JMenuItem miZoomIn_;
    private final JMenuItem miZoomOut_;

    public PanViewMenu(PanFrame parent) {
        super(parent, "view-menu");
        AbstractAction a = PanToggleToolbarLabelsAction.getSharedInstance();
        this.miToggleToolbarLabels_ = this.makeItemFromProperties("toggle-toolbar-labels", a);
        this.add(this.miToggleToolbarLabels_).setEnabled(true);
        this.addSeparator();
        this.add(new PanViewSourcesMenu(parent));
        this.addSeparator();
        this.add(new PanViewPlotMenu(parent));
        this.addSeparator();
        a = parent instanceof PanZoomableFrame ? new PanViewZoomResetAction((PanZoomableFrame)parent) : null;
        this.miZoomReset_ = this.makeItemFromProperties("zoom-view-reset", a);
        this.add(this.miZoomReset_).setEnabled(false);
        a = parent instanceof PanZoomableFrame ? new PanViewZoomInAction((PanZoomableFrame)parent) : null;
        this.miZoomIn_ = this.makeItemFromProperties("zoom-view-in", a);
        this.add(this.miZoomIn_).setEnabled(false);
        a = parent instanceof PanZoomableFrame ? new PanViewZoomOutAction((PanZoomableFrame)parent) : null;
        this.miZoomOut_ = this.makeItemFromProperties("zoom-view-out", a);
        this.add(this.miZoomOut_).setEnabled(false);
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        boolean showLabels = prefs.getBoolean("sources:toolbar.labels");
        if (showLabels) {
            this.miToggleToolbarLabels_.setText(PanProperties.MENU_PROPS.getString("hide-toolbar-labels"));
        } else {
            this.miToggleToolbarLabels_.setText(PanProperties.MENU_PROPS.getString("toggle-toolbar-labels"));
        }
        if (this.miZoomReset_.getAction() != null) {
            PanZoomableFrame zframe = (PanZoomableFrame)this.pframe_;
            this.miZoomReset_.setEnabled(true);
            this.miZoomIn_.setEnabled(zframe.canZoomIn());
            this.miZoomOut_.setEnabled(zframe.canZoomOut());
        }
    }
}

