/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanBiggerPlotAction;
import gov.nasa.giss.panoply.action.PanPlotSizeFactorAction;
import gov.nasa.giss.panoply.action.PanSmallerPlotAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanPlotSizeFactor;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.menu.GissCheckBoxMenuItem;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotSizeMenu
extends PanMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final JMenuItem miCurrentSize_;
    private final JMenuItem miBigger_;
    private final JMenuItem miSmaller_;
    private final Hashtable<String, JCheckBoxMenuItem> miPresetsHash_ = new Hashtable(20);

    public PanPlotSizeMenu(PanFrame parent) {
        super(parent, "plot-size-menu");
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        PanPlotMeta pmeta = parentIsPlot ? ((PanPlotFrame)parent).getMeta() : null;
        this.miCurrentSize_ = this.makeItemFromProperties("current-size", null);
        this.add(this.miCurrentSize_).setEnabled(false);
        this.addSeparator();
        AbstractAction a = parentIsPlot ? new PanBiggerPlotAction(pmeta) : null;
        this.miBigger_ = this.makeItemFromProperties("show-bigger", a);
        this.add(this.miBigger_).setEnabled(false);
        a = parentIsPlot ? new PanSmallerPlotAction(pmeta) : null;
        this.miSmaller_ = this.makeItemFromProperties("show-smaller", a);
        this.add(this.miSmaller_).setEnabled(false);
        this.addSeparator();
        for (PanPlotSizeFactor psize : PanPlotSizeFactor.values()) {
            String aid = psize.getActionID();
            if (aid == null) continue;
            String atext = psize.toString();
            PanPlotSizeFactorAction a2 = parentIsPlot && aid != null ? new PanPlotSizeFactorAction(pmeta, psize) : null;
            GissCheckBoxMenuItem jmi = aid != null ? this.makeCheckBoxItemFromProperties(aid, a2) : this.makeCheckBoxItem(atext, a2);
            this.miPresetsHash_.put(aid, jmi);
            this.add(jmi).setEnabled(parentIsPlot);
        }
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (!(this.pframe_ instanceof PanPlotFrame)) {
            return;
        }
        PanPlotFrame ppf = (PanPlotFrame)this.pframe_;
        PanPlotMeta pmeta = ppf.getMeta();
        if (ppf.isAnimationInProgress()) {
            return;
        }
        int sf = pmeta.getInt("size.factor");
        this.miCurrentSize_.setText(PanProperties.MENU_PROPS.getString("current-size") + " = " + sf);
        this.miBigger_.setEnabled(sf < 300);
        this.miSmaller_.setEnabled(sf > 80);
        for (String key : this.miPresetsHash_.keySet()) {
            JCheckBoxMenuItem mi = this.miPresetsHash_.get(key);
            String text = mi.getText();
            PanPlotSizeFactor psize = PanPlotSizeFactor.matching(text);
            boolean matches = psize != null && psize.getSizeFactor() == sf;
            mi.setSelected(matches);
        }
    }
}

