/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.macos;

import gov.nasa.giss.panoply.macos.PanHiddenMacFrame;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.util.PlatformUtils;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanMacApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static boolean success_;

    public static boolean init() {
        PanMacApplication instance = Singleton.INSTANCE;
        return success_;
    }

    private PanMacApplication() {
        if (!PlatformUtils.isMacintosh()) {
            throw new RuntimeException("Cannot create macOS object on this platform.");
        }
        this.initProperties();
        PanSourcesFrame.getSharedInstance();
        PanHiddenMacFrame.getSharedInstance().reveal();
    }

    private void initProperties() {
        block2: {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Panoply");
            System.setProperty("apple.awt.showGrowBox", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.antialiasing", "true");
            System.setProperty("apple.awt.textantialiasing", "true");
            System.setProperty("apple.awt.rendering", "VALUE_RENDER_QUALITY");
            System.setProperty("apple.awt.fractionalmetrics", "VALUE_FRACTIONALMETRICS_ON");
            try {
                System.setProperty("apple.awt.graphics.UseQuartz", "true");
            }
            catch (Exception exc) {
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
    }

    private static class Singleton {
        private static final PanMacApplication INSTANCE = new PanMacApplication();

        private Singleton() {
        }
    }
}

