/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.desktop;

import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.about.PanAboutFrame;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefsui.PanPreferencesFrame;
import gov.nasa.giss.panoply.util.PanQuitHandler;
import java.awt.Desktop;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDesktopAdapter
implements AboutHandler,
OpenFilesHandler,
PreferencesHandler,
QuitHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static boolean initted_;

    public static void init() {
        if (!Desktop.isDesktopSupported()) {
            LOGGER.warn("Desktop not supported on this platform.");
            return;
        }
        if (initted_) {
            LOGGER.warn("Already initialized.");
            return;
        }
        PanDesktopAdapter adapter = new PanDesktopAdapter();
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.setAboutHandler(adapter);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception setting About handler: {}", (Object)exc.getClass());
        }
        try {
            desktop.setOpenFileHandler(adapter);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception setting OpenFile handler: {}", (Object)exc.getClass());
        }
        try {
            desktop.setPreferencesHandler(adapter);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception setting Preferences handler: {}", (Object)exc.getClass());
        }
        try {
            desktop.setQuitHandler(adapter);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception setting Quit handler: {}", (Object)exc.getClass());
        }
        initted_ = true;
    }

    @Override
    public void handleAbout(AboutEvent e) {
        PanAboutFrame.getSharedInstance().reveal();
    }

    @Override
    public void openFiles(OpenFilesEvent e) {
        if (e == null) {
            return;
        }
        List<File> ff = e.getFiles();
        LOGGER.trace("Desktop handler reports {} files to open", (Object)ff.size());
        if (ff.size() < 1) {
            return;
        }
        Panoply.setFilesRequested();
        PanFileUtils.openLocalFiles(null, ff.toArray(new File[0]));
    }

    @Override
    public void handlePreferences(PreferencesEvent e) {
        PanPreferencesFrame.getSharedInstance().reveal();
    }

    @Override
    public void handleQuitRequestWith(QuitEvent e, QuitResponse response) {
        PanQuitHandler.quit();
        response.performQuit();
    }

    private PanDesktopAdapter() {
    }
}

