/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.panoply.data.PanDataGeneral2D;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.time.UnixTimeFormatter;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanDataTimeY
extends PanDataGeneral2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String timeFormat_;

    public PanDataTimeY(NcArray nca, Dimension size) {
        this(nca, size.width, size.height);
    }

    public PanDataTimeY(NcArray nca, int gridWidth, int gridHeight) {
        super(nca, gridWidth, gridHeight);
        this.setGridBottomAndTop(-90.0, 90.0);
    }

    @Override
    protected void prepareXAxisUnits() {
    }

    @Override
    public String getXAxisUnits() {
        return "";
    }

    @Override
    public void setXAxisUnits(String unitsStr) {
        LOGGER.trace("Cannot set X-axis units for time-[Y] data grid.");
    }

    @Override
    public PanAxisMethod getXAxisMethod() {
        return PanAxisMethod.SCALAR;
    }

    @Override
    public void setXAxisMethod(PanAxisMethod method) {
        LOGGER.trace("Cannot set X-axis method for time-[Y] data grid. Using SCALAR.");
    }

    @Override
    public String getXAxisName() {
        return "Time";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArray(int vindex, NcArray nca) {
        PanDataTimeY panDataTimeY = this;
        synchronized (panDataTimeY) {
            NcArray2D nca2D;
            NcTimeAxis tax;
            super.setArray(vindex, nca);
            this.updateTimeFormats();
            if (this.timeFormat_ == null && (tax = (NcTimeAxis)(nca2D = (NcArray2D)nca).getXAxis()).isUnixTime()) {
                UnixTimeFormatter tt = (UnixTimeFormatter)tax.getFormatter();
                this.timeFormat_ = tt.getPattern();
            }
        }
        this.updateTimeFormats();
    }

    public void setTimeFormat(String format) {
        this.timeFormat_ = format;
        this.updateTimeFormats();
    }

    private void updateTimeFormats() {
        if (this.timeFormat_ == null) {
            return;
        }
        for (NcArray nca : this.ncArrays_) {
            NcTimeAxis tax;
            if (nca == null || !(tax = (NcTimeAxis)((NcArray2D)nca).getXAxis()).isUnixTime()) continue;
            UnixTimeFormatter tt = (UnixTimeFormatter)tax.getFormatter();
            tt.applyPattern(this.timeFormat_);
        }
    }
}

