/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayLonTime;
import gov.nasa.giss.panoply.data.PanDataXTime;
import java.awt.Dimension;

public class PanDataLonTime
extends PanDataXTime {
    public PanDataLonTime(NcArray nca, Dimension size) {
        this(nca, size.width, size.height);
    }

    public PanDataLonTime(NcArray nca, int gridWidth, int gridHeight) {
        super(nca, gridWidth, gridHeight);
        this.setGridLeftAndRight(-180.0, 180.0);
    }

    @Override
    protected boolean validateArrayType(NcArray nca) {
        if (!(nca instanceof NcArrayLonTime)) {
            throw new IllegalArgumentException("NcArray is not an NcArrayLonTime.");
        }
        return true;
    }

    @Override
    public String getXAxisName() {
        return "Longitude";
    }

    @Override
    public String getDataXAxisUnits() {
        return "degree_east";
    }

    @Override
    public String getXAxisUnits() {
        return "degree_east";
    }
}

