/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArrayDiscreteTrajectory;
import gov.nasa.giss.data.nc.gridder.NcGridderFeatureTypeTrajectory;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.util.PanCombinationType;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.Converter;

public class PanDataLonLatTrajectory
extends PanData {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private double bound1_;
    private double bound2_;
    private double[][] outputCoords_ = new double[2][];

    public PanDataLonLatTrajectory(NcArray nca) {
        super(nca);
        NcAxis xAxis = ((NcArrayDiscreteTrajectory)nca).getAxis();
        double[][] bounds = xAxis.getBounds();
        this.bound1_ = bounds[0][0];
        this.bound2_ = bounds[xAxis.getLength() - 1][1];
    }

    @Override
    protected boolean validateArrayType(NcArray nca) {
        if (!(nca instanceof NcArrayDiscreteTrajectory)) {
            throw new IllegalArgumentException("NcArray is not an NcArrayDiscreteTrajectory.");
        }
        return true;
    }

    @Override
    protected void prepareGrid() {
    }

    @Override
    protected synchronized void regrid() {
        if (!this.needsGridding_) {
            return;
        }
        if (this.gridding_) {
            return;
        }
        this.gridding_ = true;
        this.prepareGrid();
        double[][] result = null;
        double[][] resultB = null;
        if (this.comboType_ == PanCombinationType.A1_ONLY) {
            result = this.getTrajectoryVals(this.ncArrays_[0]);
            this.convertValues(result, this.ncarUnitConverters_[0]);
        } else if (this.comboType_ == PanCombinationType.A2_ONLY) {
            result = this.getTrajectoryVals(this.ncArrays_[1]);
            this.convertValues(result, this.ncarUnitConverters_[1]);
        } else if (this.comboType_ == PanCombinationType.COMPARE) {
            result = this.getTrajectoryVals(this.ncArrays_[0]);
            resultB = this.getTrajectoryVals(this.ncArrays_[1]);
            this.convertValues(result, this.ncarUnitConverters_[0]);
            this.convertValues(resultB, this.ncarUnitConverters_[1]);
        }
        if (result == null) {
            LOGGER.warn("Got null array for trajectory data.");
            result = null;
        }
        this.outputVals_[0] = this.getValArray(result);
        this.outputCoords_[0] = this.getLLArray(result);
        if (resultB != null) {
            this.outputVals_[1] = this.getValArray(resultB);
            this.outputCoords_[1] = this.getLLArray(resultB);
        } else {
            this.outputVals_[1] = null;
            this.outputCoords_[1] = null;
        }
        this.dataMin_ = Double.NaN;
        this.dataMax_ = Double.NaN;
        this.needsGridding_ = false;
        this.needsExtrema_ = true;
        this.gridding_ = false;
    }

    private double[][] getTrajectoryVals(NcArray nca) {
        NcGridderFeatureTypeTrajectory gridder = (NcGridderFeatureTypeTrajectory)nca.getGridder();
        gridder.setBounds(this.bound1_, this.bound2_);
        return gridder.regridAsIs(nca);
    }

    protected void convertValues(double[][] ptvals, Converter converter) {
        if (ptvals == null) {
            LOGGER.debug("ptvals is null");
            return;
        }
        if (converter == null) {
            return;
        }
        int isize = ptvals.length;
        for (int i = 0; i < isize; ++i) {
            if (Double.isNaN(ptvals[i][2])) continue;
            ptvals[i][2] = converter.convert(ptvals[i][2]);
        }
    }

    private double[] getValArray(double[][] tdata) {
        if (tdata == null) {
            LOGGER.warn("Cannot work with null trajectory data");
            return null;
        }
        double[] target = new double[tdata.length];
        for (int i = 0; i < tdata.length; ++i) {
            target[i] = tdata[i][2];
        }
        return target;
    }

    private double[] getLLArray(double[][] tdata) {
        if (tdata == null) {
            LOGGER.warn("Cannot work with null trajectory data");
            return null;
        }
        double[] target = new double[2 * tdata.length];
        for (int i = 0; i < tdata.length; ++i) {
            target[i * 2] = tdata[i][0];
            target[i * 2 + 1] = tdata[i][1];
        }
        return target;
    }

    public int trajectoryLength(int trajNum) {
        if (this.outputVals_[trajNum] == null) {
            return 0;
        }
        if (this.outputVals_[trajNum].length == 0) {
            this.regrid();
        }
        if (this.outputVals_[trajNum] == null) {
            return 0;
        }
        return this.outputVals_[trajNum].length;
    }

    public double valueAt(int trajNum, int index) {
        if (this.needsGridding_) {
            this.regrid();
        }
        if (this.outputVals_[trajNum] == null) {
            return Double.NaN;
        }
        double result = this.outputVals_[trajNum][index];
        if (this.scalingFactor_ != 1.0) {
            result /= this.scalingFactor_;
        }
        return result;
    }

    public PointLL lonLatAt(int trajNum, int idx) {
        if (this.needsGridding_) {
            this.regrid();
        }
        if (this.outputCoords_[trajNum] == null) {
            return null;
        }
        return new PointLL(this.outputCoords_[trajNum][idx * 2], this.outputCoords_[trajNum][idx * 2 + 1]);
    }

    public PointLL[] getLonLatArray(int trajNum) {
        if (this.needsGridding_) {
            this.regrid();
        }
        if (this.outputCoords_[trajNum] == null) {
            return null;
        }
        int icount = this.outputCoords_[trajNum].length / 2;
        PointLL[] array = new PointLL[icount];
        for (int i = 0; i < icount; ++i) {
            double lon = this.outputCoords_[trajNum][i * 2];
            double lat = this.outputCoords_[trajNum][i * 2 + 1];
            array[i] = Double.isNaN(lon) || Double.isNaN(lat) ? null : new PointLL(lon, lat);
        }
        return array;
    }

    public void describeDataAtAxisPt(StringBuilder sb, double axval) {
        if (this.needsGridding_) {
            this.regrid();
        }
        Objects.requireNonNull(sb, "StringBuilder cannot be null.");
    }
}

