/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.DataGrid2D;
import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcGridder2D;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanVectorType;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.ConversionException;
import ucar.units.Converter;
import ucar.units.Unit;

public abstract class PanData2D
extends PanData
implements DataGrid2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected int gridWidth_;
    protected int gridHeight_;
    protected double lBound_;
    protected double rBound_;
    protected double tBound_;
    protected double bBound_;
    private static Unit angleUnit_;
    private boolean angleUpstream_;
    private PanVectorType vectorComp_ = PanVectorType.XY;

    protected PanData2D(NcArray nca, int width, int height) {
        super(nca);
        this.setSize(width, height);
    }

    @Override
    public int getWidth() {
        return this.gridWidth_;
    }

    @Override
    public int getHeight() {
        return this.gridHeight_;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.gridWidth_, this.gridHeight_);
    }

    public void setSize(int w, int h) {
        if (w == this.gridWidth_ && h == this.gridHeight_) {
            return;
        }
        this.gridWidth_ = w;
        this.gridHeight_ = h;
        this.needsGridding_ = true;
        this.fireDataEvent(PanDataEvent.EType.SIZE_CHANGED);
    }

    public PanVectorType getVectorType() {
        return this.vectorComp_;
    }

    public boolean isVectorMagAngle() {
        return this.comboType_ == PanCombinationType.VECTOR && (this.vectorComp_ == PanVectorType.MAG_ANGLE || this.vectorComp_ == PanVectorType.ANGLE_MAG);
    }

    public boolean isVectorAngleUpstream() {
        return this.isVectorMagAngle() && this.angleUpstream_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] getUnitsChoices() {
        if (this.comboType_ != PanCombinationType.VECTOR) {
            return super.getUnitsChoices();
        }
        ArrayList<String> choices = new ArrayList<String>();
        Unit baseUnit = null;
        if (this.ncaUcarUnits_[0] == null && this.ncaUcarUnits_[1] == null) {
            this.vectorComp_ = PanVectorType.XY;
            return new String[]{"[null units]"};
        }
        if (this.ncaUcarUnits_[0] != null && this.ncaUcarUnits_[1] != null && this.ncArrays_[0].isCompatibleUnits(this.ncArrays_[1])) {
            this.vectorComp_ = PanVectorType.XY;
            baseUnit = this.ncaUcarUnits_[0];
            for (int i = 0; i < 2; ++i) {
                if (this.ncaUcarUnits_[i] == null) continue;
                this.addToUnitsChoices(choices, this.ncaUcarUnits_[i]);
            }
        } else if (this.ncaUcarUnits_[0] != null && this.ncaUcarUnits_[0].isCompatible(angleUnit_)) {
            this.vectorComp_ = PanVectorType.ANGLE_MAG;
            String lclname = this.getVarLongName(0).toLowerCase();
            boolean bl = this.angleUpstream_ = lclname.matches(".*from.*direction.*") || lclname.matches(".*direction.*from.*");
            if (this.ncaUcarUnits_[1] == null) return new String[]{"[null units]"};
            baseUnit = this.ncaUcarUnits_[1];
            this.addToUnitsChoices(choices, this.ncaUcarUnits_[1]);
        } else if (this.ncaUcarUnits_[1] != null && this.ncaUcarUnits_[1].isCompatible(angleUnit_)) {
            this.vectorComp_ = PanVectorType.MAG_ANGLE;
            String lclname = this.getVarLongName(1).toLowerCase();
            boolean bl = this.angleUpstream_ = lclname.matches(".*from.*direction.*") || lclname.matches(".*direction.*from.*");
            if (this.ncaUcarUnits_[0] == null) return new String[]{"[null units]"};
            baseUnit = this.ncaUcarUnits_[0];
            this.addToUnitsChoices(choices, this.ncaUcarUnits_[0]);
        } else {
            this.vectorComp_ = PanVectorType.XY;
            return new String[]{"[incompatible units?]"};
        }
        this.addCompatibleToUnitsChoices(choices, baseUnit);
        if (!choices.isEmpty()) return choices.toArray(new String[0]);
        return new String[]{"<scalar>"};
    }

    @Override
    protected void updateUnitConverters() {
        if (this.comboType_ != PanCombinationType.VECTOR) {
            super.updateUnitConverters();
        }
        this.ncarUnitConverters_[0] = null;
        this.ncarUnitConverters_[1] = null;
        this.targetConverter_ = null;
        if (this.targetUcarUnit_ == null) {
            return;
        }
        if (this.vectorComp_ != null) {
            switch (this.vectorComp_) {
                case XY: {
                    for (int i = 0; i < 2; ++i) {
                        if (this.ncArrays_[i] == null || this.ncaUcarUnits_[i] == null) continue;
                        try {
                            this.ncarUnitConverters_[i] = this.ncaUcarUnits_[i].getConverterTo(this.targetUcarUnit_);
                            continue;
                        }
                        catch (ConversionException exc) {
                            this.ncarUnitConverters_[0] = null;
                            this.ncarUnitConverters_[1] = null;
                            break;
                        }
                    }
                    if (this.ncarUnitConverters_[0] != null) break;
                    this.targetUnitsString_ = null;
                    this.targetUcarUnit_ = null;
                    break;
                }
                case MAG_ANGLE: {
                    try {
                        this.ncarUnitConverters_[0] = this.ncaUcarUnits_[0].getConverterTo(this.targetUcarUnit_);
                    }
                    catch (ConversionException exc) {
                        LOGGER.warn("Units conversion exception (MA1): {} -> {}", (Object)this.ncaUcarUnits_[0], (Object)this.targetUcarUnit_);
                        this.ncarUnitConverters_[0] = null;
                        this.ncarUnitConverters_[1] = null;
                        this.targetConverter_ = null;
                        return;
                    }
                    try {
                        this.ncarUnitConverters_[1] = this.ncaUcarUnits_[1].getConverterTo(angleUnit_);
                        break;
                    }
                    catch (ConversionException exc) {
                        LOGGER.warn("Units conversion exception (MA2): {} -> {}", (Object)this.ncaUcarUnits_[1], (Object)angleUnit_);
                        this.ncarUnitConverters_[0] = null;
                        this.ncarUnitConverters_[1] = null;
                        this.targetConverter_ = null;
                        return;
                    }
                }
                case ANGLE_MAG: {
                    try {
                        this.ncarUnitConverters_[0] = this.ncaUcarUnits_[0].getConverterTo(angleUnit_);
                    }
                    catch (ConversionException exc) {
                        LOGGER.warn("Units conversion exception (AM1): {} -> {}", (Object)this.ncaUcarUnits_[0], (Object)angleUnit_);
                        this.ncarUnitConverters_[0] = null;
                        this.ncarUnitConverters_[1] = null;
                        this.targetConverter_ = null;
                        return;
                    }
                    try {
                        this.ncarUnitConverters_[1] = this.ncaUcarUnits_[1].getConverterTo(this.targetUcarUnit_);
                        break;
                    }
                    catch (ConversionException exc) {
                        LOGGER.warn("Units conversion exception (AM2): {} -> {}", (Object)this.ncaUcarUnits_[1], (Object)this.targetUcarUnit_);
                        this.ncarUnitConverters_[0] = null;
                        this.ncarUnitConverters_[1] = null;
                        this.targetConverter_ = null;
                        return;
                    }
                }
                default: {
                    LOGGER.trace("Uncoded vector components type {}", (Object)this.vectorComp_);
                }
            }
        }
        this.targetConverter_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void regrid() {
        if (!this.needsGridding_) {
            return;
        }
        if (this.gridding_) {
            return;
        }
        this.gridding_ = true;
        PanData2D panData2D = this;
        synchronized (panData2D) {
            this.prepareGrid();
            int totalVals = this.gridWidth_ * this.gridHeight_;
            this.outputVals_[0] = new double[totalVals];
            this.outputVals_[1] = null;
            block2 : switch (this.comboType_) {
                case A1_ONLY: {
                    this.regrid(this.ncArrays_[0], this.outputVals_[0]);
                    this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[0]);
                    break;
                }
                case A2_ONLY: {
                    this.regrid(this.ncArrays_[1], this.outputVals_[0]);
                    this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[1]);
                    break;
                }
                case A1_MINUS_A2: {
                    double[] gridBValues = new double[totalVals];
                    this.regrid(this.ncArrays_[0], this.outputVals_[0]);
                    this.regrid(this.ncArrays_[1], gridBValues);
                    this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[0]);
                    this.convertArray(gridBValues, this.ncarUnitConverters_[1]);
                    this.combineArrays(PanData.CombineOperation.SUBTRACT, this.outputVals_[0], gridBValues, this.outputVals_[0], null);
                    break;
                }
                case A1_MINUS_A2_PCT: {
                    double[] gridBValues = new double[totalVals];
                    this.regrid(this.ncArrays_[0], this.outputVals_[0]);
                    this.regrid(this.ncArrays_[1], gridBValues);
                    this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[0]);
                    this.convertArray(gridBValues, this.ncarUnitConverters_[1]);
                    this.combineArrays(PanData.CombineOperation.SUBTRACT, this.outputVals_[0], gridBValues, this.outputVals_[0], null);
                    this.combineArrays(PanData.CombineOperation.DIVIDE, this.outputVals_[0], gridBValues, this.outputVals_[0], null);
                    this.convertArray(this.outputVals_[0], this.targetConverter_);
                    break;
                }
                case A2_MINUS_A1: {
                    double[] gridBValues = new double[totalVals];
                    this.regrid(this.ncArrays_[1], this.outputVals_[0]);
                    this.regrid(this.ncArrays_[0], gridBValues);
                    this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[1]);
                    this.convertArray(gridBValues, this.ncarUnitConverters_[0]);
                    this.combineArrays(PanData.CombineOperation.SUBTRACT, this.outputVals_[0], gridBValues, this.outputVals_[0], null);
                    break;
                }
                case A2_MINUS_A1_PCT: {
                    double[] gridBValues = new double[totalVals];
                    this.regrid(this.ncArrays_[1], this.outputVals_[0]);
                    this.regrid(this.ncArrays_[0], gridBValues);
                    this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[1]);
                    this.convertArray(gridBValues, this.ncarUnitConverters_[0]);
                    this.combineArrays(PanData.CombineOperation.SUBTRACT, this.outputVals_[0], gridBValues, this.outputVals_[0], null);
                    this.combineArrays(PanData.CombineOperation.DIVIDE, this.outputVals_[0], gridBValues, this.outputVals_[0], null);
                    this.convertArray(this.outputVals_[0], this.targetConverter_);
                    break;
                }
                case A1_PLUS_A2: {
                    double[] gridBValues = new double[totalVals];
                    this.regrid(this.ncArrays_[0], this.outputVals_[0]);
                    this.regrid(this.ncArrays_[1], gridBValues);
                    this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[0]);
                    this.convertArray(gridBValues, this.ncarUnitConverters_[1]);
                    this.combineArrays(PanData.CombineOperation.ADD, this.outputVals_[0], gridBValues, this.outputVals_[0], null);
                    break;
                }
                case A1_TIMES_A2: {
                    double[] gridBValues = new double[totalVals];
                    this.regrid(this.ncArrays_[0], this.outputVals_[0]);
                    this.regrid(this.ncArrays_[1], gridBValues);
                    this.combineArrays(PanData.CombineOperation.MULTIPLY, this.outputVals_[0], gridBValues, this.outputVals_[0], null);
                    this.convertArray(this.outputVals_[0], this.targetConverter_);
                    break;
                }
                case A1_OVER_A2: {
                    double[] gridBValues = new double[totalVals];
                    this.regrid(this.ncArrays_[0], this.outputVals_[0]);
                    this.regrid(this.ncArrays_[1], gridBValues);
                    this.combineArrays(PanData.CombineOperation.DIVIDE, this.outputVals_[0], gridBValues, this.outputVals_[0], null);
                    this.convertArray(this.outputVals_[0], this.targetConverter_);
                    break;
                }
                case A2_OVER_A1: {
                    double[] gridBValues = new double[totalVals];
                    this.regrid(this.ncArrays_[1], this.outputVals_[0]);
                    this.regrid(this.ncArrays_[0], gridBValues);
                    this.combineArrays(PanData.CombineOperation.DIVIDE, this.outputVals_[0], gridBValues, this.outputVals_[0], null);
                    this.convertArray(this.outputVals_[0], this.targetConverter_);
                    break;
                }
                case AVERAGE: {
                    double[] gridBValues = new double[totalVals];
                    this.regrid(this.ncArrays_[0], this.outputVals_[0]);
                    this.regrid(this.ncArrays_[1], gridBValues);
                    this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[0]);
                    this.convertArray(gridBValues, this.ncarUnitConverters_[1]);
                    this.combineArrays(PanData.CombineOperation.AVERAGE, this.outputVals_[0], gridBValues, this.outputVals_[0], null);
                    break;
                }
                case MERGE: {
                    double[] gridBValues = new double[totalVals];
                    this.regrid(this.ncArrays_[0], this.outputVals_[0]);
                    this.regrid(this.ncArrays_[1], gridBValues);
                    this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[0]);
                    this.convertArray(gridBValues, this.ncarUnitConverters_[1]);
                    this.combineArrays(PanData.CombineOperation.MERGE, this.outputVals_[0], gridBValues, this.outputVals_[0], null);
                    break;
                }
                case VECTOR: {
                    switch (this.vectorComp_) {
                        case XY: {
                            double[] gridBValues = new double[totalVals];
                            this.regrid(this.ncArrays_[0], this.outputVals_[0]);
                            this.regrid(this.ncArrays_[1], gridBValues);
                            this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[0]);
                            this.convertArray(gridBValues, this.ncarUnitConverters_[1]);
                            this.outputVals_[1] = gridBValues;
                            this.combineArrays(PanData.CombineOperation.MAGNITUDE, this.outputVals_[0], gridBValues, this.outputVals_[0], this.outputVals_[1]);
                            break block2;
                        }
                        case MAG_ANGLE: {
                            this.outputVals_[1] = new double[totalVals];
                            this.regrid(this.ncArrays_[0], this.outputVals_[0]);
                            this.regrid(this.ncArrays_[1], this.outputVals_[1]);
                            this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[0]);
                            this.convertArray(this.outputVals_[1], this.ncarUnitConverters_[1]);
                            break block2;
                        }
                        case ANGLE_MAG: {
                            this.outputVals_[1] = new double[totalVals];
                            this.regrid(this.ncArrays_[0], this.outputVals_[1]);
                            this.regrid(this.ncArrays_[1], this.outputVals_[0]);
                            this.convertArray(this.outputVals_[1], this.ncarUnitConverters_[0]);
                            this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[1]);
                            break block2;
                        }
                    }
                    LOGGER.trace("Uncoded vector components type {}", (Object)this.vectorComp_);
                    break;
                }
                case COMPARE: {
                    this.outputVals_[1] = new double[totalVals];
                    this.regrid(this.ncArrays_[0], this.outputVals_[0]);
                    this.regrid(this.ncArrays_[1], this.outputVals_[1]);
                    this.convertArray(this.outputVals_[0], this.ncarUnitConverters_[0]);
                    this.convertArray(this.outputVals_[1], this.ncarUnitConverters_[1]);
                    break;
                }
                default: {
                    LOGGER.trace("Uncoded combination type {}", (Object)this.comboType_);
                }
            }
        }
        this.dataMin_ = Double.NaN;
        this.dataMax_ = Double.NaN;
        this.needsGridding_ = false;
        this.needsExtrema_ = true;
        this.gridding_ = false;
    }

    private void regrid(NcArray nca, double[] target) {
        Objects.requireNonNull(target, "Target array cannot be null.");
        this.fillArrayNaN(target);
        this.regrid(nca, target, this.interpolated_);
    }

    protected void regrid(NcArray nca, double[] target, boolean interpolated) {
        NcGridder2D gridder = (NcGridder2D)nca.getGridder();
        gridder.setSize(this.gridWidth_, this.gridHeight_);
        gridder.setBounds(this.lBound_, this.tBound_, this.rBound_, this.bBound_);
        if (interpolated) {
            gridder.regridInterpolate(nca, target);
        } else {
            gridder.regridNoInterpolate(nca, target);
        }
    }

    private void combineArrays(PanData.CombineOperation how, double[] array1, double[] array2, double[] target, double[] angles) {
        int isize = array1.length;
        if (array2.length != isize) {
            throw new IllegalArgumentException("Arrays are different lengths");
        }
        if (target.length != isize) {
            throw new IllegalArgumentException("Arrays are different lengths");
        }
        switch (how) {
            case ADD: {
                for (int i = 0; i < isize; ++i) {
                    target[i] = Double.isNaN(array1[i]) || Double.isNaN(array2[i]) ? Double.NaN : array1[i] + array2[i];
                }
                break;
            }
            case SUBTRACT: {
                for (int i = 0; i < isize; ++i) {
                    target[i] = Double.isNaN(array1[i]) || Double.isNaN(array2[i]) ? Double.NaN : array1[i] - array2[i];
                }
                break;
            }
            case MULTIPLY: {
                for (int i = 0; i < isize; ++i) {
                    target[i] = Double.isNaN(array1[i]) || Double.isNaN(array2[i]) ? Double.NaN : array1[i] * array2[i];
                }
                break;
            }
            case DIVIDE: {
                for (int i = 0; i < isize; ++i) {
                    target[i] = array2[i] == 0.0 || Double.isNaN(array1[i]) || Double.isNaN(array2[i]) ? Double.NaN : array1[i] / array2[i];
                }
                break;
            }
            case AVERAGE: {
                for (int i = 0; i < isize; ++i) {
                    target[i] = Double.isNaN(array1[i]) || Double.isNaN(array2[i]) ? Double.NaN : 0.5 * (array1[i] + array2[i]);
                }
                break;
            }
            case MERGE: {
                for (int i = 0; i < isize; ++i) {
                    target[i] = Double.isNaN(array1[i]) && Double.isNaN(array2[i]) ? Double.NaN : (Double.isNaN(array1[i]) ? array2[i] : (Double.isNaN(array2[i]) ? array1[i] : 0.5 * (array1[i] + array2[i])));
                }
                break;
            }
            case MAGNITUDE: {
                if (angles.length != isize) {
                    throw new IllegalArgumentException("Angle array is wrong length");
                }
                for (int i = 0; i < isize; ++i) {
                    double v1 = array1[i];
                    double v2 = array2[i];
                    if (Double.isNaN(v1) || Double.isNaN(v2)) {
                        target[i] = Double.NaN;
                        angles[i] = 0.0;
                        continue;
                    }
                    target[i] = Math.hypot(v1, v2);
                    angles[i] = Math.atan2(v1, v2);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown merge method.");
            }
        }
    }

    private void convertArray(double[] array, Converter converter) {
        if (converter == null) {
            return;
        }
        int isize = array.length;
        for (int i = 0; i < isize; ++i) {
            if (Double.isNaN(array[i])) continue;
            array[i] = converter.convert(array[i]);
        }
    }

    @Override
    public String getDescription() {
        if (this.comboType_ != PanCombinationType.VECTOR) {
            return super.getDescription();
        }
        StringBuilder sb = new StringBuilder("");
        String first = this.ncArrays_[0].getLongName();
        String second = this.ncArrays_[1].getLongName();
        if (first == null) {
            first = "null";
        }
        if (second == null) {
            second = "null";
        }
        if (first.equalsIgnoreCase(second)) {
            second = first;
        }
        if (this.vectorComp_ == PanVectorType.XY) {
            sb.append("Sqrt").append('[').append('(').append(first).append(")\u00b2 + ").append('(').append(second).append(")\u00b2").append(']');
        } else if (this.vectorComp_ == PanVectorType.MAG_ANGLE) {
            sb.append(first);
        } else if (this.vectorComp_ == PanVectorType.ANGLE_MAG) {
            sb.append(second);
        }
        return sb.toString();
    }

    public NcAxis getXAxis() {
        if (this.ncArrays_[1] != null && this.comboType_ == PanCombinationType.A2_ONLY) {
            return ((NcArray2D)this.ncArrays_[1]).getXAxis();
        }
        return ((NcArray2D)this.ncArrays_[0]).getXAxis();
    }

    @Override
    public String getXAxisName() {
        String xname = this.getXAxis().getLongName();
        StringBuilder sb = new StringBuilder();
        if (xname.contains(" (")) {
            sb.append(xname.substring(0, xname.indexOf(" (")));
        } else {
            sb.append(xname);
        }
        return sb.toString();
    }

    public String getXAxisLabelStr() {
        StringBuilder sb = new StringBuilder(this.getXAxisName());
        String unitsStr = this.getXAxisUnits();
        if (unitsStr == null) {
            return sb.toString();
        }
        sb.append(" (");
        if (NcUnitUtils.isDegreesEast(unitsStr)) {
            sb.append("\u00b0E");
        } else if (NcUnitUtils.isDegreesNorth(unitsStr)) {
            sb.append("\u00b0N");
        } else {
            sb.append(unitsStr);
        }
        sb.append(")");
        return sb.toString();
    }

    public double[] getDataXAxisBounds() {
        NcAxis a = null;
        a = this.ncArrays_[1] != null && this.comboType_ == PanCombinationType.A2_ONLY ? ((NcArray2D)this.ncArrays_[1]).getXAxis() : ((NcArray2D)this.ncArrays_[0]).getXAxis();
        double[][] bounds = a.getBounds();
        return new double[]{bounds[0][0], bounds[a.getLength() - 1][1]};
    }

    public NcAxis getYAxis() {
        if (this.ncArrays_[1] != null && this.comboType_ == PanCombinationType.A2_ONLY) {
            return ((NcArray2D)this.ncArrays_[1]).getYAxis();
        }
        return ((NcArray2D)this.ncArrays_[0]).getYAxis();
    }

    @Override
    public String getYAxisName() {
        String yname = this.getYAxis().getLongName();
        StringBuilder sb = new StringBuilder();
        if (yname.contains(" (")) {
            sb.append(yname.substring(0, yname.indexOf(" (")));
        } else {
            sb.append(yname);
        }
        return sb.toString();
    }

    public String getYAxisLabelStr() {
        StringBuilder sb = new StringBuilder(this.getYAxisName());
        String unitsStr = this.getYAxisUnits();
        if (unitsStr == null) {
            return sb.toString();
        }
        sb.append(" (");
        if (NcUnitUtils.isDegreesEast(unitsStr)) {
            sb.append("\u00b0E");
        } else if (NcUnitUtils.isDegreesNorth(unitsStr)) {
            sb.append("\u00b0N");
        } else {
            sb.append(unitsStr);
        }
        sb.append(")");
        return sb.toString();
    }

    public double[] getDataYAxisBounds() {
        NcAxis a = null;
        a = this.ncArrays_[1] != null && this.comboType_ == PanCombinationType.A2_ONLY ? ((NcArray2D)this.ncArrays_[1]).getYAxis() : ((NcArray2D)this.ncArrays_[0]).getYAxis();
        double[][] bounds = a.getBounds();
        return new double[]{bounds[0][0], bounds[a.getLength() - 1][1]};
    }

    @Override
    protected void prepareGrid() {
        this.prepareXGrid();
        this.prepareYGrid();
    }

    protected abstract void prepareXGrid();

    protected abstract void prepareYGrid();

    @Override
    public double valueAt(int col, int row) {
        if (col < 0 || col >= this.gridWidth_) {
            throw new IndexOutOfBoundsException("Column index " + col + " out of bounds");
        }
        if (row < 0 || row >= this.gridHeight_) {
            throw new IndexOutOfBoundsException("Row index " + row + " out of bounds");
        }
        return this.valueAt(row * this.gridWidth_ + col);
    }

    protected double valueAt(int index) {
        if (this.needsGridding_) {
            this.regrid();
        }
        double result = this.outputVals_[0][index];
        if (this.scalingFactor_ != 1.0) {
            result /= this.scalingFactor_;
        }
        return result;
    }

    public double secondValueAt(int col, int row) {
        return this.secondValueAt(row * this.gridWidth_ + col);
    }

    protected double secondValueAt(int index) {
        if (this.needsGridding_) {
            this.regrid();
        }
        if (this.comboType_ == PanCombinationType.VECTOR) {
            return this.outputVals_[1][index];
        }
        if (this.comboType_ == PanCombinationType.COMPARE) {
            double result = this.outputVals_[1][index];
            if (this.scalingFactor_ != 1.0) {
                result /= this.scalingFactor_;
            }
            return result;
        }
        return Double.NaN;
    }

    public Point2D.Double transformXY2GridCoords(double x, double y) {
        if (this.gridWidth_ < 1 || this.gridHeight_ < 1) {
            return null;
        }
        double xx = this.lBound_ + x * (this.lBound_ - this.rBound_) / (double)this.gridWidth_;
        double yy = this.tBound_ + y * (this.bBound_ - this.tBound_) / (double)this.gridHeight_;
        return new Point2D.Double(xx, yy);
    }

    @Override
    public double getColX(int col) {
        return this.lBound_ + ((double)col + 0.5) * (this.rBound_ - this.lBound_) / (double)this.gridWidth_;
    }

    @Override
    public double getRowY(int row) {
        return this.tBound_ + ((double)row + 0.5) * (this.bBound_ - this.tBound_) / (double)this.gridHeight_;
    }

    @Override
    public Point2D.Double getXY(double col, double row) {
        if (this.gridWidth_ < 1 || this.gridHeight_ < 1) {
            return null;
        }
        double x = this.lBound_ + col / (double)this.gridWidth_ * (this.rBound_ - this.lBound_);
        double y = this.tBound_ + row / (double)this.gridHeight_ * (this.bBound_ - this.tBound_);
        return new Point2D.Double(x, y);
    }

    public abstract void describeDataAt(StringBuilder var1, int var2, int var3);

    static {
        try {
            angleUnit_ = NcUnitUtils.parse("rad");
        }
        catch (Exception exc) {
            throw new RuntimeException("Could not create standard units");
        }
    }
}

