/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.gridder.NcAxisMethod;
import gov.nasa.giss.data.nc.gridder.NcGridder1D;
import gov.nasa.giss.math.DouglasPeuckerSimplifier;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.Converter;
import ucar.units.Unit;

public class PanData1D
extends PanData {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double DP_TOLERANCE = 0.0025;
    private PanAxisMethod axisMethod_ = PanAxisMethod.SCALAR;
    protected double bound1_;
    protected double bound2_;
    protected double[][] axisValues_;
    private String axisUnitsStr_;
    private Unit axisUnits_;
    private Converter[] axisUnitsConverter_;

    public PanData1D(NcArray nca) {
        super(nca);
        NcAxis axis = ((NcArray1D)nca).getAxis();
        double[][] bounds = axis.getBounds();
        this.bound1_ = bounds[0][0];
        this.bound2_ = bounds[axis.getLength() - 1][1];
    }

    @Override
    protected boolean validateArrayType(NcArray nca) {
        if (!(nca instanceof NcArray1D)) {
            throw new IllegalArgumentException("NcArray is not an NcArray1D.");
        }
        return true;
    }

    public NcAxis getAxis() {
        return ((NcArray1D)this.ncArrays_[0]).getAxis();
    }

    public boolean isAxisPressure() {
        return this.getAxis().isPressure();
    }

    public boolean isAxisHeight() {
        return this.getAxis().isHeight();
    }

    public String getAxisShortName() {
        NcAxis ax = ((NcArray1D)this.ncArrays_[0]).getAxis();
        return ax.getShortName();
    }

    public String getAxisLabel() {
        String name = this.getAxisShortName();
        String unitsStr = this.getAxisUnits();
        if (name == null || name.isEmpty()) {
            if (unitsStr != null) {
                return unitsStr;
            }
            return "\u2026";
        }
        if (unitsStr == null || unitsStr.isEmpty()) {
            return name;
        }
        if (NcUnitUtils.isDegreesEast(unitsStr)) {
            return "Longitude (\u00b0E)";
        }
        if (NcUnitUtils.isDegreesNorth(unitsStr)) {
            return "Latitude (\u00b0N)";
        }
        return name + " (" + unitsStr + ")";
    }

    protected void prepareAxisUnits() {
        NcArray1D[] nca1D = new NcArray1D[]{(NcArray1D)this.ncArrays_[0], (NcArray1D)this.ncArrays_[1]};
        Unit[] ucarUnits = new Unit[]{null, null};
        ucarUnits[0] = nca1D[0] != null ? nca1D[0].getAxis().getUcarUnits() : null;
        ucarUnits[1] = nca1D[1] != null ? nca1D[1].getAxis().getUcarUnits() : null;
        this.axisUnitsConverter_ = new Converter[]{null, null};
        if (ucarUnits[0] != null) {
            try {
                this.axisUnitsConverter_[0] = ucarUnits[0].getConverterTo(this.axisUnits_);
            }
            catch (Exception exc) {
                this.axisUnitsConverter_[0] = null;
            }
        }
        if (ucarUnits[1] != null) {
            try {
                this.axisUnitsConverter_[1] = ucarUnits[1].getConverterTo(this.axisUnits_);
            }
            catch (Exception exc) {
                this.axisUnitsConverter_[1] = null;
            }
        }
    }

    public String getDataAxisUnits() {
        NcAxis a = ((NcArray1D)this.ncArrays_[0]).getAxis();
        return a.getUnitsString();
    }

    public String getAxisUnits() {
        String xunits = this.axisUnits_ != null ? this.axisUnitsStr_ : this.getAxis().getUnitsString();
        LOGGER.trace("{}", (Object)xunits);
        if (xunits == null || xunits.isEmpty() || xunits.equals("-")) {
            return null;
        }
        return xunits;
    }

    public void setAxisUnits(String unitsStr) {
        LOGGER.trace("{}", (Object)unitsStr);
        this.axisUnitsStr_ = unitsStr;
        try {
            this.axisUnits_ = NcUnitUtils.parse(unitsStr);
        }
        catch (Exception exc) {
            this.axisUnitsStr_ = null;
            this.axisUnits_ = null;
        }
        this.setBoundsChanged();
    }

    public PanAxisMethod getAxisMethod() {
        return this.axisMethod_;
    }

    public void setAxisMethod(PanAxisMethod method) {
        this.axisMethod_ = method;
        this.bound1_ = Double.NaN;
        this.bound2_ = Double.NaN;
        this.setBoundsChanged();
    }

    public double[] getAxisBounds() {
        return new double[]{this.bound1_, this.bound2_};
    }

    public void setAxisBounds(double bound1, double bound2) {
        this.bound1_ = bound1;
        this.bound2_ = bound2;
        this.setBoundsChanged();
    }

    public double[] getDefaultAxisRange(PanAxisMethod method) {
        double bound1 = Double.NaN;
        double bound2 = Double.NaN;
        this.prepareAxisUnits();
        for (int i = 0; i < 2; ++i) {
            double bb;
            double tt;
            if (this.ncArrays_[i] == null) continue;
            NcAxis a = ((NcArray1D)this.ncArrays_[i]).getAxis();
            double[] values = a.getValues();
            double v1 = values[0];
            double v2 = values[a.getLength() - 1];
            if (a.isPositiveUp()) {
                tt = Math.max(v1, v2);
                bb = Math.min(v1, v2);
            } else if (a.isPositiveDown()) {
                tt = Math.min(v1, v2);
                bb = Math.max(v1, v2);
            } else {
                bb = v1;
                tt = v2;
            }
            if (this.axisUnitsConverter_ != null && this.axisUnitsConverter_[i] != null) {
                bb = this.axisUnitsConverter_[i].convert(bb);
                tt = this.axisUnitsConverter_[i].convert(tt);
            }
            if (Double.isNaN(bound1)) {
                bound1 = bb;
                bound2 = tt;
                continue;
            }
            if (bound1 < bound2) {
                bound1 = MathUtils.min(bound1, bb, tt);
                bound2 = MathUtils.max(bound2, bb, tt);
                continue;
            }
            bound1 = MathUtils.max(bound1, bb, tt);
            bound2 = MathUtils.min(bound2, bb, tt);
        }
        if (method == PanAxisMethod.LOG10) {
            if (bound1 <= 0.0) {
                bound1 = 1.0E-50;
            }
            if (bound2 <= 0.0) {
                bound2 = 1.0E-50;
            }
        }
        return new double[]{bound1, bound2};
    }

    @Override
    protected void prepareGrid() {
        if (Double.isNaN(this.bound1_) || Double.isNaN(this.bound2_)) {
            double[] defaults = this.getDefaultAxisRange(this.axisMethod_);
            this.bound1_ = defaults[0];
            this.bound2_ = defaults[1];
        }
    }

    @Override
    protected synchronized void regrid() {
        if (!this.needsGridding_) {
            return;
        }
        if (this.gridding_) {
            return;
        }
        this.gridding_ = true;
        this.prepareGrid();
        Point2D.Double[][] result = new Point2D.Double[2][];
        LOGGER.trace("{}", (Object)this.comboType_);
        switch (this.comboType_) {
            case A1_ONLY: {
                result[0] = this.getGridVals(this.ncArrays_[0]);
                this.convertValues(result[0], this.ncarUnitConverters_[0]);
                break;
            }
            case A2_ONLY: {
                result[0] = this.getGridVals(this.ncArrays_[1]);
                this.convertValues(result[0], this.ncarUnitConverters_[1]);
                break;
            }
            case A1_MINUS_A2: {
                Point2D.Double[] line1 = this.getGridVals(this.ncArrays_[0]);
                Point2D.Double[] line2 = this.getGridVals(this.ncArrays_[1]);
                this.convertValues(line1, this.ncarUnitConverters_[0]);
                this.convertValues(line2, this.ncarUnitConverters_[1]);
                result[0] = this.combineLines(PanData.CombineOperation.SUBTRACT, line1, line2);
                break;
            }
            case A2_MINUS_A1: {
                Point2D.Double[] line1 = this.getGridVals(this.ncArrays_[1]);
                Point2D.Double[] line2 = this.getGridVals(this.ncArrays_[0]);
                this.convertValues(line1, this.ncarUnitConverters_[1]);
                this.convertValues(line2, this.ncarUnitConverters_[0]);
                result[0] = this.combineLines(PanData.CombineOperation.SUBTRACT, line1, line2);
                break;
            }
            case A1_PLUS_A2: {
                Point2D.Double[] line1 = this.getGridVals(this.ncArrays_[0]);
                Point2D.Double[] line2 = this.getGridVals(this.ncArrays_[1]);
                this.convertValues(line1, this.ncarUnitConverters_[0]);
                this.convertValues(line2, this.ncarUnitConverters_[1]);
                result[0] = this.combineLines(PanData.CombineOperation.ADD, line1, line2);
                break;
            }
            case A1_TIMES_A2: {
                Point2D.Double[] line1 = this.getGridVals(this.ncArrays_[0]);
                Point2D.Double[] line2 = this.getGridVals(this.ncArrays_[1]);
                result[0] = this.combineLines(PanData.CombineOperation.MULTIPLY, line1, line2);
                this.convertValues(result[0], this.targetConverter_);
                break;
            }
            case A1_OVER_A2: {
                Point2D.Double[] line1 = this.getGridVals(this.ncArrays_[0]);
                Point2D.Double[] line2 = this.getGridVals(this.ncArrays_[1]);
                result[0] = this.combineLines(PanData.CombineOperation.DIVIDE, line1, line2);
                this.convertValues(result[0], this.targetConverter_);
                break;
            }
            case A2_OVER_A1: {
                Point2D.Double[] line1 = this.getGridVals(this.ncArrays_[1]);
                Point2D.Double[] line2 = this.getGridVals(this.ncArrays_[0]);
                result[0] = this.combineLines(PanData.CombineOperation.DIVIDE, line1, line2);
                this.convertValues(result[0], this.targetConverter_);
                break;
            }
            case A1_MINUS_A2_PCT: {
                Point2D.Double[] line1 = this.getGridVals(this.ncArrays_[0]);
                Point2D.Double[] line2 = this.getGridVals(this.ncArrays_[1]);
                this.convertValues(line1, this.ncarUnitConverters_[0]);
                this.convertValues(line2, this.ncarUnitConverters_[1]);
                Point2D.Double[] temp = this.combineLines(PanData.CombineOperation.SUBTRACT, line1, line2);
                result[0] = this.combineLines(PanData.CombineOperation.DIVIDE, temp, line2);
                this.convertValues(result[0], this.targetConverter_);
                break;
            }
            case A2_MINUS_A1_PCT: {
                Point2D.Double[] line1 = this.getGridVals(this.ncArrays_[1]);
                Point2D.Double[] line2 = this.getGridVals(this.ncArrays_[0]);
                this.convertValues(line1, this.ncarUnitConverters_[1]);
                this.convertValues(line2, this.ncarUnitConverters_[0]);
                Point2D.Double[] temp = this.combineLines(PanData.CombineOperation.SUBTRACT, line1, line2);
                result[0] = this.combineLines(PanData.CombineOperation.DIVIDE, temp, line2);
                this.convertValues(result[0], this.targetConverter_);
                break;
            }
            case AVERAGE: {
                Point2D.Double[] line1 = this.getGridVals(this.ncArrays_[0]);
                Point2D.Double[] line2 = this.getGridVals(this.ncArrays_[1]);
                this.convertValues(line1, this.ncarUnitConverters_[0]);
                this.convertValues(line2, this.ncarUnitConverters_[1]);
                result[0] = this.combineLines(PanData.CombineOperation.AVERAGE, line1, line2);
                break;
            }
            case MERGE: {
                Point2D.Double[] line1 = this.getGridVals(this.ncArrays_[0]);
                Point2D.Double[] line2 = this.getGridVals(this.ncArrays_[1]);
                this.convertValues(line1, this.ncarUnitConverters_[0]);
                this.convertValues(line2, this.ncarUnitConverters_[1]);
                result[0] = this.combineLines(PanData.CombineOperation.MERGE, line1, line2);
                break;
            }
            case COMPARE: {
                result[0] = this.getGridVals(this.ncArrays_[0]);
                result[1] = this.getGridVals(this.ncArrays_[1]);
                this.convertValues(result[0], this.ncarUnitConverters_[0]);
                this.convertValues(result[1], this.ncarUnitConverters_[1]);
                break;
            }
            default: {
                LOGGER.trace("Uncoded combination type {}", (Object)this.comboType_);
            }
        }
        for (int i = 0; i < 2; ++i) {
            if (result[i] == null || result[i].length < 12000) continue;
            double[] minmax = this.getRangeExtrema(result[i]);
            double range = Math.abs(minmax[1] - minmax[0]);
            double tolerance = Double.isNaN(minmax[0]) ? 0.01 : 0.0025 * range;
            result[i] = DouglasPeuckerSimplifier.simplify(result[i], tolerance, this.bound1_, this.bound2_);
        }
        this.axisValues_ = new double[2][];
        this.axisValues_[0] = this.getXArray(result[0]);
        this.outputVals_[0] = this.getYArray(result[0]);
        if (result[1] != null) {
            this.axisValues_[1] = this.getXArray(result[1]);
            this.outputVals_[1] = this.getYArray(result[1]);
        } else {
            this.axisValues_[1] = null;
            this.outputVals_[1] = null;
        }
        this.dataMin_ = Double.NaN;
        this.dataMax_ = Double.NaN;
        this.needsGridding_ = false;
        this.needsExtrema_ = true;
        this.gridding_ = false;
    }

    private Point2D.Double[] getGridVals(NcArray nca) {
        NcGridder1D gridder = (NcGridder1D)nca.getGridder();
        gridder.setBounds(this.bound1_, this.bound2_);
        gridder.setAxisUnits(this.axisUnits_);
        if (this.axisMethod_ == PanAxisMethod.LOG10) {
            gridder.setAxisMethod(NcAxisMethod.LOG10);
        } else {
            gridder.setAxisMethod(NcAxisMethod.SCALAR);
        }
        return gridder.regridAsIs(nca);
    }

    private double[] getRangeExtrema(Point2D.Double ... pts) {
        double min = Double.NaN;
        double max = Double.NaN;
        boolean onefound = false;
        for (Point2D.Double pt : pts) {
            if (Double.isNaN(pt.y) || Double.isInfinite(pt.y)) continue;
            if (onefound) {
                if (pt.y < min) {
                    min = pt.y;
                    continue;
                }
                if (!(pt.y > max)) continue;
                max = pt.y;
                continue;
            }
            min = pt.y;
            max = pt.y;
            onefound = true;
        }
        return new double[]{min, max};
    }

    private Point2D.Double[] combineLines(PanData.CombineOperation how, Point2D.Double[] line1, Point2D.Double[] line2) {
        int i;
        int isize = line1.length;
        Point2D.Double[] target = new Point2D.Double[line1.length];
        for (i = 0; i < line1.length; ++i) {
            target[i] = (Point2D.Double)line1[i].clone();
        }
        switch (how) {
            case ADD: {
                for (i = 0; i < isize; ++i) {
                    target[i].y = Double.isNaN(line1[i].y) || Double.isNaN(line2[i].y) ? Double.NaN : line1[i].y + line2[i].y;
                }
                break;
            }
            case SUBTRACT: {
                for (i = 0; i < isize; ++i) {
                    target[i].y = Double.isNaN(line1[i].y) || Double.isNaN(line2[i].y) ? Double.NaN : line1[i].y - line2[i].y;
                }
                break;
            }
            case MULTIPLY: {
                for (i = 0; i < isize; ++i) {
                    target[i].y = Double.isNaN(line1[i].y) || Double.isNaN(line2[i].y) ? Double.NaN : line1[i].y * line2[i].y;
                }
                break;
            }
            case DIVIDE: {
                for (i = 0; i < isize; ++i) {
                    target[i].y = line2[i].y == 0.0 || Double.isNaN(line1[i].y) || Double.isNaN(line2[i].y) ? Double.NaN : line1[i].y / line2[i].y;
                }
                break;
            }
            case AVERAGE: {
                for (i = 0; i < isize; ++i) {
                    target[i].y = Double.isNaN(line1[i].y) || Double.isNaN(line2[i].y) ? Double.NaN : 0.5 * (line1[i].y + line2[i].y);
                }
                break;
            }
            case MERGE: {
                for (i = 0; i < isize; ++i) {
                    target[i].y = Double.isNaN(line1[i].y) && Double.isNaN(line2[i].y) ? Double.NaN : (Double.isNaN(line1[i].y) ? line2[i].y : (Double.isNaN(line2[i].y) ? line1[i].y : 0.5 * (line1[i].y + line2[i].y)));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown merge method.");
            }
        }
        return target;
    }

    protected void convertValues(Point2D.Double[] pts, Converter converter) {
        if (converter == null) {
            return;
        }
        int isize = pts.length;
        for (int i = 0; i < isize; ++i) {
            if (Double.isNaN(pts[i].y)) continue;
            pts[i].y = converter.convert(pts[i].y);
        }
    }

    private double[] getXArray(Point2D.Double ... pts) {
        double[] target = new double[pts.length];
        for (int i = 0; i < pts.length; ++i) {
            target[i] = pts[i].x;
        }
        return target;
    }

    private double[] getYArray(Point2D.Double ... pts) {
        double[] target = new double[pts.length];
        for (int i = 0; i < pts.length; ++i) {
            target[i] = pts[i].y;
        }
        return target;
    }

    public int getAxisLength(int gridNum) {
        if (this.outputVals_[gridNum] == null) {
            return 0;
        }
        return this.outputVals_[gridNum].length;
    }

    public double valueAt(int gridNum, int index) {
        if (this.needsGridding_) {
            this.regrid();
        }
        if (this.outputVals_[gridNum] == null) {
            return Double.NaN;
        }
        double result = this.outputVals_[gridNum][index];
        if (this.scalingFactor_ != 1.0) {
            result /= this.scalingFactor_;
        }
        return result;
    }

    public double axisValueAt(int gridNum, int idx) {
        if (this.needsGridding_) {
            this.regrid();
        }
        if (this.axisValues_[gridNum] == null) {
            return Double.NaN;
        }
        return this.axisValues_[gridNum][idx];
    }

    public double valueAtAxisPt(int gridNum, double axval) {
        if (this.needsGridding_) {
            this.regrid();
        }
        if (this.outputVals_[gridNum] == null) {
            return Double.NaN;
        }
        int iend = this.axisValues_[gridNum].length - 1;
        for (int i = 0; i < iend; ++i) {
            double axval1 = this.axisValues_[gridNum][i];
            double axval2 = this.axisValues_[gridNum][i + 1];
            if (Double.isNaN(axval1) || Double.isNaN(axval2)) {
                return Double.NaN;
            }
            if (!(axval >= axval1 && axval < axval2) && (!(axval < axval1) || !(axval >= axval2))) continue;
            double value1 = this.valueAt(gridNum, i);
            double value2 = this.valueAt(gridNum, i + 1);
            if (Double.isNaN(value1) || Double.isNaN(value2)) {
                return Double.NaN;
            }
            double axdiff = axval2 - axval1;
            if (axdiff == 0.0) {
                return 0.5 * (value1 + value2);
            }
            double valdiff = value2 - value1;
            return value1 + valdiff * (axval - axval1) / axdiff;
        }
        return Double.NaN;
    }

    public void describeDataAtAxisPt(StringBuilder sb, double axval) {
        if (this.needsGridding_) {
            this.regrid();
        }
        Objects.requireNonNull(sb, "StringBuilder cannot be null.");
        double value = this.valueAtAxisPt(0, axval);
        if (this.comboType_ == PanCombinationType.COMPARE) {
            sb.append("Line Value 1: ");
        } else {
            sb.append("Line Value: ");
        }
        if (!Double.isNaN(value)) {
            sb.append(PrintfFormat.PFORMAT_7G.sprintfx(value)).append('\n');
        } else {
            sb.append("null or NaN\n");
        }
        if (this.comboType_ == PanCombinationType.COMPARE) {
            value = this.valueAtAxisPt(1, axval);
            sb.append("Line Value 2: ");
            if (!Double.isNaN(value)) {
                sb.append(PrintfFormat.PFORMAT_7G.sprintfx(value)).append('\n');
            } else {
                sb.append("null or NaN\n");
            }
        }
    }
}

